/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.build.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.enums.GanttAreaTypeEnum;
import kd.bd.mpdm.common.gantt.enums.GanttContentLocationEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCrossModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttEnumModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttIconModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLinkTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttToDoTaskMenusSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.ganttmodel.build.AbstractGanttToDoDataBuild;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class GanttModeToDoViewDataBuild
extends AbstractGanttToDoDataBuild {
    @Override
    public void buildToDoData(GanttBuildContext context) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String entryTag = GanttDataUtils.getEntryTag(mGanttSourceObj);
        Map<String, Object> groupData = this.getToDoData(context, entryTag);
        this.toDoData.putAll(groupData);
        this.toDoData.put("showRows", 4);
    }

    public Map<String, Object> getToDoData(GanttBuildContext context, String entryTag) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String entityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        HashMap<String, Object> groupData = new HashMap<String, Object>(3);
        DynamicObject[] tasks = GanttUtils.getGanttTaskModel(context, "toDoTask");
        GanttUtils.putCustomGanttSource(context, entityNumber, tasks);
        List<DynamicObject> taskList = GanttDealDataUtils.getEntryToDoTaskList(context, entryTag, tasks);
        ArrayList<GanttRowDataModel> rowDatas = new ArrayList<GanttRowDataModel>(1);
        ArrayList<GanttTaskModel> taskDatas = new ArrayList<GanttTaskModel>(10);
        String requestId = context.getRequestId();
        GanttRowDataModel ganttRowDataModel = new GanttRowDataModel(requestId.concat("0"), null, ResManager.loadKDString((String)"\u5f85\u6392", (String)"GanttModeToDoViewDataBuild_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]), null, Boolean.TRUE, Boolean.TRUE, 0, null, null, null, "0", null);
        DynamicObject dataModelEntity = context.getDataModelEntity();
        DynamicObjectCollection relationColl = dataModelEntity.getDynamicObjectCollection("entityrelation");
        String upEntity = GanttUtils.getUpEntity(relationColl, entityNumber);
        Integer entityFlagIndex = GanttUtils.getEntityFlagIndex(upEntity);
        ganttRowDataModel.setEntityFlagIndex(entityFlagIndex);
        ganttRowDataModel.setGanttType("todo");
        ganttRowDataModel.setDataModelType(context.getDataModelType());
        rowDatas.add(ganttRowDataModel);
        String billFormId = context.getBillFormId();
        boolean dragAble = false;
        boolean adjustAble = false;
        GanttViewSchemModel viewSchemModel = context.getmGanttViewSchemModel();
        Map<String, GanttCrossModel> ganttCrossModels = viewSchemModel.getCorssSet();
        String resourceFlagUpLevel = GanttUtils.getTaskUpFlag(context);
        Map<String, String> featureColorGroup = context.getFeatureColorGroupMap();
        String highGroupValue = "DEFAULTHIGH";
        String highGroupColorValue = "#ffffff";
        List<GanttEnumModel> menus = GanttToDoTaskMenusSingleton.getSingleInstance().getTaskMenus(entityNumber.concat("_").concat(billFormId));
        DynamicObjectCollection highColorGroup = context.getmGanttSourceObj().getDynamicObjectCollection("highlightgroupentry");
        for (Map.Entry<String, GanttCrossModel> entry : ganttCrossModels.entrySet()) {
            GanttCrossModel ganttCrossModel = ganttCrossModels.get(entry.getKey());
            String crossObj = ganttCrossModel.getCrossObjType();
            String crossType = ganttCrossModel.getCrossType();
            if (!GanttCrossObjectEnum.TASK.getValue().equals(crossObj) || !GanttCrossTypeEnum.PLAN.getValue().equals(crossType)) continue;
            String corssId = ganttCrossModel.getCrossId();
            Boolean labelIsShow = ganttCrossModel.getLabelisshow();
            String[] times = GanttUtils.getTimeFieldDataSource(crossObj, crossType, mGanttSourceObj);
            if (times.length <= 0) break;
            String[] copyTimes = (String[])times.clone();
            String entryName = GanttDataUtils.changeTimes(copyTimes);
            DynamicObject barMoveProp = GanttUtils.getBarMoveProp(crossObj, crossType, context);
            for (DynamicObject task : taskList) {
                List<String> pictureUrls;
                List<String> iconUrls;
                String colorValue;
                String executeStatus;
                String id = task.get("id").toString();
                Long startTime = task.getDate(times[0]) == null ? 0L : task.getDate(times[0]).getTime();
                Long endTime = task.getDate(times[1]) == null ? 0L : task.getDate(times[1]).getTime();
                String taskEntryId = id;
                if (StringUtils.isNotBlank((CharSequence)entryName)) {
                    DynamicObject entryDyn = (DynamicObject)task.getDynamicObjectCollection(entryName).get(0);
                    startTime = entryDyn.getDate(copyTimes[0]) == null ? 0L : entryDyn.getDate(copyTimes[0]).getTime();
                    endTime = entryDyn.getDate(copyTimes[1]) == null ? 0L : entryDyn.getDate(copyTimes[1]).getTime();
                    taskEntryId = String.valueOf(entryDyn.get("id"));
                }
                String desc = GanttDealDataUtils.getDescDynamicObject(task, context, crossObj, crossType, GanttContentLocationEnum.UP.getValue());
                String down = GanttDealDataUtils.getDescDynamicObject(task, context, crossObj, crossType, GanttContentLocationEnum.DOWN.getValue());
                String left = GanttDealDataUtils.getDescDynamicObject(task, context, crossObj, crossType, GanttContentLocationEnum.LEFT.getValue());
                String right = GanttDealDataUtils.getDescDynamicObject(task, context, crossObj, crossType, GanttContentLocationEnum.RIGHT.getValue());
                String innerDesc = GanttDealDataUtils.getDescDynamicObject(task, context, crossObj, crossType, GanttContentLocationEnum.CENTRE.getValue());
                String title = GanttDealDataUtils.getDescDynamicObject(task, context, crossObj, crossType, GanttContentLocationEnum.TIP.getValue());
                String allId = requestId.concat(ganttCrossModel.getCrossObjType().concat("_").concat(ganttCrossModel.getCrossType()).concat("_").concat(id).concat("_").concat(taskEntryId));
                GanttTaskModel ganttTaskModel = new GanttTaskModel(requestId.concat("0"), allId, corssId, crossObj, crossType, new ArrayList<GanttLinkTaskModel>(), startTime, endTime, title, desc, labelIsShow, id, "0");
                ganttTaskModel.setDataModelType(context.getDataModelType());
                ganttTaskModel.setCrossValue(ganttCrossModel.getCrossHeightVal(), ganttCrossModel.getIsline(), ganttCrossModel.getPosition(), ganttCrossModel.getCrossObj());
                ganttTaskModel.setInnerDesc(innerDesc);
                ganttTaskModel.setBotDesc(down);
                ganttTaskModel.setRightDesc(right);
                ganttTaskModel.setLeftDesc(left);
                ganttTaskModel.setMenus(menus);
                if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmpd_resourceplan_pre") && !CollectionUtils.isEmpty(menus) && (StringUtils.equals((CharSequence)"3", (CharSequence)(executeStatus = task.getString("executestatus"))) || StringUtils.equals((CharSequence)"4", (CharSequence)executeStatus))) {
                    List<GanttEnumModel> collect = menus.stream().filter(x -> !Arrays.asList("breakup", "nose to tail").contains(x.getCbNumber())).collect(Collectors.toList());
                    ganttTaskModel.setMenus(collect);
                }
                if (Objects.nonNull(barMoveProp)) {
                    dragAble = barMoveProp.getBoolean("entiretymove");
                    adjustAble = barMoveProp.getBoolean("partmove");
                }
                if (StringUtils.equals((CharSequence)context.getEntityId(), (CharSequence)"pmpd_resourceplan") && (StringUtils.equals((CharSequence)"2", (CharSequence)(executeStatus = task.getString("executestatus"))) || StringUtils.equals((CharSequence)"3", (CharSequence)executeStatus) || StringUtils.equals((CharSequence)"4", (CharSequence)executeStatus))) {
                    dragAble = false;
                }
                ganttTaskModel.setDraggable(dragAble);
                ganttTaskModel.setAdjustable(adjustAble);
                ganttTaskModel.setTaskEntryId(taskEntryId);
                ganttTaskModel.setGanttType("todo");
                ganttTaskModel.setStarttimeToField(times[0]);
                ganttTaskModel.setEndtimeToField(times[1]);
                ganttTaskModel.setMetaKey(entityNumber);
                ganttTaskModel.setBarColor(ganttCrossModel.getCrossColorVal());
                ganttTaskModel.setGroupToField(resourceFlagUpLevel);
                DataEntityPropertyCollection propcolls = task.getDataEntityType().getProperties();
                for (DynamicObject highsetObj : highColorGroup) {
                    String objval;
                    String highGroupFlag = highsetObj.getString("entryhighlightgroupflag");
                    long count = propcolls.stream().filter(x -> StringUtils.equals((CharSequence)highGroupFlag, (CharSequence)x.getName())).count();
                    if (count > 0L && (objval = task.getString(highGroupFlag)) != null && !"".equals(objval)) {
                        highGroupValue = task.getString(highGroupFlag);
                    }
                    if (ganttTaskModel.getHighlightType() != null && !"DEFAULTHIGH".equals(ganttTaskModel.getHighlightType())) continue;
                    ganttTaskModel.setHighightType(highGroupValue);
                    ganttTaskModel.setHighlightColor(highGroupColorValue);
                    break;
                }
                String taskId = ganttTaskModel.getTaskEntryId();
                if (featureColorGroup.size() > 0 && context.getSchemModel().getApplyGroupColor().booleanValue() && StringUtils.equals((CharSequence)ganttTaskModel.getCrossType(), (CharSequence)GanttCrossTypeEnum.PLAN.getValue()) && StringUtils.equals((CharSequence)ganttTaskModel.getCrossObj(), (CharSequence)GanttCrossObjectEnum.TASK.getValue()) && (colorValue = featureColorGroup.get(taskId)) != null && !"".equals(colorValue)) {
                    ganttTaskModel.setBarColor(colorValue);
                }
                Map<String, List<String>> barIconMap = context.getBarIconMap();
                Map<String, List<String>> barPictureMap = context.getBarPictureMap();
                String corssIdKey = crossObj.concat("_").concat(crossType).concat("_").concat(String.valueOf(taskId));
                ArrayList<GanttIconModel> descIconList = new ArrayList<GanttIconModel>();
                if (barIconMap.size() > 0 && !CollectionUtils.isEmpty(iconUrls = barIconMap.get(corssIdKey))) {
                    for (String iconUrl : iconUrls) {
                        GanttIconModel platform = new GanttIconModel("platform", iconUrl);
                        descIconList.add(platform);
                    }
                }
                if (barPictureMap.size() > 0 && !CollectionUtils.isEmpty(pictureUrls = barPictureMap.get(corssIdKey))) {
                    for (String pictureUrl : pictureUrls) {
                        String attachmentFullUrl = UrlService.getAttachmentFullUrl((String)pictureUrl);
                        GanttIconModel url = new GanttIconModel("url", attachmentFullUrl);
                        descIconList.add(url);
                    }
                }
                ganttTaskModel.setDescIconList(descIconList);
                taskDatas.add(ganttTaskModel);
                this.updateGlobalTime(context, ganttTaskModel.getStartDate(), ganttTaskModel.getEndDate());
            }
        }
        Map<String, Object> dataListMap = GanttDealDataUtils.dealData(rowDatas, taskDatas, context, GanttAreaTypeEnum.TODOAREA);
        this.resourcePlanSetTrt(context, entryTag, tasks, taskDatas);
        groupData.put("dataList", rowDatas);
        groupData.put("taskDataList", taskDatas);
        groupData.putAll(dataListMap);
        return groupData;
    }

    private void resourcePlanSetTrt(GanttBuildContext context, String entryTag, DynamicObject[] tasks, List<GanttTaskModel> taskdatas) {
        if (StringUtils.equals((CharSequence)context.getEntityId(), (CharSequence)"pmpd_resourceplan")) {
            HashMap<String, DynamicObject> tasksMap = new HashMap<String, DynamicObject>(tasks.length);
            for (DynamicObject task : tasks) {
                DynamicObjectCollection col = task.getDynamicObjectCollection(entryTag);
                for (DynamicObject dynamicObject : col) {
                    String id = dynamicObject.get("id").toString();
                    tasksMap.put(id, task);
                }
            }
            for (GanttTaskModel ganttTaskModel : taskdatas) {
                DynamicObject task;
                if (!GanttCrossObjectEnum.TASK.getValue().equals(ganttTaskModel.getCrossObj()) || !"3".equals(ganttTaskModel.getCrossType()) || (task = (DynamicObject)tasksMap.get(ganttTaskModel.getTaskEntryId())) == null) continue;
                ganttTaskModel.setIsDashedBar(true);
                ganttTaskModel.setDashedStartDate(task.getDate("estiapproachtime") == null ? 0L : task.getDate("estiapproachtime").getTime());
                ganttTaskModel.setDashedEndDate(task.getDate("estideparttime") == null ? 0L : task.getDate("estideparttime").getTime());
            }
            GanttCacheUtils.cacheBigObjectWithDataModel(SessionManager.getCurrent().getPageCache(context.getPageId()), context.getDataModelType(), "toDoTaskDataList", taskdatas);
        }
    }

    private void updateGlobalTime(GanttBuildContext context, Long startTime, Long endTime) {
        GanttViewSchemModel schemModel = context.getmGanttViewSchemModel();
        Long globalStartTime = schemModel.getStart();
        Long globalEndTime = schemModel.getEnd();
        if (globalStartTime == 0L || startTime != 0L && startTime < globalStartTime) {
            schemModel.setStart(startTime);
        }
        if (globalEndTime == 0L || endTime != 0L && endTime > globalEndTime) {
            schemModel.setEnd(endTime);
        }
    }

    @Deprecated
    public void createDateLine(GanttBuildContext context) {
    }
}

