/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.build.impl;

import java.util.ArrayList;
import java.util.Objects;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttColModel;
import kd.bd.mpdm.common.gantt.ganttmodel.build.AbstractGanttColumnsBuild;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;

public class GanttModelColumnsBuild
extends AbstractGanttColumnsBuild {
    public static final String rowFieldName = "seq";

    @Override
    public void buildColumns(GanttBuildContext context) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        DynamicObject mJobViewSchemObj = context.getmJobViewSchemObj();
        String dataModelType = context.getDataModelType();
        DynamicObject dataModelEntity = GanttUtils.getDataModelEntity(mGanttSourceObj, dataModelType);
        if (Objects.isNull(dataModelEntity)) {
            return;
        }
        DynamicObjectCollection sourceColls = mGanttSourceObj.getDynamicObjectCollection("filedentryentity");
        DynamicObjectCollection viewColls = mJobViewSchemObj.getDynamicObjectCollection("entryentity_fieldset");
        ArrayList<GanttColModel> colList = new ArrayList<GanttColModel>(viewColls.size());
        ArrayList<DynamicObject> sourceDataList = new ArrayList<DynamicObject>(sourceColls.size());
        for (DynamicObject sourceColl : sourceColls) {
            String entryEntityName = sourceColl.getDynamicObject("entryentityname").getString("number");
            if (!entryEntityName.equals(dataModelEntity.getString("entity.number"))) continue;
            sourceDataList.add(sourceColl);
        }
        for (int index = 0; index < sourceDataList.size(); ++index) {
            DynamicObject sourceColl;
            if (index >= viewColls.size()) continue;
            sourceColl = (DynamicObject)sourceDataList.get(index);
            DynamicObject viewColl = (DynamicObject)viewColls.get(index);
            GanttColModel model = this.getGanttColModel(viewColl, sourceColl);
            model.setColIndex(index);
            model.setId(viewColl.getString("id"));
            colList.add(model);
        }
        this.colModels = colList;
    }

    private GanttColModel getGanttColModel(DynamicObject viewColl, DynamicObject sourceColl) {
        GanttColModel model = new GanttColModel();
        String colFieldFlag = sourceColl.getString("entryfieldflag");
        String colFieldName = sourceColl.getString("entryfieldname");
        String entryFieldAlign = sourceColl.getString("entryfieldalign");
        colFieldName = StringUtils.isBlank((CharSequence)entryFieldAlign) ? colFieldName : entryFieldAlign;
        String colAlign = viewColl.getString("colalign");
        int colWidth = viewColl.getInt("colwidth");
        int fontSize = viewColl.getInt("fontsize");
        model.setColName(colFieldFlag == null ? "" : colFieldFlag);
        model.setColCaption(colFieldName == null ? "" : colFieldName);
        model.setColAlign(colAlign);
        model.setColWidth(colWidth);
        model.setFontSize(fontSize);
        model.setVisible(Boolean.TRUE);
        return model;
    }
}

