/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.build.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.mpdm.common.gantt.enums.GanttAreaTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildAfterModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttParallelWrapper;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.build.AbstractGanttPageDataBuild;
import kd.bd.mpdm.common.gantt.ganttmodel.builder.DecoratorFactoryBuilder;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.AbstractGanttComponent;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.comp.GroupComponent;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.comp.ResourceComponent;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.comp.TaskComponent;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttReturnUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bd.mpdm.common.utils.MMCCommonThreadPoolUtil;
import kd.bos.algo.DataSet;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;

public class GanttModelTaskViewDataBuild
extends AbstractGanttPageDataBuild {
    private static final Log logger = LogFactory.getLog(GanttModelTaskViewDataBuild.class);

    @Override
    public void buildModelPageData(GanttBuildContext context) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String entryTag = GanttDataUtils.getEntryTag(mGanttSourceObj);
        GanttBuildAfterModel afterModel = new GanttBuildAfterModel();
        afterModel.setEntryTag(entryTag);
        context.setAfterModel(afterModel);
        this.getTaskViewData(context, entryTag);
    }

    public Map<String, Object> getTaskViewData(GanttBuildContext context, String entryTag) {
        Map<String, Object> groupData;
        String taskEntityName = GanttUtils.getTaskEntityNumber(context.getmGanttSourceObj());
        DynamicObject[] tasks = GanttUtils.getGanttTaskModel(context, "planTask");
        GanttUtils.putCustomGanttSource(context, taskEntityName, tasks);
        List<DynamicObject> taskList = GanttDealDataUtils.getEntryPlanTaskList(context, entryTag, tasks);
        logger.info("\u8fc7\u6ee4\u51fa\u6765\u4efb\u52a1\u7684\u6570\u91cf\uff1a" + taskList.size());
        String dataModelType = context.getDataModelType();
        Map<String, DynamicObject[]> treeData = this.getResourceMapData(context);
        logger.info("\u8fc7\u6ee4\u51fa\u6765\u7518\u7279\u56fe\u6811\u5f62\u7ed3\u679c\u5bf9\u8c61\u7684\u7c7b\u578b\uff1a" + treeData.size());
        if (CollectionUtils.isEmpty(taskList)) {
            treeData.put(taskEntityName, new DynamicObject[0]);
            groupData = this.groupResourceAndTasks(context, dataModelType, treeData, new DynamicObject[0]);
        } else {
            DynamicObject[] dynamicObjects = taskList.toArray(new DynamicObject[taskList.size()]);
            treeData.put(taskEntityName, dynamicObjects);
            groupData = this.groupResourceAndTasks(context, dataModelType, treeData, taskList.toArray(new DynamicObject[taskList.size()]));
        }
        this.data.putAll(groupData);
        this.data.put("height", "");
        DecoratorFactoryBuilder.schemeDecorator(taskEntityName, context, this.data);
        this.createDateLine(context);
        DecoratorFactoryBuilder.afterDecorator(taskEntityName, context, this.data);
        return this.data;
    }

    private DynamicObject[] sortDynamicObject(String upLevelSelfFlag, DynamicObject[] resourcesObjs) {
        ArrayList<Object> tmpList = new ArrayList<Object>();
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        List sourceList = Stream.of(resourcesObjs).collect(Collectors.toList());
        for (DynamicObject resobj : sourceList) {
            if (resobj.getDynamicObject(upLevelSelfFlag) != null) continue;
            tmpList.add(resobj);
            resultList.add(resobj);
        }
        sourceList.removeAll(tmpList);
        while (tmpList.size() > 0) {
            ArrayList<DynamicObject> _tmpList = new ArrayList<DynamicObject>();
            for (DynamicObject dynamicObject : tmpList) {
                for (DynamicObject resobj : sourceList) {
                    Long parentid;
                    Long id = dynamicObject.getLong("id");
                    if (id.compareTo(parentid = Long.valueOf(resobj.getDynamicObject(upLevelSelfFlag).getLong("id"))) != 0) continue;
                    _tmpList.add(resobj);
                    resultList.add(resobj);
                }
            }
            tmpList.clear();
            tmpList.addAll(_tmpList);
            sourceList.removeAll(tmpList);
        }
        return resultList.toArray(new DynamicObject[0]);
    }

    private DynamicObject getNewDynamicObject(String metaKey) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(metaKey);
    }

    private long getNewDynamicObjectLongId(String metaKey) {
        ORM orm = ORM.create();
        return orm.genLongId(metaKey);
    }

    private Map<String, Object> groupResourceAndTasks(GanttBuildContext context, String dataModelType, Map<String, DynamicObject[]> treeData, DynamicObject[] tasks) {
        GanttUtils.fillCycleModel(context, treeData);
        HashSet<String> entitySortList = new HashSet<String>(treeData.keySet());
        HashMap<String, Object> groupData = new HashMap<String, Object>();
        ArrayList<GanttRowDataModel> rowDatas = new ArrayList<GanttRowDataModel>();
        ArrayList<GanttTaskModel> taskDatas = new ArrayList<GanttTaskModel>();
        if (treeData.size() == 0) {
            return GanttReturnUtils.getNullAreaResult();
        }
        List<ResourceComponent> resourceComp = this.getRootResourceComponent(context, treeData);
        logger.info("\u7518\u7279\u56fe\u6811\u5f62\u6839\u8282\u70b9\u6570\u91cf\uff1a" + resourceComp.size());
        Iterator<Map.Entry<String, DynamicObject[]>> iter = treeData.entrySet().iterator();
        HashMap<Long, ResourceComponent> taskResourceCompMap = new HashMap<Long, ResourceComponent>(tasks.length);
        HashMap<Long, ResourceComponent> resourceCompMap = new HashMap<Long, ResourceComponent>(resourceComp.size());
        this.getResourceCompMap(resourceComp, resourceCompMap);
        ArrayList hasGroupList = new ArrayList(10);
        String taskEntityName = GanttUtils.getTaskEntityNumber(context.getmGanttSourceObj());
        while (iter.hasNext()) {
            DynamicObject[] obj = iter.next();
            String metakey = obj.getKey();
            boolean isTree = GanttUtils.isTreeStruct(metakey);
            DynamicObject[] resourcesObjs = (DynamicObject[])obj.getValue();
            String upLevelSelfFlag = GanttUtils.getParentFieldName(metakey);
            if (isTree) {
                resourcesObjs = this.sortDynamicObject(upLevelSelfFlag, resourcesObjs);
            }
            List<List<String>> upFlags = GanttUtils.getUpFlags(context, metakey);
            for (DynamicObject resource : resourcesObjs) {
                ResourceComponent parentComponent;
                Object flag;
                Object selfParentId;
                Object parentId = null;
                if (isTree) {
                    selfParentId = resource.getDynamicObject(upLevelSelfFlag) == null ? 0L : resource.getDynamicObject(upLevelSelfFlag).getLong("id");
                    Long zeroLong = 0L;
                    if (selfParentId != null && Long.compare((Long)selfParentId, zeroLong) != 0) {
                        parentId = selfParentId;
                    }
                }
                if (parentId == null) {
                    List upFlag;
                    selfParentId = upFlags.iterator();
                    while (selfParentId.hasNext() && ((parentId = (upFlag = (List)selfParentId.next()).size() > 1 ? Long.valueOf(((DynamicObject)resource.getDynamicObjectCollection((String)upFlag.get(0)).get(0)).getDynamicObject((String)upFlag.get(1)).getLong("id")) : Long.valueOf(resource.getDynamicObject((String)(flag = (String)upFlag.get(0))) == null ? 0L : resource.getDynamicObject((String)flag).getLong("id"))) == null || (Long)parentId == 0L)) {
                    }
                }
                if (parentId == null || (Long)parentId == 0L || (parentComponent = (ResourceComponent)resourceCompMap.get(parentId)) == null) continue;
                boolean isExistGroup = false;
                flag = parentComponent.getGanttChildComponent().iterator();
                while (flag.hasNext()) {
                    AbstractGanttComponent gc = (AbstractGanttComponent)flag.next();
                    if (!(gc instanceof GroupComponent)) continue;
                    isExistGroup = true;
                }
                if (!isExistGroup) {
                    DynamicObject tmpObj = this.getNewDynamicObject(metakey);
                    tmpObj.set("id", (Object)this.getNewDynamicObjectLongId(metakey));
                    GroupComponent groupTc = new GroupComponent(context, tmpObj);
                    groupTc.setParentComponent(parentComponent);
                    AbstractGanttComponent decorator = DecoratorFactoryBuilder.getAbstractGanttComponent(groupTc, context.getCycleModel().getGroupDecoratorClassMap().get(parentComponent.getDynobj().getDynamicObjectType().getName()));
                    if (decorator != null) {
                        parentComponent.add(decorator);
                    }
                }
                ResourceComponent rc = new ResourceComponent(context, resource);
                rc.setIsleaf(true);
                rc.setExpand(false);
                rc.setLevel(parentComponent.getLevel() + 1);
                rc.setParentComponent(parentComponent);
                ResourceComponent decorator = DecoratorFactoryBuilder.decoratorResource(rc, context.getCycleModel().getResourceDecoratorClassMap().get(metakey));
                if (decorator == null) continue;
                parentComponent.add(decorator);
                resourceCompMap.put(resource.getLong("id"), decorator);
                if (StringUtils.equals((CharSequence)resource.getDynamicObjectType().getName(), (CharSequence)metakey)) {
                    taskResourceCompMap.put(resource.getLong("id"), decorator);
                }
                parentComponent.setIsleaf(false);
                parentComponent.setExpand(true);
            }
        }
        resourceCompMap.clear();
        this.entitySortResourceComp(resourceComp, entitySortList, GanttUtils.getTaskEntityNumber(context.getmGanttSourceObj()));
        block4: for (DynamicObject task : tasks) {
            String metaKey = task.getDynamicObjectType().getName();
            Long parentId = task.getLong("id");
            ResourceComponent hitComp = (ResourceComponent)taskResourceCompMap.get(parentId);
            if (hitComp == null) continue;
            TaskComponent taskComp = new TaskComponent(context, task);
            taskComp.setLevel(hitComp.getLevel() + 1);
            taskComp.setParentComponent(hitComp);
            taskComp.setDraggable(true);
            AbstractGanttComponent decorator = DecoratorFactoryBuilder.getAbstractGanttComponent(taskComp, context.getCycleModel().getTaskDecoratorClassMap().get(context.getBillFormId().concat(metaKey)));
            if (decorator != null) {
                hitComp.add(decorator);
            }
            List<AbstractGanttComponent> ganttChildComponent = hitComp.getGanttChildComponent();
            Iterator<AbstractGanttComponent> iterator = ganttChildComponent.iterator();
            while (iterator.hasNext()) {
                AbstractGanttComponent next = iterator.next();
                if (!(next instanceof GroupComponent)) continue;
                iterator.remove();
                continue block4;
            }
        }
        for (ResourceComponent comp : resourceComp) {
            comp.createGanttModelMethod();
            rowDatas.addAll(comp.getGanttRowDataModel());
            taskDatas.addAll(comp.getGanttTaskModel());
        }
        GanttDealDataUtils.dealTaskData(taskDatas);
        Map<String, Object> ganttRowNumModelMap = GanttDealDataUtils.dealData(rowDatas, taskDatas, context, GanttAreaTypeEnum.PLANAREA);
        groupData.put("dataList", rowDatas);
        groupData.put("taskDataList", taskDatas);
        groupData.putAll(ganttRowNumModelMap);
        return groupData;
    }

    private void getResourceCompMap(List<ResourceComponent> resourceComp, Map<Long, ResourceComponent> resourceCompMap) {
        if (!CollectionUtils.isEmpty(resourceComp)) {
            for (ResourceComponent resourceComponent : resourceComp) {
                resourceCompMap.put(resourceComponent.getDynobj().getLong("id"), resourceComponent);
                List<AbstractGanttComponent> ganttChildComponent = resourceComponent.getGanttChildComponent();
                ArrayList<ResourceComponent> childRosourceList = new ArrayList<ResourceComponent>(ganttChildComponent.size());
                for (AbstractGanttComponent abstractGanttComponent : ganttChildComponent) {
                    if (!(abstractGanttComponent instanceof ResourceComponent)) continue;
                    childRosourceList.add((ResourceComponent)abstractGanttComponent);
                }
                this.getResourceCompMap(childRosourceList, resourceCompMap);
            }
        }
    }

    private List<ResourceComponent> getRootResourceComponent(GanttBuildContext context, Map<String, DynamicObject[]> treeData) {
        List<ResourceComponent> rootComponent = new ArrayList<ResourceComponent>();
        Iterator<Map.Entry<String, DynamicObject[]>> iter = treeData.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<String, DynamicObject[]> obj = iter.next();
            String metaKey = obj.getKey();
            DynamicObject[] resourcesObjs = obj.getValue();
            String parentName = GanttUtils.getParentFieldName(metaKey);
            rootComponent = this.getTreeResourceComponent(context, metaKey, parentName, resourcesObjs);
            treeData.remove(metaKey);
        }
        return rootComponent;
    }

    private List<ResourceComponent> getTreeResourceComponent(GanttBuildContext context, String metakey, String parentField, DynamicObject[] resourcesObjs) {
        ArrayList<ResourceComponent> rootComponent = new ArrayList<ResourceComponent>();
        ArrayList<DynamicObject> topList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : resourcesObjs) {
            if (parentField == null) {
                topList.add(obj);
                ResourceComponent rc = new ResourceComponent(context, obj);
                rc.setLevel(0);
                rc.setIsleaf(true);
                ResourceComponent decorator = DecoratorFactoryBuilder.decoratorResource(rc, context.getCycleModel().getResourceDecoratorClassMap().get(metakey));
                rootComponent.add(decorator);
                continue;
            }
            DynamicObject parent = obj.getDynamicObject(parentField);
            if (!StringUtils.isBlank((Object)parent)) continue;
            topList.add(obj);
            ResourceComponent rc = new ResourceComponent(context, obj);
            rc.setLevel(0);
            rc.setIsleaf(true);
            ResourceComponent decorator = DecoratorFactoryBuilder.decoratorResource(rc, context.getCycleModel().getResourceDecoratorClassMap().get(metakey));
            rootComponent.add(decorator);
        }
        ArrayList resultList = new ArrayList(resourcesObjs.length);
        Collections.addAll(resultList, resourcesObjs);
        resultList.removeAll(topList);
        if (parentField != null) {
            LinkedHashMap<Long, DynamicObject> localMap = new LinkedHashMap<Long, DynamicObject>(16);
            HashMap<Long, Long> parentLongMap = new HashMap<Long, Long>(16);
            for (DynamicObject obj : resultList) {
                localMap.put(obj.getLong("id"), obj);
                DynamicObject parentObj = obj.getDynamicObject(parentField);
                if (parentObj == null) continue;
                parentLongMap.put(obj.getLong("id"), parentObj.getLong("id"));
            }
            this.fillTree(context, topList, localMap, parentLongMap, rootComponent);
        }
        return rootComponent;
    }

    public void fillTree(GanttBuildContext context, List<DynamicObject> parentList, Map<Long, DynamicObject> localMap, Map<Long, Long> parentLongMap, List<ResourceComponent> rootComponent) {
        for (int i = 0; i < parentList.size(); ++i) {
            this.fillChildren(context, parentList.get(i), localMap, parentLongMap, rootComponent);
        }
    }

    public List<DynamicObject> fillChildren(GanttBuildContext context, DynamicObject parent, Map<Long, DynamicObject> localMap, Map<Long, Long> parentLongMap, List<ResourceComponent> rootComponent) {
        ArrayList<DynamicObject> childList = new ArrayList<DynamicObject>();
        Long parentId = parent.getLong("id");
        for (Map.Entry<Long, DynamicObject> entry : localMap.entrySet()) {
            Long objpk = entry.getKey();
            if (parentLongMap.get(objpk) == null || Long.compare(parentLongMap.get(objpk), parentId) != 0) continue;
            DynamicObject t = localMap.get(objpk);
            ResourceComponent rc = new ResourceComponent(context, t);
            ResourceComponent parentRc = this.matchGanttComponent(rootComponent, parent.getLong("id"));
            if (parentRc != null) {
                int parentLevel = parentRc.getLevel();
                rc.setLevel(parentLevel + 1);
                parentRc.setExpand(true);
                parentRc.setIsleaf(false);
                rc.setParentComponent(parentRc);
            }
            rc.setExpand(true);
            rc.setIsleaf(true);
            ResourceComponent decorator = DecoratorFactoryBuilder.decoratorResource(rc, context.getCycleModel().getResourceDecoratorClassMap().get(t.getDataEntityType().getName()));
            parentRc.add(decorator);
            this.fillChildren(context, t, localMap, parentLongMap, rootComponent);
        }
        return childList;
    }

    private ResourceComponent matchGanttComponent(List<ResourceComponent> resourceComp, Long id) {
        ResourceComponent resComp = null;
        for (ResourceComponent comp : resourceComp) {
            if (Long.valueOf(comp.getDynobj().getLong("id")).compareTo(id) == 0) {
                resComp = comp;
                break;
            }
            List<AbstractGanttComponent> comps = comp.getGanttChildComponent();
            List<ResourceComponent> rescomps = this.filterResourceComponent(comps);
            if (comps == null || comps.size() <= 0 || resComp != null) continue;
            resComp = this.matchGanttComponent(rescomps, id);
        }
        return resComp;
    }

    private List<ResourceComponent> filterResourceComponent(List<AbstractGanttComponent> comps) {
        ArrayList<ResourceComponent> rescomps = new ArrayList<ResourceComponent>();
        if (comps != null && comps.size() > 0) {
            for (AbstractGanttComponent comp : comps) {
                if (!(comp instanceof ResourceComponent)) continue;
                rescomps.add((ResourceComponent)comp);
            }
        }
        return rescomps;
    }

    private Map<String, DynamicObject[]> getResourceMapData(GanttBuildContext context) {
        List<QFilter> qFilterList = GanttUtils.getGanttTaskFilter(context);
        String dataModelType = context.getDataModelType();
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        LinkedHashMap<String, DynamicObject[]> resultTreeMap = new LinkedHashMap<String, DynamicObject[]>();
        Stack<String> patchTreeList = GanttUtils.getPatchTreeList(context);
        if (CollectionUtils.isEmpty(patchTreeList)) {
            return resultTreeMap;
        }
        String topLevelMetaKey = patchTreeList.pop();
        QFilter[] filters = GanttUtils.getAndCacheResourceEntityFilter(topLevelMetaKey, qFilterList, context);
        String entitySort = GanttUtils.getEntitySort(topLevelMetaKey, mGanttSourceObj, dataModelType);
        ArrayList<Long> pkids = new ArrayList<Long>(16);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)("gantt_init_queryEntity" + topLevelMetaKey), (String)topLevelMetaKey, (String)"id", (QFilter[])filters, (String)entitySort);){
            while (dataset.hasNext()) {
                pkids.add(dataset.next().getLong("id"));
            }
        }
        List collList = GanttUtils.spliceArrays(pkids, 500);
        ArrayList<Object> resObj = new ArrayList<Object>();
        ThreadExecutorService pool = MMCCommonThreadPoolUtil.getThreadExecutorService();
        ArrayList<Future> resultFuture = new ArrayList<Future>(collList.size());
        for (List<Long> list : collList) {
            Future result = pool.submit((Callable)new GanttParallelWrapper(topLevelMetaKey, list, entitySort), MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContextCreator.createForThreadPool(), OperationContext.get());
            resultFuture.add(result);
        }
        while (!resultFuture.isEmpty()) {
            Iterator iter = resultFuture.iterator();
            while (iter.hasNext()) {
                Future future = (Future)iter.next();
                if (!future.isDone()) continue;
                try {
                    resObj.addAll(Arrays.asList((Object[])future.get()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                iter.remove();
            }
        }
        resultTreeMap.put(topLevelMetaKey, resObj.toArray(new DynamicObject[0]));
        this.getResourceDataByMetaKey(context, patchTreeList, qFilterList, resultTreeMap);
        return resultTreeMap;
    }

    private void getResourceDataByMetaKey(GanttBuildContext context, Stack<String> patchTreeList, List<QFilter> qFilterList, Map<String, DynamicObject[]> resultTreeMap) {
        while (patchTreeList.size() > 0) {
            String entityNumber = patchTreeList.pop();
            QFilter[] filters = GanttUtils.getAndCacheResourceEntityFilter(entityNumber, qFilterList, context);
            String entitySort = GanttUtils.getEntitySort(entityNumber, context.getmGanttSourceObj(), context.getDataModelType());
            String selectItems = GanttUtils.queryAllFileds(entityNumber, new ArrayList<String>(2));
            DynamicObject[] resourceObjs = BusinessDataServiceHelper.load((String)entityNumber, (String)selectItems, (QFilter[])filters, (String)entitySort);
            if (resourceObjs.length <= 0) continue;
            resultTreeMap.put(entityNumber, resourceObjs);
        }
    }
}

