/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.build.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bd.mpdm.common.gantt.consts.JobViewSchemConst;
import kd.bd.mpdm.common.gantt.enums.GanttCrossEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttPositionEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildPreModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCrossModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttFilterArg;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttHolidayModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherDateLineMoel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherHLineModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherLLineModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttQFilter;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.ganttmodel.build.AbstractGanttModelViewSchemeBuild;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonDateFilterColumn;

public class GanttModelViewSchemeBuild
extends AbstractGanttModelViewSchemeBuild {
    @Override
    public void buildViewScheme(GanttBuildContext context) {
        DynamicObject mJobViewSchemObj = context.getmJobViewSchemObj();
        GanttViewSchemModel model = this.getResult();
        GanttViewSchemModel schemModel = context.getSchemModel();
        model.setSummaryShow(schemModel.getSummaryShow());
        DynamicObject dynamicObject = context.getmGanttSourceObj();
        ILocaleString ganttName = dynamicObject.getDynamicObjectCollection("entityselect").stream().filter(x -> StringUtils.equals((CharSequence)context.getDataModelType(), (CharSequence)Long.toString(x.getLong("id")))).findFirst().get().getLocaleString("mviewalias");
        if (ganttName != null) {
            model.setGanttName(ganttName.getLocaleValue());
        }
        model.setTodoShow(schemModel.getTodoShow());
        model.setViewID(String.valueOf(mJobViewSchemObj.getPkValue()));
        model.setViewName(mJobViewSchemObj.getString("name"));
        model.setViewNumber(mJobViewSchemObj.getString("number"));
        DynamicObjectCollection colls = mJobViewSchemObj.getDynamicObjectCollection("entryentity_cross");
        for (DynamicObject coll : colls) {
            GanttCrossModel crossModel = this.getGanttCrossModel(coll);
            model.getCorssSet().put(crossModel.getCrossId(), crossModel);
        }
        GanttOtherModel otherModel = this.getGanttOtherModel(mJobViewSchemObj);
        model.setOtherSet(otherModel);
        model.setCellUnitType(otherModel.getOtherSecondrule());
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        CommonDateFilterColumn timeFilter = GanttUtils.defaultStandardTimeFilterColumn(mGanttSourceObj);
        GanttFilterArg filterArg = context.getFilterArg();
        List<GanttQFilter> ganttQFilters = filterArg.getSeachFilters();
        if (timeFilter != null) {
            for (GanttQFilter filter : ganttQFilters) {
                if (!filter.getProperty().equals(timeFilter.getFieldName())) continue;
                String cp = filter.getCp();
                if (">=".equals(cp)) {
                    Long tmpStarttime = ((Date)filter.getValue()).getTime();
                    model.getOtherSet().getDateline().setPlanstartdate(tmpStarttime);
                    model.setStart(tmpStarttime);
                    continue;
                }
                if (!"<".equals(cp)) continue;
                Long tmpEndtime = ((Date)filter.getValue()).getTime();
                model.setEnd(tmpEndtime);
            }
        } else {
            model.getOtherSet().getDateline().setPlanstartdate(System.currentTimeMillis());
            Long currentTime = System.currentTimeMillis();
            model.setStart(GanttUtils.getYearStartTime(currentTime, "GMT+8:00"));
            model.setEnd(GanttUtils.getYearEndTime(currentTime, "GMT+8:00"));
        }
        if (mGanttSourceObj.getString("highcolorvalue") != null) {
            model.setHighlightColor(mGanttSourceObj.getString("highcolorvalue"));
        }
        model.setHoliday(this.resolutionGanttSchemeToRule(context, mJobViewSchemObj));
        GanttBuildPreModel preModel = context.getPreModel();
        model.setCellUnitType(preModel.getCellUnitType());
        model.setCellScale(new BigDecimal(preModel.getScale()));
        model.setDropTargetType(GanttUtils.getDropTargetType(context.getBillFormId()));
        model.setTimelineFillType(GanttUtils.getTimeLineFillType(context.getEntityId()));
        context.setmGanttViewSchemModel(model);
        this.resolutionGanttSourceToRule(context, mGanttSourceObj);
    }

    private GanttHolidayModel resolutionGanttSchemeToRule(GanttBuildContext context, DynamicObject mJobViewSchemObj) {
        GanttHolidayModel holidayModel = new GanttHolidayModel();
        holidayModel.setEnable(true);
        int monday = mJobViewSchemObj.getBoolean("monday") ? 1 : -1;
        int tuesday = mJobViewSchemObj.getBoolean("monday") ? 2 : -1;
        int wednesday = mJobViewSchemObj.getBoolean("wednesday") ? 3 : -1;
        int thursday = mJobViewSchemObj.getBoolean("thursday") ? 4 : -1;
        int friday = mJobViewSchemObj.getBoolean("friday") ? 5 : -1;
        int saturday = mJobViewSchemObj.getBoolean("saturday") ? 6 : -1;
        int sunday = mJobViewSchemObj.getBoolean("sunday") ? 0 : -1;
        ArrayList<Integer> days = new ArrayList<Integer>(16);
        if (monday > -1) {
            days.add(monday);
        }
        if (tuesday > -1) {
            days.add(tuesday);
        }
        if (wednesday > -1) {
            days.add(wednesday);
        }
        if (thursday > -1) {
            days.add(thursday);
        }
        if (friday > -1) {
            days.add(friday);
        }
        if (saturday > -1) {
            days.add(saturday);
        }
        if (sunday > -1) {
            days.add(sunday);
        }
        if (days.size() > 0) {
            holidayModel.setDay(days.toArray(new Integer[0]));
        }
        DynamicObjectCollection holidays = mJobViewSchemObj.getDynamicObjectCollection("holidayentry");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> holidayList = new ArrayList<String>();
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (DynamicObject holiday : holidays) {
            Date startDateRange = holiday.getDate("startdaterange");
            Date endDateRange = holiday.getDate("enddaterange");
            String color = holiday.getString("fcolorvalue");
            List<Date> dates = this.getWorktime(startDateRange, endDateRange);
            for (Date date : dates) {
                String dateStr = dateFormat.format(date);
                colorMap.put(dateStr, StringUtils.isEmpty((CharSequence)color) ? "#ececec80" : color);
                holidayList.add(dateStr);
            }
        }
        if (holidayList.size() > 0) {
            holidayModel.setSpcDay(holidayList.toArray(new String[0]));
        }
        holidayModel.setColorMap(colorMap);
        return holidayModel;
    }

    private void resolutionGanttSourceToRule(GanttBuildContext context, DynamicObject mGanttSourceObj) {
        GanttCommandUtils.resolutionGanttSourceToRule(context, mGanttSourceObj);
    }

    private GanttCrossModel getGanttCrossModel(DynamicObject coll) {
        GanttCrossModel model = new GanttCrossModel();
        String crossObjType = coll.getString("crossobj");
        String crossObj = "";
        switch (GanttCrossObjectEnum.getByValue(crossObjType)) {
            case TASK: {
                crossObj = GanttCrossEnum.TASK.getValue();
                break;
            }
            case LANDMARKS: {
                crossObj = GanttCrossEnum.LANDMARKS.getValue();
                break;
            }
            case KEYPATH: {
                crossObj = GanttCrossEnum.TASK.getValue();
                break;
            }
            case GROUP: {
                crossObj = GanttCrossEnum.GROUP.getValue();
                break;
            }
            case SECONDKEYPATH: {
                crossObj = GanttCrossEnum.TASK.getValue();
                break;
            }
        }
        DynamicObject crossTypeObj = coll.getDynamicObject("crosstype");
        String crossColorVal = coll.getString("crosscolorval");
        String crossShap = coll.getString("crossshap");
        model.setCrossId(String.valueOf(coll.getPkValue()));
        Integer height = coll.getInt("height");
        model.setCrossLevel(JobViewSchemConst.MAX_CROSS_HEIGHT - height);
        model.setIsline(coll.getBoolean("isline"));
        model.setLabelisshow(coll.getBoolean("labelisshow"));
        model.setCrossHeightVal(height);
        model.setPosition(GanttPositionEnum.getByValue(coll.getString("position")).getKey());
        model.setLimitvalue(coll.getInt("limitvalue"));
        if (!StringUtils.equals((CharSequence)crossObj, (CharSequence)"")) {
            model.setCrossObj(crossObj);
            model.setCrossObjType(crossObjType);
        }
        if (crossTypeObj != null) {
            model.setCrossType(crossTypeObj.getString("crosstype"));
        }
        if (crossColorVal != null) {
            model.setCrossColorVal(crossColorVal);
        }
        if (crossShap != null) {
            model.setCrossShap(crossShap);
        }
        return model;
    }

    private GanttOtherModel getGanttOtherModel(DynamicObject mJobViewSchemObj) {
        GanttOtherModel otherModel = new GanttOtherModel();
        otherModel.setOtherId("othermodel");
        otherModel.setOtherFirstrule("YYYY-MM");
        if (mJobViewSchemObj.getBoolean("firstyear")) {
            otherModel.setOtherFirstrule("YYYY");
        }
        if (mJobViewSchemObj.getBoolean("firstym")) {
            otherModel.setOtherFirstrule("YYYY-MM");
        }
        if (mJobViewSchemObj.getBoolean("firstyq")) {
            otherModel.setOtherFirstrule("YYYY-MM-DD");
        }
        otherModel.setOtherSecondrule("day");
        if (mJobViewSchemObj.getBoolean("secondyear")) {
            otherModel.setOtherSecondrule("month");
        }
        if (mJobViewSchemObj.getBoolean("secondyq")) {
            otherModel.setOtherSecondrule("week");
        }
        if (mJobViewSchemObj.getBoolean("secondym")) {
            otherModel.setOtherSecondrule("day");
        }
        if (mJobViewSchemObj.getBoolean("secondhour")) {
            otherModel.setOtherSecondrule("hour");
        }
        GanttOtherDateLineMoel dateline = new GanttOtherDateLineMoel();
        dateline.setOtherShowdatal(mJobViewSchemObj.getBoolean("showdatal"));
        if (mJobViewSchemObj.getInt("linetype") == 1) {
            dateline.setOtherLinetype("solid");
        } else {
            dateline.setOtherLinetype("dashed");
        }
        dateline.setOtherColorvalue(mJobViewSchemObj.get("colorvalue").toString());
        otherModel.setDateline(dateline);
        GanttOtherLLineModel lline = new GanttOtherLLineModel();
        lline.setOtherShowlvlline(mJobViewSchemObj.getBoolean("showlvlline"));
        if (mJobViewSchemObj.getInt("assislinetype") == 1) {
            lline.setOtherAssislinetype("solid");
        } else {
            lline.setOtherAssislinetype("dashed");
        }
        lline.setOtherInternalrow(mJobViewSchemObj.getInt("internalrow"));
        otherModel.setLline(lline);
        GanttOtherHLineModel hline = new GanttOtherHLineModel();
        hline.setOtherShowhline(mJobViewSchemObj.getBoolean("showhline"));
        if (mJobViewSchemObj.getInt("assishlinetype") == 1) {
            hline.setOtherAssishlinetype("solid");
        } else {
            hline.setOtherAssishlinetype("dashed");
        }
        hline.setOtherInternalcol(mJobViewSchemObj.getInt("internalcol"));
        otherModel.setHline(hline);
        return otherModel;
    }

    private List<Date> getWorktime(Date starttime, Date endtime) {
        ArrayList<Date> list = new ArrayList<Date>(16);
        Date dateFrom = starttime;
        Date dateTo = endtime;
        Calendar cal = null;
        while (dateFrom.compareTo(dateTo) <= 0) {
            cal = Calendar.getInstance();
            cal.setTime(dateFrom);
            list.add(cal.getTime());
            cal.add(5, 1);
            dateFrom = cal.getTime();
        }
        return list;
    }
}

