/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.composite;

import java.util.LinkedList;
import java.util.List;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.AbstractGanttDecorator;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.comp.GroupComponent;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.comp.TaskComponent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class AbstractGanttComponent {
    Log logger = LogFactory.getLog(AbstractGanttComponent.class);
    private GanttBuildContext context;
    private DynamicObject dynobj;
    private int level;
    private boolean isleaf;
    private boolean isExpand;
    private boolean draggable;
    private int entityFlagIndex;
    private AbstractGanttComponent parentcomponent;
    private List<AbstractGanttComponent> resouceComps = new LinkedList<AbstractGanttComponent>();
    private List<GanttRowDataModel> rowdataList = new LinkedList<GanttRowDataModel>();
    private GanttRowDataModel rowdata;
    private List<GanttTaskModel> taskdataList = new LinkedList<GanttTaskModel>();

    public AbstractGanttComponent() {
    }

    public AbstractGanttComponent(GanttBuildContext context, DynamicObject dynobj) {
        this.context = context;
        this.dynobj = dynobj;
    }

    public DynamicObject getDynobj() {
        return this.dynobj;
    }

    public void setDynobj(DynamicObject dynobj) {
        this.dynobj = dynobj;
    }

    public GanttRowDataModel getRowdata() {
        return this.rowdata;
    }

    public void setRowdata(GanttRowDataModel rowdata) {
        this.rowdata = rowdata;
    }

    public GanttBuildContext getContext() {
        return this.context;
    }

    public void setContext(GanttBuildContext context) {
        this.context = context;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public AbstractGanttComponent getParentComponent() {
        return this.parentcomponent;
    }

    public void setParentComponent(AbstractGanttComponent parentcomponent) {
        this.parentcomponent = parentcomponent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isIsleaf() {
        return this.isleaf;
    }

    public void setIsleaf(boolean isleaf) {
        this.isleaf = isleaf;
    }

    public boolean isExpand() {
        return this.isExpand;
    }

    public void setExpand(boolean isExpand) {
        this.isExpand = isExpand;
    }

    public int getEntityFlagIndex() {
        return this.entityFlagIndex;
    }

    public void setEntityFlagIndex(int entityFlagIndex) {
        this.entityFlagIndex = entityFlagIndex;
    }

    public abstract void createGanttModel();

    public List<GanttRowDataModel> getGanttRowDataModel() {
        for (AbstractGanttComponent comp : this.getGanttChildComponent()) {
            this.rowdataList.addAll(comp.getGanttRowDataModel());
        }
        return this.rowdataList;
    }

    public List<GanttTaskModel> getGanttTaskModel() {
        for (AbstractGanttComponent comp : this.getGanttChildComponent()) {
            this.taskdataList.addAll(comp.getGanttTaskModel());
        }
        return this.taskdataList;
    }

    public List<AbstractGanttComponent> getGanttChildComponent() {
        return this.resouceComps;
    }

    public void setGanttChildComponent(List<AbstractGanttComponent> resouceComps) {
        this.resouceComps = resouceComps;
    }

    protected void add(AbstractGanttComponent component) {
        throw new UnsupportedOperationException();
    }

    protected void remove(AbstractGanttComponent component) {
        throw new UnsupportedOperationException();
    }

    public void createGanttModelMethod() {
        this.createGanttModel();
        for (AbstractGanttComponent comp : this.getGanttChildComponent()) {
            comp.createGanttModelMethod();
        }
    }

    public AbstractGanttComponent find(Long id) {
        AbstractGanttComponent resComp = null;
        Long localId = this.getDynobj() == null ? 0L : this.getDynobj().getLong("id");
        if (localId.compareTo(id) == 0) {
            return this;
        }
        List<AbstractGanttComponent> childs = this.getGanttChildComponent();
        if (childs.size() > 0) {
            for (AbstractGanttComponent comp : childs) {
                AbstractGanttComponent _comp = comp;
                Long tempId = _comp.getDynobj() == null ? 0L : _comp.getDynobj().getLong("id");
                if (id.compareTo(tempId) == 0) {
                    resComp = _comp;
                    break;
                }
                if (resComp != null) continue;
                resComp = _comp.find(id);
            }
        }
        return resComp;
    }

    protected void updateGlobalTime(Long startTime, Long endTime) {
        GanttViewSchemModel schemModel = this.context.getmGanttViewSchemModel();
        Long globalStartTime = schemModel.getStart();
        Long globalEndTime = schemModel.getEnd();
        if (globalStartTime == 0L || startTime != 0L && startTime < globalStartTime) {
            schemModel.setStart(startTime);
        }
        if (globalEndTime == 0L || endTime != 0L && endTime > globalEndTime) {
            schemModel.setEnd(endTime);
        }
    }

    protected void updateGroupTime(Long starttime, Long endtime) {
        if (this instanceof TaskComponent || this instanceof AbstractGanttDecorator) {
            for (AbstractGanttComponent gc = this.getParentComponent(); gc != null; gc = gc.getParentComponent()) {
                this.nestUpdateGroupTime(gc, starttime, endtime);
            }
        }
    }

    private void nestUpdateGroupTime(AbstractGanttComponent gc, Long starttime, Long endtime) {
        List<AbstractGanttComponent> gcList = gc.getGanttChildComponent();
        block0: for (AbstractGanttComponent _gc : gcList) {
            if (!(_gc instanceof GroupComponent)) continue;
            List<GanttTaskModel> taskList = _gc.getGanttTaskModel();
            for (GanttTaskModel task : taskList) {
                String taskid = task.getTaskId();
                if (taskid.indexOf("group") < 0) continue;
                Long taskStarttime = task.getStartDate();
                Long taskEndtime = task.getEndDate();
                if (taskStarttime == 0L || starttime != 0L && starttime.compareTo(taskStarttime) < 0) {
                    task.setStartDate(starttime);
                }
                if (taskEndtime != 0L && (endtime == 0L || endtime <= taskEndtime)) continue block0;
                task.setEndDate(endtime);
                continue block0;
            }
        }
    }
}

