/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.composite.comp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCellModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.AbstractGanttComponent;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceComponent
extends AbstractGanttComponent {
    public ResourceComponent() {
    }

    public ResourceComponent(GanttBuildContext context, DynamicObject dynObj) {
        super(context, dynObj);
    }

    @Override
    public void add(AbstractGanttComponent component) {
        this.getGanttChildComponent().add(component);
    }

    @Override
    protected void remove(AbstractGanttComponent component) {
        this.getGanttChildComponent().remove(component);
    }

    @Override
    public void createGanttModel() {
        String parentObjId;
        String requestId = this.getContext().getRequestId();
        String id = String.valueOf(this.getDynobj().getLong("id"));
        IDataEntityType entityType = this.getDynobj().getDataEntityType();
        String metaKey = this.getDynobj().getDynamicObjectType().getName();
        String name = "-";
        String number = "-";
        if (entityType instanceof BasedataEntityType) {
            boolean isWorkCenter = "mpdm_workcenter_info".equals(metaKey);
            if (isWorkCenter) {
                name = this.getDynobj().getLocaleString("masterid.name").toString();
                number = this.getDynobj().getString("masterid.number");
            } else {
                name = this.getDynobj().getLocaleString("name").toString();
                number = this.getDynobj().getString("number");
            }
        } else if (entityType instanceof BillEntityType) {
            number = name = this.getDynobj().getString("billno");
        }
        String parentId = null;
        String string = parentObjId = this.getParentComponent() == null ? null : String.valueOf(this.getParentComponent().getDynobj().getLong("id"));
        if (StringUtils.isNotBlank(parentObjId)) {
            parentId = requestId.concat(parentObjId);
        }
        int level = this.getLevel();
        boolean isLeaf = this.isIsleaf();
        boolean isExpend = this.isExpand();
        List<GanttCellModel> cellsModel = this.createGanttCellModelByDsView(this.getContext(), this.getDynobj());
        GanttRowDataModel ganttRowDataModel = new GanttRowDataModel(requestId.concat(id), number, name, parentId, isLeaf, isExpend, level, cellsModel, new ArrayList<GanttRowDataModel>(), metaKey, id, parentObjId);
        ganttRowDataModel.setDataModelType(this.getContext().getDataModelType());
        Integer index = GanttUtils.getEntityFlagIndex(metaKey);
        ganttRowDataModel.setEntityFlagIndex(index == null ? 0 : index);
        this.setRowdata(ganttRowDataModel);
        String billFormId = this.getContext().getBillFormId();
        ganttRowDataModel.setMenus(this.getContext().getCycleModel().getResourceMenusMap().get(metaKey.concat("_").concat(billFormId)));
        ganttRowDataModel.setEditable(this.getContext().getCycleModel().getResourceEditSet().contains(metaKey.concat("_").concat(billFormId)));
        AbstractGanttComponent comps = this.getParentComponent();
        if (comps != null) {
            comps.getRowdata().getChildNodes().add(ganttRowDataModel);
        }
        this.getGanttRowDataModel().add(ganttRowDataModel);
    }

    private List<GanttCellModel> createGanttCellModelByDsView(GanttBuildContext context, DynamicObject dynobj) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        DynamicObject mJobViewSchemObj = context.getmJobViewSchemObj();
        DynamicObjectCollection fieldEntryEntity = mGanttSourceObj.getDynamicObjectCollection("filedentryentity");
        DynamicObjectCollection viewColls = mJobViewSchemObj.getDynamicObjectCollection("entryentity_fieldset");
        String metaKey = this.getDynobj().getDynamicObjectType().getName();
        int index = 0;
        ArrayList<GanttCellModel> res = new ArrayList<GanttCellModel>();
        if (!CollectionUtils.isEmpty((Collection)viewColls)) {
            for (DynamicObject obj : fieldEntryEntity) {
                DynamicObject entryEntity = obj.getDynamicObject("entryentityname");
                String entityNumber = entryEntity.getString("number");
                if (!metaKey.equals(entityNumber) || index >= viewColls.size()) continue;
                String entryFieldFlag = obj.getString("entryfieldflag");
                GanttCellModel cell = new GanttCellModel();
                cell.setFieldFlag(entryFieldFlag);
                cell.setCellTag(dynobj.get(entryFieldFlag) == null ? "" : dynobj.get(entryFieldFlag).toString());
                cell.setColIndex(index);
                cell.setEnable(true);
                cell.setVal(GanttUtils.getResouceValue(context, dynobj, entryFieldFlag));
                res.add(cell);
                ++index;
            }
        }
        return res;
    }
}

