/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.composite.comp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bd.mpdm.common.gantt.enums.GanttContentLocationEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCrossModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttEnumModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLinkTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.AbstractGanttComponent;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bos.dataentity.entity.DynamicObject;
import org.apache.commons.lang3.StringUtils;

public class TaskComponent
extends AbstractGanttComponent {
    public TaskComponent(GanttBuildContext context, DynamicObject dynobj) {
        super(context, dynobj);
    }

    @Override
    protected void add(AbstractGanttComponent component) {
        this.getGanttChildComponent().add(component);
    }

    @Override
    protected void remove(AbstractGanttComponent component) {
        this.getGanttChildComponent().remove(component);
    }

    @Override
    public void createGanttModel() {
        String parentObjId;
        String requestId = this.getContext().getRequestId();
        String mateKey = this.getDynobj().getDynamicObjectType().getName();
        String billFormId = this.getContext().getBillFormId();
        GanttViewSchemModel schemModel = this.getContext().getmGanttViewSchemModel();
        Map<String, GanttCrossModel> ganttCrossModels = schemModel.getCorssSet();
        String id = String.valueOf(this.getDynobj().getLong("id"));
        String parentId = null;
        String string = parentObjId = this.getParentComponent() == null ? null : String.valueOf(this.getParentComponent().getDynobj().getLong("id"));
        if (StringUtils.isNotBlank(parentObjId)) {
            parentId = requestId.concat(parentObjId);
        }
        String metaKey = this.getDynobj().getDynamicObjectType().getName();
        List<GanttEnumModel> menus = this.getContext().getCycleModel().getTaskMenusMap().get(metaKey.concat("_").concat(billFormId));
        String taskUpFlag = this.getContext().getCycleModel().getTaskUpFlag();
        Map<String, String[]> ganttBarTimeMap = this.getContext().getCycleModel().getGanttBarTimeMap();
        for (Map.Entry<String, String[]> barTimeEntry : ganttBarTimeMap.entrySet()) {
            String crossKey = barTimeEntry.getKey();
            GanttCrossModel ganttCrossModel = ganttCrossModels.get(crossKey);
            String crossObj = ganttCrossModel.getCrossObjType();
            String crossType = ganttCrossModel.getCrossType();
            String corssId = ganttCrossModel.getCrossId();
            Boolean labelIsShow = ganttCrossModel.getLabelisshow();
            String[] times = this.getContext().getCycleModel().getGanttBarOrginTimeMap().get(crossKey);
            String[] copyTimes = barTimeEntry.getValue();
            String entryName = this.getContext().getCycleModel().getGanttBarTimeEntryMap().get(crossKey);
            Long startTime = this.getDynobj().getDate(times[0]) == null ? 0L : this.getDynobj().getDate(times[0]).getTime();
            Long endTime = this.getDynobj().getDate(times[1]) == null ? 0L : this.getDynobj().getDate(times[1]).getTime();
            String taskEntryId = id;
            if (StringUtils.isNotBlank((CharSequence)entryName)) {
                DynamicObject entryDyn = (DynamicObject)this.getDynobj().getDynamicObjectCollection(entryName).get(0);
                startTime = entryDyn.getDate(copyTimes[0]) == null ? 0L : entryDyn.getDate(copyTimes[0]).getTime();
                endTime = entryDyn.getDate(copyTimes[1]) == null ? 0L : entryDyn.getDate(copyTimes[1]).getTime();
                taskEntryId = String.valueOf(entryDyn.get("id"));
            }
            String up = GanttDealDataUtils.getDescDynamicObject(this.getDynobj(), this.getContext(), crossObj, crossType, GanttContentLocationEnum.UP.getValue());
            String down = GanttDealDataUtils.getDescDynamicObject(this.getDynobj(), this.getContext(), crossObj, crossType, GanttContentLocationEnum.DOWN.getValue());
            String left = GanttDealDataUtils.getDescDynamicObject(this.getDynobj(), this.getContext(), crossObj, crossType, GanttContentLocationEnum.LEFT.getValue());
            String right = GanttDealDataUtils.getDescDynamicObject(this.getDynobj(), this.getContext(), crossObj, crossType, GanttContentLocationEnum.RIGHT.getValue());
            String innerDesc = GanttDealDataUtils.getDescDynamicObject(this.getDynobj(), this.getContext(), crossObj, crossType, GanttContentLocationEnum.CENTRE.getValue());
            String title = GanttDealDataUtils.getDescDynamicObject(this.getDynobj(), this.getContext(), crossObj, crossType, GanttContentLocationEnum.TIP.getValue());
            String allId = ganttCrossModel.getCrossObjType() + "_" + ganttCrossModel.getCrossType() + "_" + id + "_" + taskEntryId;
            GanttTaskModel ganttTaskModel = new GanttTaskModel(parentId, requestId.concat(allId), corssId, crossObj, crossType, new ArrayList<GanttLinkTaskModel>(), startTime, endTime, title, up, labelIsShow, id, parentObjId);
            ganttTaskModel.setDataModelType(this.getContext().getDataModelType());
            ganttTaskModel.setCrossValue(ganttCrossModel.getCrossHeightVal(), ganttCrossModel.getIsline(), ganttCrossModel.getPosition(), ganttCrossModel.getCrossObj());
            ganttTaskModel.setInnerDesc(innerDesc);
            ganttTaskModel.setBotDesc(down);
            ganttTaskModel.setRightDesc(right);
            ganttTaskModel.setLeftDesc(left);
            ganttTaskModel.setMenus(menus);
            ganttTaskModel.setTaskEntryId(taskEntryId);
            boolean dragAble = false;
            boolean adjustAble = false;
            DynamicObject barMoveProp = this.getContext().getCycleModel().getBarMovePropMap().get(crossKey);
            if (Objects.nonNull(barMoveProp)) {
                dragAble = barMoveProp.getBoolean("entiretymove");
                adjustAble = barMoveProp.getBoolean("partmove");
            }
            ganttTaskModel.setDraggable(dragAble);
            ganttTaskModel.setAdjustable(adjustAble);
            ganttTaskModel.setStarttimeToField(times[0]);
            ganttTaskModel.setEndtimeToField(times[1]);
            ganttTaskModel.setMetaKey(mateKey);
            ganttTaskModel.setBarColor(ganttCrossModel.getCrossColorVal());
            ganttTaskModel.setGroupToField(taskUpFlag);
            this.getGanttTaskModel().add(ganttTaskModel);
            if (GanttCrossTypeEnum.PLAN.getValue().equals(crossType)) {
                this.updateGroupTime(startTime, endTime);
            }
            this.updateGlobalTime(startTime, endTime);
        }
    }
}

