/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel.decorator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttIconModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.AbstractGanttDecorator;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class FeatureColorHighDecorator
extends AbstractGanttDecorator {
    @Override
    public void createGanttModel() {
        super.createGanttModel();
        this.decorateMethod();
    }

    private void decorateMethod() {
        Map<String, String> featureColorGroup = this.getContext().getFeatureColorGroupMap();
        String highGroupValue = "DEFAULTHIGH";
        String highGroupColorValue = "#ffffff";
        DynamicObjectCollection highColorGroup = this.getContext().getmGanttSourceObj().getDynamicObjectCollection("highlightgroupentry");
        DataEntityPropertyCollection propcolls = this.getComponent().getDynobj().getDataEntityType().getProperties();
        block0: for (Object highsetObj : highColorGroup) {
            String objval;
            String highGroupFlag = highsetObj.getString("entryhighlightgroupflag");
            long count = propcolls.stream().filter(x -> StringUtils.equals((CharSequence)highGroupFlag, (CharSequence)x.getName())).count();
            if (count > 0L && (objval = this.getComponent().getDynobj().getString(highGroupFlag)) != null && !"".equals(objval)) {
                highGroupValue = this.getComponent().getDynobj().getString(highGroupFlag);
            }
            List<GanttTaskModel> taskModels = this.getComponent().getGanttTaskModel();
            for (GanttTaskModel task : taskModels) {
                if (task.getHighlightType() != null && !"DEFAULTHIGH".equals(task.getHighlightType())) continue;
                task.setHighightType(highGroupValue);
                task.setHighlightColor(highGroupColorValue);
                continue block0;
            }
        }
        List<GanttTaskModel> taskModels = this.getComponent().getGanttTaskModel();
        if (featureColorGroup.size() > 0 && this.getContext().getSchemModel().getApplyGroupColor().booleanValue()) {
            for (GanttTaskModel task : taskModels) {
                String taskId;
                String colorValue;
                if (!StringUtils.equals((CharSequence)task.getCrossType(), (CharSequence)GanttCrossTypeEnum.PLAN.getValue()) || !StringUtils.equals((CharSequence)task.getCrossObj(), (CharSequence)GanttCrossObjectEnum.TASK.getValue()) || (colorValue = featureColorGroup.get(taskId = task.getTaskEntryId())) == null || "".equals(colorValue)) continue;
                task.setBarColor(colorValue);
            }
        }
        Map<String, List<String>> barIconMap = this.getContext().getBarIconMap();
        Map<String, List<String>> barPictureMap = this.getContext().getBarPictureMap();
        for (GanttTaskModel task : taskModels) {
            List<String> pictureUrls;
            List<String> iconUrls;
            String crossObj = task.getCrossObj();
            String crossType = task.getCrossType();
            String taskId = task.getTaskEntryId();
            String corssIdKey = crossObj.concat("_").concat(crossType).concat("_").concat(String.valueOf(taskId));
            ArrayList<GanttIconModel> descIconList = new ArrayList<GanttIconModel>();
            if (barIconMap.size() > 0 && !CollectionUtils.isEmpty(iconUrls = barIconMap.get(corssIdKey))) {
                for (String iconUrl : iconUrls) {
                    GanttIconModel platform = new GanttIconModel("platform", iconUrl);
                    descIconList.add(platform);
                }
            }
            if (barPictureMap.size() > 0 && !CollectionUtils.isEmpty(pictureUrls = barPictureMap.get(corssIdKey))) {
                for (String pictureUrl : pictureUrls) {
                    String attachmentFullUrl = UrlService.getAttachmentFullUrl((String)pictureUrl);
                    GanttIconModel url = new GanttIconModel("url", attachmentFullUrl);
                    descIconList.add(url);
                }
            }
            task.setDescIconList(descIconList);
        }
    }
}

