/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public interface GanttVersionCreateService {
    public static final String MPDM_GANTT_VERSION = "mpdm_gantt_version";
    public static final String VERSIONNO = "versionno";

    public void createVersion(DynamicObject var1, IFormView var2);

    public static void setVersion(Map<String, Object> map, DynamicObject version) {
        version.set("createorg", (Object)RequestContext.get().getOrgId());
        version.set("number", map.get("number"));
        version.set("name", map.get("name"));
        version.set("versiontype", map.get("versiontype"));
        version.set("status", (Object)"C");
        version.set("enable", (Object)"1");
        version.set("ctrlstrategy", (Object)"5");
        version.set("creator", (Object)RequestContext.get().getCurrUserId());
        version.set("createtime", (Object)System.currentTimeMillis());
        version.set("modifier", (Object)RequestContext.get().getCurrUserId());
        version.set("modifytime", (Object)System.currentTimeMillis());
        version.set("auditor", (Object)RequestContext.get().getCurrUserId());
        version.set("audittime", (Object)System.currentTimeMillis());
        version.set("filterstr_tag", map.get("filterstr_tag"));
        version.set("remark", map.get("remark"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{version});
        CodeRuleServiceHelper.getNumber((String)MPDM_GANTT_VERSION, (DynamicObject)version, (String)"");
    }

    default public Map<String, DynamicObject[]> getResourcePlanList(IFormView formView) {
        String pageId = formView.getPageId();
        List<String> dataModelTypeList = GanttDataUtils.getDataModelTypeList(pageId);
        HashMap<String, Set> entityToIdMap = new HashMap<String, Set>(16);
        for (String dataModelType : dataModelTypeList) {
            Map entityVersionMap = (Map)GanttCacheUtils.getCacheBigObjectWithDataModel(formView.getPageCache(), dataModelType, "entityVersionMap");
            if (!Objects.nonNull(entityVersionMap)) continue;
            for (Map.Entry entry : entityVersionMap.entrySet()) {
                String entityNumber = (String)entry.getKey();
                QFilter qFilter = (QFilter)GanttCacheUtils.getCacheBigObjectWithDataModel(formView.getPageCache(), dataModelType, (String)entry.getKey());
                if (qFilter == null) continue;
                DynamicObjectCollection collection = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (CollectionUtils.isEmpty((Collection)collection)) continue;
                Set ids = collection.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                Set entityIdSet = entityToIdMap.getOrDefault(entityNumber, new HashSet());
                entityIdSet.addAll(ids);
                entityToIdMap.put(entityNumber, entityIdSet);
            }
        }
        if (entityToIdMap.size() > 0) {
            HashMap<String, DynamicObject[]> dynamicObjectMap = new HashMap<String, DynamicObject[]>(entityToIdMap.size());
            for (Map.Entry entityToIdEntry : entityToIdMap.entrySet()) {
                String entityNumber = (String)entityToIdEntry.getKey();
                Set ids = (Set)entityToIdEntry.getValue();
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)type);
                dynamicObjectMap.put(entityNumber, dynamicObjects);
            }
            return dynamicObjectMap;
        }
        return null;
    }

    default public void setVersionPlans(Map<String, DynamicObject[]> resourcePlanMap, IFormView formView, DynamicObject version) {
    }
}

