/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bos.form.IPageCache;
import org.apache.commons.lang.StringUtils;

public class GanttCacheUtils {
    public static void cache(IPageCache pageCache, String cacheKey, String vlue) {
        pageCache.put(cacheKey, vlue);
    }

    public static String getCache(IPageCache pageCache, String cacheKey) {
        return pageCache.get(cacheKey);
    }

    public static void cacheWithDataModel(IPageCache pageCache, String dataModelType, String cacheKey, String vlue) {
        String mainDataModelType = GanttDataUtils.getMainDataModelType(pageCache);
        if (StringUtils.equals((String)mainDataModelType, (String)dataModelType)) {
            GanttCacheUtils.cache(pageCache, cacheKey, vlue);
        } else {
            pageCache.put(dataModelType.concat(".").concat(cacheKey), vlue);
        }
    }

    public static String getCacheWithDataModel(IPageCache pageCache, String dataModelType, String cacheKey) {
        String mainDataModelType = GanttDataUtils.getMainDataModelType(pageCache);
        if (StringUtils.equals((String)mainDataModelType, (String)dataModelType)) {
            return pageCache.get(cacheKey);
        }
        return pageCache.get(dataModelType.concat(".").concat(cacheKey));
    }

    public static void removeCacheWithDataModel(IPageCache pageCache, String dataModelType, String cacheKey) {
        String mainDataModelType = GanttDataUtils.getMainDataModelType(pageCache);
        if (StringUtils.equals((String)mainDataModelType, (String)dataModelType)) {
            pageCache.remove(cacheKey);
        } else {
            pageCache.remove(dataModelType.concat(".").concat(cacheKey));
        }
    }

    public static void cacheBigObject(String pageId, String cacheKey, Object vlue) {
        GanttBigObjectCache.put((String)pageId, (String)cacheKey, (Object)vlue);
    }

    public static void removeCacheBigObject(String pageId, String cacheKey) {
        GanttBigObjectCache.remove((String)pageId, (String[])new String[]{cacheKey});
    }

    public static <T> T getCacheBigObject(String pageId, String cacheKey) {
        return (T)GanttBigObjectCache.get((String)pageId, (String)cacheKey);
    }

    public static void cacheBigObjectWithDataModel(IPageCache pageCache, String dataModelType, String cacheKey, Object vlue) {
        String pageId = pageCache.getPageId();
        String mainDataModelType = GanttDataUtils.getMainDataModelType(pageCache);
        if (StringUtils.equals((String)mainDataModelType, (String)dataModelType)) {
            GanttBigObjectCache.put((String)pageId, (String)cacheKey, (Object)vlue);
        } else {
            GanttBigObjectCache.put((String)pageId, (String)dataModelType.concat(".").concat(cacheKey), (Object)vlue);
        }
    }

    public static void removeBigObjectWithDataModel(IPageCache pageCache, String dataModelType, String cacheKey) {
        String pageId = pageCache.getPageId();
        String mainDataModelType = GanttDataUtils.getMainDataModelType(pageCache);
        if (StringUtils.equals((String)mainDataModelType, (String)dataModelType)) {
            GanttBigObjectCache.remove((String)pageId, (String[])new String[]{cacheKey});
        } else {
            GanttBigObjectCache.remove((String)pageId, (String[])new String[]{dataModelType.concat(".").concat(cacheKey)});
        }
    }

    public static <T> T getCacheBigObjectWithDataModel(IPageCache pageCache, String dataModelType, String cacheKey) {
        String pageId = pageCache.getPageId();
        String mainDataModelType = GanttDataUtils.getMainDataModelType(pageCache);
        if (StringUtils.equals((String)mainDataModelType, (String)dataModelType)) {
            return (T)GanttBigObjectCache.get((String)pageId, (String)cacheKey);
        }
        return (T)GanttBigObjectCache.get((String)pageId, (String)dataModelType.concat(".").concat(cacheKey));
    }
}

