/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.enums.GanttAreaTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildPreModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttGlobalModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.build.impl.GanttModelSummaryViewDataBuild;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttUserConfigUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bd.mpdm.common.utils.MMCCommonThreadPoolUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.FilterModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.operate.MutexHelper;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;

public class GanttCommandUtils {
    private static String TASK_ENTITY = "pmts_task";
    private static String WBS_ENTITY = "pmts_wbs";
    private static String SCHEDULETYPE = "scheduletype";
    public static final String ID = "id";
    public static final String WBS = "wbs";
    private static final ThreadExecutorService executorService = GanttCommandUtils.getExecutorService();
    private static Log logger = LogFactory.getLog(GanttCommandUtils.class);

    private static ThreadExecutorService getExecutorService() {
        return MMCCommonThreadPoolUtil.getThreadExecutorService();
    }

    @Deprecated
    public static void updateTaskOrder(GanttCommandContext ctx, GanttTaskModel taskModel, Map<String, Object> pageData) {
    }

    public static String getBillNo(DynamicObject dynObj) {
        IDataEntityType entitytype = dynObj.getDataEntityType();
        String number = null;
        if (entitytype instanceof BasedataEntityType) {
            boolean isWorkCenter = "mpdm_workcenter_info".equals(entitytype.getName());
            number = isWorkCenter ? dynObj.getString("masterid.number") : dynObj.getString("number");
        } else if (entitytype instanceof BillEntityType) {
            number = dynObj.getString("billno");
        }
        return number;
    }

    public static String getBillName(DynamicObject dynObj) {
        IDataEntityType entitytype = dynObj.getDataEntityType();
        String number = null;
        if (entitytype instanceof BasedataEntityType) {
            boolean isWorkCenter = "mpdm_workcenter_info".equals(entitytype.getName());
            number = isWorkCenter ? dynObj.getString("masterid.name") : dynObj.getString("name");
        } else if (entitytype instanceof BillEntityType) {
            number = dynObj.getString("billno");
        }
        return number;
    }

    public static String getQueryField(String taskUpEntityNumber) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)taskUpEntityNumber);
        String queryField = "id, ";
        if (type instanceof BasedataEntityType) {
            boolean isWorkCenter = "mpdm_workcenter_info".equals(type.getName());
            queryField = isWorkCenter ? queryField + "masterid.number number, profitworkcenter" : queryField + "number number";
        } else if (type instanceof BillEntityType) {
            queryField = queryField + "billno number";
        }
        return queryField;
    }

    public static void updataShowScale(IFormView view, int scale) {
        HashMap fieldMap = new HashMap();
        HashMap<String, String> textMap = new HashMap<String, String>();
        String langTag = Lang.get().getLocale().toString();
        textMap.put(langTag, ResManager.loadKDString((String)"\u663e\u793a", (String)"GanttCommandUtils_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]).concat("\uff08").concat(Integer.toString(scale)).concat("%\uff09"));
        fieldMap.put("text", textMap);
        view.updateControlMetadata("bar_show", fieldMap);
    }

    public static void updataTimeScale(IFormView view, String timeScale) {
        HashMap fieldMap = new HashMap(1);
        HashMap<String, String> textMap = new HashMap<String, String>(1);
        String langTag = Lang.get().getLocale().toString();
        textMap.put(langTag, GanttCommandUtils.getTimeScaleStr(timeScale));
        fieldMap.put("text", textMap);
        view.updateControlMetadata("timerule", fieldMap);
    }

    private static String getTimeScaleStr(String timeScale) {
        String timeScaleStr = ResManager.loadKDString((String)"\u65f6\u95f4\u6807\u5c3a", (String)"GanttCommandUtils_7", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"bar_dependhour", (CharSequence)timeScale)) {
            timeScaleStr = timeScaleStr.concat(ResManager.loadKDString((String)"\uff08\u65f6\uff09", (String)"GanttCommandUtils_8", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)"bar_dependday", (CharSequence)timeScale)) {
            timeScaleStr = timeScaleStr.concat(ResManager.loadKDString((String)"\uff08\u5929\uff09", (String)"GanttCommandUtils_9", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)"bar_dependweek", (CharSequence)timeScale)) {
            timeScaleStr = timeScaleStr.concat(ResManager.loadKDString((String)"\uff08\u5468\uff09", (String)"GanttCommandUtils_10", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)"bar_dependmonth", (CharSequence)timeScale)) {
            timeScaleStr = timeScaleStr.concat(ResManager.loadKDString((String)"\uff08\u6708\uff09", (String)"GanttCommandUtils_11", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        return timeScaleStr;
    }

    public static void changeScaleOrUnit(GanttCommandContext ctx, String cellUnitType, String scale) {
        GanttPageShowModel pageShowModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(ctx.getView().getPageId(), "pageShowSet");
        pageShowModel.setCellScale(new BigDecimal(scale));
        pageShowModel.setCellUnitType(cellUnitType);
        pageShowModel.setTimelineShowRows(pageShowModel.getTimelineRows());
        if (!"day".equals(cellUnitType)) {
            pageShowModel.setTimelineShowRows(2);
        }
        List<String> dataModelTypeList = GanttDataUtils.getDataModelTypeList(ctx.getPageCache().getPageId());
        Map<String, String> modelTypeToCtrlMap = GanttDataUtils.getModelTypeToCtrlMap(ctx.getPageCache().getPageId());
        IPageCache pageCache = ctx.getView().getPageCache();
        for (String dataModelType : dataModelTypeList) {
            String ganttCtl = modelTypeToCtrlMap.get(dataModelType);
            GanttGlobalModel model = (GanttGlobalModel)GanttCacheUtils.getCacheBigObjectWithDataModel(pageCache, dataModelType, "model");
            model.getViewSchem().setCellUnitType(cellUnitType);
            model.getViewSchem().setCellScale(new BigDecimal(scale));
            model.getViewSchem().setTimelineShowRows(pageShowModel.getTimelineShowRows());
            model.getViewSchem().setIsVerticalMode(pageShowModel.getIsVerticalMode());
            GanttBuildContext ganttBuildContext = (GanttBuildContext)GanttCacheUtils.getCacheBigObjectWithDataModel(pageCache, dataModelType, "ganttBuildContext");
            GanttBuildPreModel preModel = ganttBuildContext.getPreModel();
            preModel.setCellUnitType(cellUnitType);
            preModel.setScale(scale);
            List rowDatas = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(pageCache, dataModelType, "dataList");
            List taskDatas = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(pageCache, dataModelType, "taskDataList");
            Map<String, Object> ganttRowNumModelMap = GanttDealDataUtils.dealData((List<GanttRowDataModel>)rowDatas, (List<GanttTaskModel>)taskDatas, ganttBuildContext, GanttAreaTypeEnum.PLANAREA);
            GanttDealDataUtils.dealDataForFornt(rowDatas);
            model.getPageData().put("dataList", rowDatas);
            model.getPageData().put("taskDataList", taskDatas);
            model.getPageData().putAll(ganttRowNumModelMap);
            boolean toDoShow = preModel.getToDoShow();
            if (toDoShow) {
                List rowDataModelList = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(pageCache, dataModelType, "toDoDataList");
                List taskModelList = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(pageCache, dataModelType, "toDoTaskDataList");
                Map<String, Object> toDoMap = GanttDealDataUtils.dealData((List<GanttRowDataModel>)rowDataModelList, (List<GanttTaskModel>)taskModelList, ganttBuildContext, GanttAreaTypeEnum.TODOAREA);
                model.getTodo().put("dataList", rowDataModelList);
                model.getTodo().put("taskDataList", taskModelList);
                model.getTodo().putAll(toDoMap);
            }
            if (ganttBuildContext.getSchemModel().getSummaryShow().booleanValue()) {
                GanttModelSummaryViewDataBuild build = new GanttModelSummaryViewDataBuild();
                build.buildSummaryData(ganttBuildContext);
                model.setSummary(build.getSummaryResult());
            }
            CustomControl custCtl = (CustomControl)ctx.getView().getControl(ganttCtl);
            JSONObject result = (JSONObject)JSONObject.toJSON((Object)model);
            custCtl.setData((Object)result);
            GanttCacheUtils.cacheBigObjectWithDataModel(pageCache, dataModelType, "model", model);
        }
        GanttCacheUtils.cacheBigObject(ctx.getView().getPageId(), "pageShowSet", pageShowModel);
        GanttUserConfigUtils.setConfig((ListView)ctx.getView(), pageShowModel);
    }

    public static void returnNullData(GanttCommandContext ctx) {
        CustomControl ctrl = (CustomControl)ctx.getView().getControl("ganttctl");
        ctrl.setData(null);
    }

    @Deprecated
    public static boolean isTaskView(GanttCommandContext ctx) {
        List taskDataModelList;
        String currentEntity = GanttCacheUtils.getCache(ctx.getPageCache(), "viewSchemEntity");
        DynamicObject mGanttSourceObj = (DynamicObject)GanttCacheUtils.getCacheBigObject(ctx.getPageCache().getPageId(), "datasource");
        DynamicObjectCollection entitySelects = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        List collect = entitySelects.stream().filter(x -> "B".equals(x.getString("gantttype"))).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(collect) && (taskDataModelList = collect.stream().map(x -> Long.toString(x.getLong(ID))).collect(Collectors.toList())).contains(currentEntity);
    }

    public static String getFirstResourceId(List<GanttRowDataModel> planDataList, String taskEntityIds, String objId) {
        List ganttRowDataModels = planDataList.stream().filter(x -> objId.equals(x.getObjId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ganttRowDataModels)) {
            return null;
        }
        GanttRowDataModel ganttRowDataModel = (GanttRowDataModel)ganttRowDataModels.get(0);
        if (taskEntityIds.contains(ganttRowDataModel.getEntityFlag())) {
            return GanttCommandUtils.getFirstResourceId(planDataList, taskEntityIds, ganttRowDataModel.getParentObjId());
        }
        return ganttRowDataModel.getObjId();
    }

    public static String verifyTime(GanttCommandContext ctx, long startTime, long endTime) {
        String filterStartTimeStr = GanttCacheUtils.getCache(ctx.getPageCache(), "filterStartTime");
        String filterEndTimeStr = GanttCacheUtils.getCache(ctx.getPageCache(), "filterEndTime");
        if (StringUtils.isNotBlank((CharSequence)filterStartTimeStr) && StringUtils.isNotBlank((CharSequence)filterEndTimeStr)) {
            long filterStartTime = Long.parseLong(filterStartTimeStr);
            long filterEndTime = Long.parseLong(filterEndTimeStr);
            if (filterStartTime > endTime || filterEndTime <= startTime) {
                String showMsg = ResManager.loadKDString((String)"\u6a2a\u9053\u4e0d\u53ef\u62d6\u62fd\u81f3\u65f6\u95f4\u8303\u56f4\u5916\u3002", (String)"GanttCommandUtils_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
                ctx.getView().showTipNotification(showMsg);
                GanttCommandUtils.returnNullData(ctx);
                return showMsg;
            }
        }
        return null;
    }

    public static void showBillForm(GanttCommandContext ctx, long objId, String metaKey) {
        Future submit = executorService.submit(() -> {
            FormShowParameter formShowParamter = GanttCommandUtils.createFormShowParamter(objId, metaKey);
            GanttCommandUtils.showBillForm(ctx, formShowParamter);
            return null;
        }, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
        try {
            submit.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f51\u7edc\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"GanttCommandUtils_4", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9875\u9762\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5%s\u3002", (String)"GanttCommandUtils_5", (String)"bd-mpdm-gantt", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static FormShowParameter createFormShowParamter(long objId, String metaKey) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)objId);
        if (metaKey.equals(TASK_ENTITY) || metaKey.equals(WBS_ENTITY)) {
            QFilter qFilter;
            DynamicObject dynamicObject;
            showParameter.setCloseCallBack(new CloseCallBack("kd.pmc.pmts.formplugin.gantt.GanttListPlugin", "close"));
            if (metaKey.equals(TASK_ENTITY) && (dynamicObject = QueryServiceHelper.queryOne((String)metaKey, (String)SCHEDULETYPE, (QFilter[])(qFilter = new QFilter(ID, "=", (Object)objId)).toArray())).getString(SCHEDULETYPE).equals("3")) {
                metaKey = "pmts_milestone";
            }
        }
        showParameter.setFormId(metaKey);
        return showParameter;
    }

    public static void showBillForm(GanttCommandContext ctx, FormShowParameter showParameter) {
        StringBuilder errorMsg = new StringBuilder();
        String metaKey = showParameter.getFormId();
        Object objId = ((BillShowParameter)showParameter).getPkId();
        boolean modify = MutexHelper.require((String)showParameter.getFormId(), (Object)objId, (String)"modify", (StringBuilder)errorMsg);
        if (modify) {
            MutexHelper.release((String)metaKey, (String)"modify", (String)String.valueOf(objId));
            showParameter.setStatus(OperationStatus.EDIT);
            ctx.getView().showForm(showParameter);
        } else {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("showFormConfirmCallBack", ctx.getPlugin());
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(1);
            btnNameMaps.put(6, ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"GanttCommandUtils_2", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            ArrayList links = new ArrayList(1);
            ctx.getView().showConfirm(errorMsg.toString(), links, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, btnNameMaps);
            showParameter.setStatus(OperationStatus.VIEW);
            GanttCacheUtils.cacheBigObject(ctx.getView().getPageId(), "showForm", showParameter);
        }
    }

    public static void showBillFormHistory(GanttCommandContext ctx, long objId, String metaKey) {
        QFilter qFilter;
        DynamicObject dynamicObject;
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)objId);
        showParameter.setPageId(Long.toString(RequestContext.get().getCurrUserId()).concat("_").concat(Long.toString(objId)));
        if (metaKey.equals(TASK_ENTITY) && (dynamicObject = QueryServiceHelper.queryOne((String)metaKey, (String)SCHEDULETYPE, (QFilter[])(qFilter = new QFilter(ID, "=", (Object)objId)).toArray())).getString(SCHEDULETYPE).equals("3")) {
            metaKey = "pmts_milestone";
        }
        showParameter.setFormId(metaKey);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.addCustPlugin("kd.bd.mpdm.formplugin.gantt.RemoveModifyPlugin");
        ctx.getView().showForm((FormShowParameter)showParameter);
    }

    public static void resolutionGanttSourceToRule(GanttBuildContext context, DynamicObject mGanttSourceObj) {
        String highGroupFlag = mGanttSourceObj.getString("highlightgroupflag");
        if (highGroupFlag != null) {
            context.setHighGroupFlag(highGroupFlag);
        }
        String entryTag = GanttDataUtils.getEntryTag(mGanttSourceObj);
        HashMap<String, String> idMapColor = new HashMap<String, String>(16);
        DynamicObjectCollection featureColorGroups = mGanttSourceObj.getDynamicObjectCollection("colorentryentity");
        String taskEntityName = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        for (DynamicObject colorGroup : featureColorGroups) {
            String colorconditon = colorGroup.getString("colorcondfilter_tag");
            String colorValue = colorGroup.getString("colorvalue");
            if (StringUtils.isBlank((CharSequence)colorconditon)) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)colorconditon, FilterCondition.class);
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)taskEntityName);
            FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
            fb.buildFilter(false);
            List filters = fb.getQFilters();
            String selectField = ID;
            if (CollectionUtils.isEmpty((Collection)filters)) continue;
            if (StringUtils.isNotBlank((CharSequence)entryTag)) {
                selectField = String.format("%s.id id", entryTag);
            }
            DataSet datas = QueryServiceHelper.queryDataSet((String)"colorentryentity_query", (String)taskEntityName, (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), null);
            while (datas.hasNext()) {
                Row data = datas.next();
                Long id = data.getLong(ID);
                String idStr = String.valueOf(id);
                if (!StringUtils.isBlank((CharSequence)((CharSequence)idMapColor.get(idStr)))) continue;
                idMapColor.put(idStr, colorValue);
            }
            datas.close();
        }
        context.setFeatureColorGroupMap(idMapColor);
        HashMap<String, List<String>> idMapIcon = new HashMap<String, List<String>>(16);
        HashMap<String, List<String>> idMapPicture = new HashMap<String, List<String>>(16);
        DynamicObjectCollection colls = mGanttSourceObj.getDynamicObjectCollection("crossset");
        for (DynamicObject coll : colls) {
            String tCrossObj = coll.getString("crossobj");
            DynamicObject crossTypeObj = coll.getDynamicObject("crosstype");
            String tCrossType = Objects.isNull(crossTypeObj) ? "" : crossTypeObj.getString("crosstype");
            DynamicObjectCollection crossIconEntry = coll.getDynamicObjectCollection("crossiconset");
            if (CollectionUtils.isEmpty((Collection)crossIconEntry)) continue;
            for (DynamicObject iconDyn : crossIconEntry) {
                String iconCondition = iconDyn.getString("iconconditionvalue_tag");
                if (StringUtils.isBlank((CharSequence)iconCondition)) continue;
                String iconUrl = iconDyn.getString("iconurl");
                String pictureUrl = iconDyn.getString("pictureurl");
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)iconCondition, FilterCondition.class);
                MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)taskEntityName);
                FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
                fb.buildFilter(false);
                List filters = fb.getQFilters();
                String selectField = ID;
                if (CollectionUtils.isEmpty((Collection)filters)) continue;
                if (StringUtils.isNotBlank((CharSequence)entryTag)) {
                    selectField = String.format("%s.id id", entryTag);
                }
                DataSet datas = QueryServiceHelper.queryDataSet((String)"iconEntryEntity_query", (String)taskEntityName, (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), null);
                Throwable throwable = null;
                try {
                    while (datas.hasNext()) {
                        Row data = datas.next();
                        Long id = data.getLong(ID);
                        String corssIdKey = tCrossObj.concat("_").concat(tCrossType).concat("_").concat(String.valueOf(id));
                        if (StringUtils.isNotBlank((CharSequence)iconUrl)) {
                            List iconUrls = idMapIcon.getOrDefault(corssIdKey, new ArrayList());
                            iconUrls.add(iconUrl);
                            idMapIcon.put(corssIdKey, iconUrls);
                        }
                        if (!StringUtils.isNotBlank((CharSequence)pictureUrl)) continue;
                        List pictureUrls = idMapPicture.getOrDefault(corssIdKey, new ArrayList());
                        pictureUrls.add(pictureUrl);
                        idMapPicture.put(corssIdKey, pictureUrls);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (datas == null) continue;
                    if (throwable != null) {
                        try {
                            datas.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    datas.close();
                }
            }
        }
        context.setBarIconMap(idMapIcon);
        context.setBarPictureMap(idMapPicture);
    }

    public static long getIdJundeNull(DynamicObject groupObj) {
        if (Objects.isNull(groupObj)) {
            return 0L;
        }
        return groupObj.getLong(ID);
    }

    public static String judgeCanDrag(GanttCommandContext ctx, String ganttType, String targetGanttType, long startTime, long endTime) {
        if ("pageData".equals(ganttType) && !"pageData".equals(targetGanttType)) {
            String showMsg = ResManager.loadKDString((String)"\u8ba1\u5212\u533a\u6a2a\u9053\u4e0d\u53ef\u62d6\u62fd\u81f3\u5176\u4ed6\u533a\u3002", (String)"GanttCommandUtils_3", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
            ctx.getView().showTipNotification(showMsg);
            GanttCommandUtils.returnNullData(ctx);
            return showMsg;
        }
        String verifyResult = GanttCommandUtils.verifyTime(ctx, startTime, endTime);
        if (StringUtils.isNotBlank((CharSequence)verifyResult)) {
            return verifyResult;
        }
        return null;
    }

    public static String getTaskUpEntityNumber(DynamicObject mGanttSourceObj, String taskEntityIds, String dataModeType) {
        DynamicObjectCollection col = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        for (DynamicObject dynamicObject : col) {
            String viewStr = Long.toString(dynamicObject.getLong(ID));
            if (!StringUtils.equals((CharSequence)dataModeType, (CharSequence)viewStr)) continue;
            DynamicObjectCollection relationColl = dynamicObject.getDynamicObjectCollection("entityrelation");
            for (DynamicObject relation : relationColl) {
                String relationNumber = relation.getString("rentity.number");
                if (!StringUtils.equals((CharSequence)relationNumber, (CharSequence)taskEntityIds)) continue;
                return relation.getString("ruplevelentity.number");
            }
        }
        return null;
    }

    public static void openGanttDealDefaultScheme(ListShowParameter listShowParameter) {
        FilterScheme defaultScheme = null;
        SchemeQuery schemeQuery = new SchemeQuery();
        String billFormId = listShowParameter.getBillFormId();
        List scheme = schemeQuery.getScheme(billFormId, Long.toString(RequestContext.get().getCurrUserId()));
        if (!CollectionUtils.isEmpty((Collection)scheme)) {
            defaultScheme = scheme.stream().filter(x -> x.isDefault()).findFirst().orElse(null);
        }
        if (defaultScheme != null) {
            FilterModel filterModel = new FilterModel();
            filterModel.setFormId(billFormId);
            StringBuilder errorMsg = new StringBuilder();
            boolean sucess = filterModel.updateScheme(defaultScheme.getId(), false, new StringBuilder());
            if (!sucess) {
                logger.error(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9ed8\u8ba4\u65b9\u6848%1$s\u5931\u8d25\uff1a%2$s", (String)"GanttCommandUtils_12", (String)"bd-mpdm-gantt", (Object[])new Object[0]), defaultScheme.getId(), errorMsg.toString()));
            }
            listShowParameter.setCustomParam("defaultScheme", (Object)defaultScheme.getId());
        }
    }
}

