/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import com.google.common.collect.Maps;
import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import kd.bd.mpdm.common.enums.DateValueEnum;
import kd.bd.mpdm.common.enums.GanttLabelFiledTypeEnum;
import kd.bd.mpdm.common.enums.GanttLabelTypeEnum;
import kd.bd.mpdm.common.gantt.consts.GanttDefaultDataConst;
import kd.bd.mpdm.common.gantt.enums.GanttAreaTypeEnum;
import kd.bd.mpdm.common.gantt.enums.GanttContentLocationEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttRowTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.DecimalPropModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildPreModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCrossModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLinkTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowNumModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.service.CustomerContentService;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.login.utils.DateUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GanttDealDataUtils {
    private static String font = "Microsoft YaHei";
    private static int fontSize = 12;
    private static int baseWidth = 25;
    private static int minRow = 27;
    private static int toDoRow = 4;
    private static int expandIndex = 10;
    private static int rowHeightVal = 50;
    private static int textOffSet = 8;

    @Deprecated
    public static GanttBuildPreModel getPreModelByCache(PageCache pageCache) {
        GanttBuildPreModel preModel = new GanttBuildPreModel();
        preModel.setRequestId(GanttCacheUtils.getCache((IPageCache)pageCache, "requestId"));
        preModel.setPageId(pageCache.getPageId());
        GanttPageShowModel pageShowModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(pageCache.getPageId(), "pageShowSet");
        preModel.setScale(pageShowModel.getCellScale().toString());
        preModel.setCellUnitType(pageShowModel.getCellUnitType());
        preModel.setToDoShow(Boolean.parseBoolean(pageCache.get("toDoShow")));
        GanttViewSchemModel viewSchemModel = (GanttViewSchemModel)GanttCacheUtils.getCacheBigObject(pageCache.getPageId(), "viewSchem");
        GanttCrossModel value = GanttDealDataUtils.getEmptyCrossModel(viewSchemModel);
        preModel.setEmptyBarCrossModel(value);
        preModel.setGlobalStartTime(viewSchemModel.getStart());
        preModel.setGlobalEndTime(viewSchemModel.getEnd());
        return preModel;
    }

    public static GanttBuildPreModel getPreModelByCache(PageCache pageCache, String dataModelType) {
        GanttBuildPreModel preModel = new GanttBuildPreModel();
        preModel.setRequestId(GanttCacheUtils.getCacheWithDataModel((IPageCache)pageCache, dataModelType, "requestId"));
        preModel.setPageId(pageCache.getPageId());
        GanttPageShowModel pageShowModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(pageCache.getPageId(), "pageShowSet");
        preModel.setScale(pageShowModel.getCellScale().toString());
        preModel.setCellUnitType(pageShowModel.getCellUnitType());
        preModel.setToDoShow(Boolean.parseBoolean(pageCache.get("toDoShow")));
        GanttViewSchemModel viewSchemModel = (GanttViewSchemModel)GanttCacheUtils.getCacheBigObjectWithDataModel((IPageCache)pageCache, dataModelType, "viewSchem");
        GanttCrossModel value = GanttDealDataUtils.getEmptyCrossModel(viewSchemModel);
        preModel.setEmptyBarCrossModel(value);
        preModel.setGlobalStartTime(viewSchemModel.getStart());
        preModel.setGlobalEndTime(viewSchemModel.getEnd());
        return preModel;
    }

    public static GanttCrossModel getEmptyCrossModel(GanttViewSchemModel viewSchemModel) {
        Map<String, GanttCrossModel> corssSet = viewSchemModel.getCorssSet();
        for (GanttCrossModel value : corssSet.values()) {
            if (!GanttCrossObjectEnum.EMPTY.getValue().equals(value.getCrossObjType())) continue;
            return value;
        }
        return null;
    }

    public static List<DynamicObject> getEntryToDoTaskList(GanttBuildContext context, String entryTag, DynamicObject[] tasks) {
        List<DynamicObject> taskList = new ArrayList<DynamicObject>();
        if (Objects.isNull(tasks)) {
            return taskList;
        }
        CloneUtils cloneUtils = new CloneUtils(false, false);
        List<String> taskUpLevelFlags = GanttUtils.getTaskFirstUpFlag(context);
        String upLevelFlag = taskUpLevelFlags.get(taskUpLevelFlags.size() - 1);
        if (StringUtils.isNotBlank((CharSequence)entryTag)) {
            for (DynamicObject task : tasks) {
                DynamicObjectCollection entryCol;
                DynamicObject upObject = null;
                if (taskUpLevelFlags.size() == 1) {
                    upObject = task.getDynamicObject(upLevelFlag);
                }
                if ((entryCol = task.getDynamicObjectCollection(entryTag)).size() == 1) {
                    taskList.add(task);
                    continue;
                }
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryCol.get(i);
                    if (taskUpLevelFlags.size() == 2) {
                        upObject = entry.getDynamicObject(upLevelFlag);
                    }
                    if (!Objects.isNull(upObject)) continue;
                    DynamicObject newDyn = (DynamicObject)cloneUtils.clone((IDataEntityBase)task);
                    newDyn.getDynamicObjectCollection(entryTag).removeIf(x -> !x.getPkValue().equals(entry.getPkValue()));
                    taskList.add(newDyn);
                }
            }
        } else {
            taskList = Arrays.asList(tasks);
        }
        return taskList;
    }

    public static List<DynamicObject> getEntryPlanTaskList(GanttBuildContext context, String entryTag, DynamicObject[] tasks) {
        List<DynamicObject> taskList = new ArrayList<DynamicObject>();
        if (Objects.isNull(tasks)) {
            return taskList;
        }
        CloneUtils cloneUtils = new CloneUtils(false, false);
        if (StringUtils.isNotBlank((CharSequence)entryTag)) {
            String taskEntityNumber = GanttUtils.getTaskEntityNumber(context.getmGanttSourceObj());
            QFilter cacheQfilter = (QFilter)GanttCacheUtils.getCacheBigObjectWithDataModel((IPageCache)new PageCache(context.getPageId()), context.getDataModelType(), taskEntityNumber);
            ArrayList<Long> matchEntryIds = new ArrayList<Long>();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"gantt_queryEntryId", (String)taskEntityNumber, (String)entryTag.concat(".id"), (QFilter[])new QFilter[]{cacheQfilter}, null);){
                for (Row row : dataSet) {
                    matchEntryIds.add(row.getLong(0));
                }
            }
            for (DynamicObject task : tasks) {
                DynamicObjectCollection entryCol = task.getDynamicObjectCollection(entryTag);
                if (entryCol.size() == 1) {
                    taskList.add(task);
                    continue;
                }
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryCol.get(i);
                    if (!matchEntryIds.contains(entry.getLong("id"))) continue;
                    DynamicObject newDyn = (DynamicObject)cloneUtils.clone((IDataEntityBase)task);
                    newDyn.getDynamicObjectCollection(entryTag).removeIf(x -> !x.getPkValue().equals(entry.getPkValue()));
                    taskList.add(newDyn);
                }
            }
            GanttDealDataUtils.changeObjId(context, entryTag, taskList);
        } else {
            taskList = Arrays.asList(tasks);
        }
        return taskList;
    }

    private static void changeObjId(GanttBuildContext context, String entryTag, List<DynamicObject> taskList) {
        List<String> taskFlagUpLevel = GanttUtils.getTaskFirstUpFlag(context);
        if (!CollectionUtils.isEmpty(taskFlagUpLevel) && taskFlagUpLevel.size() == 2) {
            String upFlag = taskFlagUpLevel.get(taskFlagUpLevel.size() - 1);
            HashMap<String, Long> upIdToEntryIdMap = new HashMap<String, Long>(taskList.size());
            Iterator<DynamicObject> iterator = taskList.iterator();
            HashMap entryIdToIdMap = Maps.newHashMapWithExpectedSize((int)taskList.size());
            while (iterator.hasNext()) {
                DynamicObject task = iterator.next();
                DynamicObject entry = (DynamicObject)task.getDynamicObjectCollection(entryTag).get(0);
                DynamicObject upObject = entry.getDynamicObject(upFlag);
                if (Objects.isNull(upObject)) {
                    iterator.remove();
                    continue;
                }
                long id = upObject.getLong("id");
                long taskId = task.getLong("id");
                String taskAndUpId = taskId + "_" + id;
                Long entryId = (Long)upIdToEntryIdMap.get(taskAndUpId);
                if (entryId == null || entryId == 0L) {
                    upIdToEntryIdMap.put(taskAndUpId, entry.getLong("id"));
                }
                task.set("id", upIdToEntryIdMap.get(taskAndUpId));
                entryIdToIdMap.put(upIdToEntryIdMap.get(taskAndUpId), taskId);
            }
            GanttCacheUtils.cacheBigObjectWithDataModel(SessionManager.getCurrent().getPageCache(context.getPageId()), context.getDataModelType(), "entryIdToIdMap", entryIdToIdMap);
        }
    }

    public static void dealTaskData(List<GanttTaskModel> taskdatas) {
        HashSet<String> uniqeIds = new HashSet<String>(taskdatas.size());
        Iterator<GanttTaskModel> iterator = taskdatas.iterator();
        if (iterator.hasNext()) {
            GanttTaskModel task = iterator.next();
            String crossid = task.getCrossId();
            String taskid = task.getObjId();
            String taskEntryId = task.getTaskEntryId();
            String uniqeId = taskid + taskEntryId + crossid;
            if (!uniqeIds.add(uniqeId)) {
                iterator.remove();
            }
        }
    }

    private static void cacheData(GanttBuildContext context, GanttAreaTypeEnum areaType, List<GanttRowDataModel> rowdatas, List<GanttTaskModel> taskdatas, Map<String, Object> dataListMap) {
        GanttBuildPreModel preModel = context.getPreModel();
        boolean isExpand = preModel.getIsExpand();
        String pageId = preModel.getPageId();
        PageCache pageCache = new PageCache(pageId);
        if (areaType == GanttAreaTypeEnum.TODOAREA) {
            GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, context.getDataModelType(), "toDoDataList", rowdatas);
            if (!isExpand) {
                GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, context.getDataModelType(), "toDoTaskDataList", taskdatas);
            }
            GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, context.getDataModelType(), "toDoDataListMap", dataListMap);
        } else {
            GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, context.getDataModelType(), "dataList", rowdatas);
            if (!isExpand) {
                GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, context.getDataModelType(), "taskDataList", taskdatas);
            }
            GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, context.getDataModelType(), "dataListMap", dataListMap);
        }
    }

    @Deprecated
    private static List<GanttTaskModel> taskSortedAndRemoveNull(List<GanttTaskModel> taskdatas) {
        return taskdatas;
    }

    private static List<GanttTaskModel> taskSortedAndRemoveNull(List<GanttTaskModel> taskDatas, String timeRule, BigDecimal showScale) {
        for (GanttTaskModel taskData : taskDatas) {
            taskData.setMinStartDate(taskData.getStartDate());
            taskData.setMaxeEndDate(taskData.getEndDate());
            if (!taskData.getLabelIsShow().booleanValue()) continue;
            Long leftDescEndDate = GanttDealDataUtils.getEndDate(taskData.getStartDate(), GanttDealDataUtils.getMaxPixelOfStr(taskData), timeRule, showScale);
            Long rightDescEndDate = GanttDealDataUtils.getEndDate(taskData.getEndDate(), GanttDealDataUtils.getPixelOfStr(taskData.getRightDesc()), timeRule, showScale);
            if (rightDescEndDate.longValue() != taskData.getEndDate().longValue()) {
                rightDescEndDate = rightDescEndDate + (long)textOffSet;
            }
            Long descEndDate = leftDescEndDate > rightDescEndDate ? leftDescEndDate : rightDescEndDate;
            taskData.setMaxeEndDate(descEndDate);
            Long leftDate = GanttDealDataUtils.getDateOfPix(GanttDealDataUtils.getPixelOfStr(taskData.getLeftDesc()), timeRule, showScale);
            if (leftDate <= 0L) continue;
            taskData.setMinStartDate(taskData.getStartDate() - (long)textOffSet - leftDate);
        }
        return taskDatas.stream().filter(x -> x.getStartDate() != null && x.getStartDate() != 0L && x.getEndDate() != null && x.getEndDate() != 0L && (x.getStartDate() < x.getEndDate() || StringUtils.equals((CharSequence)x.getCrossObj(), (CharSequence)GanttCrossObjectEnum.LANDMARKS.getValue()))).sorted(Comparator.comparingLong(GanttTaskModel::getMinStartDate)).collect(Collectors.toList());
    }

    @Deprecated
    public static Map<String, Object> dealData(List<GanttRowDataModel> rowdatas, List<GanttTaskModel> taskdatas, PageCache pageCache, GanttAreaTypeEnum areaType) {
        GanttBuildPreModel preModel = GanttDealDataUtils.getPreModelByCache(pageCache);
        GanttBuildContext ganttBuildContext = (GanttBuildContext)GanttBigObjectCache.get((String)pageCache.getPageId(), (String)"ganttBuildContext");
        ganttBuildContext.setPreModel(preModel);
        return GanttDealDataUtils.dealData1(rowdatas, taskdatas, ganttBuildContext, areaType);
    }

    public static Map<String, Object> dealData(List<GanttRowDataModel> rowdatas, List<GanttTaskModel> taskdatas, GanttBuildContext buildContext, GanttAreaTypeEnum areaType) {
        GanttViewSchemModel viewSchemModel = buildContext.getmGanttViewSchemModel();
        Long start = viewSchemModel.getStart();
        Long end = viewSchemModel.getEnd();
        GanttBuildPreModel preModel = buildContext.getPreModel();
        preModel.setGlobalStartTime(start);
        preModel.setGlobalEndTime(end);
        return GanttDealDataUtils.dealData1(rowdatas, taskdatas, buildContext, areaType);
    }

    public static Map<String, Object> dealData1(List<GanttRowDataModel> rowdatas, List<GanttTaskModel> taskdatas, GanttBuildContext buildContext, GanttAreaTypeEnum areaType) {
        GanttBuildPreModel preModel = buildContext.getPreModel();
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        GanttDealDataUtils.rowDataRemoveDuplicate(rowdatas);
        String timeRule = GanttDealDataUtils.getTimeRule(preModel);
        BigDecimal showScale = GanttDealDataUtils.getShowScale(preModel);
        List<GanttTaskModel> filterTaskdatas = GanttDealDataUtils.taskSortedAndRemoveNull(taskdatas, timeRule, showScale);
        Map<String, List<GanttTaskModel>> ganttTaskModelMap = filterTaskdatas.stream().collect(Collectors.groupingBy(GanttTaskModel::getParentObjId));
        if (!buildContext.getDataModelType().equals(buildContext.getMianDataModelType())) {
            rowdatas.removeIf(x -> !ganttTaskModelMap.containsKey(x.getObjId()));
        }
        ArrayList<GanttTaskModel> taskResultDatas = new ArrayList<GanttTaskModel>(filterTaskdatas.size());
        HashMap<String, Object> dataListMap = new HashMap<String, Object>(rowdatas.size() + 1);
        int startRow = 1;
        int taskIndex = 0;
        GanttRowNumModel preGanttRowNumModel = new GanttRowNumModel();
        GanttCrossModel emptyBarCrossModel = preModel.getEmptyBarCrossModel();
        ArrayList<GanttTaskModel> emptyTaskList = new ArrayList<GanttTaskModel>();
        for (int i = 0; i < rowdatas.size(); ++i) {
            GanttRowNumModel ganttRowNumModel;
            GanttRowDataModel rowdata = rowdatas.get(i);
            String id = rowdata.getObjId();
            List<GanttTaskModel> taskPendingDatas = ganttTaskModelMap.get(id);
            if (CollectionUtils.isEmpty(taskPendingDatas)) {
                if (Objects.nonNull(emptyBarCrossModel) && areaType == GanttAreaTypeEnum.PLANAREA) {
                    GanttDealDataUtils.addEmptyTaskList(buildContext, emptyBarCrossModel, emptyTaskList, i, rowdata, id, taskPendingDatas, 1);
                }
                ganttRowNumModel = new GanttRowNumModel(1, startRow++, i, preGanttRowNumModel.getTaskStartIndex(), preGanttRowNumModel.getTaskEndIndex(), rowdata.getName());
            } else {
                int taskSize;
                for (GanttTaskModel taskPendingData : taskPendingDatas) {
                    taskPendingData.setRealRow(i);
                    taskPendingData.setTaskListIndex(taskIndex++);
                }
                int rows = GanttDealDataUtils.removeOverlap(taskResultDatas, taskPendingDatas);
                if (Objects.nonNull(emptyBarCrossModel) && areaType == GanttAreaTypeEnum.PLANAREA) {
                    GanttDealDataUtils.addEmptyTaskList(buildContext, emptyBarCrossModel, emptyTaskList, i, rowdata, id, taskPendingDatas, rows);
                }
                ganttRowNumModel = new GanttRowNumModel(rows, startRow, i, taskIndex - (taskSize = taskPendingDatas.size()) - expandIndex > 0 ? taskIndex - taskSize - expandIndex : 0, taskIndex + expandIndex, rowdata.getName());
                startRow += rows;
                rowdata.setRowCount(rows);
            }
            dataListMap.put(rowdata.getId(), ganttRowNumModel);
            preGanttRowNumModel = ganttRowNumModel;
        }
        dataListMap.put("totalRow", startRow - 1);
        taskdatas.clear();
        taskdatas.addAll(taskResultDatas);
        GanttDealDataUtils.cacheData(buildContext, areaType, rowdatas, taskdatas, dataListMap);
        String requestId = preModel.getRequestId();
        int needRow = GanttDealDataUtils.getNeddAddRow(buildContext, areaType);
        GanttDealDataUtils.autoAddLineForFornt(rowdatas, startRow - 1, needRow, requestId, dataListMap, preGanttRowNumModel, areaType, buildContext.getDataModelType());
        GanttDealDataUtils.autoDragLineForFornt(rowdatas, taskdatas, dataListMap, buildContext, areaType, requestId);
        returnMap.put("dataListMap", dataListMap);
        returnMap.put("emptyBarsList", emptyTaskList);
        return returnMap;
    }

    private static void autoDragLineForFornt(List<GanttRowDataModel> rowDatas, List<GanttTaskModel> taskDatas, Map<String, Object> dataListMap, GanttBuildContext buildContext, GanttAreaTypeEnum areaType, String requestId) {
        if (GanttUtils.isAddDragLine(buildContext.getEntityId()) && areaType.getName().equals("planArea")) {
            String dataModelType = buildContext.getDataModelType();
            String addId = requestId.concat("planarea").concat(Integer.toString(100));
            GanttRowDataModel ganttRowDataModel = new GanttRowDataModel(addId, null, "", null, Boolean.TRUE, Boolean.TRUE, 0, null, null, null, "0", null);
            ganttRowDataModel.setDropable(true);
            ganttRowDataModel.setRowType(GanttRowTypeEnum.TEXT.getValue());
            ganttRowDataModel.setDataModelType(dataModelType);
            GanttRowNumModel ganttRowNumModel = new GanttRowNumModel(1, rowDatas.size() - 1, rowDatas.size() - 1, taskDatas.size() - 1, taskDatas.size(), "");
            dataListMap.put(addId, ganttRowNumModel);
            rowDatas.add(ganttRowDataModel);
            for (GanttRowDataModel rowData : rowDatas) {
                rowData.setDropable(true);
            }
            dataListMap.put("totalRow", rowDatas.size());
        }
    }

    private static void addEmptyTaskList(GanttBuildContext context, GanttCrossModel emptyBarCrossModel, List<GanttTaskModel> emptyTaskList, int i, GanttRowDataModel rowdata, String id, List<GanttTaskModel> taskPendingDatas, int rows) {
        GanttBuildPreModel preModel = context.getPreModel();
        if (CollectionUtils.isEmpty(taskPendingDatas)) {
            GanttTaskModel ganttTaskModel = GanttDealDataUtils.createEmptyTask(context, emptyBarCrossModel, i, rowdata, id, rows, preModel.getGlobalStartTime(), preModel.getGlobalEndTime());
            emptyTaskList.add(ganttTaskModel);
            return;
        }
        List taskNoGroupList = taskPendingDatas.stream().filter(x -> !x.getTaskId().contains("group")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskNoGroupList)) {
            GanttTaskModel ganttTaskModel = GanttDealDataUtils.createEmptyTask(context, emptyBarCrossModel, i, rowdata, id, rows, preModel.getGlobalStartTime(), preModel.getGlobalEndTime());
            emptyTaskList.add(ganttTaskModel);
            return;
        }
        long maxTime = 0L;
        for (int i1 = 0; i1 <= taskNoGroupList.size(); ++i1) {
            Long preEndDate = preModel.getGlobalStartTime();
            Long lastStartDate = preModel.getGlobalEndTime();
            if (i1 == 0) {
                lastStartDate = ((GanttTaskModel)taskNoGroupList.get(i1)).getStartDate();
            } else if (i1 == taskNoGroupList.size()) {
                preEndDate = ((GanttTaskModel)taskNoGroupList.get(i1 - 1)).getEndDate();
            } else {
                preEndDate = ((GanttTaskModel)taskNoGroupList.get(i1 - 1)).getEndDate();
                lastStartDate = ((GanttTaskModel)taskNoGroupList.get(i1)).getStartDate();
            }
            preEndDate = preEndDate > maxTime ? preEndDate : maxTime;
            if (i1 < taskNoGroupList.size()) {
                Long endDate = ((GanttTaskModel)taskNoGroupList.get(i1)).getEndDate();
                long l = maxTime = maxTime > endDate ? maxTime : endDate;
            }
            if (preEndDate > lastStartDate) continue;
            GanttTaskModel ganttTaskModel = GanttDealDataUtils.createEmptyTask(context, emptyBarCrossModel, i, rowdata, id, rows, preEndDate, lastStartDate);
            emptyTaskList.add(ganttTaskModel);
        }
    }

    private static GanttTaskModel createEmptyTask(GanttBuildContext context, GanttCrossModel emptyBarCrossModel, int i, GanttRowDataModel rowdata, String id, int rows, Long preEndDate, Long lastStartDate) {
        String taskObjId = Long.toString(UUID.randomUUID().getMostSignificantBits());
        String allId = context.getRequestId().concat(emptyBarCrossModel.getCrossObjType().concat("_").concat(emptyBarCrossModel.getCrossType()).concat("_").concat(id).concat("_").concat(taskObjId));
        GanttTaskModel ganttTaskModel = new GanttTaskModel(rowdata.getId(), allId, emptyBarCrossModel.getCrossId(), emptyBarCrossModel.getCrossObjType(), emptyBarCrossModel.getCrossType(), new ArrayList<GanttLinkTaskModel>(), preEndDate, lastStartDate, null, null, emptyBarCrossModel.getLabelisshow(), taskObjId, id);
        ganttTaskModel.setDataModelType(context.getDataModelType());
        ganttTaskModel.setCrossValue(rows * rowHeightVal, emptyBarCrossModel.getIsline(), emptyBarCrossModel.getPosition(), emptyBarCrossModel.getCrossObj());
        ganttTaskModel.setBarColor(emptyBarCrossModel.getCrossColorVal());
        BigDecimal dayValue = new BigDecimal(lastStartDate - preEndDate).divide(DateValueEnum.DAY.getValue(), 0, 4);
        ganttTaskModel.setInnerDesc(dayValue.toString());
        ganttTaskModel.setRealRow(i);
        return ganttTaskModel;
    }

    private static void rowDataRemoveDuplicate(List<GanttRowDataModel> rowdatas) {
        ArrayList<String> rowDataIdList = new ArrayList<String>(rowdatas.size());
        Iterator<GanttRowDataModel> iterator = rowdatas.iterator();
        ArrayList<String> removeIds = new ArrayList<String>(rowdatas.size());
        while (iterator.hasNext()) {
            GanttRowDataModel ganttRowDataModel = iterator.next();
            String id = ganttRowDataModel.getObjId();
            if (rowDataIdList.contains(id)) {
                iterator.remove();
                removeIds.add(ganttRowDataModel.getRandomId());
                continue;
            }
            rowDataIdList.add(id);
        }
        for (GanttRowDataModel rowdata : rowdatas) {
            List<GanttRowDataModel> childNodes = rowdata.getChildNodes();
            if (CollectionUtils.isEmpty(childNodes)) continue;
            childNodes = childNodes.stream().filter(x -> !removeIds.contains(x.getRandomId())).collect(Collectors.toList());
            rowdata.setChildNodes(childNodes);
        }
    }

    private static void autoAddLineForFornt(List<GanttRowDataModel> rowdatas, int row, int needRow, String requestId, Map<String, Object> dataListMap, GanttRowNumModel preGanttRowNumModel, GanttAreaTypeEnum areaType, String dataModelType) {
        if (needRow > row) {
            for (int i = 0; i < needRow - row; ++i) {
                String addId = requestId.concat(areaType.getName()).concat(Integer.toString(i));
                GanttRowDataModel ganttRowDataModel = new GanttRowDataModel(addId, null, "", null, Boolean.TRUE, Boolean.TRUE, 0, null, null, null, "0", null);
                ganttRowDataModel.setDropable(false);
                ganttRowDataModel.setRowType(GanttRowTypeEnum.TEXT.getValue());
                ganttRowDataModel.setDataModelType(dataModelType);
                GanttRowNumModel ganttRowNumModel = new GanttRowNumModel(1, row + i + 1, rowdatas.size() + i, preGanttRowNumModel.getTaskStartIndex(), preGanttRowNumModel.getTaskEndIndex(), "");
                dataListMap.put(addId, ganttRowNumModel);
                rowdatas.add(ganttRowDataModel);
            }
            dataListMap.put("totalRow", needRow);
        }
    }

    private static int getNeddAddRow(GanttBuildContext context, GanttAreaTypeEnum areaType) {
        int needRow = GanttDealDataUtils.getNeddAddRow(context.getPreModel(), areaType);
        if (areaType == GanttAreaTypeEnum.PLANAREA && context.getmGanttViewSchemModel().getSummaryShow().booleanValue()) {
            needRow -= 3;
        }
        return needRow;
    }

    private static int getNeddAddRow(GanttBuildPreModel preModel, GanttAreaTypeEnum areaType) {
        int needRow = 0;
        if (areaType == GanttAreaTypeEnum.TODOAREA) {
            needRow = toDoRow;
        } else {
            boolean toDoShow = preModel.getToDoShow();
            needRow = minRow;
            if (toDoShow) {
                needRow -= toDoRow;
            }
        }
        return needRow;
    }

    public static void dealDataForFornt(List<GanttRowDataModel> rowdatas) {
        if (!CollectionUtils.isEmpty(rowdatas)) {
            for (GanttRowDataModel ganttRowDataModel : rowdatas) {
                ganttRowDataModel.setChildNodes(null);
            }
        }
    }

    private static String getTimeRule(GanttBuildPreModel preModel) {
        String cellUnitType = preModel.getCellUnitType();
        if (StringUtils.isBlank((CharSequence)cellUnitType)) {
            cellUnitType = "day";
        }
        return cellUnitType;
    }

    private static BigDecimal getShowScale(GanttBuildPreModel preModel) {
        String showScaleStr = preModel.getScale();
        if (StringUtils.isBlank((CharSequence)showScaleStr)) {
            return GanttDefaultDataConst.SHOW_SCALE;
        }
        return new BigDecimal(showScaleStr);
    }

    private static int removeOverlap(List<GanttTaskModel> taskResultDatas, List<GanttTaskModel> taskPendingDatas) {
        LinkedHashMap groupIdToDateMap = new LinkedHashMap(taskPendingDatas.size());
        for (GanttTaskModel taskPendingData : taskPendingDatas) {
            String groupId = taskPendingData.getParentObjId() + "_" + taskPendingData.getTaskEntryId();
            Long startDate = taskPendingData.getMinStartDate();
            Long endDate = taskPendingData.getMaxeEndDate();
            HashMap<String, Long> dateMap = (HashMap<String, Long>)groupIdToDateMap.get(groupId);
            if (dateMap == null) {
                dateMap = new HashMap<String, Long>(2);
                dateMap.put("startDate", startDate);
                dateMap.put("endDate", endDate);
            } else {
                if (startDate < (Long)dateMap.get("startDate")) {
                    dateMap.put("startDate", startDate);
                }
                if (endDate > (Long)dateMap.get("endDate")) {
                    dateMap.put("endDate", endDate);
                }
            }
            groupIdToDateMap.put(groupId, dateMap);
        }
        int rows = 0;
        HashMap rowToMaxValueMap = new HashMap(16);
        HashMap groupIdToRowMap = new HashMap(taskPendingDatas.size());
        for (Map.Entry groupIdToDateMapEntry : groupIdToDateMap.entrySet()) {
            Boolean isSetRow = Boolean.FALSE;
            for (Map.Entry rowEntry : rowToMaxValueMap.entrySet()) {
                Long value = (Long)rowEntry.getValue();
                if (value.compareTo((Long)((Map)groupIdToDateMapEntry.getValue()).get("startDate")) >= 0) continue;
                Integer row = (Integer)rowEntry.getKey();
                rowToMaxValueMap.put(row, ((Map)groupIdToDateMapEntry.getValue()).get("endDate"));
                groupIdToRowMap.put(groupIdToDateMapEntry.getKey(), row);
                isSetRow = Boolean.TRUE;
                break;
            }
            if (isSetRow.booleanValue()) continue;
            rowToMaxValueMap.put(++rows, ((Map)groupIdToDateMapEntry.getValue()).get("endDate"));
            groupIdToRowMap.put(groupIdToDateMapEntry.getKey(), rows);
        }
        taskPendingDatas.stream().forEach(x -> x.setCurRow((Integer)groupIdToRowMap.get(x.getParentObjId() + "_" + x.getTaskEntryId())));
        taskResultDatas.addAll(taskPendingDatas);
        return rows;
    }

    private static int getMaxPixelOfStr(GanttTaskModel taskPendingData) {
        Font f = new Font(font, 0, fontSize);
        JLabel j = new JLabel();
        FontMetrics fm = j.getFontMetrics(f);
        int descLength = taskPendingData.getDesc() == null ? 0 : fm.stringWidth(taskPendingData.getDesc());
        int innerDescLength = taskPendingData.getInnerDesc() == null ? 0 : fm.stringWidth(taskPendingData.getInnerDesc());
        int botDescLength = taskPendingData.getBotDesc() == null ? 0 : fm.stringWidth(taskPendingData.getBotDesc());
        int max = descLength > innerDescLength ? (descLength += taskPendingData.getDescIconList().size() * 14) : innerDescLength;
        max = max > botDescLength ? max : botDescLength;
        return max == 0 ? 0 : max + textOffSet;
    }

    private static int getPixelOfStr(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            return 0;
        }
        Font f = new Font(font, 0, fontSize);
        JLabel j = new JLabel();
        FontMetrics fm = j.getFontMetrics(f);
        int descLength = fm.stringWidth(desc);
        return descLength;
    }

    private static Long getEndDate(Long startDate, int pixel, String timeRule, BigDecimal showScale) {
        return startDate + GanttDealDataUtils.getDateOfPix(pixel, timeRule, showScale);
    }

    private static Long getDateOfPix(int pixel, String timeRule, BigDecimal showScale) {
        for (DateValueEnum value : DateValueEnum.values()) {
            if (!timeRule.equals(value.getName())) continue;
            BigDecimal bigDecimal = new BigDecimal(Integer.toString(pixel)).multiply(value.getValue()).divide(new BigDecimal(Integer.toString(baseWidth)).multiply(showScale), 2, 4);
            return bigDecimal.longValue();
        }
        return 0L;
    }

    public static String getDescDynamicObject(DynamicObject dyn, GanttBuildContext context, String crossObj, String corssType, String fieldType) {
        DynamicObject customGanttSource = context.getCustomGanttSourceMap().get(dyn.getLong("id"));
        StringBuilder builder = new StringBuilder();
        String connector = "";
        if (customGanttSource != null) {
            DynamicObjectCollection entryColl = customGanttSource.getDynamicObjectCollection("entryentity");
            DynamicObject entryDyn = entryColl.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("crossobj"), (CharSequence)crossObj) && StringUtils.equals((CharSequence)(Objects.isNull(x.getDynamicObject("crosstype")) ? "" : x.getDynamicObject("crosstype").getString("crosstype")), (CharSequence)corssType)).findFirst().orElse(null);
            if (entryDyn == null) {
                return "";
            }
            DynamicObjectCollection subEntryColl = entryDyn.getDynamicObjectCollection("subentryentity");
            DynamicObject crossCotent = subEntryColl.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("contentlocation"), (CharSequence)fieldType)).findFirst().orElse(null);
            if (crossCotent == null) {
                return "";
            }
            String labelKind = crossCotent.getString("contenttype");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)labelKind)) {
                String content = crossCotent.getString("fieldcontentdesc");
                connector = crossCotent.getString("concatflag");
                String labeltype = crossCotent.getString("lbltype");
                String labelformat = crossCotent.getString("lblformat");
                String[] fieldArrays = content.split(",");
                String[] labeltypeArrays = labeltype.split(",");
                String[] labelformatArrays = labelformat.split(",");
                int index = 0;
                for (String fields : fieldArrays) {
                    if (StringUtils.isBlank((CharSequence)fields)) {
                        builder.append("").append(connector);
                        continue;
                    }
                    String ltype = labeltypeArrays.length != fieldArrays.length ? "" : labeltypeArrays[index];
                    String lformat = labelformatArrays.length != fieldArrays.length ? "" : labelformatArrays[index];
                    String entryTag = GanttDealDataUtils.getEntryTag(context.getEntryTagList(), fields);
                    if (StringUtils.isNotBlank((CharSequence)entryTag)) {
                        fields = fields.substring(entryTag.length() + 1);
                        DynamicObjectCollection entryList = dyn.getDynamicObjectCollection(entryTag);
                        if (!CollectionUtils.isEmpty((Collection)entryList)) {
                            DynamicObject dynamicObject = (DynamicObject)entryList.get(0);
                            Object value = GanttDealDataUtils.getValue(dynamicObject, context.getComboItemsMap(), context.getDecimalPropMap(), fields, ltype, lformat, fieldType);
                            builder.append(value).append(connector);
                        } else {
                            builder.append("").append(connector);
                        }
                    } else {
                        Object value = GanttDealDataUtils.getValue(dyn, context.getComboItemsMap(), context.getDecimalPropMap(), fields, ltype, lformat, fieldType);
                        builder.append(value).append(connector);
                    }
                    ++index;
                }
            } else {
                if (StringUtils.equals((CharSequence)"2", (CharSequence)labelKind)) {
                    DynamicObject customerDyn = crossCotent.getDynamicObject("customimpl");
                    if (customerDyn == null) {
                        return "";
                    }
                    String implClass = customerDyn.getString("implclass");
                    return GanttDealDataUtils.getCustomerValue(dyn, context, crossObj, corssType, implClass);
                }
                if (StringUtils.equals((CharSequence)"3", (CharSequence)labelKind)) {
                    return crossCotent.getString("contentnote");
                }
            }
        } else {
            String dataModelType = context.getDataModelType();
            DynamicObject mGantt = context.getmGanttSourceObj();
            boolean isChange = mGantt.getBoolean("ischange");
            List<String> entryTagList = context.getEntryTagList();
            Map<String, List<ValueMapItem>> comboItemsMap = context.getComboItemsMap();
            Map<String, DecimalPropModel> decimalPropMap = context.getDecimalPropMap();
            DynamicObjectCollection colls = mGantt.getDynamicObjectCollection("crossset");
            String content = "";
            String labeltype = "";
            String labelformat = "";
            String labelKind = "1";
            for (DynamicObject coll : colls) {
                DynamicObject crossCotent;
                String tcrosstype;
                String tcrossobj = coll.getString("crossobj");
                DynamicObject crossTypeObj = coll.getDynamicObject("crosstype");
                String string = tcrosstype = Objects.isNull(crossTypeObj) ? "" : crossTypeObj.getString("crosstype");
                if (!tcrossobj.equals(crossObj) || !tcrosstype.equals(corssType)) continue;
                DynamicObjectCollection crossCotentEntry = coll.getDynamicObjectCollection("crosscontententry");
                if (CollectionUtils.isEmpty((Collection)crossCotentEntry)) break;
                DynamicObject dataModelEntity = GanttUtils.getDataModelEntity(mGantt, dataModelType);
                if (isChange) {
                    crossCotent = crossCotentEntry.stream().filter(x -> dataModelEntity.getLong("viewid") == x.getLong("cviewid") && StringUtils.equals((CharSequence)x.getString("lableseat"), (CharSequence)fieldType)).findFirst().orElse(null);
                    if (crossCotent == null) break;
                    content = crossCotent.getString("labelflag");
                    connector = crossCotent.getString("labelconnector");
                    labeltype = crossCotent.getString("lbltype");
                    labelformat = crossCotent.getString("lblformat");
                    labelKind = crossCotent.getString("labelkind");
                } else {
                    crossCotent = crossCotentEntry.stream().filter(x -> dataModelEntity.getLong("viewid") == x.getLong("cviewid")).findFirst().orElse(null);
                    if (crossCotent == null) break;
                    if (GanttContentLocationEnum.UP.getValue().equals(fieldType)) {
                        content = crossCotent.getString("entrycrossflagcontent");
                        connector = crossCotent.getString("entryflagconnector");
                        labeltype = crossCotent.getString("ltype");
                        labelformat = crossCotent.getString("labelformat");
                    } else if (GanttContentLocationEnum.TIP.getValue().equals(fieldType)) {
                        content = crossCotent.getString("entrycrossflagdetailconte");
                        connector = crossCotent.getString("entryflagdetailconnector");
                        labeltype = crossCotent.getString("ltypeonewo");
                        labelformat = crossCotent.getString("labelformattwo");
                    } else if (GanttContentLocationEnum.CENTRE.getValue().equals(fieldType)) {
                        content = crossCotent.getString("entrycrossfcone");
                        connector = crossCotent.getString("entryflagconnectorone");
                        labeltype = crossCotent.getString("ltypeone");
                        labelformat = crossCotent.getString("labelformatone");
                    }
                }
                if (StringUtils.equals((CharSequence)labelKind, (CharSequence)"2")) {
                    DynamicObject customerDyn = crossCotent.getDynamicObject("customimpl");
                    if (customerDyn == null) {
                        return "";
                    }
                    String implClass = customerDyn.getString("implclass");
                    return GanttDealDataUtils.getCustomerValue(dyn, context, crossObj, corssType, implClass);
                }
                String[] fieldArrays = content.split(",");
                String[] labeltypeArrays = labeltype.split(",");
                String[] labelformatArrays = labelformat.split(",");
                int index = 0;
                for (String fields : fieldArrays) {
                    if (StringUtils.isBlank((CharSequence)fields)) {
                        builder.append("").append(connector);
                        continue;
                    }
                    String ltype = labeltypeArrays.length != fieldArrays.length ? "" : labeltypeArrays[index];
                    String lformat = labelformatArrays.length != fieldArrays.length ? "" : labelformatArrays[index];
                    String entryTag = GanttDealDataUtils.getEntryTag(entryTagList, fields);
                    if (StringUtils.isNotBlank((CharSequence)entryTag)) {
                        fields = fields.substring(entryTag.length() + 1);
                        DynamicObjectCollection entryList = dyn.getDynamicObjectCollection(entryTag);
                        if (!CollectionUtils.isEmpty((Collection)entryList)) {
                            DynamicObject dynamicObject = (DynamicObject)entryList.get(0);
                            Object value = GanttDealDataUtils.getValue(dynamicObject, comboItemsMap, decimalPropMap, fields, ltype, lformat, fieldType);
                            builder.append(value).append(connector);
                        } else {
                            builder.append("").append(connector);
                        }
                    } else {
                        Object value = GanttDealDataUtils.getValue(dyn, comboItemsMap, decimalPropMap, fields, ltype, lformat, fieldType);
                        builder.append(value).append(connector);
                    }
                    ++index;
                }
                break;
            }
        }
        builder.setLength(builder.length() - connector.length());
        return builder.toString();
    }

    private static String getCustomerValue(DynamicObject dyn, GanttBuildContext context, String crossObj, String corssType, String implClass) {
        Object classInstance;
        if (StringUtils.isNotBlank((CharSequence)implClass) && (classInstance = TypesContainer.createInstance((String)implClass)) instanceof CustomerContentService) {
            CustomerContentService contentService = (CustomerContentService)classInstance;
            String customerValue = contentService.getCustomerValue(context, dyn, crossObj, corssType);
            return customerValue;
        }
        return "";
    }

    private static String getEntryTag(List<String> entryTagList, String fields) {
        String entryTag = "";
        for (String entry : entryTagList) {
            if (!fields.startsWith(entry)) continue;
            entryTag = entry;
            break;
        }
        return entryTag;
    }

    private static Object getValue(DynamicObject dyn, Map<String, List<ValueMapItem>> comboItemsMap, Map<String, DecimalPropModel> decimalPropMap, String fields, String labeltype, String labelformat, String fieldType) {
        Object value = dyn.get(fields);
        if (Objects.isNull(value)) {
            value = "-";
            return value;
        }
        if (comboItemsMap.containsKey(fields)) {
            for (ValueMapItem valueMapItem : comboItemsMap.get(fields)) {
                if (!valueMapItem.getValue().equals(value.toString())) continue;
                String name = valueMapItem.getName().toString();
                return name;
            }
        }
        if (decimalPropMap.containsKey(fields)) {
            DecimalPropModel decimalPropModel = decimalPropMap.get(fields);
            BigDecimal bigDecimal = new BigDecimal(value.toString()).setScale(decimalPropModel.getScale(), 4);
            if (decimalPropModel.getNoDisplayScaleZero()) {
                bigDecimal = bigDecimal.stripTrailingZeros();
            }
            value = bigDecimal.toPlainString();
        }
        if (StringUtils.isNotEmpty((CharSequence)labeltype) && StringUtils.isNotEmpty((CharSequence)labelformat)) {
            String errormsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u6a2a\u9053\u7c7b\u578b\u6807\u7b7e\u8bbe\u7f6e%s\u914d\u7f6e\u6709\u8bef\u3002", (String)"GanttDealDataUtils_2", (String)"bd-mpdm-gantt", (Object[])new Object[0]), GanttLabelFiledTypeEnum.get(fieldType).getName());
            if (labeltype.equals(GanttLabelTypeEnum.DATE.getValue())) {
                if (value instanceof Timestamp) {
                    Date date = new Date(((Timestamp)value).getTime());
                    try {
                        value = DateUtils.formatDate((Date)date, (Object[])new Object[]{labelformat});
                    }
                    catch (Exception e) {
                        throw new KDBizException(errormsg);
                    }
                }
            } else if (labeltype.equals(GanttLabelTypeEnum.PERCENTAGE.getValue()) && (value instanceof BigDecimal || value instanceof Integer)) {
                value = ((BigDecimal)value).toPlainString() + labelformat;
            }
        }
        return value;
    }
}

