/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GanttDynamicObjectJsonParserUtil {
    private static final Log logger = LogFactory.getLog(GanttDynamicObjectJsonParserUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] deserialize(String str, DynamicObjectType dt) {
        String outStr = "";
        GZIPInputStream gunzip = null;
        try {
            int n;
            byte[] bytes = Base64.getDecoder().decode(str);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            gunzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            outStr = out.toString();
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
        }
        finally {
            try {
                if (gunzip != null) {
                    gunzip.close();
                }
            }
            catch (IOException e) {
                logger.info(e.getMessage());
            }
        }
        DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dt);
        b.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
        String[] r = (String[])JSON.parseObject((String)outStr, String[].class);
        Object[] result = new Object[r.length];
        for (int i = 0; i < r.length; ++i) {
            DynamicObject o = (DynamicObject)jsr.deserializeFromString(r[i], null);
            result[i] = o;
        }
        return result;
    }
}

