/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPrintTempModel;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class GanttImageCutterUtil {
    private static Log logger = LogFactory.getLog(GanttImageCutterUtil.class);

    public static String getImageFormatName(File file) throws IOException {
        String formatName = null;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> imageReader = ImageIO.getImageReaders(iis);
        if (imageReader.hasNext()) {
            ImageReader reader = imageReader.next();
            formatName = reader.getFormatName();
        }
        return formatName;
    }

    public static BufferedImage[] processImage(BufferedImage[] images, int x, int y, int width, int height) throws Exception {
        if (null == images) {
            return images;
        }
        BufferedImage[] oldImages = images;
        images = new BufferedImage[images.length];
        for (int i = 0; i < oldImages.length; ++i) {
            BufferedImage image = oldImages[i];
            BufferedImage subimage = image.getSubimage(x, y, width, height);
            BufferedImage bufferedImage = new BufferedImage(subimage.getWidth(), subimage.getHeight(), 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(subimage, 0, 0, null);
            graphics.dispose();
            images[i] = bufferedImage;
        }
        return images;
    }

    public static BufferedImage[] cutImage(BufferedImage sourceImg, int x, int y, int width, int height) throws Exception {
        BufferedImage[] images = new BufferedImage[]{sourceImg};
        images = GanttImageCutterUtil.processImage(images, x, y, width, height);
        return images;
    }

    public static BufferedImage zoom(BufferedImage sourceImage, int width, int height) {
        BufferedImage zoomImage = new BufferedImage(width, height, sourceImage.getType());
        Image image = sourceImage.getScaledInstance(width, height, 4);
        Graphics gc = zoomImage.getGraphics();
        gc.setColor(Color.WHITE);
        gc.drawImage(image, 0, 0, null);
        return zoomImage;
    }

    public static String getFilePrefixPath(File file) throws IOException {
        String path = null;
        if (!file.exists()) {
            throw new IOException("not found the file !");
        }
        String fileName = file.getName();
        path = file.getPath().replace(fileName, "");
        return path;
    }

    public static String getFilePrefixPath(String path) throws Exception {
        if (null == path || path.isEmpty()) {
            throw new Exception("File Path is null\uff01");
        }
        int index = path.lastIndexOf(File.separator);
        if (index > 0) {
            path = path.substring(0, index + 1);
        }
        return path;
    }

    public static String getPathWithoutSuffix(String src) {
        String path = src;
        int index = path.lastIndexOf(".");
        if (index > 0) {
            path = path.substring(0, index + 1);
        }
        return path;
    }

    public static byte[] readStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = inStream.read(buffer)) != -1) {
            outSteam.write(buffer, 0, len);
        }
        outSteam.close();
        inStream.close();
        return outSteam.toByteArray();
    }

    public static String base64CodeToBeImage(String billformid, String pageid, InputStream inStream, String path, BigDecimal zoomRatio, Integer printpage, String radiogroup) {
        String returnObjPk = null;
        BufferedImage image = null;
        byte[] imageByte = null;
        try {
            imageByte = GanttImageCutterUtil.readStream(inStream);
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            image = ImageIO.read(new ByteArrayInputStream(imageByte));
            bis.close();
            returnObjPk = GanttImageCutterUtil.cuteDetial(billformid, pageid, image, printpage, radiogroup);
        }
        catch (Exception e) {
            logger.error(ResManager.loadKDString((String)"\u751f\u6210\u56fe\u7247\u5931\u8d25", (String)"GanttImageCutterUtil_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u56fe\u7247\u5931\u8d25%s", (String)"GanttImageCutterUtil_2", (String)"bd-mpdm-gantt", (Object[])new Object[]{e.getMessage()}));
        }
        return returnObjPk;
    }

    public static GanttPrintTempModel getPrintSettingData(String billformid) {
        GanttPrintTempModel tpMode = new GanttPrintTempModel();
        Long userId = RequestContext.get().getCurrUserId();
        String key = billformid + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)key);
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        tpMode.setCompratio(new BigDecimal(String.valueOf(jsonData.get("compratio"))));
        String templateid = String.valueOf(jsonData.get("templateid"));
        PrintMetadata printMetadata = null;
        try {
            printMetadata = PrintMetadataUtil.getPrintMetadata((String)templateid);
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6253\u5370\u9884\u89c8\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"GanttImageCutterUtil_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        kd.bos.print.api.metedata.control.Image tmpImage = null;
        if (printMetadata != null) {
            List pages = printMetadata.getPages();
            for (List listpages : pages) {
                for (Control comp : listpages) {
                    if (!(comp instanceof kd.bos.print.api.metedata.control.Image)) continue;
                    tmpImage = (kd.bos.print.api.metedata.control.Image)comp;
                }
            }
            if (tmpImage != null) {
                Number width = (Number)tmpImage.getWidth().getDefaultValue();
                Number height = (Number)tmpImage.getHeight().getDefaultValue();
                tpMode.setTempWidth(width.intValue());
                tpMode.setTempHigh(height.intValue());
            }
        }
        return tpMode;
    }

    public static String cuteDetial(String billformid, String pageid, BufferedImage image, Integer printpage, String radiogroup) throws Exception {
        GanttPrintTempModel setModel = GanttImageCutterUtil.getPrintSettingData(billformid);
        Long parentid = ORM.create().genLongId("mpdm_gantt_printstore");
        try {
            boolean radiogroupValue;
            int m_width = 0;
            int m_higth = 0;
            int width = setModel.getTempWidth();
            int height = setModel.getTempHigh();
            int destWidth = image.getWidth();
            int destHeight = image.getHeight();
            boolean bl = radiogroupValue = "1".equals(radiogroup);
            if (radiogroupValue) {
                m_width = destWidth / printpage;
                m_higth = m_width * height / width;
            } else {
                m_higth = destHeight / printpage;
                m_width = m_higth * width / height;
            }
            if (destWidth < m_width) {
                m_width = destWidth;
            }
            if (destHeight < m_higth) {
                m_higth = destHeight;
            }
            List<List<Integer>> reactList = GanttImageCutterUtil.getCuteReactList(m_width, m_higth, destWidth, destHeight, radiogroupValue);
            FileService service = FileServiceFactory.getImageFileService();
            int printcount = 1;
            for (List<Integer> data : reactList) {
                DynamicObject billDyn = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_gantt_printstore");
                billDyn.set("batchid", (Object)parentid);
                billDyn.set("enable", (Object)1);
                billDyn.set("status", (Object)"A");
                billDyn.set("pageid", (Object)pageid);
                CodeRuleInfo coderuleinfo = CodeRuleServiceHelper.getCodeRule((String)"mpdm_gantt_printstore", (DynamicObject)billDyn, (String)"0");
                String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)coderuleinfo, (DynamicObject)billDyn);
                billDyn.set("number", (Object)number);
                String formatName = IMAGE_FORMAT.JPG.getValue();
                String pathSuffix = "." + formatName;
                String targetPath = System.currentTimeMillis() + pathSuffix;
                String uploadPath = "/image/mmc/ganttprint/" + targetPath;
                BufferedImage[] images = GanttImageCutterUtil.cutImage(image, data.get(0), data.get(1), data.get(2), data.get(3));
                BufferedImage input = images[0];
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)input, "jpg", os);
                }
                catch (IOException e) {
                    throw new KDBizException(e.getMessage());
                }
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                FileItem fileitem = new FileItem(targetPath, uploadPath, (InputStream)is);
                String path = service.upload(fileitem);
                billDyn.set("picstore", (Object)uploadPath);
                billDyn.set("printindex", (Object)printcount++);
                billDyn.set("picstore", (Object)path);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billDyn});
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return String.valueOf(parentid);
    }

    private static List<List<Integer>> getCuteReactList(int width, int height, int i_width, int i_height, boolean isLeftToRight) {
        double f1 = BigDecimal.valueOf((float)i_width / (float)width).setScale(2, 4).doubleValue();
        double f2 = BigDecimal.valueOf((float)i_height / (float)height).setScale(2, 4).doubleValue();
        int cols = (int)Math.ceil(f1);
        int rows = (int)Math.ceil(f2);
        int chunks = cols * rows;
        ArrayList<List<Integer>> reactList = new ArrayList<List<Integer>>(chunks);
        int startX = 0;
        int startY = 0;
        int currentWidth = width;
        int currentHeight = height;
        if (isLeftToRight) {
            for (int x = 0; x < rows; ++x) {
                for (int y = 0; y < cols; ++y) {
                    ArrayList<Integer> result = new ArrayList<Integer>(4);
                    result.add(startX);
                    result.add(startY);
                    if (currentWidth > i_width) {
                        result.add(width - (currentWidth - i_width));
                    } else {
                        result.add(width);
                    }
                    if (currentHeight > i_height) {
                        result.add(height - (currentHeight - i_height));
                    } else {
                        result.add(height);
                    }
                    startX += width;
                    currentWidth += width;
                    reactList.add(result);
                }
                startX = 0;
                startY += height;
                currentWidth = width;
                currentHeight += height;
            }
        } else {
            for (int y = 0; y < cols; ++y) {
                for (int x = 0; x < rows; ++x) {
                    ArrayList<Integer> result = new ArrayList<Integer>(4);
                    result.add(startX);
                    result.add(startY);
                    if (currentWidth > i_width) {
                        result.add(width - (currentWidth - i_width));
                    } else {
                        result.add(width);
                    }
                    if (currentHeight > i_height) {
                        result.add(height - (currentHeight - i_height));
                    } else {
                        result.add(height);
                    }
                    startY += height;
                    currentHeight += height;
                    reactList.add(result);
                }
                startY = 0;
                startX += width;
                currentHeight = height;
                currentWidth += width;
            }
        }
        return reactList;
    }

    public static enum IMAGE_FORMAT {
        BMP("bmp"),
        JPG("jpg"),
        WBMP("wbmp"),
        JPEG("jpeg"),
        PNG("png"),
        GIF("gif");

        private String value;

        private IMAGE_FORMAT(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

