/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import org.apache.commons.lang.StringUtils;

public class GanttUserConfigUtils {
    private static final String KEY_SUFFIX = "_pageShowSetConfig";
    private static final String COLUMS_SUFFIX = "_columsWidthConfig";

    public static GanttPageShowModel getConfig(ListView view) {
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)view.getBillFormId().concat(KEY_SUFFIX));
        if (StringUtils.isNotBlank((String)setting)) {
            GanttPageShowModel ganttPageShowModel = (GanttPageShowModel)SerializationUtils.fromJsonString((String)setting, GanttPageShowModel.class);
            return ganttPageShowModel;
        }
        return null;
    }

    public static void setConfig(ListView view, GanttPageShowModel ganttPageShowModel) {
        UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)view.getBillFormId().concat(KEY_SUFFIX), (String)SerializationUtils.toJsonString((Object)ganttPageShowModel));
    }

    public static void clearConfig(ListView view) {
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)view.getBillFormId().concat(KEY_SUFFIX));
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)view.getBillFormId().concat(COLUMS_SUFFIX));
    }

    public static boolean getShowRisk(ListView view) {
        String pageId = view.getPageId();
        GanttPageShowModel showModel = GanttUserConfigUtils.getConfig(view);
        if (Objects.isNull(showModel)) {
            showModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(pageId, "pageShowSet");
        }
        return showModel.getShowRisk();
    }

    public static boolean getShowIndex(ListView view) {
        String pageId = view.getPageId();
        GanttPageShowModel showModel = GanttUserConfigUtils.getConfig(view);
        if (Objects.isNull(showModel)) {
            showModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(pageId, "pageShowSet");
        }
        return showModel.getShowIndex();
    }

    public static GanttPageShowModel getPageShowSet(ListView view) {
        String pageId = view.getPageId();
        GanttPageShowModel showModel = GanttUserConfigUtils.getConfig(view);
        if (Objects.isNull(showModel)) {
            showModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(pageId, "pageShowSet");
        }
        return showModel;
    }

    public static void setColumsWidth(ListView view, int index, int columWidth) {
        Map<String, Integer> columsWidth = GanttUserConfigUtils.getColumsWidth(view);
        if (Objects.isNull(columsWidth)) {
            columsWidth = new HashMap<String, Integer>(1);
        }
        columsWidth.put(Integer.toString(index), columWidth);
        UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)view.getBillFormId().concat(COLUMS_SUFFIX), (String)SerializationUtils.toJsonString(columsWidth));
    }

    public static Map<String, Integer> getColumsWidth(ListView view) {
        String columsWidthStr = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)view.getBillFormId().concat(COLUMS_SUFFIX));
        if (StringUtils.isNotBlank((String)columsWidthStr)) {
            Map columsWidthMap = (Map)SerializationUtils.fromJsonString((String)columsWidthStr, Map.class);
            return columsWidthMap;
        }
        return null;
    }
}

