/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.enums.GanttLineTypeEnum;
import kd.bd.mpdm.common.gantt.consts.JobViewSchemConst;
import kd.bd.mpdm.common.gantt.enums.GanttAreaTypeEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttRowTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.DecimalPropModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildCycleModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttColModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCrossModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttFilterArg;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttFilterParamModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttGlobalModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLinkTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttMenusSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherDateLineMoel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherHLineModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherLLineModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttQFilter;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttResourceEditSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskMenusSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttYLinesModel;
import kd.bd.mpdm.common.gantt.ganttmodel.build.impl.GanttModelStandardBuild;
import kd.bd.mpdm.common.gantt.ganttmodel.builder.DecoratorFactoryBuilder;
import kd.bd.mpdm.common.gantt.ganttmodel.builder.GanttModelBuilder;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttUserConfigUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.list.ControlContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import org.apache.commons.beanutils.BeanUtils;

public class GanttUtils {
    private static Log logger = LogFactory.getLog(GanttUtils.class);
    private static final Map<String, String> existTreeEntityMap = new HashMap<String, String>();
    private static final Map<String, Integer> entityFlagIndex = new HashMap<String, Integer>();
    private static final Map<String, Integer> accessMap = new HashMap<String, Integer>();
    private static final List<String> resourceReverseList = new ArrayList<String>();
    private static final Map<String, Integer> dropTargetTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> timeLineFillTypeMap = new HashMap<String, Integer>();
    private static final List<String> customerTimeList = new ArrayList<String>();
    private static final List<String> addDragLineList = new ArrayList<String>();

    public static List<String> getResourceReverseList() {
        return resourceReverseList;
    }

    public static boolean isOnlyCustomerTime(String entityId) {
        return customerTimeList.contains(entityId);
    }

    public static boolean isAddDragLine(String entityId) {
        return addDragLineList.contains(entityId);
    }

    public static Integer getEntityFlagIndex(String metaKey) {
        Integer index = entityFlagIndex.get(metaKey);
        return index == null ? Integer.valueOf(0) : index;
    }

    public static void putEntityFlagIndex(String metaKey, Integer flagIndex) {
        entityFlagIndex.put(metaKey, flagIndex);
    }

    public static void dealFilter(List<QFilter> filters, DynamicObject mGanttSourceObj, String dataModelType) {
        String flag = GanttUtils.getCurrDataModelField(mGanttSourceObj, dataModelType);
        List delFields = mGanttSourceObj.getDynamicObjectCollection("entityfilter").stream().filter(x -> !x.getBoolean(flag)).map(x -> x.getString("entitycondalign").replace(".name", "").replace(".id", "")).collect(Collectors.toList());
        delFields.add("viewscheme");
        delFields.add("ganttentity.id".replace(".id", ""));
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        if (GanttUtils.isOnlyCustomerTime(taskEntityNumber)) {
            String timeField = mGanttSourceObj.getString("ttimefield");
            delFields.add(timeField);
        }
        for (int i = filters.size() - 1; i >= 0; --i) {
            String prop;
            QFilter filter = filters.get(i);
            if (filter == null || !delFields.contains(prop = filter.getProperty().replace(".name", "").replace(".id", ""))) continue;
            filters.remove(i);
        }
    }

    public static String getCurrDataModelField(DynamicObject mGanttSourceObj, String dataModelType) {
        DynamicObjectCollection entitySelectColl = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        DynamicObject dynamicObject = entitySelectColl.stream().filter(x -> StringUtils.equals((CharSequence)dataModelType, (CharSequence)Long.toString(x.getLong("id")))).findFirst().orElse(null);
        int seq = 1;
        if (Objects.nonNull(dynamicObject)) {
            seq = dynamicObject.getInt("seq");
        }
        String flag = seq == 1 ? "controlrangeone" : (seq == 2 ? "controlrangetwo" : (seq == 3 ? "controlrangethree" : "controlrangefour"));
        return flag;
    }

    public static Map<String, Object> getReResult(String methodName) {
        HashMap<String, Object> reResult = new HashMap<String, Object>();
        reResult.put("methodName", methodName);
        reResult.put("success", Boolean.FALSE);
        reResult.put("message", "");
        return reResult;
    }

    public static List<GanttQFilter> setSearchQfilter(List<QFilter> filterModels) {
        ArrayList<GanttQFilter> gtFilters = new ArrayList<GanttQFilter>(filterModels.size());
        for (QFilter filter : filterModels) {
            if (filter == null) continue;
            GanttQFilter gtFilter = new GanttQFilter(filter.getProperty(), filter.getCP(), filter.getValue());
            gtFilters.add(gtFilter);
            List nestQ = filter.getNests(true);
            for (QFilter.QFilterNest next : nestQ) {
                QFilter qNext = next.getFilter();
                GanttQFilter qNextFilter = new GanttQFilter(qNext.getProperty(), qNext.getCP(), qNext.getValue());
                gtFilters.add(qNextFilter);
            }
        }
        return gtFilters;
    }

    public static void fieldNameConvertId(List<GanttQFilter> gtfilters, String pageId) {
        Map fieldToEntityMap = (Map)GanttCacheUtils.getCacheBigObject(pageId, "fieldToEntityMap");
        Lang currentLang = Lang.get();
        List enabledLangs = InteServiceHelper.getEnabledLang();
        ArrayList otherLang = Lists.newArrayListWithCapacity((int)10);
        for (EnabledLang enabledLang : enabledLangs) {
            Lang lang = Lang.valueOf((String)enabledLang.getNumber());
            if (lang.equals((Object)currentLang)) continue;
            otherLang.add(lang);
        }
        ORM orm = ORM.create();
        for (GanttQFilter gtfilter : gtfilters) {
            String refEntityId;
            String property = gtfilter.getProperty();
            if (!property.contains(".name") || !StringUtils.isNotBlank((CharSequence)(refEntityId = (String)fieldToEntityMap.get(property)))) continue;
            Object value = gtfilter.getValue();
            boolean equals = gtfilter.getCp().equals("=");
            List values = equals ? Collections.singletonList(value) : (List)value;
            orm.hint().setLang(currentLang);
            QFilter qFilter = new QFilter("name", "in", (Object)values);
            DynamicObjectCollection query = orm.query(refEntityId, "id", qFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)query)) {
                for (Lang lang : otherLang) {
                    orm.hint().setLang(lang);
                    query = orm.query(refEntityId, "id", qFilter.toArray());
                    if (CollectionUtils.isEmpty((Collection)query)) continue;
                    break;
                }
            }
            if (CollectionUtils.isEmpty((Collection)query)) continue;
            List idList = query.stream().map(x -> x.get("id")).collect(Collectors.toList());
            gtfilter.setProperty(property.replace(".name", ".id"));
            if (property.contains("ganttentity")) {
                DynamicObject dataSource = (DynamicObject)GanttCacheUtils.getCacheBigObject(pageId, "datasource");
                List viewIdList = dataSource.getDynamicObjectCollection("entityselect").stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                idList.removeIf(x -> !viewIdList.contains(x));
            }
            if (equals) {
                gtfilter.setValue(idList.get(0));
                continue;
            }
            gtfilter.setValue(idList);
        }
    }

    public static Map<String, GanttQFilter> getMapQFilter(List<GanttQFilter> filters) {
        int initialCapacity = (int)((double)filters.size() / 0.75) + 1;
        HashMap<String, GanttQFilter> filterMap = new HashMap<String, GanttQFilter>(initialCapacity);
        for (GanttQFilter filter : filters) {
            String prop = filter.getProperty();
            filterMap.put(prop, filter);
        }
        return filterMap;
    }

    public static GanttRowDataModel getRowDataModel(String strVal) {
        GanttRowDataModel filterModels = new GanttRowDataModel();
        if (strVal != null) {
            filterModels = (GanttRowDataModel)JSON.parseObject((String)strVal, GanttRowDataModel.class);
        }
        return filterModels;
    }

    public static GanttTaskModel getGanttTaskModel(String strVal) {
        GanttTaskModel filterModels = new GanttTaskModel();
        if (strVal != null) {
            filterModels = (GanttTaskModel)JSON.parseObject((String)strVal, GanttTaskModel.class);
        }
        return filterModels;
    }

    public static GanttLinkTaskModel getGanttLinkTaskModel(String strVal) {
        GanttLinkTaskModel filterModels = new GanttLinkTaskModel();
        if (strVal != null) {
            filterModels = (GanttLinkTaskModel)JSON.parseObject((String)strVal, GanttLinkTaskModel.class);
        }
        return filterModels;
    }

    public static String convertRelationsToValue(String startLinePosType, String endLinePosType) {
        String resultString = "";
        if (startLinePosType.equals("next") && endLinePosType.equals("pre")) {
            resultString = "1";
        } else if (startLinePosType.equals("next") && endLinePosType.equals("next")) {
            resultString = "2";
        } else if (startLinePosType.equals("pre") && endLinePosType.equals("pre")) {
            resultString = "3";
        } else if (startLinePosType.equals("pre") && endLinePosType.equals("next")) {
            resultString = "4";
        }
        return resultString;
    }

    public static Map<String, String> convertRelationsToString(String value) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        switch (value) {
            case "1": {
                returnMap.put("startLinePosType", "next");
                returnMap.put("endLinePosType", "pre");
                break;
            }
            case "2": {
                returnMap.put("startLinePosType", "next");
                returnMap.put("endLinePosType", "next");
                break;
            }
            case "3": {
                returnMap.put("startLinePosType", "pre");
                returnMap.put("endLinePosType", "pre");
                break;
            }
            case "4": {
                returnMap.put("startLinePosType", "pre");
                returnMap.put("endLinePosType", "next");
                break;
            }
        }
        return returnMap;
    }

    public static void sendGanttMessage(IFormView view, String ctlKey, Map<String, Object> reResult) {
        CustomControl custCtl = (CustomControl)view.getControl(ctlKey);
        custCtl.setData(reResult);
    }

    public static List<QFilter> getQFilterList(GanttFilterArg filterArg) {
        List<GanttQFilter> ganttQFilters = filterArg.getSeachFilters();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(ganttQFilters.size() + 1);
        Map<String, GanttQFilter> stringGanttQFilterMap = filterArg.getSeachFilterMap();
        for (GanttQFilter ganttQFilter : ganttQFilters) {
            QFilter qFilter = null;
            qFilter = ganttQFilter.getValue() instanceof String && ganttQFilter.getValue().toString().contains("select") ? QFilter.sqlExpress((String)ganttQFilter.getProperty(), (String)ganttQFilter.getCp(), (String)ganttQFilter.getValue().toString()) : new QFilter(ganttQFilter.getProperty(), ganttQFilter.getCp(), ganttQFilter.getValue());
            qFilterList.add(qFilter);
        }
        GanttQFilter verifyOrgGanttQFilter = stringGanttQFilterMap.get("verifyOrg");
        if (verifyOrgGanttQFilter != null) {
            QFilter verifyOrgFilter = new QFilter("createorg", "=", verifyOrgGanttQFilter.getValue());
            qFilterList.add(verifyOrgFilter);
        }
        return qFilterList;
    }

    public static String parseDateToString(Date date, String format) {
        String result = "";
        SimpleDateFormat formatter = null;
        try {
            if (date != null) {
                formatter = StringUtils.isBlank((CharSequence)format) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat(format);
                result = formatter.format(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getResouceValue(GanttBuildContext context, DynamicObject work, String field) {
        Object value = work.get(field);
        if (Objects.isNull(value)) {
            return "";
        }
        Map<String, List<ValueMapItem>> comboItemsMap = context.getComboItemsMap();
        Map<String, DecimalPropModel> decimalPropMap = context.getDecimalPropMap();
        if (comboItemsMap.containsKey(field)) {
            for (ValueMapItem valueMapItem : comboItemsMap.get(field)) {
                if (!valueMapItem.getValue().equals(value.toString())) continue;
                String name = valueMapItem.getName().toString();
                return name;
            }
        }
        if (decimalPropMap.containsKey(field)) {
            if (StringUtils.equals((CharSequence)field, (CharSequence)"finishpercent")) {
                return ((BigDecimal)value).setScale(2, 1).toString() + "%";
            }
            DecimalPropModel decimalPropModel = decimalPropMap.get(field);
            BigDecimal bigDecimal = new BigDecimal(value.toString()).setScale(decimalPropModel.getScale(), 4);
            if (decimalPropModel.getNoDisplayScaleZero()) {
                bigDecimal = bigDecimal.stripTrailingZeros();
            }
            return String.valueOf(bigDecimal);
        }
        if (value instanceof Timestamp || value instanceof Date) {
            return GanttUtils.parseDateToString((Date)value, "yyyy-MM-dd HH:mm:ss");
        }
        if (value instanceof DynamicObject) {
            if (field.equals("projectnum")) {
                return ((DynamicObject)value).getString("number");
            }
            return ((DynamicObject)value).getString("name");
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ResManager.loadKDString((String)"\u662f", (String)"GanttUtils_31", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u5426", (String)"GanttUtils_32", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
        }
        return value.toString();
    }

    public static String getResouceValue(DynamicObject work, String field) {
        return "";
    }

    private static String isNullSet(String value) {
        return value == null ? "" : value;
    }

    public static GanttViewSchemModel getSchemViewPara(GanttBuildContext ganttBuildContext, DynamicObject mJobViewSchemObj) {
        if (ganttBuildContext.getSchemModel() != null) {
            return ganttBuildContext.getSchemModel();
        }
        GanttViewSchemModel model = new GanttViewSchemModel();
        model.setViewID(String.valueOf(mJobViewSchemObj.getPkValue()));
        model.setViewName(mJobViewSchemObj.getString("name"));
        model.setViewNumber(mJobViewSchemObj.getString("number"));
        model.setStart(0L);
        model.setEnd(0L);
        DynamicObjectCollection colls = mJobViewSchemObj.getDynamicObjectCollection("entryentity_cross");
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject coll = (DynamicObject)colls.get(i);
            GanttCrossModel crossModel = GanttUtils.getGanttCrossModel(coll);
            model.getCorssSet().put(crossModel.getCrossId(), crossModel);
        }
        GanttOtherModel otherModel = GanttUtils.getGanttOtherModel(mJobViewSchemObj);
        model.setOtherSet(otherModel);
        model.setCellUnitType(otherModel.getOtherSecondrule());
        model.setTodoShow(mJobViewSchemObj.getBoolean("todoarea"));
        model.setSummaryShow(mJobViewSchemObj.getBoolean("summaryarea"));
        return model;
    }

    public static GanttViewSchemModel getSchemViewPara(DynamicObject mJobViewSchemObj) {
        GanttViewSchemModel model = new GanttViewSchemModel();
        model.setViewID(String.valueOf(mJobViewSchemObj.getPkValue()));
        model.setViewName(mJobViewSchemObj.getString("name"));
        model.setViewNumber(mJobViewSchemObj.getString("number"));
        model.setStart(0L);
        model.setEnd(0L);
        DynamicObjectCollection colls = mJobViewSchemObj.getDynamicObjectCollection("entryentity_cross");
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject coll = (DynamicObject)colls.get(i);
            GanttCrossModel crossModel = GanttUtils.getGanttCrossModel(coll);
            model.getCorssSet().put(crossModel.getCrossId(), crossModel);
        }
        GanttOtherModel otherModel = GanttUtils.getGanttOtherModel(mJobViewSchemObj);
        model.setOtherSet(otherModel);
        model.setCellUnitType(otherModel.getOtherSecondrule());
        model.setTodoShow(mJobViewSchemObj.getBoolean("todoarea"));
        model.setSummaryShow(mJobViewSchemObj.getBoolean("summaryarea"));
        return model;
    }

    private static GanttCrossModel getGanttCrossModel(DynamicObject coll) {
        GanttCrossModel model = new GanttCrossModel();
        String crossobjType = coll.getString("crossobj");
        String crossobj = "";
        switch (GanttCrossObjectEnum.getByValue(crossobjType)) {
            case TASK: {
                crossobj = GanttCrossEnum.TASK.getValue();
                break;
            }
            case LANDMARKS: {
                crossobj = GanttCrossEnum.LANDMARKS.getValue();
                break;
            }
            case KEYPATH: {
                crossobj = GanttCrossEnum.TASK.getValue();
                break;
            }
            case GROUP: {
                crossobj = GanttCrossEnum.GROUP.getValue();
                break;
            }
            case EMPTY: {
                crossobj = GanttCrossEnum.GROUP.getValue();
                break;
            }
            case SECONDKEYPATH: {
                crossobj = GanttCrossEnum.TASK.getValue();
                break;
            }
        }
        DynamicObject crosstypeObj = coll.getDynamicObject("crosstype");
        String crosscolorval = coll.getString("crosscolorval");
        String crossshap = coll.getString("crossshap");
        model.setCrossId(String.valueOf(coll.getPkValue()));
        Integer height = coll.getInt("height");
        model.setCrossLevel(JobViewSchemConst.MAX_CROSS_HEIGHT - height);
        model.setIsline(coll.getBoolean("isline"));
        model.setLabelisshow(coll.getBoolean("labelisshow"));
        model.setCrossHeightVal(height);
        switch (coll.getString("position")) {
            case "1": {
                model.setPosition("right");
                break;
            }
            case "2": {
                model.setPosition("top");
                break;
            }
            case "3": {
                model.setPosition("left");
                break;
            }
        }
        model.setLimitvalue(coll.getInt("limitvalue"));
        if (!StringUtils.equals((CharSequence)crossobj, (CharSequence)"")) {
            model.setCrossObj(crossobj);
            model.setCrossObjType(crossobjType);
        }
        if (crosstypeObj != null) {
            model.setCrossType(crosstypeObj.getString("crosstype"));
        }
        if (crosscolorval != null) {
            model.setCrossColorVal(crosscolorval);
        }
        if (crossshap != null) {
            model.setCrossShap(crossshap);
        }
        return model;
    }

    private static GanttOtherModel getGanttOtherModel(DynamicObject mJobViewSchemObj) {
        GanttOtherModel otherModel = new GanttOtherModel();
        otherModel.setOtherId("othermodel");
        otherModel.setOtherFirstrule("YYYY-MM");
        if (mJobViewSchemObj.getBoolean("firstyear")) {
            otherModel.setOtherFirstrule("YYYY");
        }
        if (mJobViewSchemObj.getBoolean("firstym")) {
            otherModel.setOtherFirstrule("YYYY-MM");
        }
        if (mJobViewSchemObj.getBoolean("firstyq")) {
            otherModel.setOtherFirstrule("YYYY-MM-DD");
        }
        otherModel.setOtherSecondrule("day");
        if (mJobViewSchemObj.getBoolean("secondyear")) {
            otherModel.setOtherSecondrule("month");
        }
        if (mJobViewSchemObj.getBoolean("secondyq")) {
            otherModel.setOtherSecondrule("week");
        }
        if (mJobViewSchemObj.getBoolean("secondym")) {
            otherModel.setOtherSecondrule("day");
        }
        if (mJobViewSchemObj.getBoolean("secondhour")) {
            otherModel.setOtherSecondrule("hour");
        }
        GanttOtherDateLineMoel dateline = new GanttOtherDateLineMoel();
        dateline.setOtherShowdatal(mJobViewSchemObj.getBoolean("showdatal"));
        if (mJobViewSchemObj.getInt("linetype") == 1) {
            dateline.setOtherLinetype("solid");
        } else {
            dateline.setOtherLinetype("dashed");
        }
        dateline.setOtherColorvalue(mJobViewSchemObj.get("colorvalue").toString());
        otherModel.setDateline(dateline);
        GanttOtherLLineModel lline = new GanttOtherLLineModel();
        lline.setOtherShowlvlline(mJobViewSchemObj.getBoolean("showlvlline"));
        if (mJobViewSchemObj.getInt("assislinetype") == 1) {
            lline.setOtherAssislinetype("solid");
        } else {
            lline.setOtherAssislinetype("dashed");
        }
        lline.setOtherInternalrow(mJobViewSchemObj.getInt("internalrow"));
        otherModel.setLline(lline);
        GanttOtherHLineModel hline = new GanttOtherHLineModel();
        hline.setOtherShowhline(mJobViewSchemObj.getBoolean("showhline"));
        if (mJobViewSchemObj.getInt("assishlinetype") == 1) {
            hline.setOtherAssishlinetype("solid");
        } else {
            hline.setOtherAssishlinetype("dashed");
        }
        hline.setOtherInternalcol(mJobViewSchemObj.getInt("internalcol"));
        otherModel.setHline(hline);
        return otherModel;
    }

    public static String[] getTimeFieldDataSource(String crossobj, String coresstype, DynamicObject mGanttSourceObj) {
        DynamicObjectCollection crosssets = mGanttSourceObj.getDynamicObjectCollection("crossset");
        ArrayList<String> timefieldList = new ArrayList<String>(16);
        for (DynamicObject crossset : crosssets) {
            String dcrosstype;
            String dcrossobj = crossset.getString("crossobj");
            DynamicObject crossTypeObj = crossset.getDynamicObject("crosstype");
            String string = dcrosstype = Objects.isNull(crossTypeObj) ? "" : String.valueOf(crossTypeObj.getString("crosstype"));
            if (!crossobj.equals(dcrossobj) || !coresstype.equals(dcrosstype)) continue;
            timefieldList.add(crossset.getString("startdatefiled"));
            timefieldList.add(crossset.getString("enddatefiled"));
            break;
        }
        return timefieldList.toArray(new String[0]);
    }

    public static DynamicObject getBarMoveProp(String crossObj, String corssType, GanttBuildContext context) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        DynamicObjectCollection crossSets = mGanttSourceObj.getDynamicObjectCollection("crossset");
        for (DynamicObject crossSet : crossSets) {
            String dCrossType;
            String dCrossObj = crossSet.getString("crossobj");
            DynamicObject crossTypeObj = crossSet.getDynamicObject("crosstype");
            String string = dCrossType = Objects.isNull(crossTypeObj) ? "" : String.valueOf(crossTypeObj.getString("crosstype"));
            if (!crossObj.equals(dCrossObj) || !corssType.equals(dCrossType)) continue;
            String dataModelType = context.getDataModelType();
            DynamicObjectCollection crossMoveEntry = crossSet.getDynamicObjectCollection("crossmoveentry");
            if (CollectionUtils.isEmpty((Collection)crossMoveEntry)) {
                return null;
            }
            DynamicObject dataModelEntity = GanttUtils.getDataModelEntity(mGanttSourceObj, dataModelType);
            DynamicObject crossMove = crossMoveEntry.stream().filter(x -> dataModelEntity.getLong("viewid") == x.getLong("tviewid")).findFirst().orElse(null);
            return crossMove;
        }
        return null;
    }

    public static boolean isTreeStruct(String metaKey) {
        boolean isTreeStruct = false;
        if (existTreeEntityMap.get(metaKey) != null) {
            isTreeStruct = true;
        }
        return isTreeStruct;
    }

    public static int getAccess(String billFormId) {
        return accessMap.getOrDefault(billFormId, 1);
    }

    public static int getDropTargetType(String billFormId) {
        return dropTargetTypeMap.getOrDefault(billFormId, 1);
    }

    public static int getTimeLineFillType(String billFormId) {
        return timeLineFillTypeMap.getOrDefault(billFormId, 1);
    }

    public static String getParentFieldName(String metaKey) {
        return existTreeEntityMap.get(metaKey);
    }

    public static QFilter[] getAndCacheResourceEntityFilter(String metaKey, List<QFilter> qFilterList, GanttBuildContext context) {
        QFilter[] resourceEntityFilter = GanttUtils.getResourceEntityFilter(metaKey, qFilterList, context);
        ArrayList<QFilter> resourceFilterList = new ArrayList<QFilter>(resourceEntityFilter.length);
        Collections.addAll(resourceFilterList, resourceEntityFilter);
        DecoratorFactoryBuilder.resourceFilterDecorator(metaKey, context, resourceFilterList);
        resourceEntityFilter = resourceFilterList.toArray(new QFilter[0]);
        GanttUtils.cacheResourceQFilter(metaKey, resourceEntityFilter, context);
        return resourceEntityFilter;
    }

    public static QFilter[] getResourceEntityFilter(String metaKey, List<QFilter> qFilterList, GanttBuildContext context) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String dataModelType = context.getDataModelType();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        GanttUtils.dealFilter(qFilterList, mGanttSourceObj, dataModelType);
        String flag = GanttUtils.getCurrDataModelField(mGanttSourceObj, dataModelType);
        List entityfilter = mGanttSourceObj.getDynamicObjectCollection("entityfilter").stream().filter(x -> x.getBoolean(flag)).collect(Collectors.toList());
        for (DynamicObject obj : entityfilter) {
            String metaFlag = ((ListView)SessionManager.getCurrent().getView(context.getPageId())).getListModel().getEntityId();
            String entityCondAlign = obj.getString("entitycondalign");
            String fieldName = entityCondAlign.replaceAll(metaFlag + ".", "");
            DynamicObjectCollection subcolls = obj.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subobj : subcolls) {
                QFilter tmpQf;
                DynamicObject childentityflag = subobj.getDynamicObject("childentityflag");
                String entityNum = childentityflag.getString("number");
                String toFilterFlag = subobj.getString("tofilterflag");
                if (!StringUtils.isNotBlank((CharSequence)toFilterFlag)) continue;
                String tofilterflagId = toFilterFlag + ".id";
                if (!metaKey.equals(entityNum)) continue;
                List setFilters = (List)GanttCacheUtils.getCacheBigObject(context.getPageId(), fieldName.concat(".name"));
                for (QFilter setFilter : setFilters) {
                    tmpQf = setFilter.copy();
                    tmpQf.__setProperty(toFilterFlag.concat(".").concat(tmpQf.getProperty()));
                    filters.add(tmpQf);
                }
                for (QFilter filter : qFilterList) {
                    tmpQf = filter.copy();
                    String prop = tmpQf.getProperty().replace(".id", "");
                    if (!entityCondAlign.contains(prop)) continue;
                    tmpQf.__setProperty(tofilterflagId);
                    filters.add(tmpQf);
                }
            }
        }
        DynamicObjectCollection entitySelects = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        for (DynamicObject entitySelect : entitySelects) {
            long viewEntryId = entitySelect.getLong("id");
            if (!StringUtils.equals((CharSequence)dataModelType, (CharSequence)Long.toString(viewEntryId))) continue;
            DynamicObjectCollection entityCondition = entitySelect.getDynamicObjectCollection("entitycondition");
            for (DynamicObject condition : entityCondition) {
                String cfiltertext;
                DynamicObject centity = condition.getDynamicObject("centity");
                String number = centity.getString("number");
                if (!metaKey.equals(number) || StringUtils.isBlank((CharSequence)(cfiltertext = condition.getString("cfilter_tag")))) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)cfiltertext, FilterCondition.class);
                MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)metaKey);
                FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
                fb.buildFilter(false);
                filters.addAll(fb.getQFilters());
            }
        }
        return filters.toArray(new QFilter[0]);
    }

    public static String getEntitySort(String metaKey, DynamicObject mGanttSourceObj, String dataModelType) {
        DynamicObjectCollection entitySelects = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        for (DynamicObject entitySelect : entitySelects) {
            long viewEntryId = entitySelect.getLong("id");
            if (!StringUtils.equals((CharSequence)dataModelType, (CharSequence)Long.toString(viewEntryId))) continue;
            DynamicObjectCollection entityCondition = entitySelect.getDynamicObjectCollection("entitycondition");
            for (DynamicObject condition : entityCondition) {
                DynamicObject centity = condition.getDynamicObject("centity");
                String number = centity.getString("number");
                if (!metaKey.equals(number)) continue;
                String sortField = condition.getString("fieldsortflag");
                return sortField;
            }
        }
        return "";
    }

    @Deprecated
    public static String getResourceFlagUpLevel(GanttBuildContext context, String upLevelMetaKey, String metaKey) {
        DynamicObject dataModelEntity = context.getDataModelEntity();
        DynamicObjectCollection relationColl = dataModelEntity.getDynamicObjectCollection("entityrelation");
        for (DynamicObject relation : relationColl) {
            String rentityNumber = relation.getString("rentity.number");
            String upEntityNumber = relation.getString("ruplevelentity.number");
            if (!StringUtils.equals((CharSequence)upLevelMetaKey, (CharSequence)upEntityNumber) || !StringUtils.equals((CharSequence)rentityNumber, (CharSequence)metaKey)) continue;
            String flag = relation.getString("rentityflag");
            return flag;
        }
        return null;
    }

    public static List<List<String>> getUpFlags(GanttBuildContext context, String metakey) {
        DynamicObject dataModelEntity = context.getDataModelEntity();
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        DynamicObjectCollection relationColl = dataModelEntity.getDynamicObjectCollection("entityrelation");
        ArrayList<List<String>> upFlags = new ArrayList<List<String>>();
        for (DynamicObject relation : relationColl) {
            String entityNumber = relation.getString("rentity.number");
            if (!StringUtils.equals((CharSequence)metakey, (CharSequence)entityNumber)) continue;
            ArrayList<String> entityMetaKeyList = new ArrayList<String>(2);
            String flag = relation.getString("rentityflag");
            if (!StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)metakey)) {
                entityMetaKeyList.add(flag);
            } else {
                String entryFlag = relation.getString("rentryflag");
                if (StringUtils.isNotBlank((CharSequence)entryFlag)) {
                    entityMetaKeyList.add(entryFlag);
                    entityMetaKeyList.add(flag.replace(entryFlag.concat("."), ""));
                } else {
                    entityMetaKeyList.add(flag);
                }
            }
            upFlags.add(entityMetaKeyList);
        }
        return upFlags;
    }

    public static List<List<String>> getTaskUpFlags(GanttBuildContext context) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        DynamicObject dataModelEntity = context.getDataModelEntity();
        DynamicObjectCollection relationColl = dataModelEntity.getDynamicObjectCollection("entityrelation");
        ArrayList<List<String>> upFlags = new ArrayList<List<String>>();
        for (DynamicObject relation : relationColl) {
            String entityNumber = relation.getString("rentity.number");
            if (!StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)entityNumber)) continue;
            ArrayList<String> entityMetaKeyList = new ArrayList<String>(2);
            String flag = relation.getString("rentityflag");
            String entryFlag = relation.getString("rentryflag");
            if (StringUtils.isNotBlank((CharSequence)entryFlag)) {
                entityMetaKeyList.add(entryFlag);
                entityMetaKeyList.add(flag.replace(entryFlag.concat("."), ""));
            } else {
                entityMetaKeyList.add(flag);
            }
            upFlags.add(entityMetaKeyList);
        }
        return upFlags;
    }

    public static List<String> getTaskFirstUpFlag(GanttBuildContext context) {
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        DynamicObject dataModelEntity = context.getDataModelEntity();
        DynamicObjectCollection relationColl = dataModelEntity.getDynamicObjectCollection("entityrelation");
        ArrayList<String> entityMetaKeyList = new ArrayList<String>(2);
        for (DynamicObject relation : relationColl) {
            String entityNumber = relation.getString("rentity.number");
            if (!StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)entityNumber)) continue;
            String flag = relation.getString("rentityflag");
            String entryFlag = relation.getString("rentryflag");
            if (StringUtils.isNotBlank((CharSequence)entryFlag)) {
                entityMetaKeyList.add(entryFlag);
                entityMetaKeyList.add(flag.replace(entryFlag.concat("."), ""));
            } else {
                entityMetaKeyList.add(flag);
            }
            return entityMetaKeyList;
        }
        return entityMetaKeyList;
    }

    public static CommonDateFilterColumn defaultStandardTimeFilterColumn(DynamicObject mGanttSourceObj) {
        CommonDateFilterColumn filterColumn = null;
        String entityName = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        String timefield = mGanttSourceObj.getString("ttimefield");
        if (StringUtils.isNotBlank((CharSequence)timefield)) {
            filterColumn = new CommonDateFilterColumn();
            filterColumn.setDataConst("");
            filterColumn.setContext(new ControlContext());
            filterColumn.setMustInput(false);
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityName);
            filterColumn.setEntityType(type);
            filterColumn.setFieldName(timefield);
            filterColumn.setKey(timefield);
            filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4", (String)"GanttUtils_33", (String)"bd-mpdm-gantt", (Object[])new Object[0])));
            filterColumn.setType("datetime");
            filterColumn.setCustom(true);
            if (!GanttUtils.isOnlyCustomerTime(entityName)) {
                filterColumn.setMustInput(true);
                filterColumn.setDataConst("13,10,63,24,66,68,69");
                filterColumn.setDefaultValue(String.valueOf(66));
            }
        }
        return filterColumn;
    }

    public static List<FilterColumn> standardViewSchemeFilterColumn(String metaFlag, DynamicObjectCollection filtercolls, String versionId, String versionField, String pageId) {
        ArrayList<FilterColumn> resList = new ArrayList<FilterColumn>(16);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        List<GanttFilterParamModel> filterParamModelList = GanttUtils.getGanttFilterParamModels(view);
        for (DynamicObject obj : filtercolls) {
            List collect;
            String fieldName = obj.getString("entitycondalign");
            String filterFieldName = fieldName = fieldName.replaceAll(metaFlag + ".", "");
            List<Object> defaultValues = new ArrayList();
            if (!CollectionUtils.isEmpty(filterParamModelList) && !CollectionUtils.isEmpty(collect = filterParamModelList.stream().filter(x -> StringUtils.equals((CharSequence)x.getFieldName(), (CharSequence)filterFieldName)).collect(Collectors.toList()))) {
                GanttFilterParamModel ganttFilterParamModel = (GanttFilterParamModel)collect.get(0);
                if (ganttFilterParamModel.getHiddenColumn()) continue;
                defaultValues = ganttFilterParamModel.getDefaultValues();
            }
            DynamicObject entityObj = obj.getDynamicObject("entitycond");
            ArrayList filters = (ArrayList)GanttCacheUtils.getCacheBigObject(pageId, fieldName + ".name");
            if (CollectionUtils.isEmpty((Collection)filters)) {
                filters = new ArrayList();
            }
            CommonFilterColumn filterColumn = new CommonFilterColumn(fieldName + ".name");
            filterColumn.setCaption(new LocaleString(entityObj.getString("name")));
            boolean unlimited = obj.getBoolean("isunlimited");
            filterColumn.setMustInput(!unlimited);
            filterColumn.setMulti(obj.getBoolean("ismulti"));
            String metaKey = entityObj.getString("number");
            Map colls = BusinessDataServiceHelper.loadFromCache((String)metaKey, (QFilter[])filters.toArray(new QFilter[0]));
            boolean isWorkCenter = "mpdm_workcenter_info".equals(metaKey);
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
            for (DynamicObject col : colls.values()) {
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(col.getLong("id")));
                if (isWorkCenter) {
                    item.setCaption(new LocaleString(col.getString("masterid.name")));
                } else {
                    item.setCaption(new LocaleString(col.getString("name")));
                }
                item.setValue(String.valueOf(col.getLong("id")));
                combos.add(item);
            }
            if (StringUtils.isNotBlank((CharSequence)versionField) && versionField.equals(fieldName) && StringUtils.isNotBlank((CharSequence)versionId)) {
                filterColumn.setDefaultValue(versionId);
            } else {
                if (combos.size() > 0 && !unlimited) {
                    filterColumn.setDefaultValue(((ComboItem)combos.get(0)).getId());
                }
                if (!CollectionUtils.isEmpty(defaultValues)) {
                    boolean multi = filterColumn.isMulti();
                    if (multi) {
                        filterColumn.setDefaultValues(defaultValues.toArray());
                    } else {
                        filterColumn.setDefaultValue((String)defaultValues.get(0));
                    }
                }
            }
            resList.add((FilterColumn)filterColumn);
        }
        return resList;
    }

    public static FilterColumn defaultDataModelFilterColumn(String metaFlag, DynamicObject datasource, String pageId, List<Object> currentViewNumberList) {
        boolean displaySchemeFilter = GanttUtils.displaySchemeFilter(pageId, "displayEntityFilter");
        if (!displaySchemeFilter) {
            return null;
        }
        CommonFilterColumn filterColumn = new CommonFilterColumn("ganttentity.name");
        filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u89c6\u56fe\u65b9\u6848", (String)"GanttUtils_34", (String)"bd-mpdm-gantt", (Object[])new Object[0])));
        filterColumn.setMustInput(true);
        filterColumn.setMulti(true);
        filterColumn.setDefaultValues(currentViewNumberList);
        return filterColumn;
    }

    public static FilterColumn defaultViewSchemeFilterColumn(String metaFlag, DynamicObjectCollection colls, String pageId) {
        boolean displaySchemeFilter = GanttUtils.displaySchemeFilter(pageId, "displayViewFilter");
        if (!displaySchemeFilter) {
            return null;
        }
        CommonFilterColumn filterColumn = new CommonFilterColumn("viewscheme.name");
        filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6837\u5f0f\u65b9\u6848", (String)"GanttUtils_35", (String)"bd-mpdm-gantt", (Object[])new Object[0])));
        filterColumn.setMustInput(true);
        filterColumn.setMulti(false);
        if (!CollectionUtils.isEmpty((Collection)colls)) {
            filterColumn.setDefaultValue(String.valueOf(((DynamicObject)colls.get(0)).getLong("id")));
        }
        return filterColumn;
    }

    private static void addItem(List<ComboItem> combos, DynamicObject viewScheme) {
        ComboItem item = new ComboItem();
        item.setId(String.valueOf(viewScheme.getLong("id")));
        item.setCaption(new LocaleString(viewScheme.getString("name")));
        item.setValue(item.getId());
        combos.add(item);
    }

    public static List<QFilter> getGanttTaskFilter(GanttBuildContext context) {
        List<QFilter> qFilterList = GanttUtils.getQFilterList(context.getFilterArg());
        GanttUtils.dealFilter(qFilterList, context.getmGanttSourceObj(), context.getDataModelType());
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        String timefield = mGanttSourceObj.getString("ttimefield");
        if (StringUtils.isNotBlank((CharSequence)timefield)) {
            QFilter filter = new QFilter(timefield, "is null", null);
            QFilter timefilter = null;
            ArrayList<QFilter> delQFilter = new ArrayList<QFilter>();
            for (QFilter tmpFilter : qFilterList) {
                if (!tmpFilter.getProperty().equals(timefield)) continue;
                if (timefilter == null) {
                    timefilter = tmpFilter.copy();
                    timefilter.or(filter);
                } else {
                    timefilter.and(tmpFilter.copy().or(filter));
                }
                delQFilter.add(tmpFilter);
            }
            qFilterList.removeAll(delQFilter);
            if (timefilter != null) {
                qFilterList.add(timefilter);
            }
        }
        return qFilterList;
    }

    public static DynamicObject[] getGanttTaskModel(GanttBuildContext context, String type) {
        List<QFilter> qFilterList = GanttUtils.getQFilterList(context.getFilterArg());
        GanttUtils.dealFilter(qFilterList, context.getmGanttSourceObj(), context.getDataModelType());
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        DynamicObjectCollection entityselects = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        String pageId = context.getPageId();
        String dataModelType = context.getDataModelType();
        PageCache pageCache = new PageCache(pageId);
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        for (DynamicObject entityselect : entityselects) {
            long ganttEntityId = entityselect.getLong("id");
            if (!dataModelType.equals(Long.toString(ganttEntityId))) continue;
            String selectItems = GanttUtils.queryAllFileds(taskEntityNumber, new ArrayList<String>(2));
            List<QFilter> qfilters = GanttUtils.getGanttTaskFilter(context);
            String mainOrgField = GanttCacheUtils.getCache((IPageCache)pageCache, "mainOrgField");
            if (StringUtils.isNotBlank((CharSequence)mainOrgField)) {
                for (int i = 0; i < qfilters.size(); ++i) {
                    QFilter qFilter = qfilters.get(i);
                    if (!qFilter.getProperty().contains(mainOrgField)) continue;
                    Object value = qFilter.getValue();
                    QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)taskEntityNumber, (Long)Long.parseLong(value.toString()));
                    QFilter filter = new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('5'));
                    for (QFilter.QFilterNest nest : baseDataFilter.getNests(false)) {
                        QFilter nestFilter = nest.getFilter();
                        if (!nestFilter.getProperty().equals("id")) continue;
                        filter.or(nestFilter);
                    }
                    qfilters.set(i, filter);
                }
            }
            GanttUtils.getToDoFilter(type, entityselect, taskEntityNumber, qfilters);
            GanttUtils.addEntryFilter(entityselect, taskEntityNumber, qfilters);
            String sortField = GanttUtils.getSortField(entityselect, taskEntityNumber);
            DecoratorFactoryBuilder.taskFilterDecorator(taskEntityNumber, context, qfilters);
            DynamicObject[] tasks = StringUtils.isNotBlank((CharSequence)sortField) ? BusinessDataServiceHelper.load((String)taskEntityNumber, (String)selectItems, (QFilter[])qfilters.toArray(new QFilter[0]), (String)sortField) : BusinessDataServiceHelper.load((String)taskEntityNumber, (String)selectItems, (QFilter[])qfilters.toArray(new QFilter[0]));
            if (qfilters != null && qfilters.size() > 0) {
                QFilter qFilter = qfilters.get(0);
                for (int i = 1; i < qfilters.size(); ++i) {
                    qFilter.and(qfilters.get(i));
                }
                QFilter cacheQfilter = (QFilter)GanttCacheUtils.getCacheBigObjectWithDataModel((IPageCache)pageCache, dataModelType, taskEntityNumber);
                if (cacheQfilter != null) {
                    cacheQfilter.or(qFilter);
                } else {
                    cacheQfilter = qFilter;
                }
                GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, dataModelType, taskEntityNumber, cacheQfilter);
            }
            if (tasks != null && tasks.length > 0) {
                GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)pageCache, dataModelType, "haveTaskEntity", Boolean.TRUE);
            }
            return tasks;
        }
        return new DynamicObject[0];
    }

    private static void cacheResourceQFilter(String entityNumber, QFilter[] filters, GanttBuildContext context) {
        if (filters != null && filters.length > 0) {
            QFilter qFilter = filters[0];
            for (int i = 1; i < filters.length; ++i) {
                qFilter.and(filters[i]);
            }
            GanttCacheUtils.cacheBigObjectWithDataModel((IPageCache)new PageCache(context.getPageId()), context.getDataModelType(), entityNumber, qFilter);
        }
    }

    private static String getSortField(DynamicObject entityselect, String taskEntityNumber) {
        DynamicObjectCollection entityCondition = entityselect.getDynamicObjectCollection("entitycondition");
        for (DynamicObject condition : entityCondition) {
            DynamicObject centity = condition.getDynamicObject("centity");
            if (!taskEntityNumber.equals(centity.getString("number"))) continue;
            String sortField = condition.getString("fieldsortflag");
            return sortField;
        }
        return null;
    }

    private static void addEntryFilter(DynamicObject entityselect, String taskEntityNumber, List<QFilter> qfilters) {
        DynamicObjectCollection entityCondition = entityselect.getDynamicObjectCollection("entitycondition");
        for (DynamicObject condition : entityCondition) {
            String cfiltertext;
            String centityNumber = condition.getString("centity.number");
            if (!taskEntityNumber.equals(centityNumber) || StringUtils.isBlank((CharSequence)(cfiltertext = condition.getString("cfilter_tag")))) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)cfiltertext, FilterCondition.class);
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)taskEntityNumber);
            FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
            fb.buildFilter(false);
            List filters = fb.getQFilters();
            qfilters.addAll(filters);
        }
    }

    private static void getToDoFilter(String type, DynamicObject entityselect, String taskEntityNumber, List<QFilter> qfilters) {
        if ("toDoTask".equals(type)) {
            DynamicObjectCollection relationColl = entityselect.getDynamicObjectCollection("entityrelation");
            String groupField = null;
            for (DynamicObject relation : relationColl) {
                String entityNumber = relation.getString("rentity.number");
                if (!StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)entityNumber)) continue;
                groupField = relation.getString("rentityflag").concat(".id");
                break;
            }
            if (StringUtils.isBlank(groupField)) {
                return;
            }
            Boolean hasUpFilter = Boolean.FALSE;
            for (QFilter tmpFilter : qfilters) {
                if (!tmpFilter.getProperty().equals(groupField)) continue;
                tmpFilter.__setValue((Object)0L);
                hasUpFilter = Boolean.TRUE;
                break;
            }
            if (!hasUpFilter.booleanValue()) {
                qfilters.add(new QFilter(groupField, "=", (Object)0L).or(new QFilter(groupField, "is null", null)));
            }
        }
    }

    public static String queryAllFileds(String entityName, List<String> noQueryFiledList) {
        StringBuilder fileds = new StringBuilder("id,");
        Map entityTypeMap = MetadataServiceHelper.getDataEntityType((String)entityName).getAllEntities();
        for (Map.Entry m : entityTypeMap.entrySet()) {
            Map entityPropertyMap = ((EntityType)entityTypeMap.get(m.getKey())).getFields();
            for (String filed : entityPropertyMap.keySet()) {
                if (noQueryFiledList != null) {
                    boolean isNotQuery = false;
                    for (String f : noQueryFiledList) {
                        if (!StringUtils.equals((CharSequence)filed, (CharSequence)f)) continue;
                        isNotQuery = true;
                        break;
                    }
                    if (isNotQuery) continue;
                }
                fileds.append(filed).append(',');
            }
        }
        return fileds.substring(0, fileds.length() - 1);
    }

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return null;
        }
        int totalSize = datas.size();
        int count = totalSize % splitSize == 0 ? totalSize / splitSize : totalSize / splitSize + 1;
        ArrayList<List<T>> rows = new ArrayList<List<T>>(16);
        for (int i = 0; i < count; ++i) {
            int index = i * splitSize;
            ArrayList<T> cols = new ArrayList<T>(16);
            for (int j = 0; j < splitSize && index < totalSize; ++j) {
                cols.add(datas.get(index++));
            }
            rows.add(cols);
        }
        return rows;
    }

    public static Long getYearStartTime(Long timeStamp, String timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(timeStamp);
        calendar.add(1, 0);
        calendar.add(5, 0);
        calendar.add(2, 0);
        calendar.set(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static Long getYearEndTime(Long timeStamp, String timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(timeStamp);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.roll(6, -1);
        return calendar.getTimeInMillis();
    }

    public static void getDateLine(List<GanttYLinesModel> yLines, GanttViewSchemModel mGanttViewSchemModel, DynamicObjectCollection datalineset, Long end, Long start) {
        for (DynamicObject date_line : datalineset) {
            Calendar calendar;
            boolean isshow = date_line.getBoolean("isshow");
            if (!isshow) continue;
            String datalinetype = date_line.getString("datalinetype");
            String lineshape = date_line.getString("lineshape");
            String linecolorvalue = date_line.getString("linecolorvalue");
            boolean isShowCurrent = date_line.getBoolean("isshowcurrent");
            GanttYLinesModel currdateLine = new GanttYLinesModel();
            currdateLine.setColor(linecolorvalue);
            currdateLine.setType(GanttLineTypeEnum.getNameByValue(lineshape));
            currdateLine.setWidth(GanttLineTypeEnum.getWidthByValue(lineshape));
            currdateLine.setDatelinetype(datalinetype);
            if ("1".equals(datalinetype)) {
                currdateLine.setTime(GanttUtils.getCurrZeroTime(System.currentTimeMillis()));
                yLines.add(currdateLine);
                continue;
            }
            if ("0".equals(datalinetype)) {
                if (mGanttViewSchemModel.getStart() == null) continue;
                currdateLine.setTime(GanttUtils.getCurrZeroTime(mGanttViewSchemModel.getStart()));
                yLines.add(currdateLine);
                continue;
            }
            if ("2".equals(datalinetype)) {
                if (isShowCurrent) {
                    Calendar currCal = Calendar.getInstance();
                    int currentYear = currCal.get(1);
                    currCal.clear();
                    currCal.set(1, currentYear);
                    currdateLine.setTime(GanttUtils.getCurrZeroTime(currCal));
                    yLines.add(currdateLine);
                    continue;
                }
                GanttUtils.getEveryDateLine(yLines, end, start, currdateLine, 1);
                continue;
            }
            if ("3".equals(datalinetype)) {
                if (isShowCurrent) {
                    calendar = Calendar.getInstance();
                    calendar.add(2, 0);
                    calendar.set(5, 1);
                    currdateLine.setTime(GanttUtils.getCurrZeroTime(calendar));
                    yLines.add(currdateLine);
                    continue;
                }
                GanttUtils.getEveryDateLine(yLines, end, start, currdateLine, 2);
                continue;
            }
            if (!"4".equals(datalinetype)) continue;
            if (isShowCurrent) {
                calendar = Calendar.getInstance();
                calendar.set(7, 1);
                currdateLine.setTime(GanttUtils.getCurrZeroTime(calendar));
                yLines.add(currdateLine);
                continue;
            }
            GanttUtils.getEveryDateLine(yLines, end, start, currdateLine, 3);
        }
    }

    public static void getEveryDateLine(List<GanttYLinesModel> yLines, Long end, Long start, GanttYLinesModel currdateLine, int calendarType) {
        ArrayList<Long> timeList = new ArrayList<Long>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(start);
        int currentYear = calendar.get(1);
        int currentMonth = calendar.get(2);
        int weekOfYear = calendar.get(3);
        calendar.clear();
        calendar.set(1, currentYear);
        if (calendarType == 2) {
            calendar.set(12, currentMonth);
        }
        if (calendarType == 3) {
            calendar.set(3, weekOfYear);
        }
        while (GanttUtils.getCurrZeroTime(calendar) < end) {
            Long timeime = GanttUtils.getCurrZeroTime(calendar);
            timeList.add(timeime);
            calendar.add(calendarType, 1);
        }
        for (Long timeime : timeList) {
            try {
                GanttYLinesModel cloneBean = (GanttYLinesModel)BeanUtils.cloneBean((Object)currdateLine);
                cloneBean.setTime(timeime);
                yLines.add(cloneBean);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static Long getCurrZeroTime(Long now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }

    public static Long getCurrZeroTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }

    public static DynamicObject getDataModelEntity(DynamicObject mGanttSourceObj, String dataModelType) {
        DynamicObjectCollection entitySelectColl = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        for (DynamicObject dynamicObject : entitySelectColl) {
            Long ganttEntityId = dynamicObject.getLong("id");
            if (!StringUtils.equals((CharSequence)Long.toString(ganttEntityId), (CharSequence)dataModelType)) continue;
            return dynamicObject;
        }
        return (DynamicObject)entitySelectColl.get(0);
    }

    public static String getTaskEntityNumber(DynamicObject mGanttSourceObj) {
        String taskEntityNumber = mGanttSourceObj.getString("taskentity.number");
        return taskEntityNumber;
    }

    public static Stack<String> getPatchTreeList(GanttBuildContext context) {
        DynamicObject dataModelEntity = context.getDataModelEntity();
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        DynamicObjectCollection relationColl = dataModelEntity.getDynamicObjectCollection("entityrelation");
        String entityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        Stack<String> stack = new Stack<String>();
        for (int num = 0; StringUtils.isNotBlank((CharSequence)entityNumber) && num < 20; ++num) {
            if (!StringUtils.isNotBlank((CharSequence)(entityNumber = GanttUtils.getUpEntity(relationColl, entityNumber)))) continue;
            stack.push(entityNumber);
        }
        return stack;
    }

    public static String getUpEntity(DynamicObjectCollection relationColl, String entityNumber) {
        for (DynamicObject dynamicObject : relationColl) {
            String rentityNumber = dynamicObject.getString("rentity.number");
            if (!StringUtils.equals((CharSequence)rentityNumber, (CharSequence)entityNumber)) continue;
            String upEntityNumber = dynamicObject.getString("ruplevelentity.number");
            return upEntityNumber;
        }
        return null;
    }

    public static String getTaskUpFlag(GanttBuildContext context) {
        DynamicObject dataModelEntity = context.getDataModelEntity();
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(context.getmGanttSourceObj());
        DynamicObjectCollection relationColl = dataModelEntity.getDynamicObjectCollection("entityrelation");
        for (DynamicObject dynamicObject : relationColl) {
            String rentityNumber = dynamicObject.getString("rentity.number");
            if (!StringUtils.equals((CharSequence)rentityNumber, (CharSequence)taskEntityNumber)) continue;
            String flag = dynamicObject.getString("rentityflag");
            return flag;
        }
        return null;
    }

    public static Object getFilterValue(String filterField, String pageId) {
        String fieldNoId = filterField.replace(".id", "");
        String filtersStr = (String)GanttBigObjectCache.get((String)pageId, (String)"filterStr");
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)filtersStr, Map.class);
        for (Map.Entry m : filterMap.entrySet()) {
            if (!((String)m.getKey()).equals(filterField) && !((String)m.getKey()).equals(fieldNoId)) continue;
            Map mm = (Map)m.getValue();
            Object value = mm.get("value");
            return value;
        }
        return null;
    }

    public static void ganttRefresh(IFormView view) {
        List<String> dataModelTypeList = GanttDataUtils.getDataModelTypeList(view.getPageId());
        Map<String, String> modelTypeToCtrlMap = GanttDataUtils.getModelTypeToCtrlMap(view.getPageId());
        for (String dataModelType : dataModelTypeList) {
            GanttBuildContext ganttBuildContext = (GanttBuildContext)GanttCacheUtils.getCacheBigObjectWithDataModel(view.getPageCache(), dataModelType, "ganttBuildContext");
            ganttBuildContext.getCustomDataMap().clear();
            ganttBuildContext.getCustomGanttSourceMap().clear();
            GanttViewSchemModel schemModel = ganttBuildContext.getSchemModel();
            GanttPageShowModel pageShowSet = GanttUserConfigUtils.getPageShowSet((ListView)view);
            GanttDataUtils.copyProperties(schemModel, pageShowSet);
            ganttBuildContext.setSchemModel(schemModel);
            GanttModelStandardBuild build = new GanttModelStandardBuild();
            GanttModelBuilder builder = new GanttModelBuilder(build);
            GanttGlobalModel model = builder.packaging(ganttBuildContext);
            Map<String, Object> pageDataMap = model.getPageData();
            Map<String, Object> toDoMap = model.getTodo();
            GanttUtils.dealSelectAndExpand("pageData", ganttBuildContext, pageDataMap, view, dataModelType);
            GanttUtils.dealSelectAndExpand("todo", ganttBuildContext, toDoMap, view, dataModelType);
            ganttBuildContext.getmGanttViewSchemModel().setGanttNums(dataModelTypeList.size());
            GanttUtils.setShowSet(model, view);
            model.setPageData(pageDataMap);
            model.setTodo(toDoMap);
            model.setStayInPlace(true);
            GanttCacheUtils.cacheBigObjectWithDataModel(view.getPageCache(), dataModelType, "model", model);
            GanttCacheUtils.cacheBigObjectWithDataModel(view.getPageCache(), dataModelType, "viewSchem", model.getViewSchem());
            String ganttCtl = modelTypeToCtrlMap.get(dataModelType);
            CustomControl custCtl = (CustomControl)view.getControl(ganttCtl);
            JSONObject result = (JSONObject)JSONObject.toJSON((Object)model);
            custCtl.setData((Object)result);
        }
    }

    private static void dealSelectAndExpand(String ganttType, GanttBuildContext ganttBuildContext, Map<String, Object> pageDataMap, IFormView view, String dataModelType) {
        String unExpandKey = "unExpandIds";
        String selectKey = "selectDataListId";
        String cacheKey = "dataList";
        if (StringUtils.equals((CharSequence)ganttType, (CharSequence)"todo")) {
            unExpandKey = "toDoUnExpandIds";
            selectKey = "toDoSelectDataListId";
            cacheKey = "toDoDataList";
        }
        List selectIds = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(view.getPageCache(), dataModelType, selectKey);
        List unExpandIds = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(view.getPageCache(), dataModelType, unExpandKey);
        Object dataListObj = pageDataMap.get("dataList");
        if (dataListObj == null) {
            return;
        }
        List dataList = (List)dataListObj;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            GanttRowDataModel ganttRowDataModel = (GanttRowDataModel)dataList.get(i);
            String objId = ganttRowDataModel.getObjId();
            if (!CollectionUtils.isEmpty((Collection)unExpandIds) && unExpandIds.contains(objId)) {
                ganttRowDataModel.setIsExpand(Boolean.FALSE);
                dataList.removeAll(ganttRowDataModel.getChildNodes());
                for (GanttRowDataModel childNode : ganttRowDataModel.getChildNodes()) {
                    if (CollectionUtils.isEmpty((Collection)selectIds) || !selectIds.contains(childNode.getObjId())) continue;
                    childNode.setIsSelect(Boolean.TRUE);
                }
                GanttUtils.deleteChildNodes(ganttRowDataModel.getChildNodes(), dataList, selectIds);
            }
            if (CollectionUtils.isEmpty((Collection)selectIds) || !selectIds.contains(objId)) continue;
            ganttRowDataModel.setIsSelect(Boolean.TRUE);
        }
        dataList.removeIf(x -> StringUtils.equals((CharSequence)x.getRowType(), (CharSequence)GanttRowTypeEnum.TEXT.getValue()));
        Map<String, Object> stringObjectMap = GanttDealDataUtils.dealData((List<GanttRowDataModel>)dataList, (List<GanttTaskModel>)((List)pageDataMap.get("taskDataList")), ganttBuildContext, GanttAreaTypeEnum.getByValue(ganttType));
        GanttDealDataUtils.dealDataForFornt(dataList);
        pageDataMap.putAll(stringObjectMap);
    }

    private static void deleteChildNodes(List<GanttRowDataModel> rowDataModels, List<GanttRowDataModel> showList, List<String> selectIds) {
        for (int i = 0; i < rowDataModels.size(); ++i) {
            GanttRowDataModel ganttRowDataModel = rowDataModels.get(i);
            if (ganttRowDataModel.getChildNodes() == null || ganttRowDataModel.getChildNodes().size() <= 0) continue;
            showList.removeAll(ganttRowDataModel.getChildNodes());
            for (GanttRowDataModel childNode : ganttRowDataModel.getChildNodes()) {
                if (CollectionUtils.isEmpty(selectIds) || !selectIds.contains(childNode.getObjId())) continue;
                childNode.setIsSelect(Boolean.TRUE);
            }
            GanttUtils.deleteChildNodes(ganttRowDataModel.getChildNodes(), showList, selectIds);
        }
    }

    public static void fillCycleModel(GanttBuildContext context, Map<String, DynamicObject[]> treeData) {
        GanttBuildCycleModel cycleModel = context.getCycleModel();
        for (String entityKey : treeData.keySet()) {
            List<String> decoratorTaskClasses = DecoratorFactoryBuilder.getDecoratorResourceClass(entityKey);
            List<String> decoratorGroupClass = DecoratorFactoryBuilder.getDecoratorGroupClass(entityKey);
            if (!CollectionUtils.isEmpty(decoratorTaskClasses)) {
                cycleModel.getResourceDecoratorClassMap().put(entityKey, decoratorTaskClasses);
            }
            if (CollectionUtils.isEmpty(decoratorGroupClass)) continue;
            cycleModel.getGroupDecoratorClassMap().put(entityKey, decoratorGroupClass);
        }
        String taskEntityName = GanttUtils.getTaskEntityNumber(context.getmGanttSourceObj());
        List<String> taskDecoratorClass = DecoratorFactoryBuilder.getTaskDecoratorClass(taskEntityName, context.getBillFormId());
        if (!CollectionUtils.isEmpty(taskDecoratorClass)) {
            cycleModel.getTaskDecoratorClassMap().put(context.getBillFormId().concat(taskEntityName), taskDecoratorClass);
        }
        cycleModel.setResourceMenusMap(GanttMenusSingleton.getSingleInstance().getMenusMap());
        cycleModel.setResourceEditSet(GanttResourceEditSingleton.getSingleInstance().getEditAbleSet());
        cycleModel.setTaskMenusMap(GanttTaskMenusSingleton.getSingleInstance().getMenusMap());
        cycleModel.setTaskUpFlag(GanttUtils.getTaskUpFlag(context));
        GanttViewSchemModel schemModel = context.getmGanttViewSchemModel();
        Map<String, GanttCrossModel> ganttCrossModels = schemModel.getCorssSet();
        DynamicObject mGanttSourceObj = context.getmGanttSourceObj();
        for (Map.Entry<String, GanttCrossModel> entry : ganttCrossModels.entrySet()) {
            String crossType;
            GanttCrossModel ganttCrossModel = ganttCrossModels.get(entry.getKey());
            String crossObj = ganttCrossModel.getCrossObjType();
            String[] times = GanttUtils.getTimeFieldDataSource(crossObj, crossType = ganttCrossModel.getCrossType(), mGanttSourceObj);
            if (times.length > 0) {
                String[] copyTimes = (String[])times.clone();
                String entryName = GanttDataUtils.changeTimes(copyTimes);
                cycleModel.getGanttBarTimeMap().put(entry.getKey(), copyTimes);
                cycleModel.getGanttBarTimeEntryMap().put(entry.getKey(), entryName);
                cycleModel.getGanttBarOrginTimeMap().put(entry.getKey(), times);
            }
            DynamicObject barMoveProp = GanttUtils.getBarMoveProp(crossObj, crossType, context);
            cycleModel.getBarMovePropMap().put(entry.getKey(), barMoveProp);
        }
    }

    public static void putCustomGanttSource(GanttBuildContext context, String taskEntityName, DynamicObject[] tasks) {
        if (tasks == null || tasks.length == 0) {
            return;
        }
        ArrayList<Long> taskIds = new ArrayList<Long>(tasks.length);
        for (DynamicObject task : tasks) {
            taskIds.add(task.getLong("id"));
        }
        QFilter qFilter = new QFilter("taskentity", "=", (Object)taskEntityName);
        qFilter.and("dataid", "in", taskIds);
        DynamicObject[] customGanttSources = BusinessDataServiceHelper.load((String)"msplan_custom_ganttsource", (String)"dataid, crossobj, crosstype, contentlocation, contenttype, concatflag, fieldcontent, fieldcontentdesc, lblformat, lbltype, contentnote, customimpl", (QFilter[])qFilter.toArray());
        HashMap<Long, DynamicObject> customGanttSourceMap = new HashMap<Long, DynamicObject>(customGanttSources.length);
        for (DynamicObject customGanttSource : customGanttSources) {
            customGanttSourceMap.put(customGanttSource.getLong("dataid"), customGanttSource);
        }
        context.getCustomGanttSourceMap().putAll(customGanttSourceMap);
    }

    public static void setShowSet(GanttGlobalModel model, IFormView view) {
        GanttPageShowModel pageShowSet = GanttUserConfigUtils.getPageShowSet((ListView)view);
        GanttViewSchemModel viewSchem = model.getViewSchem();
        GanttDataUtils.copyProperties(viewSchem, pageShowSet);
        model.setViewSchem(viewSchem);
        Map<String, Integer> columsWidth = GanttUserConfigUtils.getColumsWidth((ListView)view);
        if (Objects.nonNull(columsWidth)) {
            List<GanttColModel> columns = model.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                Integer width = columsWidth.get(Integer.toString(i));
                if (!Objects.nonNull(width)) continue;
                columns.get(i).setColWidth(width);
            }
        }
    }

    public static boolean displaySchemeFilter(String pageId, String filterName) {
        String display = SessionManager.getCurrent().getPageCache(pageId).get(filterName);
        if (StringUtils.isNotBlank((CharSequence)display)) {
            return Boolean.parseBoolean(display);
        }
        return true;
    }

    public static List<GanttFilterParamModel> getGanttFilterParamModels(IFormView view) {
        String customParam = (String)view.getFormShowParameter().getCustomParam("filterColumn");
        if (StringUtils.isNotBlank((CharSequence)customParam)) {
            return SerializationUtils.fromJsonStringToList((String)customParam, GanttFilterParamModel.class);
        }
        return null;
    }

    static {
        resourceReverseList.add("pmts_task");
        customerTimeList.add("pmts_task");
        addDragLineList.add("pmts_task");
        dropTargetTypeMap.put("pmpd_resourcepersonplan", 2);
        timeLineFillTypeMap.put("pmts_task", 2);
        accessMap.put("pmts_task_gantt_history", 2);
        accessMap.put("pmts_task_mp_history", 2);
        accessMap.put("pmts_task_qy_history", 2);
        accessMap.put("pmts_task_ip_history", 2);
        accessMap.put("pmts_task_mplan_release", 2);
        accessMap.put("pmts_task_release", 2);
        accessMap.put("pmts_task_release_version", 2);
        accessMap.put("pmts_task_mplan_release_v", 2);
        accessMap.put("pmts_task_qy_release_v", 2);
        accessMap.put("pmts_task_ip_release_v", 2);
        accessMap.put("pmts_task_qy_release", 2);
        accessMap.put("pmts_task_ip_release", 2);
        accessMap.put("pmpd_resourcepersonplan", 2);
        existTreeEntityMap.put("pmts_wbs", "parent");
        existTreeEntityMap.put("mpdm_aricamera", "group");
        entityFlagIndex.put("pmpd_project", 0);
        entityFlagIndex.put("pmts_wbs", 1);
        entityFlagIndex.put("pmts_task", -1);
        entityFlagIndex.put("msplan_hangar", 0);
        entityFlagIndex.put("msplan_aricamera", 1);
        entityFlagIndex.put("msplan_cameraplan", 3);
        entityFlagIndex.put("pmpd_aircraftplan", 2);
        entityFlagIndex.put("mpdm_aircraftplay", 1);
        entityFlagIndex.put("pmpd_resourceplan", 1);
        entityFlagIndex.put("mpdm_workcenter_info", 6);
        entityFlagIndex.put("bd_customer", 6);
    }
}

