/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.enums.GanttVersionFilterEnum;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttevent.itf.IGanttCommandClosedCallBack;
import kd.bd.mpdm.common.gantt.ganttevent.itf.IGanttCommandConfirmCallBack;
import kd.bd.mpdm.common.gantt.ganttmodel.DecimalPropModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildAfterModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildPreModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttDecoratorSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttEventSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttFilterArg;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttFilterParamModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttGlobalModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLogModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttQFilter;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.ganttmodel.build.impl.GanttModelStandardBuild;
import kd.bd.mpdm.common.gantt.ganttmodel.builder.GanttModelBuilder;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttLogUtils;
import kd.bd.mpdm.common.gantt.util.GanttUserConfigUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.CompareTypeConfig;
import kd.bos.entity.CompareTypeField;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterModel;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.time.DateFormatUtils;

public class GanttFormTplPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(GanttFormTplPlugin.class);
    private static final String GANTT_MULTI_TEMPLATE = "mpdm_gantt_list_multi";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        AppInfo info = AppMetadataCache.getAppInfo((String)"pmpd");
        LicenseCheckResult checkResult = LicenseServiceHelper.checkByAppAndBizObj((String)info.getId(), (String)"mpdm_gantt_list", (Long)UserServiceHelper.getCurrentUserId());
        logger.info("\u8bb8\u53ef\u6821\u9a8c\u7ed3\u679c\uff1a" + checkResult.getMsg());
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
            e.setCancel(true);
        }
    }

    public void beforeBindData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String defaultScheme = (String)this.getView().getFormShowParameter().getCustomParam("defaultScheme");
        if (StringUtils.isNotBlank((CharSequence)defaultScheme)) {
            FilterModel filterModel = new FilterModel();
            String billFormId = ((ListView)this.getView()).getBillFormId();
            filterModel.setFormId(billFormId);
            StringBuilder errorMsg = new StringBuilder();
            boolean sucess = filterModel.updateScheme(defaultScheme, true, errorMsg);
            if (!sucess) {
                logger.error(String.format(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848%1$s\u5931\u8d25\uff1a%2$s", (String)"GanttFormTplPlugin_14", (String)"bd-mpdm-gantt", (Object[])new Object[0]), defaultScheme, errorMsg.toString()));
            }
        }
    }

    private void registerCommand() {
        GanttEventSingleton.getSingleInstance().registerEventCommand("gtRestData", "kd.bd.mpdm.formplugin.gantt.command.GtRestDataCommond");
        GanttEventSingleton.getSingleInstance().registerEventCommand("selectNodeGtTreeList", "kd.bd.mpdm.formplugin.gantt.command.SelectNodeGtTreeListCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("expandNodeGtTreeList", "kd.bd.mpdm.formplugin.gantt.command.ExpandNodeGtTreeListCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("tblrefresh", "kd.bd.mpdm.formplugin.gantt.command.RefreshTaskCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("printpreview", "kd.bd.mpdm.formplugin.gantt.command.PrintPreCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("sendPrintInfo", "kd.bd.mpdm.formplugin.gantt.command.SendPrintInfokCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("printset", "kd.bd.mpdm.formplugin.gantt.command.PrintSetCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("print", "kd.bd.mpdm.formplugin.gantt.command.PrintTaskCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("tbllog", "kd.bd.mpdm.formplugin.gantt.command.GanttEventLogCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("tblversiontype", "kd.bd.mpdm.formplugin.gantt.command.GanttVersionTypeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("cellClickGtTreeList", "kd.bd.mpdm.formplugin.gantt.command.CellClickGtTreeListCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("barClickGtList", "kd.bd.mpdm.formplugin.gantt.command.BarClickGtListCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("dragTask", "kd.bd.mpdm.formplugin.gantt.command.DragTaskCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("adjustTask", "kd.bd.mpdm.formplugin.gantt.command.AdjustTaskCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_dependmonth", "kd.bd.mpdm.formplugin.gantt.command.TimeScaleCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_dependweek", "kd.bd.mpdm.formplugin.gantt.command.TimeScaleCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_dependday", "kd.bd.mpdm.formplugin.gantt.command.TimeScaleCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_dependhour", "kd.bd.mpdm.formplugin.gantt.command.TimeScaleCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale500", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale400", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale300", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale200", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale150", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale120", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale100", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale90", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale80", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale70", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale60", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale50", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale40", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_scale30", "kd.bd.mpdm.formplugin.gantt.command.ShowScopeCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_timelinerow2", "kd.bd.mpdm.formplugin.gantt.command.TimeLineRowCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("bar_timelinerow3", "kd.bd.mpdm.formplugin.gantt.command.TimeLineRowCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("lineisshow", "kd.bd.mpdm.formplugin.gantt.command.ShowLineRelationCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("verticalshow", "kd.bd.mpdm.formplugin.gantt.command.TimeLineShowWayCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("barshow", "kd.bd.mpdm.formplugin.gantt.command.BarShowCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("emptybarshow", "kd.bd.mpdm.formplugin.gantt.command.EmptyBarShowCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("showset", "kd.bd.mpdm.formplugin.gantt.command.ShowSetCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("changeInitTableWidth", "kd.bd.mpdm.formplugin.gantt.command.ChangeInitTableWidthCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("changeTreeWidth", "kd.bd.mpdm.formplugin.gantt.command.ChangeTreeWidthCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("changeColumnsWidth", "kd.bd.mpdm.formplugin.gantt.command.ChangeColumnsWidthCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("selectTask", "kd.bd.mpdm.formplugin.gantt.command.BarSelectCommand");
        GanttEventSingleton.getSingleInstance().registerEventCommand("summaryshow", "kd.bd.mpdm.formplugin.gantt.command.SummaryShowCommand");
        GanttDecoratorSingleton.getSingleInstance().registerDecoratorClass("gantt_global", "kd.bd.mpdm.common.gantt.ganttmodel.decorator.FeatureColorHighDecorator");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button tblDel = (Button)this.getView().getControl("tbldel");
        Button tblRefresh = (Button)this.getView().getControl("tblrefresh");
        Button print = (Button)this.getView().getControl("print");
        Button printPreView = (Button)this.getView().getControl("printpreview");
        Button printSet = (Button)this.getView().getControl("printset");
        Button tblLog = (Button)this.getView().getControl("tbllog");
        Button showSet = (Button)this.getView().getControl("showset");
        Button tblVersionType = (Button)this.getView().getControl("tblversiontype");
        if (tblDel != null) {
            tblDel.addClickListener((ClickListener)this);
        }
        if (print != null) {
            print.addClickListener((ClickListener)this);
        }
        if (printPreView != null) {
            printPreView.addClickListener((ClickListener)this);
        }
        if (printSet != null) {
            printSet.addClickListener((ClickListener)this);
        }
        if (tblRefresh != null) {
            tblRefresh.addClickListener((ClickListener)this);
        }
        if (tblLog != null) {
            tblLog.addClickListener((ClickListener)this);
        }
        if (showSet != null) {
            showSet.addClickListener((ClickListener)this);
        }
        if (tblVersionType != null) {
            tblVersionType.addClickListener((ClickListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap1"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.registerCommand();
        this.updatePageData();
        String billMetaKey = ((ListView)this.getView()).getBillFormId();
        QFilter filter = new QFilter("modelentity.number", "=", (Object)billMetaKey).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        DynamicObject geMapping = BusinessDataServiceHelper.loadSingle((String)"msplan_gemapping", (String)"datasource", (QFilter[])new QFilter[]{filter});
        if (geMapping == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u53ef\u7528\u7684\u5ba1\u6838\u5b9e\u4f53\u5bf9\u7167\u6570\u636e\u6e90\u3002", (String)"GanttFormTplPlugin_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        DynamicObject dataSource = geMapping.getDynamicObject("datasource");
        if (dataSource == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u201c\u7518\u7279\u56fe\u6570\u636e\u6e90\u201d\u3002", (String)"GanttFormTplPlugin_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        QFilter dataSourceFilter = new QFilter("id", "=", (Object)geMapping.getLong("datasource.id")).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        dataSource = BusinessDataServiceHelper.loadSingleFromCache((String)"msplan_gantt_source", (QFilter[])new QFilter[]{dataSourceFilter});
        if (dataSource == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u7167\u6570\u636e\u6e90\u4e2d\uff0c\u201c\u7518\u7279\u56fe\u6570\u636e\u6e90\u201d\u4e0d\u5b58\u5728\u6216\u5ba1\u6838\u672a\u901a\u8fc7\u3002", (String)"GanttFormTplPlugin_2", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        MulBasedataDynamicObjectCollection schemeColls = (MulBasedataDynamicObjectCollection)dataSource.getDynamicObjectCollection("viewscheme");
        List ids = schemeColls.stream().map(x -> x.getLong("fbasedataid.id")).collect(Collectors.toList());
        QFilter viewFilter = new QFilter("id", "in", ids).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        DynamicObjectCollection enableColls = QueryServiceHelper.query((String)"msplan_viewscheme", (String)"id,name", (QFilter[])new QFilter[]{viewFilter}, (String)"createtime desc");
        if (CollectionUtils.isEmpty((Collection)enableColls)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6837\u5f0f\u65b9\u6848\u65e0\u5df2\u5ba1\u6838\u53ef\u7528\u72b6\u6001\u7684\u6570\u636e\u6e90\u3002", (String)"GanttFormTplPlugin_3", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "datasource", dataSource);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "allViewScheme", enableColls);
        this.cacheFilterColumnFilters(dataSource, enableColls);
        DynamicObjectCollection dynamicObjectCollection = dataSource.getDynamicObjectCollection("entityselect");
        HashMap<String, String> modelTypeToCtrlMap = new HashMap<String, String>(dynamicObjectCollection.size());
        HashMap<String, String> modelTypeToFlexMap = new HashMap<String, String>(dynamicObjectCollection.size());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            long ganttEntityId = dynamicObject.getLong("id");
            String dataModel = Long.toString(ganttEntityId);
            String flexTag = "flexpanelap3";
            String ctrlTag = "ganttctl";
            if (i != 0) {
                flexTag = flexTag + i;
                ctrlTag = ctrlTag + i;
            }
            modelTypeToCtrlMap.put(dataModel, ctrlTag);
            modelTypeToFlexMap.put(dataModel, flexTag);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3", "flexpanelap31", "flexpanelap32", "flexpanelap33"});
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "modelTypeToCtrlMap", modelTypeToCtrlMap);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "modelTypeToFlexMap", modelTypeToFlexMap);
    }

    private void cacheFilterColumnFilters(DynamicObject dataSource, DynamicObjectCollection enableColls) {
        DynamicObjectCollection filterColls = dataSource.getDynamicObjectCollection("entityfilter");
        List<GanttFilterParamModel> filterParamModelList = GanttUtils.getGanttFilterParamModels(this.getView());
        String metaFlag = ((ListView)this.getView()).getListModel().getEntityId();
        for (DynamicObject obj : filterColls) {
            QFilter qFilter;
            List collect;
            String versionId;
            Object fieldName = obj.getString("entitycondalign");
            fieldName = ((String)fieldName).replaceAll(metaFlag + ".", "");
            DynamicObject entityObj = obj.getDynamicObject("entitycond");
            String entitycondset = obj.getString("entitycondfilter_tag");
            FilterCondition filterCondition = new FilterCondition();
            if (!StringUtils.isBlank((CharSequence)entitycondset)) {
                filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)entitycondset, FilterCondition.class);
            }
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityObj.getString("number"));
            FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
            fb.buildFilter(false);
            List<QFilter> filters = fb.getQFilters();
            if (entityObj.getString("number").equals("mpdm_gantt_version") && StringUtils.isNotBlank((CharSequence)(versionId = (String)this.getView().getFormShowParameter().getCustomParam("versionId")))) {
                filters = Collections.singletonList(new QFilter("id", "=", (Object)Long.parseLong(versionId)));
            }
            Object filterFieldName = fieldName;
            if (!CollectionUtils.isEmpty(filterParamModelList) && !CollectionUtils.isEmpty(collect = filterParamModelList.stream().filter(arg_0 -> GanttFormTplPlugin.lambda$cacheFilterColumnFilters$1((String)filterFieldName, arg_0)).collect(Collectors.toList())) && (qFilter = ((GanttFilterParamModel)collect.get(0)).getqFilter()) != null) {
                filters.add(qFilter);
            }
            GanttCacheUtils.cacheBigObject(this.getView().getPageId(), ((String)fieldName).concat(".name"), filters);
        }
        DynamicObjectCollection colls = dataSource.getDynamicObjectCollection("entityselect");
        ArrayList<Object> idList = new ArrayList<Object>(colls.size());
        for (DynamicObject col : colls) {
            idList.add(col.get("id"));
        }
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "ganttentity.name", Collections.singletonList(new QFilter("entryid", "in", idList)));
        ArrayList<Long> schemeIdList = new ArrayList<Long>();
        for (DynamicObject viewScheme : enableColls) {
            schemeIdList.add(viewScheme.getLong("id"));
        }
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "viewscheme.name", Collections.singletonList(new QFilter("id", "in", schemeIdList)));
    }

    private void updatePageData() {
        GanttPageShowModel ganttPageShowModel = GanttUserConfigUtils.getConfig((ListView)this.getView());
        if (Objects.isNull(ganttPageShowModel)) {
            ganttPageShowModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "defaultPageShowSet");
            if (Objects.isNull(ganttPageShowModel)) {
                ganttPageShowModel = new GanttPageShowModel();
            } else if (ganttPageShowModel.getIsRankMode().booleanValue() || ganttPageShowModel.getIsWeekCodeMode().booleanValue()) {
                ganttPageShowModel.setTimelineShowRows(3);
                ganttPageShowModel.setTimelineRows(3);
                if (!ganttPageShowModel.getCellUnitType().equals("day")) {
                    ganttPageShowModel.setTimelineShowRows(2);
                }
            }
        }
        BigDecimal cellScale = ganttPageShowModel.getCellScale();
        BigDecimal scale = cellScale.multiply(new BigDecimal("100")).stripTrailingZeros();
        String scaleStr = "bar_scale".concat(scale.toPlainString());
        this.getView().setEnable(Boolean.TRUE, new String[]{"bar_scale500", "bar_scale400", "bar_scale300", "bar_scale200", "bar_scale150", "bar_scale120", "bar_scale100", "bar_scale90", "bar_scale80", "bar_scale70", "bar_scale60", "bar_scale50", "bar_scale40", "bar_scale30"});
        this.getView().setEnable(Boolean.FALSE, new String[]{scaleStr});
        GanttCommandUtils.updataShowScale(this.getView(), scale.intValue());
        String cellUnitType = ganttPageShowModel.getCellUnitType();
        String cellUnitStr = "bar_depend".concat(cellUnitType);
        this.getView().setEnable(Boolean.TRUE, new String[]{"bar_dependmonth", "bar_dependweek", "bar_dependday", "bar_dependhour"});
        this.getView().setEnable(Boolean.FALSE, new String[]{cellUnitStr});
        GanttCommandUtils.updataTimeScale(this.getView(), cellUnitStr);
        Boolean isVerticalMode = ganttPageShowModel.getIsVerticalMode();
        this.getModel().setValue("verticalshow", (Object)isVerticalMode);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "pageShowSet", ganttPageShowModel);
        this.getModel().setValue("showrisk", (Object)ganttPageShowModel.getShowRisk());
        this.getModel().setValue("showpercentvalue", (Object)ganttPageShowModel.getShowPercentValue());
        this.getModel().setValue("projecttimeshow", (Object)ganttPageShowModel.getProjectTimeShow());
    }

    public void click(EventObject evt) {
        Button button;
        String buttonKey;
        super.click(evt);
        if (evt.getSource() instanceof Button && (buttonKey = (button = (Button)evt.getSource()).getKey()) != null) {
            GanttCommandContext ctx = new GanttCommandContext();
            ctx.setCommandName(buttonKey);
            ctx.setView(this.getView());
            ctx.setPageCache(this.getPageCache());
            ctx.setPlugin((IFormPlugin)this);
            this.executeCommand(ctx, buttonKey);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (("verticalshow".equals(name) || "summaryshow".equals(name)) && !StringUtils.isNotBlank((CharSequence)this.getPageCache().get("nochange"))) {
            GanttCommandContext ctx = new GanttCommandContext();
            ctx.setCommandName(name);
            ctx.setView(this.getView());
            ctx.setPageCache(this.getPageCache());
            this.executeCommand(ctx, name);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getSource() instanceof Toolbar) {
            String itemKey = evt.getItemKey();
            GanttCommandContext ctx = new GanttCommandContext();
            ctx.setCommandName(itemKey);
            ctx.setView(this.getView());
            ctx.setPageCache(this.getPageCache());
            ctx.setPlugin((IFormPlugin)this);
            this.executeCommand(ctx, itemKey);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String ctlkey = e.getKey();
        String eArgs = e.getEventArgs();
        String eName = e.getEventName();
        GanttFilterArg filterArg = new GanttFilterArg(ctlkey, eName);
        filterArg.setFilterDataJson(eArgs);
        HashMap<String, Object> reResult = new HashMap<String, Object>();
        if (Arrays.asList("ganttctl", "ganttctl1", "ganttctl2", "ganttctl3").contains(ctlkey)) {
            GanttCommandContext ctx = new GanttCommandContext();
            ctx.setCommandName(eName);
            ctx.seteArgs(eArgs);
            ctx.setReResult(reResult);
            ctx.setFilterArg(filterArg);
            ctx.setView(this.getView());
            ctx.setPageCache(this.getPageCache());
            ctx.setPlugin((IFormPlugin)this);
            this.executeCommand(ctx, eName);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object classInstance;
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        String className = GanttEventSingleton.getSingleInstance().getEventCommand(event.getActionId(), billFormId);
        if (className != null && !"".equals(className) && (classInstance = TypesContainer.getOrRegisterSingletonInstance((String)className)) instanceof IGanttCommandClosedCallBack) {
            event.setView(this.getView());
            IGanttCommandClosedCallBack command = (IGanttCommandClosedCallBack)classInstance;
            command.closedCallBack(event);
        }
    }

    private void executeCommand(GanttCommandContext ctx, String eName) {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        String className = GanttEventSingleton.getSingleInstance().getEventCommand(eName, billFormId);
        if (StringUtils.isBlank((CharSequence)className)) {
            if (StringUtils.isNotBlank((CharSequence)ctx.geteArgs()) && !StringUtils.equals((CharSequence)"changeGtViewMode", (CharSequence)eName)) {
                logger.info("\u672a\u627e\u5230\u5b9e\u73b0\u7c7b\uff0ceName:".concat(eName).concat(", eArgs:".concat(ctx.geteArgs())));
            }
            return;
        }
        Object classInstance = TypesContainer.createInstance((String)className);
        if (classInstance instanceof AbstractGanttCommand) {
            String executeResult;
            AbstractGanttCommand command = (AbstractGanttCommand)classInstance;
            String number = command.getCommondNumber();
            String name = command.getCommondName();
            try {
                command.execute(ctx);
                executeResult = command.getErrorMsg();
            }
            catch (Exception ex) {
                logger.error("(" + number + ")\u7518\u7279\u56fe\u547d\u4ee4\u6267\u884c", (Throwable)ex);
                this.getView().showTipNotification(ex.getMessage());
                executeResult = ex.getMessage();
            }
            GanttLogModel traceLog = command.getGanttLogModel();
            if (Objects.nonNull(traceLog)) {
                traceLog.setFailCause(executeResult);
                if (StringUtils.isNotBlank((CharSequence)executeResult)) {
                    traceLog.setResult("0");
                }
                if (StringUtils.isBlank((CharSequence)traceLog.getNumber())) {
                    traceLog.setNumber(number);
                }
                if (StringUtils.isBlank((CharSequence)traceLog.getName())) {
                    traceLog.setName(name);
                }
                traceLog.setBillFormId(billFormId);
                GanttLogUtils.saveLog(traceLog);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        DynamicObject datasource = (DynamicObject)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "datasource");
        String metaKey = ((ListView)this.getView()).getListModel().getEntityId();
        this.fillFilterColumn(metaKey, datasource, args);
    }

    private void fillFilterColumn(String metaKey, DynamicObject datasource, FilterContainerInitArgs args) {
        FilterColumn entityColumn;
        args.getSchemeFilterColumns().clear();
        String needFilterFieldStr = GanttCacheUtils.getCache(this.getPageCache(), "needFilterFields");
        if (StringUtils.isNotBlank((CharSequence)needFilterFieldStr)) {
            List needFilterFields = (List)SerializationUtils.fromJsonString((String)needFilterFieldStr, List.class);
            args.getCommonFilterColumns().removeIf(x -> !needFilterFields.contains(x.getFieldName()));
        }
        String versionId = (String)this.getView().getFormShowParameter().getCustomParam("versionId");
        DynamicObjectCollection entitySelectColl = datasource.getDynamicObjectCollection("entityselect");
        ArrayList<DynamicObject> currentViewList = new ArrayList<DynamicObject>();
        DynamicObject versionDyn = this.getCurrentViewList(versionId, entitySelectColl, currentViewList);
        List<Object> currentViewNumberList = currentViewList.stream().map(x -> x.get("id").toString()).collect(Collectors.toList());
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(datasource);
        String versionField = this.getVersionField(currentViewList, taskEntityNumber);
        String pageId = this.getView().getPageId();
        DynamicObjectCollection enableColls = (DynamicObjectCollection)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "allViewScheme");
        FilterColumn viewSchemeColumn = GanttUtils.defaultViewSchemeFilterColumn(metaKey, enableColls, pageId);
        if (viewSchemeColumn != null) {
            args.addFilterColumn(viewSchemeColumn);
        }
        if ((entityColumn = GanttUtils.defaultDataModelFilterColumn(metaKey, datasource, pageId, currentViewNumberList)) != null) {
            String listFormId = ((ListView)this.getView()).getFormShowParameter().getFormConfig().getListFormId();
            ((CommonFilterColumn)entityColumn).setMulti(StringUtils.equals((CharSequence)listFormId, (CharSequence)GANTT_MULTI_TEMPLATE));
            args.addFilterColumn(entityColumn);
        }
        DynamicObjectCollection filtercolls = datasource.getDynamicObjectCollection("entityfilter");
        List<FilterColumn> columnList = GanttUtils.standardViewSchemeFilterColumn(metaKey, filtercolls, versionId, versionField, pageId);
        for (FilterColumn column : columnList) {
            args.addFilterColumn(column);
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)column;
            commonFilterColumn.setDefaultValues(column.getDefaultValues());
        }
        CommonDateFilterColumn timefilterColumn = GanttUtils.defaultStandardTimeFilterColumn(datasource);
        if (Objects.nonNull(timefilterColumn)) {
            List comboItems;
            GanttCacheUtils.cache(this.getPageCache(), "timeFilterField", timefilterColumn.getFieldName());
            if (!GanttUtils.isOnlyCustomerTime(taskEntityNumber)) {
                this.addCustomCompare(timefilterColumn);
            }
            args.addFilterColumn((FilterColumn)timefilterColumn);
            if (!GanttUtils.isOnlyCustomerTime(taskEntityNumber)) {
                comboItems = timefilterColumn.getComboItems();
                ComboItem remove = (ComboItem)comboItems.remove(0);
                remove.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672a\u6765\u4e24\u5e74", (String)"GanttFormTplPlugin_4", (String)"bd-mpdm-gantt", (Object[])new Object[0])));
                comboItems.add(remove);
                String billFormId = ((ListView)this.getView()).getBillFormId();
                if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmpd_resourceplan_bench") || StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmpd_resourceplan_pre")) {
                    timefilterColumn.setDefaultValue("1434825437409744896");
                }
            } else {
                comboItems = timefilterColumn.getComboItems();
                comboItems.clear();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)versionId)) {
            this.updateDefaultValue(args, versionDyn, versionField);
        }
        this.addSchemeFilter(args);
        if (!GanttUtils.isOnlyCustomerTime(taskEntityNumber)) {
            this.updateSchemeCompareSort(args);
        }
        this.cacheFilterInfo(args, pageId);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = (List)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), fieldName);
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            for (QFilter filter : filters) {
                args.addCustomQFilter(filter);
            }
        }
    }

    private String getVersionField(List<DynamicObject> currentViewList, String taskEntityNumber) {
        for (DynamicObject currentViewObject : currentViewList) {
            DynamicObjectCollection entityConditionColl = currentViewObject.getDynamicObjectCollection("entitycondition");
            for (DynamicObject entityCondition : entityConditionColl) {
                String centityNumber = entityCondition.getString("centity.number");
                String versionFiled = entityCondition.getString("versionfiled");
                if (!StringUtils.isNotBlank((CharSequence)centityNumber) || !StringUtils.isNotBlank((CharSequence)versionFiled) || !StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)centityNumber)) continue;
                return versionFiled;
            }
        }
        return null;
    }

    private DynamicObject getCurrentViewList(String versionId, DynamicObjectCollection entitySelectColl, List<DynamicObject> currentViewList) {
        Map gtFilterMap;
        DynamicObject versionDyn = null;
        if (StringUtils.isNotBlank((CharSequence)versionId) && Objects.nonNull(versionDyn = QueryServiceHelper.queryOne((String)"mpdm_gantt_version", (String)"filterstr_tag,versiontype.filtervalue filtervalue", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(versionId)).toArray())) && Objects.nonNull(gtFilterMap = (Map)JSONObject.parseObject((String)versionDyn.getString("filterstr_tag"), Map.class))) {
            for (Map.Entry entry : gtFilterMap.entrySet()) {
                String key;
                String filterKey = key = (String)entry.getKey();
                filterKey = filterKey.replace(".name", "");
                if (!"ganttentity".equals(filterKey = filterKey.replace(".id", ""))) continue;
                JSONObject ganttQFilterObj = (JSONObject)entry.getValue();
                if (!Objects.nonNull(ganttQFilterObj)) break;
                String currentViewStr = ganttQFilterObj.getString("value");
                List<Long> currentViewStrList = new ArrayList<Long>();
                try {
                    currentViewStrList = JSONObject.parseArray((String)currentViewStr, Long.class);
                }
                catch (Exception e) {
                    currentViewStrList.add(Long.parseLong(currentViewStr));
                }
                List<Long> currentViewStrList1 = currentViewStrList;
                List defaultViewList = entitySelectColl.stream().filter(x -> currentViewStrList1.contains(x.getLong("id"))).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(defaultViewList)) break;
                currentViewList.addAll(defaultViewList);
                break;
            }
        }
        if (CollectionUtils.isEmpty(currentViewList)) {
            List defaultViewList = entitySelectColl.stream().filter(x -> x.getBoolean("defaultview")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(defaultViewList)) {
                currentViewList.addAll(defaultViewList);
            } else {
                currentViewList.add((DynamicObject)entitySelectColl.get(0));
            }
        }
        return versionDyn;
    }

    private void updateSchemeCompareSort(FilterContainerInitArgs args) {
        for (FilterColumn filterColumn : args.getSchemeFilterColumns()) {
            if (!"datetime".equals(filterColumn.getType())) continue;
            SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)filterColumn;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass("kd.bos.filter.SchemeFilterColumn");
                Field compareTypesField = clazz.getDeclaredField("compareTypes");
                AccessibleObject[] colorAcce = new AccessibleObject[]{compareTypesField};
                AccessibleObject.setAccessible(colorAcce, true);
                List compareTypes = (List)compareTypesField.get(schemeFilterColumn);
                CompareType remove = (CompareType)compareTypes.remove(0);
                remove.setName(new LocaleString(ResManager.loadKDString((String)"\u672a\u6765\u4e24\u5e74", (String)"GanttFormTplPlugin_4", (String)"bd-mpdm-gantt", (Object[])new Object[0])));
                compareTypes.add(remove);
                compareTypesField.set(schemeFilterColumn, compareTypes);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    private void addCustomCompare(CommonDateFilterColumn timefilterColumn) {
        FilterField filterField = timefilterColumn.getFilterField();
        DateTimeProp srcFieldProp = (DateTimeProp)filterField.getSrcFieldProp();
        CompareTypeConfig compareTypeConfig = srcFieldProp.getCompareTypeConfig();
        if (Objects.isNull(compareTypeConfig)) {
            compareTypeConfig = new CompareTypeConfig();
        }
        List compareTypeFields = compareTypeConfig.getCompareTypeFields();
        CompareTypeField twoYear = new CompareTypeField();
        twoYear.setId("1434825437409744896");
        twoYear.setName(new LocaleString(ResManager.loadKDString((String)"\u672a\u6765\u4e24\u5e74", (String)"GanttFormTplPlugin_4", (String)"bd-mpdm-gantt", (Object[])new Object[0])));
        twoYear.setClassName("kd.bd.mpdm.formplugin.gantt.TwoYearFilter");
        boolean isExistField = false;
        for (CompareTypeField field : compareTypeFields) {
            if (!field.getId().equals(twoYear.getId())) continue;
            isExistField = true;
        }
        if (!isExistField) {
            compareTypeFields.add(twoYear);
        }
        srcFieldProp.setCompareTypeConfig(compareTypeConfig);
    }

    private void cacheFilterInfo(FilterContainerInitArgs args, String pageId) {
        List schemeFilterColumns = args.getSchemeFilterColumns();
        HashMap<String, String> fieldToEntityMap = new HashMap<String, String>(schemeFilterColumns.size());
        if (!CollectionUtils.isEmpty((Collection)schemeFilterColumns)) {
            for (FilterColumn schemeFilterColumn : schemeFilterColumns) {
                String fieldName = schemeFilterColumn.getFieldName();
                String refEntityId = schemeFilterColumn.getFilterField().getRefEntityId();
                fieldToEntityMap.put(fieldName, refEntityId);
            }
        }
        GanttCacheUtils.cacheBigObject(pageId, "fieldToEntityMap", fieldToEntityMap);
        List commonFilterColumns = args.getCommonFilterColumns();
        HashMap<String, String> mustInputFieldMap = new HashMap<String, String>(commonFilterColumns.size());
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            boolean mustInput = commonFilterColumn.isMustInput();
            if (!mustInput) continue;
            String fieldName = commonFilterColumn.getFieldName();
            String fieldId = fieldName.replace(".name", "").replace(".id", "");
            mustInputFieldMap.put(fieldId, commonFilterColumn.getCaption().getLocaleValue());
        }
        GanttCacheUtils.cacheBigObject(pageId, "mustInputFieldMap", mustInputFieldMap);
    }

    private void updateDefaultValue(FilterContainerInitArgs args, DynamicObject versionDyn, String versionField) {
        if (Objects.isNull(versionDyn)) {
            return;
        }
        Map gtFilterMap = (Map)JSONObject.parseObject((String)versionDyn.getString("filterstr_tag"), Map.class);
        if (Objects.isNull(gtFilterMap)) {
            return;
        }
        String filterValue = versionDyn.getString("filtervalue");
        boolean isCurrentFilter = false;
        if (GanttVersionFilterEnum.CURRENT.getValue().equals(filterValue)) {
            isCurrentFilter = true;
        }
        String pageId = this.getView().getPageId();
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("viewscheme.name".equals(fieldName) || "ganttentity.name".equals(fieldName)) continue;
            fieldName = fieldName.replace(".name", "");
            fieldName = fieldName.replace(".id", "");
            boolean hasValue = false;
            Iterator iterator = gtFilterMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String filterKey = key = (String)iterator.next();
                filterKey = filterKey.replace(".name", "");
                if (!fieldName.equals(filterKey = filterKey.replace(".id", ""))) continue;
                hasValue = true;
                this.columSetDefaultValue(gtFilterMap, commonFilterColumn, key, isCurrentFilter, pageId, fieldName);
                break;
            }
            if (hasValue || !isCurrentFilter || StringUtils.equals((CharSequence)versionField, (CharSequence)fieldName) || fieldName.contains("ganttentity")) continue;
            commonFilterColumn.getComboItems().clear();
            QFilter qFilter = new QFilter("id", "is null", null);
            GanttCacheUtils.cacheBigObject(pageId, fieldName, Collections.singletonList(qFilter));
        }
    }

    private void addSchemeFilter(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            SchemeFilterColumn schemeFilterColumn = new SchemeFilterColumn();
            schemeFilterColumn.setEntityType(commonFilterColumn.getEntityType());
            schemeFilterColumn.setFieldName(commonFilterColumn.getFieldName());
            schemeFilterColumn.setKey(commonFilterColumn.getKey());
            schemeFilterColumn.setCaption(commonFilterColumn.getCaption());
            schemeFilterColumn.setType(commonFilterColumn.getType());
            List compareTypes = schemeFilterColumn.getFilterField().getCompareTypes();
            if ("datetime".equals(commonFilterColumn.getType())) {
                if (GanttUtils.isOnlyCustomerTime(commonFilterColumn.getEntryEntity())) {
                    compareTypes.removeIf(x -> !StringUtils.equals((CharSequence)"1", (CharSequence)x.getId()));
                } else {
                    compareTypes.removeIf(x -> !Arrays.asList("13", "10", "63", "24", "66", "68", "69", "1").contains(x.getId()));
                }
            } else if (commonFilterColumn.isMulti()) {
                compareTypes.removeIf(x -> !Arrays.asList("67", "17", "110", "111").contains(x.getId()));
            } else {
                compareTypes.removeIf(x -> !Arrays.asList("67", "110").contains(x.getId()));
            }
            args.addFilterColumn((FilterColumn)schemeFilterColumn);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List filters;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        fieldName = fieldName.replaceAll(".id", "").replaceAll(".name", "");
        if ("sectionresource".equals(fieldName)) {
            fieldName = "entry_repair.sectionresource";
        }
        if (!CollectionUtils.isEmpty((Collection)(filters = (List)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), fieldName.concat(".name"))))) {
            args.setCustomQFilters(filters);
        }
    }

    private void columSetDefaultValue(Map<String, JSONObject> gtFilterMap, CommonFilterColumn commonFilterColumn, String key, boolean isCurrentFilter, String pageId, String fieldName) {
        if (key.contains("ganttentity")) {
            return;
        }
        JSONObject ganttQFilterObj = gtFilterMap.get(key);
        if (Objects.nonNull(ganttQFilterObj)) {
            String value = ganttQFilterObj.getString("value");
            try {
                List values = JSONObject.parseArray((String)value, String.class);
                ArrayList<String> valueList = new ArrayList<String>(values.size());
                for (String s : values) {
                    valueList.add(s);
                }
                if (isCurrentFilter) {
                    commonFilterColumn.setMustInput(true);
                    commonFilterColumn.getComboItems().removeIf(x -> !valueList.contains(x.getValue()));
                    QFilter qFilter = new QFilter("id", "in", this.convertFilterValue(valueList));
                    GanttCacheUtils.cacheBigObject(pageId, fieldName, Collections.singletonList(qFilter));
                }
                commonFilterColumn.setDefaultValues(valueList);
            }
            catch (Exception e) {
                if (isCurrentFilter) {
                    commonFilterColumn.setMustInput(true);
                    commonFilterColumn.getComboItems().removeIf(x -> !value.equals(x.getValue()));
                    QFilter qFilter = new QFilter("id", "=", this.convertFilterValue(value));
                    GanttCacheUtils.cacheBigObject(pageId, fieldName, Collections.singletonList(qFilter));
                }
                commonFilterColumn.setDefaultValue(value);
            }
        }
    }

    private Object convertFilterValue(Object value) {
        try {
            if (value instanceof List) {
                List values = (List)value;
                ArrayList<Long> longList = new ArrayList<Long>(values.size());
                for (Object o : values) {
                    longList.add(Long.parseLong(o.toString()));
                }
                return longList;
            }
            if (value instanceof String) {
                return Long.parseLong(value.toString());
            }
            return value;
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public void setFilter(SetFilterEvent e) {
        Object viewSchemId;
        GanttFilterArg filterArg = new GanttFilterArg();
        List<GanttQFilter> gtfilters = GanttUtils.setSearchQfilter(e.getMergeQFilters());
        GanttUtils.fieldNameConvertId(gtfilters, this.getView().getPageId());
        List<GanttFilterParamModel> ganttFilterParamModels = GanttUtils.getGanttFilterParamModels(this.getView());
        if (!CollectionUtils.isEmpty(ganttFilterParamModels)) {
            ganttFilterParamModels = ganttFilterParamModels.stream().filter(x -> x.getHiddenColumn()).collect(Collectors.toList());
            for (GanttFilterParamModel ganttFilterParamModel : ganttFilterParamModels) {
                if (!StringUtils.isNotBlank((CharSequence)ganttFilterParamModel.getFieldName()) || CollectionUtils.isEmpty(ganttFilterParamModel.getDefaultValues())) continue;
                List filterValues = ganttFilterParamModel.getDefaultValues().stream().map(x -> Long.parseLong(x)).collect(Collectors.toList());
                GanttQFilter defaultFilter = new GanttQFilter(ganttFilterParamModel.getFieldName().concat(".id"), "in", filterValues);
                gtfilters.add(defaultFilter);
            }
        }
        Map<String, GanttQFilter> gtFilterMap = GanttUtils.getMapQFilter(gtfilters);
        this.getView().setVisible(Boolean.TRUE, new String[]{"toolbarap", "summaryshow", "toolbarap1"});
        if (this.mustFilterHasInput(gtFilterMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap", "summaryshow", "toolbarap1"});
            return;
        }
        filterArg.setSeachFilters(gtfilters);
        filterArg.setSeachFilterMap(gtFilterMap);
        this.changeTimeFilterValue(gtfilters, gtFilterMap);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "filterStr", JSONObject.toJSONString(gtFilterMap));
        Map<String, GanttQFilter> filterMap = filterArg.getSeachFilterMap();
        GanttQFilter typeSchemFilter = filterMap.get("viewscheme.id");
        String metaKey = ((ListView)this.getView()).getBillFormId();
        boolean displaySchemeFilter = GanttUtils.displaySchemeFilter(this.getPageCache().getPageId(), "displayViewFilter");
        DynamicObject mGanttSourceObj = (DynamicObject)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "datasource");
        if (displaySchemeFilter) {
            viewSchemId = typeSchemFilter.getValue();
        } else {
            DynamicObjectCollection enableColls = (DynamicObjectCollection)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "allViewScheme");
            viewSchemId = ((DynamicObject)enableColls.get(0)).getLong("id");
        }
        DynamicObject mJobViewSchemObj = BusinessDataServiceHelper.loadSingleFromCache((Object)viewSchemId, (String)"msplan_viewscheme");
        GanttQFilter viewSchemFilter = filterMap.get("ganttentity.id");
        List<String> dataModelTypeList = new ArrayList<String>();
        String mainDataModelType = this.getMainDataModelType(mGanttSourceObj, dataModelTypeList);
        boolean displayEntityFilter = GanttUtils.displaySchemeFilter(this.getPageCache().getPageId(), "displayEntityFilter");
        if (displayEntityFilter) {
            try {
                List dataModelTypeIdList = (List)viewSchemFilter.getValue();
                dataModelTypeList = dataModelTypeIdList.stream().map(String::valueOf).collect(Collectors.toList());
            }
            catch (Exception exception) {
                dataModelTypeList.add(viewSchemFilter.getValue().toString());
            }
            mainDataModelType = this.getMainDataModelType(mGanttSourceObj, dataModelTypeList);
            if (!dataModelTypeList.contains(mainDataModelType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4e3b\u89c6\u56fe\u65b9\u6848\uff0c\u65e0\u6cd5\u663e\u793a\u89c6\u56fe\u3002", (String)"GanttFormTplPlugin_8", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                return;
            }
        } else {
            dataModelTypeList.add(mainDataModelType);
        }
        GanttCacheUtils.cache(this.getPageCache(), "mainDataModelType", mainDataModelType);
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        DynamicObject versionType = this.getFilterVersionType(mainDataModelType, filterMap, mGanttSourceObj);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)taskEntityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String formEntityId = formMeta.getEntityId();
        MainEntityType srcbillMainType = EntityMetadataCache.getDataEntityTypeById((String)formEntityId);
        List<String> entryTagList = this.getEntryTagList(srcbillMainType);
        Map<String, List<ValueMapItem>> comboItemsMap = this.getComboItemsMap(srcbillMainType);
        Map<String, DecimalPropModel> decimalPropMap = this.getDecimalPropMap(formMeta, srcbillMainType);
        this.cacheFilterTime(filterArg, mGanttSourceObj);
        Map modelTypeToCtrlMap = (Map)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "modelTypeToCtrlMap");
        Map modelTypeToFlexMap = (Map)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "modelTypeToFlexMap");
        for (String dataModelType : dataModelTypeList) {
            GanttBuildContext ganttBuildContext = this.buildContext(filterArg, dataModelType, metaKey, mGanttSourceObj, mJobViewSchemObj);
            ganttBuildContext.setMianDataModelType(mainDataModelType);
            ganttBuildContext.setEntryTagList(entryTagList);
            ganttBuildContext.setComboItemsMap(comboItemsMap);
            ganttBuildContext.setDecimalPropMap(decimalPropMap);
            ganttBuildContext.setVersionType(versionType);
            this.setPreModel(ganttBuildContext);
            GanttCacheUtils.cacheWithDataModel(this.getPageCache(), dataModelType, "toDoShow", Boolean.FALSE.toString());
            this.cacheEntityVersionMap(ganttBuildContext, taskEntityNumber);
            GanttModelStandardBuild build = new GanttModelStandardBuild();
            GanttModelBuilder builder = new GanttModelBuilder(build);
            GanttGlobalModel model = builder.packaging(ganttBuildContext);
            ganttBuildContext.getmGanttViewSchemModel().setGanttNums(dataModelTypeList.size());
            GanttUtils.setShowSet(model, this.getView());
            GanttDealDataUtils.dealDataForFornt(model.getPageData().getOrDefault("dataList", new ArrayList()));
            GanttBuildAfterModel afterModel = ganttBuildContext.getAfterModel();
            GanttCacheUtils.cacheWithDataModel(this.getPageCache(), dataModelType, "entryTag", afterModel.getEntryTag());
            GanttCacheUtils.cacheBigObjectWithDataModel(this.getView().getPageCache(), dataModelType, "ganttBuildContext", ganttBuildContext);
            GanttCacheUtils.cacheBigObjectWithDataModel(this.getView().getPageCache(), dataModelType, "model", model);
            GanttCacheUtils.cacheBigObjectWithDataModel(this.getView().getPageCache(), dataModelType, "viewSchem", model.getViewSchem());
            String ganttCtl = (String)modelTypeToCtrlMap.get(dataModelType);
            String flexpanelap3 = (String)modelTypeToFlexMap.get(dataModelType);
            CustomControl custCtl = (CustomControl)this.getView().getControl(ganttCtl);
            JSONObject result = (JSONObject)JSONObject.toJSON((Object)model);
            custCtl.setData((Object)result);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{flexpanelap3});
        }
        String listFormId = ((ListView)this.getView()).getFormShowParameter().getFormConfig().getListFormId();
        if (StringUtils.equals((CharSequence)listFormId, (CharSequence)GANTT_MULTI_TEMPLATE)) {
            for (Map.Entry entry : modelTypeToCtrlMap.entrySet()) {
                if (dataModelTypeList.contains(entry.getKey())) continue;
                CustomControl custCtl = (CustomControl)this.getView().getControl((String)entry.getValue());
                custCtl.setData(null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{(String)modelTypeToFlexMap.get(entry.getKey())});
            }
        }
        GanttCacheUtils.cache(this.getPageCache(), "dataSourceId", mGanttSourceObj.get("id").toString());
        GanttCacheUtils.cache(this.getPageCache(), "viewSchemEntity", mainDataModelType);
        GanttCacheUtils.cache(this.getPageCache(), "taskEntityIds", taskEntityNumber);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "entryTagList", entryTagList);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "comboItemsMap", comboItemsMap);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "viewSchemObj", mJobViewSchemObj);
        GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "dataModelTypeList", dataModelTypeList);
    }

    private String getMainDataModelType(DynamicObject mGanttSourceObj, List<String> ganttEntityList) {
        if (ganttEntityList.size() == 1) {
            return ganttEntityList.get(0);
        }
        DynamicObjectCollection dynamicObjectCollection = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        long ganttEntityId = ((DynamicObject)dynamicObjectCollection.get(0)).getLong("id");
        return Long.toString(ganttEntityId);
    }

    private void changeTimeFilterValue(List<GanttQFilter> gtfilters, Map<String, GanttQFilter> gtFilterMap) {
        String timeFilterField = GanttCacheUtils.getCache(this.getPageCache(), "timeFilterField");
        if (StringUtils.isNotBlank((CharSequence)timeFilterField)) {
            ArrayList<String> timeList = new ArrayList<String>(2);
            for (GanttQFilter gtfilter : gtfilters) {
                if (!timeFilterField.equals(gtfilter.getProperty())) continue;
                if (gtfilter.getCp().equals(">=")) {
                    timeList.add(0, DateFormatUtils.format((Date)((Date)gtfilter.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                timeList.add(1, DateFormatUtils.format((Date)((Date)gtfilter.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            GanttQFilter ganttQFilter = gtFilterMap.get(timeFilterField);
            if (Objects.nonNull(ganttQFilter)) {
                GanttQFilter timeQFilter = new GanttQFilter(ganttQFilter.getProperty(), ganttQFilter.getCp(), timeList);
                gtFilterMap.put(timeFilterField, timeQFilter);
            }
        }
    }

    private GanttBuildContext buildContext(GanttFilterArg filterArg, String dataModelType, String metaKey, DynamicObject mGanttSourceObj, DynamicObject mJobViewSchemObj) {
        GanttBuildContext ganttBuildContext = new GanttBuildContext();
        ListView view = (ListView)this.getView();
        boolean showRisk = GanttUserConfigUtils.getShowRisk(view);
        ganttBuildContext.setShowRisk(showRisk);
        boolean showIndex = GanttUserConfigUtils.getShowIndex(view);
        ganttBuildContext.setShowIndex(showIndex);
        String requestId = UUID.randomUUID().getMostSignificantBits() + "&";
        ganttBuildContext.setRequestId(requestId);
        GanttCacheUtils.cacheWithDataModel(this.getPageCache(), dataModelType, "requestId", requestId);
        String entityId = ((ListView)this.getView()).getListModel().getEntityId();
        ganttBuildContext.setBillFormId(metaKey);
        ganttBuildContext.setEntityId(entityId);
        ganttBuildContext.setFilterArg(filterArg);
        ganttBuildContext.setmGanttSourceObj(mGanttSourceObj);
        ganttBuildContext.setmJobViewSchemObj(mJobViewSchemObj);
        GanttViewSchemModel schemViewPara = GanttUtils.getSchemViewPara(ganttBuildContext, mJobViewSchemObj);
        if (!schemViewPara.getSummaryShow().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"summaryshow"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"summaryshow"});
            schemViewPara.setSummaryShow((Boolean)this.getModel().getValue("summaryshow"));
        }
        GanttPageShowModel pageShowSet = GanttUserConfigUtils.getPageShowSet((ListView)this.getView());
        GanttDataUtils.copyProperties(schemViewPara, pageShowSet);
        ganttBuildContext.setSchemModel(schemViewPara);
        ganttBuildContext.setDataModelType(dataModelType);
        DynamicObject dataModelEntity = GanttUtils.getDataModelEntity(mGanttSourceObj, dataModelType);
        ganttBuildContext.setDataModelEntity(dataModelEntity);
        ganttBuildContext.setPageId(this.getView().getPageId());
        return ganttBuildContext;
    }

    private Map<String, DecimalPropModel> getDecimalPropMap(FormMetadata formMeta, MainEntityType srcbillMainType) {
        HashMap<String, Boolean> noDisplayScaleZeroMap = new HashMap<String, Boolean>(16);
        HashMap<String, DecimalPropModel> decimalPropMap = new HashMap<String, DecimalPropModel>(16);
        DataEntityPropertyCollection properties = srcbillMainType.getProperties();
        for (ControlAp item : formMeta.getItems()) {
            if (!(item instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)item;
            String key = fieldAp.getKey();
            boolean noDisplayScaleZero = fieldAp.isNoDisplayScaleZero();
            noDisplayScaleZeroMap.put(key, noDisplayScaleZero);
        }
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof DecimalProp)) continue;
            DecimalProp decimalProp = (DecimalProp)property;
            String name = decimalProp.getName();
            int scale = decimalProp.getScale();
            boolean noDisplayScaleZero = (Boolean)noDisplayScaleZeroMap.get(name);
            DecimalPropModel decimalPropModel = new DecimalPropModel(scale, noDisplayScaleZero);
            decimalPropMap.put(name, decimalPropModel);
        }
        return decimalPropMap;
    }

    private Map<String, List<ValueMapItem>> getComboItemsMap(MainEntityType srcbillMainType) {
        HashMap<String, List<ValueMapItem>> comboItemsMap = new HashMap<String, List<ValueMapItem>>(16);
        DataEntityPropertyCollection properties = srcbillMainType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof BillStatusProp) && !(property instanceof ComboProp)) continue;
            List comboItems = ((ComboProp)property).getComboItems();
            String name = property.getName();
            comboItemsMap.put(name, comboItems);
        }
        return comboItemsMap;
    }

    private List<String> getEntryTagList(MainEntityType srcbillMainType) {
        Map allEntities = srcbillMainType.getAllEntities();
        ArrayList<String> entryTagList = new ArrayList<String>(allEntities.size());
        for (Map.Entry typeEntry : allEntities.entrySet()) {
            if (!(typeEntry.getValue() instanceof EntryType)) continue;
            entryTagList.add((String)typeEntry.getKey());
        }
        return entryTagList;
    }

    private DynamicObject getFilterVersionType(String mainDataModelType, Map<String, GanttQFilter> filterMap, DynamicObject mGanttSourceObj) {
        GanttCacheUtils.removeCacheBigObject(this.getView().getPageId(), "versionTypeObj");
        String taskEntityNumber = GanttUtils.getTaskEntityNumber(mGanttSourceObj);
        GanttQFilter versionQFilter = null;
        DynamicObjectCollection entitySelectColl = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        for (DynamicObject entitySelect : entitySelectColl) {
            long ganttEntity = entitySelect.getLong("id");
            if (!StringUtils.equals((CharSequence)mainDataModelType, (CharSequence)Long.toString(ganttEntity))) continue;
            DynamicObjectCollection entityConditionColl = entitySelect.getDynamicObjectCollection("entitycondition");
            for (DynamicObject entityCondition : entityConditionColl) {
                String centityNumber = entityCondition.getString("centity.number");
                String versionFiled = entityCondition.getString("versionfiled");
                if (!StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)centityNumber)) continue;
                versionQFilter = filterMap.get(versionFiled.concat(".id"));
            }
        }
        if (versionQFilter != null) {
            Object value = versionQFilter.getValue();
            QFilter qFilter = new QFilter("id", "=", value);
            DynamicObject version = QueryServiceHelper.queryOne((String)"mpdm_gantt_version", (String)"versiontype", (QFilter[])qFilter.toArray());
            if (Objects.isNull(version)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"GanttFormTplPlugin_10", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            }
            DynamicObject versionType = BusinessDataServiceHelper.loadSingle((Object)version.getLong("versiontype"), (String)"mpdm_gantt_versiontype");
            GanttCacheUtils.cacheBigObject(this.getView().getPageId(), "versionTypeObj", versionType);
            GanttCacheUtils.cache(this.getView().getPageCache(), "versionid", value.toString());
            return versionType;
        }
        return null;
    }

    private void cacheEntityVersionMap(GanttBuildContext ganttBuildContext, String taskEntityNumber) {
        DynamicObject mGanttSourceObj = ganttBuildContext.getmGanttSourceObj();
        String dataModelType = ganttBuildContext.getDataModelType();
        DynamicObjectCollection entitySelectColl = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        HashMap<String, String> entityVersionMap = new HashMap<String, String>(16);
        for (DynamicObject entitySelect : entitySelectColl) {
            Long ganttEntityId = entitySelect.getLong("id");
            if (!StringUtils.equals((CharSequence)dataModelType, (CharSequence)Long.toString(ganttEntityId))) continue;
            DynamicObjectCollection entityConditionColl = entitySelect.getDynamicObjectCollection("entitycondition");
            for (DynamicObject entityCondition : entityConditionColl) {
                String centityNumber = entityCondition.getString("centity.number");
                String versionFiled = entityCondition.getString("versionfiled");
                if (StringUtils.isNotBlank((CharSequence)centityNumber) && StringUtils.isNotBlank((CharSequence)versionFiled)) {
                    entityVersionMap.put(centityNumber, versionFiled);
                }
                if (!StringUtils.equals((CharSequence)taskEntityNumber, (CharSequence)centityNumber)) continue;
                GanttCacheUtils.cacheBigObjectWithDataModel(this.getView().getPageCache(), dataModelType, "taskEntityVersionField", versionFiled);
            }
        }
        if (Objects.nonNull(entityVersionMap)) {
            for (Map.Entry entry : entityVersionMap.entrySet()) {
                GanttCacheUtils.removeBigObjectWithDataModel(this.getView().getPageCache(), dataModelType, (String)entry.getKey());
            }
        }
        GanttCacheUtils.cacheBigObjectWithDataModel(this.getView().getPageCache(), dataModelType, "entityVersionMap", entityVersionMap);
        GanttCacheUtils.removeBigObjectWithDataModel(this.getView().getPageCache(), dataModelType, "haveTaskEntity");
    }

    private void setPreModel(GanttBuildContext ganttBuildContext) {
        GanttViewSchemModel schemViewPara = ganttBuildContext.getSchemModel();
        GanttBuildPreModel preModel = new GanttBuildPreModel();
        preModel.setRequestId(ganttBuildContext.getRequestId());
        preModel.setPageId(this.getView().getPageId());
        GanttPageShowModel pageShowModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "pageShowSet");
        preModel.setScale(pageShowModel.getCellScale().toString());
        preModel.setCellUnitType(pageShowModel.getCellUnitType());
        preModel.setToDoShow(schemViewPara.getTodoShow());
        preModel.setEmptyBarCrossModel(GanttDealDataUtils.getEmptyCrossModel(schemViewPara));
        ganttBuildContext.setPreModel(preModel);
    }

    private boolean mustFilterHasInput(Map<String, GanttQFilter> gtFilterMap) {
        Map mustInputFieldMap = (Map)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "mustInputFieldMap");
        if (Objects.isNull(mustInputFieldMap) || mustInputFieldMap.size() == 0) {
            return false;
        }
        ArrayList errorFields = new ArrayList();
        for (String key : gtFilterMap.keySet()) {
            String replace;
            if (!key.contains(".name") || !mustInputFieldMap.containsKey(replace = key.replace(".name", ""))) continue;
            errorFields.add(mustInputFieldMap.get(replace));
        }
        if (!CollectionUtils.isEmpty(errorFields)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5fc5\u5f55\u8fc7\u6ee4\u6761\u4ef6 %s \u5bf9\u5e94\u6570\u636e\u3002", (String)"GanttFormTplPlugin_7", (String)"bd-mpdm-gantt", (Object[])new Object[0]), String.join((CharSequence)",", errorFields)));
            CustomControl custCtl = (CustomControl)this.getView().getControl("ganttctl");
            JSONObject result = (JSONObject)JSONObject.toJSON((Object)new GanttGlobalModel());
            custCtl.setData((Object)result);
            return true;
        }
        for (String key : gtFilterMap.keySet()) {
            mustInputFieldMap.remove(key.replace(".id", ""));
        }
        if (mustInputFieldMap.size() > 0) {
            Collection values = mustInputFieldMap.values();
            String join = String.join((CharSequence)",", values);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5fc5\u5f55\u8fc7\u6ee4\u6761\u4ef6 %s \u7684\u503c\u3002", (String)"GanttFormTplPlugin_6", (String)"bd-mpdm-gantt", (Object[])new Object[0]), join));
            CustomControl custCtl = (CustomControl)this.getView().getControl("ganttctl");
            JSONObject result = (JSONObject)JSONObject.toJSON((Object)new GanttGlobalModel());
            custCtl.setData((Object)result);
            return true;
        }
        return false;
    }

    private void cacheFilterTime(GanttFilterArg filterArg, DynamicObject mGanttSourceObj) {
        CommonDateFilterColumn timeFilter = GanttUtils.defaultStandardTimeFilterColumn(mGanttSourceObj);
        List<GanttQFilter> ganttQFilters = filterArg.getSeachFilters();
        GanttCacheUtils.cache(this.getPageCache(), "filterStartTime", null);
        GanttCacheUtils.cache(this.getPageCache(), "filterEndTime", null);
        if (timeFilter != null) {
            for (GanttQFilter filter : ganttQFilters) {
                if (!filter.getProperty().equals(timeFilter.getFieldName())) continue;
                long tmpTime = ((Date)filter.getValue()).getTime();
                String cp = filter.getCp();
                if (cp.equals(">=")) {
                    GanttCacheUtils.cache(this.getPageCache(), "filterStartTime", Long.toString(tmpTime));
                }
                if (!cp.equals("<")) continue;
                GanttCacheUtils.cache(this.getPageCache(), "filterEndTime", Long.toString(tmpTime));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        String className = GanttEventSingleton.getSingleInstance().getEventCommand(event.getCallBackId(), billFormId);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            Object classInstance = TypesContainer.getOrRegisterSingletonInstance((String)className);
            if (classInstance instanceof IGanttCommandConfirmCallBack) {
                if (event.getResult() == MessageBoxResult.Yes) {
                    IGanttCommandConfirmCallBack command = (IGanttCommandConfirmCallBack)classInstance;
                    command.confirmCallBack(event);
                }
            } else {
                this.openDetailConfirm(event);
            }
        } else {
            this.openDetailConfirm(event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openDetailConfirm(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes && "showFormConfirmCallBack".equals(event.getCallBackId())) {
            FormShowParameter showParameter = (FormShowParameter)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "showForm");
            if (!Objects.nonNull(showParameter)) throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u9875\u9762\u53c2\u6570\u83b7\u53d6\u5931\u8d25\u3002", (String)"GanttFormTplPlugin_11", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            this.getView().showForm(showParameter);
            return;
        } else {
            GanttCacheUtils.removeCacheBigObject(this.getView().getPageId(), "showForm");
        }
    }

    private static /* synthetic */ boolean lambda$cacheFilterColumnFilters$1(String filterFieldName, GanttFilterParamModel x) {
        return x.getFieldName().equals(filterFieldName);
    }
}

