/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt;

import java.util.List;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GanttPrintDataPrintPlugin
extends AbstractPrintPlugin {
    private static final Log logger = LogFactory.getLog(GanttPrintDataPrintPlugin.class);

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String formid = dataSource.getFormId();
        Object pkid = dataSource.getPkId();
        DynamicObject dynobj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkid, (String)formid);
        String pageid = dynobj.getString("pageid");
        Object projectnumid = GanttUtils.getFilterValue("projectnum.id", pageid);
        try {
            DynamicObject obj;
            if (projectnumid != null && (obj = BusinessDataServiceHelper.loadSingleFromCache((Object)projectnumid, (String)"pmpd_project")) != null && "ganttplan".equals(dataSource.getDsName())) {
                List customDataRows = evt.getCustomDataRows();
                DataRowSet customRow = new DataRowSet();
                DynamicObject customer = obj.getDynamicObject("customer");
                String customername = customer == null ? "" : customer.getLocaleString("name").toString();
                DynamicObject engineequipmodel = obj.getDynamicObject("engineequipmodel");
                String engineequipmodelname = engineequipmodel == null ? "" : engineequipmodel.getLocaleString("name").toString();
                DynamicObject devices = obj.getDynamicObject("devices");
                String devicesname = devices == null ? "" : devices.getLocaleString("name").toString();
                String version = "Work Program(RO)";
                String projectNumber = obj.getString("number");
                DynamicObject workscope = obj.getDynamicObject("workscope");
                String contentdetail = "";
                if (workscope != null) {
                    contentdetail = workscope.getString("contentdetail");
                }
                customRow.put("header1", (Field)new TextField(customername + "     " + engineequipmodelname + "     " + devicesname + "    " + version));
                if (contentdetail == null || "".equals(contentdetail)) {
                    customRow.put("header2", (Field)new TextField("ProjectID\uff1a" + projectNumber));
                } else {
                    customRow.put("header2", (Field)new TextField("ProjectID\uff1a" + projectNumber + " for " + contentdetail));
                }
                customRow.put("footer1", (Field)new TextField(obj.getString("contact")));
                customDataRows.add(customRow);
            }
        }
        catch (Exception ex) {
            logger.error("GanttPrintErrorinfo:", (Throwable)ex);
        }
    }
}

