/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt;

import java.security.SecureRandom;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bd.mpdm.common.utils.MMCCommonThreadPoolUtil;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.print.PrintDataProgressFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.url.UrlService;

public class GanttPrintDataProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOG = LogFactory.getLog(PrintDataProgressFormPlugin.class);

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getCurrentAppCache().put("PRINT_PREVIEW_SOTP", (Object)false);
    }

    public void onProgress(ProgressEvent e) {
        try {
            boolean start = this.isStart();
            String taskId = this.getTaskId();
            boolean isPrintstop = (Boolean)this.getCurrentAppCache().get("PRINT_PREVIEW_SOTP", Boolean.TYPE);
            if (isPrintstop) {
                this.stopBar();
                this.closeForm();
                return;
            }
            if (GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "ganttprintloading") == null || !((Boolean)((FormShowParameter)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "ganttprintloading")).getCustomParam("GenPicFinish")).booleanValue()) {
                if (this.getPageCache().get("progresscount") != null) {
                    int n = Integer.parseInt(this.getPageCache().get("progresscount"));
                    if ((n += 2) > 50) {
                        e.setProgress(50);
                        return;
                    }
                    e.setProgress(n);
                    this.getPageCache().put("progresscount", String.valueOf(n));
                } else {
                    this.getPageCache().put("progresscount", "1");
                    e.setProgress(1);
                }
                return;
            }
            FormShowParameter fs = (FormShowParameter)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "ganttprintloading");
            ((FormShowParameter)GanttCacheUtils.getCacheBigObject(this.getView().getPageId(), "ganttprintloading")).setCustomParam("GenPicFinish", (Object)true);
            FormShowParameter loaclshowParaeter = this.getView().getFormShowParameter();
            loaclshowParaeter.getCustomParams().putAll(fs.getCustomParams());
            if (!start && StringUtils.isBlank((CharSequence)taskId)) {
                this.dispatchTask();
                this.getPageCache().put("isstart", String.valueOf(true));
                if (StringUtils.isBlank((CharSequence)taskId)) {
                    double n = new SecureRandom().nextDouble();
                    e.setProgress((int)(50.0 * n) + 50);
                }
                return;
            }
            if (start && StringUtils.isBlank((CharSequence)taskId)) {
                this.stopBar();
                this.closeForm();
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                boolean isFinished = this.isFinished();
                this.setFinished(true);
                if (!isFinished) {
                    e.setProgress(99);
                    return;
                }
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                String taskInfoData = taskInfo.getData();
                if (taskInfoData != null) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)taskInfoData, Map.class);
                    if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
                        this.getView().showErrMessage(taskInfo.getFailureReason(), "");
                        this.stopBar();
                        this.closeForm();
                        return;
                    }
                    Object printTaskId = data.get("taskId");
                    if (printTaskId != null) {
                        LOG.info("PrintTaskid:" + printTaskId);
                        PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)String.valueOf(printTaskId));
                        List attachList = taskResult.getAttach();
                        if (attachList.size() <= 3) {
                            for (PrtTaskResult.Attach attach : attachList) {
                                String attachId = attach.getAttachId();
                                String downloadUrl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
                                downloadUrl = String.format(downloadUrl, printTaskId, attachId);
                                FormShowParameter para = new FormShowParameter();
                                para.setFormId("bos_printpreview");
                                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                HashMap<String, String> reservedSpace = new HashMap<String, String>();
                                reservedSpace.put("reservedSpace", "true");
                                para.getOpenStyle().setCustParam(reservedSpace);
                                para.setCustomParam("src", (Object)downloadUrl);
                                parentView.showForm(para);
                                this.getView().sendFormAction(parentView);
                            }
                        } else {
                            FormShowParameter para = new FormShowParameter();
                            para.setFormId("bos_print_resultview");
                            para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"GanttPrintDataProgressFormPlugin_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                            para.getOpenStyle().setShowType(ShowType.Modal);
                            para.setCustomParam("taskId", printTaskId);
                            parentView.showForm(para);
                            this.getView().sendFormAction(parentView);
                        }
                    }
                    if (!Boolean.parseBoolean((String)data.get("success"))) {
                        String msg = String.valueOf(data.get("error"));
                        if ("tip".equalsIgnoreCase(String.valueOf(data.get("msgType")))) {
                            parentView.showTipNotification(msg);
                        } else {
                            parentView.showErrMessage(msg, "");
                        }
                        this.getView().sendFormAction(parentView);
                    }
                }
                this.stopBar();
                this.closeForm();
                this.getCurrentAppCache().remove("PRINT_PREVIEW_IS_CANCEL");
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                if (progress == 0) {
                    progress = 90;
                }
                e.setProgress(progress);
            }
        }
        catch (Exception exception) {
            this.stopBar();
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            parentView.showErrMessage("Report Error Info:" + exception.getMessage(), "");
            LOG.error((Throwable)exception);
            this.getView().sendFormAction(parentView);
            this.closeForm();
        }
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get("isfinished");
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getCurrentAppCache().put("PRINT_PREVIEW_SOTP", (Object)true);
        Map<String, Object> resultMap = GanttUtils.getReResult("gtCancelPrint");
        resultMap.put("success", Boolean.TRUE);
    }

    private void closeForm() {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            bar.setPercent(progress);
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("print_taskid")) {
            return (String)this.getView().getFormShowParameter().getCustomParam("print_taskid");
        }
        return this.getPageCache().get("print_taskid");
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void dispatchTask() {
        String isStop = (String)this.getCurrentAppCache().get("PRINT_PREVIEW_IS_CANCEL", String.class);
        if (isStop != null && Boolean.parseBoolean(isStop)) {
            this.getCurrentAppCache().remove("PRINT_PREVIEW_IS_CANCEL");
            return;
        }
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u542f\u52a8\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"GanttPrintDataProgressFormPlugin_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            LOG.info("\u53d1\u5e03\u4efb\u52a1\u5931\u8d25\uff0c\u8c03\u7528ScheduleServiceHelper.dispatch\uff0c\u8fd4\u56de\u4e86\u7a7a\u7684\u4efb\u52a1id");
        }
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put("print_taskid", taskId);
    }

    private JobFormInfo buildJobFormInfo() {
        String name = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
        if (name == null) {
            name = "";
        }
        JobInfo jobInfo = new JobInfo();
        FormShowParameter fs = this.getView().getFormShowParameter();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u6253\u5370%s\u3002", (String)"GanttPrintDataProgressFormPlugin_2", (String)"bd-mpdm-gantt", (Object[])new Object[0]), name));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(fs.getServiceAppId());
        jobInfo.setTaskClassname("kd.bos.mvc.print.PrintTask");
        jobInfo.setRunByLang(Lang.get());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parentpageid", fs.getParentPageId());
        params.putAll((Map)fs.getCustomParam("printParam"));
        params.put("fullPath", UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantId()));
        Object lang = params.get("lang");
        if (lang != null) {
            jobInfo.setRunByLang(Lang.from((String)lang.toString()));
        }
        String printTaskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        params.put("printTaskId", printTaskId);
        params.put("entityTypeId", "mpdm_gantt_printstore");
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(fs.getParentPageId());
        jobFormInfo.setRootPageId(fs.getRootPageId());
        jobFormInfo.setTimeout(this.getPrintTimes());
        jobFormInfo.getParams().putAll(fs.getCustomParams());
        if (fs.getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(fs.getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.print.PrintCloseCallBack", "");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.plugin.print.PrintTaskClick");
        return jobFormInfo;
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put("isfinished", String.valueOf(finished));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if ("CLOSE_START".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                bar.stop();
                this.closeForm();
            } else {
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                bar.start();
            }
        } else if ("CLOSE_UNSTART".equals(messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                bar.stop();
                this.closeForm();
            } else {
                this.dispatchTask();
            }
        } else if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            bar.start();
        }
        this.getCurrentAppCache().remove("PRINT_PREVIEW_IS_CANCEL");
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadExecutorService threadExecutorService = MMCCommonThreadPoolUtil.getThreadExecutorService();
            threadExecutorService.execute((Runnable)subscriber, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
        }
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove("print_jobforminfo");
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put("print_jobforminfo", str);
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getView().getFormShowParameter().getCustomParams().containsKey("print_jobforminfo") ? (String)this.getView().getFormShowParameter().getCustomParam("print_jobforminfo") : this.getPageCache().get("print_jobforminfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)this.getView().getFormShowParameter().getFormConfig().getAppId());
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.getCurrentAppCache().put("PRINT_PREVIEW_IS_CANCEL", (Object)"true");
            this.getView().close();
        }
    }

    private int getPrintTimes() {
        int selectRow = (Integer)this.getView().getFormShowParameter().getCustomParam("selectrows");
        if (selectRow <= 120) {
            selectRow = 120;
        }
        return selectRow;
    }
}

