/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;

public class PrintGanttSettingPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String controlKey;
        Control control = (Control)evt.getSource();
        switch (controlKey = control.getKey()) {
            case "btnok": {
                this.saveSetting();
            }
        }
    }

    private void saveSetting() {
        String settingData = this.buildSettingData();
        String realformid = (String)this.getView().getFormShowParameter().getCustomParam("realformid");
        Long userId = RequestContext.get().getCurrUserId();
        String key = realformid + "_printsetting";
        String reset = this.getPageCache().get("reset");
        if (StringUtils.isBlank((CharSequence)settingData) || StringUtils.isNotBlank((CharSequence)reset) && Boolean.parseBoolean(reset)) {
            if (StringUtils.isBlank((CharSequence)settingData)) {
                UserConfigServiceHelper.clearSetting((long)userId, (String)key);
            } else {
                UserConfigServiceHelper.setSetting((long)userId, (String)key, (String)settingData);
            }
        } else {
            UserConfigServiceHelper.setSetting((long)userId, (String)key, (String)settingData);
        }
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        String realformid = (String)this.getView().getFormShowParameter().getCustomParam("realformid");
        Map<String, String> templates = PrintGanttSettingPlugin.getTemplates(formId);
        this.initDefaultCombo("defaulttemplate", templates, false);
        Long userId = RequestContext.get().getCurrUserId();
        String key = realformid + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            this.initSetting(settingData);
        }
    }

    protected Map<String, Object> getPrintSetting() {
        String configKey = "mpdm_gantt_printstore_printsetting";
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            return (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return null;
    }

    private void initDefaultCombo(String controlKey, Map<String, String> templatesMap, boolean notEmpty) {
        String formId;
        String defaulttpId;
        ComboEdit defaultCombo = (ComboEdit)this.getView().getControl(controlKey);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, String> entry : templatesMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        defaultCombo.setComboItems(comboItems);
        if ("defaulttemplate".equals(controlKey) && StringUtils.isNotBlank((CharSequence)(defaulttpId = this.getDefaulttplInManangeTool(formId = (String)this.getView().getFormShowParameter().getCustomParam("formid"))))) {
            this.getModel().setValue("defaulttemplate", (Object)defaulttpId);
        }
    }

    protected String getDefaulttplInManangeTool(String formId) {
        String tplId = null;
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        DynamicObject[] cacheDatas = BusinessDataServiceHelper.load((String)"bas_manageprinttpl", (String)"printtplid.id", (QFilter[])qFilters);
        if (cacheDatas != null) {
            for (DynamicObject cacheData : cacheDatas) {
                String printtplObj = (String)cacheData.get("printtplid_id");
                if (printtplObj == null) continue;
                tplId = printtplObj;
                break;
            }
        }
        return tplId;
    }

    public static Map<String, String> getTemplates(String formId) {
        Map templates = PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(formId);
        return templates;
    }

    private void initSetting(String settingData) {
        Object printerid;
        Object templateid;
        Object radiogroup;
        Object printpage;
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        Object compratio = jsonData.get("compratio");
        if (StringUtils.isNotBlank(compratio)) {
            this.getModel().setValue("compratio", compratio);
        }
        if (StringUtils.isNotBlank(printpage = jsonData.get("printpage"))) {
            this.getModel().setValue("printpage", printpage);
        }
        if (StringUtils.isNotBlank(radiogroup = jsonData.get("radiogroup"))) {
            this.getModel().setValue("radiogroup", radiogroup);
        }
        if (StringUtils.isNotBlank(templateid = jsonData.get("templateid"))) {
            this.getModel().setValue("defaulttemplate", templateid);
        }
        if (StringUtils.isNotBlank(printerid = jsonData.get("printerid"))) {
            this.getModel().setValue("defaultprinter", printerid);
        } else {
            this.getModel().setValue("defaultprinter", null);
        }
    }

    private String buildSettingData() {
        Object pageSeparation;
        Object pageNumType;
        Object vSavePage;
        Object hSavePage;
        Object printpage;
        Object radiogroup;
        Object compratio;
        Object printerObj;
        String defaulttemplate;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        String printLang = (String)this.getModel().getValue("printlang");
        if (StringUtils.isNotBlank((CharSequence)printLang)) {
            data.put("printlang", printLang);
        }
        if (StringUtils.isNotBlank((CharSequence)(defaulttemplate = (String)this.getModel().getValue("defaulttemplate")))) {
            data.put("templateid", defaulttemplate);
        }
        if ((printerObj = this.getModel().getValue("defaultprinter")) != null) {
            data.put("printerid", ((DynamicObject)printerObj).getPkValue());
        }
        if ((compratio = this.getModel().getValue("compratio")) != null) {
            data.put("compratio", compratio);
        }
        if ((radiogroup = this.getModel().getValue("radiogroup")) != null) {
            data.put("radiogroup", radiogroup);
        }
        if ((printpage = this.getModel().getValue("printpage")) != null) {
            data.put("printpage", printpage);
        }
        ArrayList baseEntity = new ArrayList(16);
        int entryRowCount = this.getModel().getEntryRowCount("baseentryentity");
        String reset = this.getPageCache().get("reset");
        for (int i = 0; i < entryRowCount; ++i) {
            String billtypeid = (String)this.getModel().getValue("billtypeid", i);
            String templateid = "";
            if (!"true".equals(reset)) {
                templateid = (String)this.getModel().getValue("templateid", i);
            }
            HashMap<String, String> billtypeprint = new HashMap<String, String>();
            billtypeprint.put("billtypeid", billtypeid);
            billtypeprint.put("templateid", templateid);
            if (!StringUtils.isNotBlank((CharSequence)templateid)) continue;
            baseEntity.add(billtypeprint);
        }
        if (!baseEntity.isEmpty()) {
            data.put("basesetting", baseEntity);
        }
        DynamicObjectCollection objs = this.getModel().getEntryEntity("adventryentity");
        int advSettingCount = this.getModel().getEntryRowCount("adventryentity");
        if (advSettingCount > 0) {
            data.put("complexsetting", objs);
        }
        if (StringUtils.isNotBlank((Object)(hSavePage = this.getModel().getValue("hsavepage")))) {
            data.put("hSavePage", hSavePage);
        }
        if (StringUtils.isNotBlank((Object)(vSavePage = this.getModel().getValue("vsavepage")))) {
            data.put("vSavePage", vSavePage);
        }
        if (StringUtils.isNotBlank((Object)(pageNumType = this.getModel().getValue("pagenumtype")))) {
            data.put("pageNumType", pageNumType);
        }
        if (StringUtils.isNotBlank((Object)(pageSeparation = this.getModel().getValue("pageseparation")))) {
            data.put("pageSeparation", pageSeparation);
        }
        if (data.isEmpty()) {
            return "";
        }
        return SerializationUtils.toJsonString(data);
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }
}

