/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.gantt.enums.GanttAreaTypeEnum;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildPreModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.CollectionUtils;

public class ExpandNodeGtTreeListCommand
extends AbstractGanttCommand {
    @Override
    public void execute(GanttCommandContext ctx) {
        GanttRowDataModel rowModel = GanttUtils.getRowDataModel(ctx.getFilterArg().getFilterDataJson());
        String ganttType = rowModel.getGanttType();
        String objId = rowModel.getObjId();
        String dataListCacheKey = "dataList";
        String taskDataListCacheKey = "taskDataList";
        String unExpandKey = "unExpandIds";
        if (StringUtils.equals((CharSequence)ganttType, (CharSequence)"todo")) {
            dataListCacheKey = "toDoDataList";
            taskDataListCacheKey = "toDoTaskDataList";
            unExpandKey = "toDoUnExpandIds";
        }
        List ganttRowDataModelList = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(ctx.getView().getPageCache(), rowModel.getDataModelType(), dataListCacheKey);
        List ganttTaskModels = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(ctx.getView().getPageCache(), rowModel.getDataModelType(), taskDataListCacheKey);
        for (int i = 0; i < ganttRowDataModelList.size(); ++i) {
            GanttRowDataModel ganttRowDataModel = (GanttRowDataModel)ganttRowDataModelList.get(i);
            if (!StringUtils.equals((CharSequence)ganttRowDataModel.getObjId(), (CharSequence)objId)) continue;
            if (ganttRowDataModel.getIsExpand().booleanValue()) {
                ganttRowDataModel.setIsExpand(Boolean.FALSE);
                ganttRowDataModelList.removeAll(ganttRowDataModel.getChildNodes());
                this.deleteChildNodes(ganttRowDataModel.getChildNodes(), ganttRowDataModelList);
                continue;
            }
            ganttRowDataModel.setIsExpand(Boolean.TRUE);
            List<GanttRowDataModel> childNodes = ganttRowDataModel.getChildNodes();
            if (!CollectionUtils.isEmpty(childNodes)) {
                this.changeChildNodesExpand(childNodes);
            }
            ganttRowDataModelList.addAll(i + 1, childNodes);
        }
        PageCache pageCache = (PageCache)ctx.getPageCache();
        GanttBuildContext ganttBuildContext = (GanttBuildContext)GanttCacheUtils.getCacheBigObjectWithDataModel((IPageCache)pageCache, rowModel.getDataModelType(), "ganttBuildContext");
        GanttBuildPreModel preModel = GanttDealDataUtils.getPreModelByCache(pageCache, rowModel.getDataModelType());
        preModel.setIsExpand(true);
        ganttBuildContext.setPreModel(preModel);
        Map<String, Object> stringObjectMap = GanttDealDataUtils.dealData((List<GanttRowDataModel>)ganttRowDataModelList, (List<GanttTaskModel>)ganttTaskModels, ganttBuildContext, GanttAreaTypeEnum.getByValue(ganttType));
        ArrayList<String> unExpandIds = new ArrayList<String>(10);
        for (GanttRowDataModel ganttRowDataModel : ganttRowDataModelList) {
            List<GanttRowDataModel> childNodes = ganttRowDataModel.getChildNodes();
            if (ganttRowDataModel.getIsExpand().booleanValue() || CollectionUtils.isEmpty(childNodes)) continue;
            unExpandIds.add(ganttRowDataModel.getObjId());
        }
        GanttCacheUtils.cacheBigObjectWithDataModel(ctx.getView().getPageCache(), rowModel.getDataModelType(), unExpandKey, unExpandIds);
        GanttDealDataUtils.dealDataForFornt(ganttRowDataModelList);
        Map<String, Object> reResult = GanttUtils.getReResult("gtRefreshGanttData");
        reResult.put("success", Boolean.TRUE);
        HashMap<String, Object> pageData = new HashMap<String, Object>(3);
        pageData.put("dataList", ganttRowDataModelList);
        pageData.put("taskDataList", ganttTaskModels);
        pageData.putAll(stringObjectMap);
        reResult.put(ganttType, pageData);
        reResult.put("ganttType", ganttType);
        GanttUtils.sendGanttMessage(ctx.getView(), ctx.getFilterArg().getCtlKey(), reResult);
    }

    private void deleteChildNodes(List<GanttRowDataModel> rowDataModels, List<GanttRowDataModel> showList) {
        for (int i = 0; i < rowDataModels.size(); ++i) {
            GanttRowDataModel ganttRowDataModel = rowDataModels.get(i);
            if (ganttRowDataModel.getChildNodes() == null || ganttRowDataModel.getChildNodes().size() <= 0) continue;
            showList.removeAll(ganttRowDataModel.getChildNodes());
            this.deleteChildNodes(ganttRowDataModel.getChildNodes(), showList);
        }
    }

    private void changeChildNodesExpand(List<GanttRowDataModel> rowDataModels) {
        for (int i = 0; i < rowDataModels.size(); ++i) {
            GanttRowDataModel ganttRowDataModel = rowDataModels.get(i);
            ganttRowDataModel.setIsExpand(Boolean.FALSE);
            if (ganttRowDataModel.getChildNodes() == null || ganttRowDataModel.getChildNodes().size() <= 0) continue;
            this.changeChildNodesExpand(ganttRowDataModel.getChildNodes());
        }
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u89e6\u53d1\u6269\u5c55", (String)"ExpandNodeGtTreeListCommand_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }

    @Override
    public String getCommondNumber() {
        return "expandNodeGtTreeList";
    }
}

