/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class PrintPreCommand
extends AbstractGanttCommand {
    @Override
    public void execute(GanttCommandContext ctx) throws KDBizException {
        Object printpl = this.getDefaultPrinterTpl(ctx);
        if (printpl == null) {
            String message = ResManager.loadKDString((String)"\u65e0\u6cd5\u6253\u5370\u9884\u89c8\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"PrintPreCommand_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
            ctx.getView().showErrorNotification(message);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mpdm_gantt_printing");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("ServiceAppId", ctx.getView().getFormShowParameter().getServiceAppId());
        showParameter.getCustomParams().put("entityname", ctx.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        showParameter.getCustomParams().put("GenPicFinish", false);
        showParameter.setShowTitle(false);
        ctx.getPageCache().put("ProgressFormPageId", showParameter.getPageId());
        ctx.getView().showForm(showParameter);
        String pageid = ctx.getView().getPageId();
        List<String> dataModelTypeList = GanttDataUtils.getDataModelTypeList(pageid);
        Map<String, String> modelTypeToCtrlMap = GanttDataUtils.getModelTypeToCtrlMap(pageid);
        IFormView formview = SessionManager.getCurrent().getView(pageid);
        for (String dataModelType : dataModelTypeList) {
            String ganttCtl = modelTypeToCtrlMap.get(dataModelType);
            Map<String, Object> resultMap = GanttUtils.getReResult("gtPrintType");
            resultMap.put("success", Boolean.TRUE);
            GanttUtils.sendGanttMessage(formview, ganttCtl, resultMap);
        }
        formview.getPageCache().put("preAction", "printpre");
    }

    protected Object getDefaultPrinterTpl(GanttCommandContext ctx) {
        Map<String, Object> printSetting = this.getPrintSetting(ctx);
        return printSetting.get("templateid");
    }

    protected Map<String, Object> getPrintSetting(GanttCommandContext ctx) {
        ListView listview = (ListView)ctx.getView();
        String billformid = listview.getBillFormId();
        String configKey = billformid + "_printsetting";
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            return (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public String getCommondNumber() {
        return "printset";
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8", (String)"PrintPreCommand_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }
}

