/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class PrintTaskCommand
extends AbstractGanttCommand {
    @Override
    public void execute(GanttCommandContext ctx) {
        List<String> dataModelTypeList = GanttDataUtils.getDataModelTypeList(ctx.getPageCache().getPageId());
        Map<String, String> modelTypeToCtrlMap = GanttDataUtils.getModelTypeToCtrlMap(ctx.getPageCache().getPageId());
        Object printer = this.getDefaultPrinter(ctx);
        if (printer == null) {
            String message = ResManager.loadKDString((String)"\u8bf7\u5728\u6253\u5370\u8bbe\u7f6e\u4e2d\u8bbe\u7f6e\u9ed8\u8ba4\u6253\u5370\u673a\uff0c\u5373\u53ef\u76f4\u63a5\u6253\u5370\u3002", (String)"PrintTaskCommand_5", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
            ctx.getView().showErrorNotification(message);
            return;
        }
        for (String dataModelType : dataModelTypeList) {
            String ganttCtl = modelTypeToCtrlMap.get(dataModelType);
            Map<String, Object> resultMap = GanttUtils.getReResult("gtPrintType");
            resultMap.put("success", Boolean.TRUE);
            GanttUtils.sendGanttMessage(ctx.getView(), ganttCtl, resultMap);
        }
        ctx.getPageCache().put("preAction", "print");
    }

    protected Object getDefaultPrinter(GanttCommandContext ctx) {
        Map<String, Object> printSetting = this.getPrintSetting(ctx);
        return printSetting.get("printerid");
    }

    protected Map<String, Object> getPrintSetting(GanttCommandContext ctx) {
        ListView listview = (ListView)ctx.getView();
        String billformid = listview.getBillFormId();
        String configKey = billformid + "_printsetting";
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            return (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u6253\u5370", (String)"PrintTaskCommand_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }

    @Override
    public String getCommondNumber() {
        return "print";
    }
}

