/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLogModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SelectNodeGtTreeListCommand
extends AbstractGanttCommand {
    private static Log logger = LogFactory.getLog(SelectNodeGtTreeListCommand.class);
    private static String ITEM = "item";
    private static String ISSELECT = "isSelect";

    @Override
    public void execute(GanttCommandContext ctx) {
        GanttRowDataModel rowModel = GanttUtils.getRowDataModel(ctx.getFilterArg().getFilterDataJson());
        String ganttType = rowModel.getGanttType();
        Map<String, Object> reResult = GanttUtils.getReResult("gtRefreshSelectNode");
        reResult.put("id", rowModel.getId());
        reResult.put("success", Boolean.TRUE);
        String objId = rowModel.getObjId();
        String cacheKey = "dataList";
        String selectCacheKey = "selectDataListId";
        if ("todo".equals(ganttType)) {
            cacheKey = "toDoDataList";
            selectCacheKey = "toDoSelectDataListId";
        }
        this.ganttLogModel = new GanttLogModel(rowModel.getEntityFlag(), rowModel.getNumber(), null, null);
        try {
            List ganttRowDataModelList = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(ctx.getView().getPageCache(), rowModel.getDataModelType(), cacheKey);
            for (GanttRowDataModel ganttRowDataModel2 : ganttRowDataModelList) {
                if (!StringUtils.equals((CharSequence)ganttRowDataModel2.getObjId(), (CharSequence)objId)) continue;
                ganttRowDataModel2.setIsSelect(ganttRowDataModel2.getIsSelect() == false);
                rowModel = ganttRowDataModel2;
                break;
            }
            GanttCacheUtils.cacheBigObjectWithDataModel(ctx.getView().getPageCache(), rowModel.getDataModelType(), cacheKey, ganttRowDataModelList);
            rowModel.setChildNodes(null);
            reResult.put(ITEM, rowModel);
            List selectIds = ganttRowDataModelList.stream().filter(ganttRowDataModel -> ganttRowDataModel.getIsSelect()).map(ganttRowDataModel -> ganttRowDataModel.getObjId()).collect(Collectors.toList());
            GanttCacheUtils.cacheBigObjectWithDataModel(ctx.getView().getPageCache(), rowModel.getDataModelType(), selectCacheKey, selectIds);
            reResult.put(ISSELECT, rowModel.getIsSelect());
            reResult.put("ganttType", ganttType);
        }
        catch (Exception e) {
            reResult.put("success", Boolean.FALSE);
            reResult.put(ISSELECT, Boolean.FALSE);
            List selectIds = (List)GanttCacheUtils.getCacheBigObjectWithDataModel(ctx.getView().getPageCache(), rowModel.getDataModelType(), selectCacheKey);
            if (selectIds.contains(objId)) {
                reResult.put(ISSELECT, Boolean.TRUE);
            }
            ctx.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u590d\u9009\u6846\u5931\u8d25\u3002", (String)"SelectNodeGtTreeListCommand_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            logger.error("\u7518\u7279\u56fe\u9009\u4e2d\u590d\u9009\u6846\u62a5\u9519", (Throwable)e);
            this.errorMsg = e.getMessage();
        }
        GanttUtils.sendGanttMessage(ctx.getView(), ctx.getFilterArg().getCtlKey(), reResult);
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u9009\u62e9\u590d\u9009\u6846", (String)"SelectNodeGtTreeListCommand_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }

    @Override
    public String getCommondNumber() {
        return "selectNodeGtTreeList";
    }
}

