/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttImageCutterUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class SendPrintInfokCommand
extends AbstractGanttCommand {
    private static final Log logger = LogFactory.getLog(SendPrintInfokCommand.class);

    @Override
    public void execute(GanttCommandContext ctx) throws KDBizException {
        logger.info("SendPrintInfokCommand:Print picture transfer to background ,start ......");
        String args = ctx.geteArgs();
        String progressPageid = ctx.getPageCache().get("ProgressFormPageId");
        IFormView formview = ctx.getView().getView(progressPageid);
        FormShowParameter showParameter = null;
        JSONObject resultObj = JSONObject.parseObject((String)args);
        if (formview != null) {
            showParameter = ctx.getView().getView(progressPageid).getFormShowParameter();
            IAppCache cache = AppCache.get((String)formview.getFormShowParameter().getFormConfig().getAppId());
            boolean status = resultObj.getBoolean("status");
            if (!status) {
                cache.put("PRINT_PREVIEW_IS_CANCEL", (Object)true);
                formview.close();
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u56fe\u7247\u5931\u8d25", (String)"SendPrintInfokCommand_7", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            }
            cache.put("PRINT_PREVIEW_IS_CANCEL", (Object)false);
        }
        String url = resultObj.getString("url");
        String realUrl = FileServiceFactory.getImageFileService().getFileServiceExt().getRealPath(url);
        logger.info("\u81ea\u5b9a\u4e49\u63a7\u4ef6\u4e0a\u4f20\u7684\u7518\u7279\u56fe\u56fe\u7247url:" + realUrl);
        String pageid = ctx.getView().getPageId();
        Map<String, Object> printSet = this.getPrintSetting(ctx);
        FileService service = FileServiceFactory.getImageFileService();
        logger.info("\u81ea\u5b9a\u4e49\u63a7\u4ef6\u4e0a\u4f20\u7684\u7518\u7279\u56fe\u56fe\u7247\u662f\u5426\u5b58\u5728:" + service.exists(realUrl));
        InputStream in = service.getInputStream(realUrl);
        BigDecimal zoomRatio = (BigDecimal)printSet.get("compratio");
        Integer printpage = (Integer)printSet.get("printpage");
        String radiogroup = (String)printSet.get("radiogroup");
        ListView listview = (ListView)ctx.getView();
        String billformid = listview.getBillFormId();
        String pkList = null;
        try {
            logger.info("SendPrintInfokCommand:Cut Picture ,start ......");
            pkList = GanttImageCutterUtil.base64CodeToBeImage(billformid, pageid, in, "", zoomRatio, printpage, radiogroup);
            logger.info("SendPrintInfokCommand:Cut Picture ,end ......");
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        QFilter filter = new QFilter("batchid", "=", (Object)Long.parseLong(pkList));
        String preAction = ctx.getPageCache().get("preAction");
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"mpdm_gantt_printstore", (String)"id", (QFilter[])new QFilter[]{filter});
        ArrayList<Object> resultobjs = new ArrayList<Object>(objs.length);
        for (DynamicObject obj : objs) {
            resultobjs.add(obj.getPkValue());
        }
        if ("printpre".equals(preAction)) {
            List<PrintJob> jobs = this.buildPrintJobsForPC(resultobjs, ctx);
            if (showParameter != null) {
                this.showProgressForm(showParameter, ctx, jobs, "", resultobjs, resultobjs.size());
            }
            GanttCacheUtils.cacheBigObject(progressPageid, "ganttprintloading", showParameter);
        } else {
            this.directPrint(resultobjs, ctx);
        }
        logger.info("SendPrintInfokCommand:Print picture transfer to background ,end ......");
    }

    private void directPrint(List<Object> resultobjs, GanttCommandContext ctx) {
        Lang curLang = RequestContext.get().getLang();
        String printLangStr = (String)this.getPrintSetting(ctx).get("printlang");
        if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
            RequestContext.get().setLang(Lang.from((String)printLangStr));
        }
        try {
            List<PrintJob> oldPrintJobs;
            boolean printResult = true;
            OperationResult result = new OperationResult();
            String message = "";
            List<PrintJob> printJobs = this.buildPrintJobsForPC(resultobjs, ctx);
            Map<String, List<PrintJob>> classifyPrintJob = this.classifyPrintJob(printJobs);
            if (printJobs == null || printJobs.isEmpty()) {
                result.setSuccess(false);
                message = ResManager.loadKDString((String)"\u65e0\u53ef\u6253\u5370\u6570\u636e\u3002", (String)"SendPrintInfokCommand_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
                result.setMessage(message);
            }
            List<PrintJob> newPrintJobs = classifyPrintJob.get("newPrintJobs");
            NotePrintService printSvr = new NotePrintService();
            if (newPrintJobs != null && newPrintJobs.size() > 0) {
                PrtAttach.AttachDetail attach;
                ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
                for (PrintJob job : newPrintJobs) {
                    PrintTask task = new PrintTask();
                    task.setPkIds(job.getBillIds());
                    task.setFormId(job.getFormId());
                    task.setPageId(job.getPageId());
                    task.setTplId(String.valueOf(job.getTemplateId()));
                    task.setPrintType("billForm");
                    taskList.add(task);
                }
                String lang = curLang.toString();
                if (StringUtils.isNotBlank((CharSequence)printLangStr)) {
                    lang = printLangStr;
                }
                PrintWork work = new PrintWork();
                work.setPageId(((PrintTask)taskList.get(0)).getPageId());
                work.setPrintLang(lang);
                work.setExpType("pdf");
                work.setTaskList(taskList);
                String printid = String.valueOf(this.getDefaultPrinter(ctx));
                PrtAttach prtattach = BosPrintServiceHelper.doPrintDirect((String)printid, (PrintWork)work);
                List details = prtattach.getAttachDetail();
                Iterator iterator = details.iterator();
                while (iterator.hasNext() && (printResult = printSvr.createPrintJob((attach = (PrtAttach.AttachDetail)iterator.next()).getAttachId(), attach.getAttachId(), attach.getFilePath(), new LocaleString(attach.getFileName()), this.getDefaultPrinter(ctx)))) {
                }
            }
            if (printResult && (oldPrintJobs = classifyPrintJob.get("oldPrintJobs")) != null && oldPrintJobs.size() > 0) {
                String id = MetadataDao.getIdByNumber((String)"mpdm_gantt_printstore", (MetaCategory)MetaCategory.Form);
                FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
                LocaleString name = formMeta.getName();
                printResult = printSvr.createPrintJob(name, oldPrintJobs);
                result.setSuccess(printResult);
            }
            if (printResult) {
                message = ResManager.loadKDString((String)"\u6253\u5370\u4efb\u52a1\u5df2\u53d1\u9001\u81f3\u6253\u5370\u673a\uff0c\u8bf7\u524d\u5f80\u6253\u5370\u673a\u6253\u5370\u3002", (String)"SendPrintInfokCommand_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
                ctx.getView().showSuccessNotification(message);
            } else {
                ctx.getView().showErrorNotification(message);
            }
        }
        catch (Exception e) {
            ctx.getView().showErrorNotification(e.getMessage());
        }
    }

    protected Object getDefaultPrinter(GanttCommandContext ctx) {
        Map<String, Object> printSetting = this.getPrintSetting(ctx);
        return printSetting.get("printerid");
    }

    protected Map<String, Object> getPrintSetting(GanttCommandContext ctx) {
        ListView listview = (ListView)ctx.getView();
        String billformid = listview.getBillFormId();
        String configKey = billformid + "_printsetting";
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            return (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return null;
    }

    private void showProgressForm(FormShowParameter showParameter, GanttCommandContext ctx, List<PrintJob> printjobs, String printdataprovidertype, List<Object> pkids, int selectRows) {
        String defaultTempId;
        String printLangStr = (String)this.getPrintSetting(ctx).get("printlang");
        if (StringUtils.isBlank((CharSequence)printLangStr)) {
            printLangStr = RequestContext.get().getLang().toString();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lang", printLangStr);
        param.put("printdataprovidertype", printdataprovidertype);
        param.put("pageid", ctx.getView().getPageId());
        param.put("formid", "mpdm_gantt_printstore");
        param.put("defaulttemplateid", this.getPrintSetting(ctx).get("templateid"));
        param.put("pkids", pkids);
        if (printjobs != null && !printjobs.isEmpty()) {
            List<PrintJob> newPrintJobs;
            Map<String, List<PrintJob>> classifyPrintJob = this.classifyPrintJob(printjobs);
            List<PrintJob> oldPrintJobs = classifyPrintJob.get("oldPrintJobs");
            if (!oldPrintJobs.isEmpty()) {
                this.sortJobBillId(oldPrintJobs, pkids);
                param.put("oldPrintJobs", SerializationUtils.toJsonString(oldPrintJobs));
            }
            if (!(newPrintJobs = classifyPrintJob.get("newPrintJobs")).isEmpty()) {
                this.sortJobBillId(newPrintJobs, pkids);
                param.put("newPrintJobs", SerializationUtils.toJsonString(newPrintJobs));
            }
        }
        if (this.isNewTpl(defaultTempId = String.valueOf(this.getPrintSetting(ctx).get("defaulttemplateid")))) {
            param.put("newDefaultTplId", defaultTempId);
        } else {
            param.put("oldDefaultTplId", defaultTempId);
        }
        showParameter.getCustomParams().put("GenPicFinish", true);
        showParameter.getCustomParams().put("printParam", param);
        showParameter.getCustomParams().put("selectrows", selectRows);
    }

    private boolean isNewTpl(String tplId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "=", (Object)tplId)});
        if (dynamicObject == null) {
            return false;
        }
        String type = dynamicObject.getString("type");
        return "B".equals(type);
    }

    private void sortJobBillId(List<PrintJob> jobs, final List<Object> sortRegulation) {
        if (jobs == null || jobs.isEmpty()) {
            return;
        }
        if (sortRegulation != null && !sortRegulation.isEmpty()) {
            for (PrintJob job : jobs) {
                List billIds = job.getBillIds();
                if (billIds == null || billIds.isEmpty()) continue;
                Collections.sort(billIds, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int one = sortRegulation.indexOf(o1);
                        int two = sortRegulation.indexOf(o2);
                        return one - two;
                    }
                });
            }
        }
    }

    protected Map<String, List<PrintJob>> classifyPrintJob(List<PrintJob> printJobs) {
        List tplIds = printJobs.stream().map(item -> item.getTemplateId()).collect(Collectors.toList());
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "in", tplIds)});
        HashMap<String, String> config = new HashMap<String, String>(16);
        for (DynamicObject obj : dynamicObjectMap.values()) {
            String type = obj.getString("type");
            String tplId = obj.getString("printtplid_id");
            config.put(tplId, type);
        }
        ArrayList<PrintJob> oldPrintJobs = new ArrayList<PrintJob>();
        ArrayList<PrintJob> newPrintJobs = new ArrayList<PrintJob>();
        for (PrintJob job : printJobs) {
            String type = (String)config.get(job.getTemplateId());
            if ("B".equals(type)) {
                newPrintJobs.add(job);
                continue;
            }
            oldPrintJobs.add(job);
        }
        HashMap<String, List<PrintJob>> result = new HashMap<String, List<PrintJob>>();
        result.put("oldPrintJobs", oldPrintJobs);
        result.put("newPrintJobs", newPrintJobs);
        return result;
    }

    private List<PrintJob> buildPrintJobsForPC(List<Object> pkids, GanttCommandContext ctx) {
        StringBuilder errorCommandMsg = new StringBuilder();
        ArrayList<PrintJob> pcJobs = new ArrayList<PrintJob>();
        Map<String, Object> printSetting = this.getPrintSetting(ctx);
        Object defaultPrinter = printSetting.get("printerid");
        Object defaultTemplateId = printSetting.get("templateid");
        Object defaultTemplate = printSetting.get("template");
        Object selectTpl = printSetting.get("selecttpl");
        if (StringUtils.isBlank((Object)defaultTemplateId)) {
            if (StringUtils.isBlank((Object)defaultTemplate)) {
                defaultTemplate = selectTpl;
            }
            if (StringUtils.isNotBlank((Object)defaultTemplate)) {
                String templateId = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
                defaultTemplateId = templateId;
            }
        }
        if (StringUtils.isNotBlank((Object)defaultTemplateId)) {
            int result = this.getTtplInManangeToolisenable((String)defaultTemplateId);
            if (result == 1) {
                String caption = ctx.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
                PrintJob jb = new PrintJob(ctx.getView().getPageId(), "mpdm_gantt_printstore");
                jb.setBillIds(pkids);
                jb.setPrinterId(defaultPrinter);
                jb.setTemplateId(defaultTemplateId);
                jb.setName(caption);
                pcJobs.add(jb);
            } else if (result == 0) {
                if (errorCommandMsg.length() == 0) {
                    errorCommandMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u524d\u5f80\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"SendPrintInfokCommand_3", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                }
            } else if (3 == result) {
                errorCommandMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u65e0\u6743\u9650\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"SendPrintInfokCommand_4", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            } else if (errorCommandMsg.length() == 0) {
                errorCommandMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u7981\u7528\uff0c\u8bf7\u524d\u5f80\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"SendPrintInfokCommand_5", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            }
        }
        return pcJobs;
    }

    protected int getTtplInManangeToolisenable(String tplId) {
        String enable;
        int result = 0;
        QFilter[] qFilters = new QFilter[]{new QFilter("printtplid.id", "=", (Object)tplId)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)"bas_manageprinttpl", (String)"enable", (QFilter[])qFilters);
        if (defaultObj != null && ((enable = (String)defaultObj.get("enable")).equals("1") || enable.equals(""))) {
            boolean havePerm;
            result = 1;
            if (ParamUtils.isTemplateOrgIsolated() && !(havePerm = PrintTemplateServiceFactory.getService().checkUserHaveTemplate("mpdm_gantt_printstore", tplId))) {
                result = 3;
                result = 2;
            }
        }
        return result;
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        return operateOption;
    }

    @Override
    public String getCommondNumber() {
        return "sendPrintInfo";
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u6253\u5370\u8fd4\u56de\u56fe\u7247", (String)"SendPrintInfokCommand_6", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }
}

