/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttevent.itf.IGanttCommandClosedCallBack;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttGlobalModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttUserConfigUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.mvc.list.ListView;

public class ShowSetCommand
extends AbstractGanttCommand
implements IGanttCommandClosedCallBack {
    @Override
    public void execute(GanttCommandContext ctx) {
        IFormView view = ctx.getView();
        String billEntityId = ((ListView)view).getListModel().getEntityId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mpdm_gantt_showsett");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(ctx.getPlugin(), "showset"));
        showParameter.setCustomParam("billEntityId", (Object)billEntityId);
        view.showForm(showParameter);
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u663e\u793a\u8bbe\u7f6e", (String)"ShowSetCommand_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }

    @Override
    public String getCommondNumber() {
        return "tbllog";
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IFormView view = closedCallBackEvent.getView();
        IDataModel model = view.getModel();
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.nonNull(returnData)) {
            Map returnMap = (Map)returnData;
            GanttPageShowModel pageShowModel = (GanttPageShowModel)returnMap.get("pageShowSet");
            GanttPageShowModel orginPageShowSet = GanttUserConfigUtils.getPageShowSet((ListView)view);
            if (Objects.isNull(pageShowModel)) {
                pageShowModel = orginPageShowSet;
            }
            boolean lineChange = orginPageShowSet.getIsLineShow().equals(pageShowModel.getIsLineShow());
            boolean verticalChange = orginPageShowSet.getIsVerticalMode().equals(pageShowModel.getIsVerticalMode());
            boolean normalChange = orginPageShowSet.getNormalBarsShow().equals(pageShowModel.getNormalBarsShow());
            boolean emptyChange = orginPageShowSet.getEmptyBarsShow().equals(pageShowModel.getEmptyBarsShow());
            boolean showRiskChange = orginPageShowSet.getShowRisk() == pageShowModel.getShowRisk();
            boolean borderChange = orginPageShowSet.getNoTaskBorderRadiusShow().equals(pageShowModel.getNoTaskBorderRadiusShow());
            boolean showPercentValue = orginPageShowSet.getShowPercentValue().equals(pageShowModel.getShowPercentValue());
            boolean projectTimeShowValue = orginPageShowSet.getProjectTimeShow().equals(pageShowModel.getProjectTimeShow());
            boolean borderShowValue = orginPageShowSet.getIsTaskBorderShow().equals(pageShowModel.getIsTaskBorderShow());
            boolean weekCodeModeValue = orginPageShowSet.getIsWeekCodeMode().equals(pageShowModel.getIsWeekCodeMode());
            boolean rankModeValue = orginPageShowSet.getIsRankMode().equals(pageShowModel.getIsRankMode());
            boolean showIndexChange = orginPageShowSet.getShowIndex().equals(pageShowModel.getShowIndex());
            boolean checkBoxChange = orginPageShowSet.getIsRowCheckBoxShow().equals(pageShowModel.getIsRowCheckBoxShow());
            boolean groupColorChange = orginPageShowSet.getApplyGroupColor().equals(pageShowModel.getApplyGroupColor());
            boolean weekedBgChange = orginPageShowSet.getWeekedBgShow().equals(pageShowModel.getWeekedBgShow());
            if (lineChange && verticalChange && normalChange && emptyChange && showRiskChange && borderChange && showPercentValue && projectTimeShowValue && borderShowValue && weekCodeModeValue && rankModeValue && showIndexChange && checkBoxChange && groupColorChange && weekedBgChange) {
                return;
            }
            if (weekCodeModeValue || rankModeValue) {
                pageShowModel.setTimelineRows(2);
                pageShowModel.setTimelineShowRows(2);
                if (pageShowModel.getIsRankMode().booleanValue() || pageShowModel.getIsWeekCodeMode().booleanValue()) {
                    pageShowModel.setTimelineRows(3);
                    if (StringUtils.equals((CharSequence)"day", (CharSequence)pageShowModel.getCellUnitType())) {
                        pageShowModel.setTimelineShowRows(3);
                    }
                }
            }
            GanttUserConfigUtils.setConfig((ListView)view, pageShowModel);
            GanttCacheUtils.cacheBigObject(view.getPageId(), "pageShowSet", pageShowModel);
            String pageId = view.getPageId();
            List<String> dataModelTypeList = GanttDataUtils.getDataModelTypeList(pageId);
            Map<String, String> modelTypeToCtrlMap = GanttDataUtils.getModelTypeToCtrlMap(pageId);
            for (String dataModelType : dataModelTypeList) {
                String ganttCtl = modelTypeToCtrlMap.get(dataModelType);
                Map<String, Object> resultMap = GanttUtils.getReResult("gtRefreshViewSchem");
                resultMap.put("success", Boolean.TRUE);
                resultMap.put("viewSchem", pageShowModel);
                GanttViewSchemModel viewSchemModel = (GanttViewSchemModel)GanttCacheUtils.getCacheBigObjectWithDataModel(view.getPageCache(), dataModelType, "viewSchem");
                GanttGlobalModel globalModel = (GanttGlobalModel)GanttCacheUtils.getCacheBigObjectWithDataModel(view.getPageCache(), dataModelType, "model");
                GanttDataUtils.copyProperties(viewSchemModel, pageShowModel);
                globalModel.setViewSchem(viewSchemModel);
                GanttCacheUtils.cacheBigObjectWithDataModel(view.getPageCache(), dataModelType, "model", globalModel);
                GanttCacheUtils.cacheBigObjectWithDataModel(view.getPageCache(), dataModelType, "viewSchem", viewSchemModel);
                if (!verticalChange || !showRiskChange || !showPercentValue || !projectTimeShowValue || !showIndexChange || !groupColorChange) continue;
                GanttUtils.sendGanttMessage(view, ganttCtl, resultMap);
            }
            model.setValue("showrisk", (Object)pageShowModel.getShowRisk());
            model.setValue("showpercentvalue", (Object)pageShowModel.getShowPercentValue());
            model.setValue("projecttimeshow", (Object)pageShowModel.getProjectTimeShow());
            if (verticalChange && showRiskChange && showPercentValue && projectTimeShowValue && showIndexChange && groupColorChange) {
                return;
            }
            if (!verticalChange) {
                model.setValue("verticalshow", (Object)pageShowModel.getIsVerticalMode());
                return;
            }
            if (!(verticalChange && showRiskChange && showPercentValue && projectTimeShowValue && showIndexChange && groupColorChange)) {
                GanttUtils.ganttRefresh(view);
            }
        }
    }
}

