/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import java.math.BigDecimal;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCustomSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.list.ListShowParameter;

public class TimeLineShowWayCommand
extends AbstractGanttCommand {
    @Override
    public void execute(GanttCommandContext ctx) throws KDBizException {
        ListShowParameter formShowParameter = (ListShowParameter)ctx.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        String className = GanttCustomSingleton.getSingleInstance().getTimeLineWayCommand(billFormId);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            Object classInstance = TypesContainer.createInstance((String)className);
            if (classInstance instanceof AbstractGanttCommand) {
                AbstractGanttCommand command = (AbstractGanttCommand)classInstance;
                command.execute(ctx);
            }
        } else {
            Boolean verticalShow = (Boolean)ctx.getView().getModel().getValue("verticalshow");
            GanttPageShowModel ganttPageShowModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(ctx.getView().getPageId(), "pageShowSet");
            String cellUnitTypeCache = ganttPageShowModel.getCellUnitType();
            ctx.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_scale500", "bar_scale400", "bar_scale300", "bar_scale200", "bar_scale150", "bar_scale120", "bar_scale100", "bar_scale90", "bar_scale80", "bar_scale70", "bar_scale60", "bar_scale50", "bar_scale40", "bar_scale30"});
            String scale = "1";
            if (verticalShow.booleanValue()) {
                scale = "0.5";
                ctx.getView().setEnable(Boolean.FALSE, new String[]{"bar_scale50"});
            } else {
                ctx.getView().setEnable(Boolean.FALSE, new String[]{"bar_scale100"});
            }
            GanttCommandUtils.changeScaleOrUnit(ctx, cellUnitTypeCache, scale);
            GanttCommandUtils.updataShowScale(ctx.getView(), new BigDecimal(scale).multiply(new BigDecimal("100")).intValue());
        }
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u65f6\u95f4\u8f74\u6587\u5b57\u663e\u793a\u65b9\u5411\u5df2\u8c03\u6574\u4e3a\u53f3\u5bf9\u9f50\u3002", (String)"TimeLineShowWayCommand_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }

    @Override
    public String getCommondNumber() {
        return "verticalshow";
    }
}

