/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.command;

import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCustomSingleton;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttPageShowModel;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.list.ListShowParameter;

public class TimeScaleCommand
extends AbstractGanttCommand {
    @Override
    public void execute(GanttCommandContext ctx) throws KDBizException {
        ListShowParameter formShowParameter = (ListShowParameter)ctx.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        String className = GanttCustomSingleton.getSingleInstance().getTimeScaleCommand(billFormId);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            Object classInstance = TypesContainer.createInstance((String)className);
            if (classInstance instanceof AbstractGanttCommand) {
                AbstractGanttCommand command = (AbstractGanttCommand)classInstance;
                command.execute(ctx);
            }
        } else {
            String commandName = ctx.getCommandName();
            String cellUnitType = commandName.substring(10);
            GanttPageShowModel ganttPageShowModel = (GanttPageShowModel)GanttCacheUtils.getCacheBigObject(ctx.getView().getPageId(), "pageShowSet");
            String cellUnitTypeCache = ganttPageShowModel.getCellUnitType();
            String scaleCache = ganttPageShowModel.getCellScale().toString();
            if (cellUnitType.equals(cellUnitTypeCache)) {
                return;
            }
            GanttCommandUtils.changeScaleOrUnit(ctx, cellUnitType, scaleCache);
            ctx.getView().setEnable(Boolean.TRUE, new String[]{"bar_dependmonth", "bar_dependweek", "bar_dependday", "bar_dependhour"});
            ctx.getView().setEnable(Boolean.FALSE, new String[]{commandName});
            GanttCommandUtils.updataTimeScale(ctx.getView(), commandName);
        }
    }

    @Override
    public String getCommondName() {
        return ResManager.loadKDString((String)"\u65f6\u95f4\u6807\u5c3a", (String)"TimeScaleCommand_4", (String)"bd-mpdm-gantt", (Object[])new Object[0]);
    }

    @Override
    public String getCommondNumber() {
        return "timescale";
    }
}

