/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.version;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLogModel;
import kd.bd.mpdm.common.gantt.util.GanttLogUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class VersionListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String versionType = (String)showParameter.getCustomParam("versionType");
        if (StringUtils.equals((CharSequence)versionType, (CharSequence)"resource_history_S")) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5386\u53f2\u7248\u672c", (String)"VersionListPlugin_3", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)versionType, (CharSequence)"resource_simu_S")) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u6a21\u62df\u7248\u672c", (String)"VersionListPlugin_4", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
        String deleteVesion = (String)showParameter.getCustomParam("deleteVesion");
        String entityCond = (String)showParameter.getCustomParam("entityCond");
        if (StringUtils.equals((CharSequence)deleteVesion, (CharSequence)"true") && StringUtils.equals((CharSequence)entityCond, (CharSequence)"pmpd_resourceplan")) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u7248\u672c", (String)"VersionListPlugin_2", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object deleteVesion = this.getView().getFormShowParameter().getCustomParam("deleteVesion");
        if (deleteVesion == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbldelversion"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String entityCond = (String)this.getView().getFormShowParameter().getCustomParam("entityCond");
        String versionType = (String)this.getView().getFormShowParameter().getCustomParam("versionType");
        if (StringUtils.isNotBlank((CharSequence)entityCond)) {
            e.getQFilters().add(new QFilter("versionType.orgpage.number", "ftlike", (Object)entityCond));
        }
        if (StringUtils.isNotBlank((CharSequence)versionType)) {
            e.getQFilters().add(new QFilter("versionType.number", "=", (Object)versionType));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object openByF7 = this.getView().getFormShowParameter().getCustomParam("openByF7");
        if (Objects.nonNull(openByF7)) {
            return;
        }
        BillList rowData = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currSelectRow = rowData.getCurrentSelectedRowInfo();
        Long versionId = (Long)currSelectRow.getPrimaryKeyValue();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mpdm_gantt_version", (String)"id , versionType.versionpage.number page", (QFilter[])new QFilter("id", "=", (Object)versionId).toArray());
        String versionPage = dynamicObject.getString("page");
        if (StringUtils.isBlank((CharSequence)versionPage)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u7248\u672c\u7c7b\u578b\u914d\u7f6e\u4e2d\u914d\u7f6e\u201c\u9875\u9762\u201d\u3002", (String)"VersionListPlugin_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)versionPage, (boolean)false, (int)0, (boolean)false);
        showParameter.setCustomParam("versionId", (Object)Long.toString(versionId));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        BillList grid = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = grid.getSelectedRows();
        if ("deleteversion".equals(operateKey)) {
            String deleteSure = this.getPageCache().get("deleteSure");
            if (StringUtils.isBlank((CharSequence)deleteSure)) {
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                String versionNumber = listSelectedRow.getNumber();
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteVersionConfirm");
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664 %s \u7248\u672c\u7684\u6570\u636e\uff1f\u5220\u9664\u540e\u65e0\u6cd5\u6062\u590d\u3002", (String)"VersionListPlugin_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]), versionNumber), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            } else {
                this.getPageCache().put("deleteSure", null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("deleteversion".equals(operateKey)) {
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
            String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("billFormTag");
            String entityCond = (String)this.getView().getFormShowParameter().getCustomParam("entityCond");
            if (StringUtils.isBlank((CharSequence)billFormId)) {
                if (StringUtils.equals((CharSequence)"pmpd_resourceplan", (CharSequence)entityCond)) {
                    billFormId = "pmpd_resourceplan_bench";
                } else {
                    return;
                }
            }
            ValidateResultCollection validateResult = args.getOperationResult().getValidateResult();
            Collection values = args.getOperationResult().getBillNos().values();
            String billNo = null;
            if (!CollectionUtils.isEmpty(values)) {
                billNo = String.join((CharSequence)",", values);
            }
            GanttLogModel ganttLogModel = new GanttLogModel("mpdm_gantt_version", billNo, null, null);
            ganttLogModel.setBillFormId(billFormId);
            ganttLogModel.setNumber("deleteversion");
            ganttLogModel.setName(ResManager.loadKDString((String)"\u5220\u9664\u7248\u672c", (String)"VersionListPlugin_2", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            if (!validateResult.isSuccess()) {
                ganttLogModel.setResult("0");
                StringBuilder stringBuilder = new StringBuilder();
                List validateErrors = validateResult.getValidateErrors();
                for (ValidateResult validateError : validateErrors) {
                    List allErrorInfo = validateError.getAllErrorInfo();
                    for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                        stringBuilder.append(operateErrorInfo.getMessage());
                        stringBuilder.append("\r\n");
                    }
                }
                ganttLogModel.setFailCause(stringBuilder.toString());
            }
            GanttLogUtils.saveLog(ganttLogModel);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("deleteVersionConfirm".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.getPageCache().put("deleteSure", "true");
            this.getView().invokeOperation("deleteversion");
        }
    }
}

