/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.gantt.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class VersionTypeListPlugin
extends AbstractListPlugin {
    private static final String BTN_DEFAULT = "setdefault";
    private static final String BTN_AUDIT = "audit";
    private static final String BTN_ENABLE = "enable";
    private static final String ISDEFAULTID = "isDefaultId";
    private static final String NEEDCHANGEENTITY = "needChangeEntity";
    private static final String DEFAULT = "default";

    public void initialize() {
        Long orgId = RequestContext.get().getOrgId();
        this.getPageCache().put("createOrg", String.valueOf(orgId));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        BillList grid = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = grid.getSelectedRows();
        if (BTN_DEFAULT.equals(operateKey)) {
            if (selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c\u3002", (String)"VersionTypeListPlugin_0", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (BTN_AUDIT.equals(operateKey) || BTN_ENABLE.equals(operateKey)) {
            String confirmOperate = this.getPageCache().get("confirmOperate");
            if (StringUtils.isBlank((CharSequence)confirmOperate)) {
                ArrayList<Object> idlist = new ArrayList<Object>(selectedRows.size());
                for (int i = 0; i < selectedRows.size(); ++i) {
                    idlist.add(selectedRows.get(i).getPrimaryKeyValue());
                }
                QFilter[] filter = new QFilter[]{new QFilter("id", "in", idlist)};
                DynamicObject[] dyColl = BusinessDataServiceHelper.load((String)"mpdm_gantt_versiontype", (String)"id,default,orgpage,status,enable", (QFilter[])filter);
                List defaultList = Arrays.stream(dyColl).filter(x -> x.getBoolean(DEFAULT)).collect(Collectors.toList());
                if (defaultList.size() > 1) {
                    if (BTN_AUDIT.equals(formOperate.getOperateKey())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u6b62\u540c\u65f6\u5ba1\u6838\u591a\u4e2a\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u3002", (String)"VersionTypeListPlugin_1", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u542f\u7528\u4e00\u4e2a\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u3002", (String)"VersionTypeListPlugin_2", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                } else if (defaultList.size() == 1) {
                    DynamicObject dynamicObject = (DynamicObject)defaultList.get(0);
                    if (BTN_AUDIT.equals(operateKey) && "C".equals(dynamicObject.getString("status"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u65e0\u9700\u518d\u6b21\u5ba1\u6838\u3002", (String)"VersionTypeListPlugin_3", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (BTN_ENABLE.equals(operateKey) && "1".equals(dynamicObject.getString(BTN_ENABLE))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53ef\u7528\u3002", (String)"VersionTypeListPlugin_4", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    DynamicObject[] dy = this.queryEnableDefaultTypes(dynamicObject.getString("orgpage.id"));
                    if (dy.length > 0) {
                        this.getPageCache().put(ISDEFAULTID, dynamicObject.getPkValue().toString());
                        this.getPageCache().put(NEEDCHANGEENTITY, dynamicObject.getString("orgpage.id"));
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submintOrEnable");
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u9002\u7528\u9875\u9762\u7684\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u3002\u662f\u5426\u786e\u5b9a\u9700\u8981\u8bbe\u7f6e\u65b0\u7684\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\uff1f", (String)"VersionTypeListPlugin_5", (String)"bd-mpdm-gantt", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                        args.setCancel(true);
                        this.getPageCache().put("operateKey", operateKey);
                    }
                }
            }
            this.getPageCache().put("confirmOperate", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (BTN_DEFAULT.equals(operateKey)) {
            BillList grid = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = grid.getSelectedRows();
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            long ruleId = (Long)listSelectedRow.getPrimaryKeyValue();
            DynamicObject thisVersion = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"mpdm_gantt_versiontype", (String)"id,default,status,enable,number,orgpage");
            String billStatus = thisVersion.getString("status");
            if (!"C".equals(billStatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7248\u672c\u7c7b\u578b\u7f16\u7801\u4e3a\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u3002", (String)"VersionTypeListPlugin_6", (String)"bd-mpdm-gantt", (Object[])new Object[0]), listSelectedRow.getNumber()));
                return;
            }
            String enable = thisVersion.getString(BTN_ENABLE);
            if ("0".equals(enable)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7248\u672c\u7c7b\u578b\u7f16\u7801\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u3002", (String)"VersionTypeListPlugin_7", (String)"bd-mpdm-gantt", (Object[])new Object[0]), listSelectedRow.getNumber()));
                return;
            }
            boolean flag = thisVersion.getBoolean(DEFAULT);
            if (flag) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7248\u672c\u7c7b\u578b:%s\u5df2\u662f\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"VersionTypeListPlugin_8", (String)"bd-mpdm-gantt", (Object[])new Object[0]), thisVersion.getString("number")));
                return;
            }
            DynamicObject[] dy = this.queryEnableDefaultTypes(thisVersion.getString("orgpage.id"));
            if (dy.length <= 0) {
                thisVersion.set(DEFAULT, (Object)"1");
                SaveServiceHelper.update((DynamicObject)thisVersion);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u5df2\u6210\u529f\u8bbe\u7f6e\u3002", (String)"VersionTypeListPlugin_9", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
            } else {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirm");
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u9002\u7528\u9875\u9762\u7684\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u3002\u662f\u5426\u786e\u5b9a\u9700\u8981\u8bbe\u7f6e\u65b0\u7684\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\uff1f", (String)"VersionTypeListPlugin_5", (String)"bd-mpdm-gantt", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.refresh();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("confirm".equals(callBackId)) {
            if (result == MessageBoxResult.Yes) {
                BillList grid = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = grid.getSelectedRows();
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                long ruleId = (Long)listSelectedRow.getPrimaryKeyValue();
                DynamicObject thisVersion = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"mpdm_gantt_versiontype", (String)"id,default,status,enable,number,orgpage");
                DynamicObject[] dy = this.queryEnableDefaultTypes(thisVersion.getString("orgpage.id"));
                thisVersion.set(DEFAULT, (Object)"1");
                SaveServiceHelper.update((DynamicObject)thisVersion);
                for (DynamicObject dynamicObject : dy) {
                    dynamicObject.set(DEFAULT, (Object)"0");
                }
                SaveServiceHelper.update((DynamicObject[])dy);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u7248\u672c\u7c7b\u578b\u5df2\u8bbe\u7f6e\u6210\u529f\u3002", (String)"VersionTypeListPlugin_10", (String)"bd-mpdm-gantt", (Object[])new Object[0]));
                BillList list = (BillList)this.getControl("billlistap");
                list.refresh();
            }
        } else if ("submintOrEnable".equals(callBackId)) {
            if (result == MessageBoxResult.Yes) {
                DynamicObject[] dy;
                String needChangeEntity = this.getPageCache().get(NEEDCHANGEENTITY);
                for (DynamicObject dynamicObject : dy = this.queryEnableDefaultTypes(needChangeEntity)) {
                    dynamicObject.set(DEFAULT, (Object)"0");
                }
                SaveServiceHelper.update((DynamicObject[])dy);
            } else {
                String isDefaultId = this.getPageCache().get(ISDEFAULTID);
                DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)isDefaultId, (String)"mpdm_gantt_versiontype");
                dy.set(DEFAULT, (Object)"0");
                SaveServiceHelper.update((DynamicObject)dy);
            }
            this.getPageCache().put("confirmOperate", "true");
            String operateKey = this.getPageCache().get("operateKey");
            this.getView().invokeOperation(operateKey);
        }
    }

    private DynamicObject[] queryEnableDefaultTypes(String entityId) {
        QFilter[] qfilter = new QFilter[]{new QFilter(DEFAULT, "=", (Object)"1"), new QFilter(BTN_ENABLE, "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("orgpage", "=", (Object)entityId)};
        return BusinessDataServiceHelper.load((String)"mpdm_gantt_versiontype", (String)"id,name,number,status,enable,default,orgpage", (QFilter[])qfilter);
    }
}

