/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.init;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.mservice.init.impl.AbstractDataInitImpl;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class MpdmDataInitExecTask
extends AbstractTask {
    protected static final Log logger = LogFactory.getLog(MpdmDataInitExecTask.class);
    private static final String ENTITY_INIT = "mpdm_datainitconfig";
    private static final int MAX_ERROR_COUNT = 3;
    private static final String LOCK_KEY = "mmc-datainit-exec";
    private static final List<String> EXECSTATUSSET = Arrays.asList("A", "D");
    private static final String UPDATESQL_START_STATUS = " update t_mpdm_datainitconfig set fexecstatus = ?,fexecbegintime = ?,fexecendtime = ? where fid = ?";
    private static final String UPDATESQL_END_STATUS = " update t_mpdm_datainitconfig set fexecstatus = ?,fexecendtime = ?,fexecresult = ?,fexecresult_tag = ?,fexeccount = ? where fid = ?";
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final String KEY_APPLYNAME = "bd-mpdm-mservice";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        Object appNumber = paramMap.get("appnumber");
        DynamicObjectCollection coll = this.getInitConfigDataColl(appNumber == null ? "" : appNumber.toString());
        if (coll == null || coll.isEmpty()) {
            return;
        }
        String currentExecInstanceId = Instance.getInstanceId();
        try (DLock lock = DLock.create((String)LOCK_KEY);){
            if (!lock.tryLock()) {
                logger.info("--------mmc.MpdmDataInitExecTask.execute---addLockError---\u521d\u59cb\u5316\u6570\u636e\u5c1d\u8bd5\u52a0\u9501\u5931\u8d25\uff0c\u6570\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u672c\u6b21\u64cd\u4f5c\u7ec8\u6b62\uff0c\u5f53\u524d\u5b9e\u4f8b\u540d\u79f0\uff1a" + currentExecInstanceId);
                return;
            }
        }
        for (DynamicObject data : coll) {
            String newStatus = this.getInitStatus(data);
            if (!EXECSTATUSSET.contains(newStatus)) {
                logger.info("--------mmc.MpdmDataInitExecTask.execute---execInit error,initNumber=" + data.getString("number") + ",initName=" + data.getString("name") + ",\u5f53\u524d\u5b9e\u4f8b\u540d\u79f0\uff1a" + currentExecInstanceId + ",\u6267\u884c\u72b6\u6001\uff08" + newStatus + "\uff09\u4e0d\u4e3a\u672a\u6267\u884c\u6216\u6267\u884c\u5931\u8d25\uff0c\u672c\u6b21\u8df3\u8fc7\u6267\u884c\u3002");
                continue;
            }
            String endStatus = "C";
            String execResult = "ok";
            String execResultText = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5b9e\u4f8b\uff1a%1$s", (String)"MpdmDataInitExecTask_3", (String)KEY_APPLYNAME, (Object[])new Object[0]), currentExecInstanceId);
            Long id = data.getLong("id");
            int execCount = data.getInt("execcount");
            if ("D".equals(newStatus) && execCount > 3) continue;
            boolean isThreadMode = data.getBoolean("isthreadmode");
            String lockKeys = "mmc-datainit-exec-" + data.getLong("id");
            String lockDesc = "mmc-datainit-exec-" + data.getString("name");
            DLock lock = DLock.create((String)lockKeys, (String)lockDesc);
            lock.lock();
            try {
                this.setInitStartStatus(id);
                String errorMsg = this.execInit(data);
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    endStatus = "D";
                    execResultText = errorMsg;
                    execResult = String.format(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"MpdmDataInitExecTask_2", (String)KEY_APPLYNAME, (Object[])new Object[0]), execResultText);
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                endStatus = "D";
                execResultText = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                execResult = String.format(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"MpdmDataInitExecTask_2", (String)KEY_APPLYNAME, (Object[])new Object[0]), execResultText);
            }
            finally {
                lock.unlock();
            }
            if (isThreadMode) continue;
            this.setInitEndStatus(id, endStatus, execResult, execResultText, execCount + 1);
        }
    }

    private String execInit(DynamicObject data) {
        String pluginClass = data.getString("plugin");
        if (StringUtils.isEmpty((String)pluginClass)) {
            return "";
        }
        String errorMsg = "";
        Long id = data.getLong("id");
        try {
            Object object = Class.forName(pluginClass).newInstance();
            if (AbstractDataInitImpl.class.isInstance(object)) {
                ((AbstractDataInitImpl)object).startInit(id, data.getBoolean("isthreadmode"));
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u63d2\u4ef6\uff08%1$s\uff09\u672a\u7ee7\u627f\u6807\u51c6\u521d\u59cb\u5316\u63a5\u53e3\u7c7b\u3002", (String)"MpdmDataInitExecTask_1", (String)KEY_APPLYNAME, (Object[])new Object[0]), pluginClass);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
        }
        return errorMsg;
    }

    private void setInitEndStatus(Long id, String endStatus, String execResult, String execResultText, int execCount) {
        if (execResult != null && execResult.length() > 240) {
            execResult = execResult.substring(0, 240);
        }
        DB.execute((DBRoute)scmDBRoute, (String)UPDATESQL_END_STATUS, (Object[])new Object[]{endStatus, new Date(), execResult, execResultText, execCount, id});
    }

    private void setInitStartStatus(Long id) {
        DB.execute((DBRoute)scmDBRoute, (String)UPDATESQL_START_STATUS, (Object[])new Object[]{"B", new Date(), null, id});
    }

    private String getInitStatus(DynamicObject data) {
        DynamicObject newData = QueryServiceHelper.queryOne((String)ENTITY_INIT, (String)"execstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("id"))});
        return newData.getString("execstatus");
    }

    private DynamicObjectCollection getInitConfigDataColl(String appNumber) {
        QFilter qf = new QFilter("status", "=", (Object)"C");
        qf.and(new QFilter("enable", "=", (Object)"1"));
        qf.and(new QFilter("execstatus", "in", EXECSTATUSSET));
        if (!StringUtils.isEmpty((String)appNumber)) {
            qf.and(new QFilter("appnum", "=", (Object)appNumber));
        }
        return QueryServiceHelper.query((String)ENTITY_INIT, (String)this.getSelectProperties(), (QFilter[])new QFilter[]{qf});
    }

    private String getSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",name");
        sb.append(",execstatus");
        sb.append(",plugin");
        sb.append(",appnum");
        sb.append(",execcount");
        sb.append(",isthreadmode");
        return sb.toString();
    }
}

