/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.init.impl;

import java.util.Date;
import kd.bd.mpdm.mservice.api.init.IDataInitExecService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.instance.Instance;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;

public class AbstractDataInitImpl
implements IDataInitExecService {
    private static final String UPDATESQL_END_STATUS = " update t_mpdm_datainitconfig set fexecstatus = ?,fexecendtime = ?,fexecresult = ?,fexecresult_tag = ?,fexeccount = ? where fid = ?";
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final String KEY_APPLYNAME = "bd-mpdm-mservice";
    private static final String ENTITY_INIT = "mpdm_datainitconfig";

    public void startInit(final Long configId, boolean isRunByThread) {
        if (isRunByThread) {
            ThreadPools.executeOnce((String)("mmc_datainit_" + configId), (Runnable)new Runnable(){

                @Override
                public void run() {
                    String endStatus = "C";
                    String currentExecInstanceId = Instance.getInstanceId();
                    String execResultText = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5b9e\u4f8b\uff1a%1$s", (String)"MpdmDataInitExecTask_3", (String)AbstractDataInitImpl.KEY_APPLYNAME, (Object[])new Object[0]), currentExecInstanceId);
                    String execResult = "ok";
                    try {
                        AbstractDataInitImpl.this.execInit(configId);
                    }
                    catch (Exception ex) {
                        endStatus = "D";
                        execResultText = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                        execResult = String.format(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"MpdmDataInitExecTask_2", (String)AbstractDataInitImpl.KEY_APPLYNAME, (Object[])new Object[0]), execResultText);
                    }
                    AbstractDataInitImpl.this.setInitEndStatus(configId, endStatus, execResult, execResultText, AbstractDataInitImpl.this.getExecCount(configId) + 1);
                }
            });
        } else {
            this.execInit(configId);
        }
    }

    private void setInitEndStatus(Long id, String endStatus, String execResult, String execResultText, int execCount) {
        if (execResult != null && execResult.length() > 240) {
            execResult = execResult.substring(0, 240);
        }
        DB.execute((DBRoute)scmDBRoute, (String)UPDATESQL_END_STATUS, (Object[])new Object[]{endStatus, new Date(), execResult, execResultText, execCount, id});
    }

    private int getExecCount(Long id) {
        DynamicObject newData = QueryServiceHelper.queryOne((String)ENTITY_INIT, (String)"execcount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return newData.getInt("execcount");
    }

    public void execInit(Long configId) {
    }
}

