/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.materialplan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.mservice.materialplan.PlanBusinessGroupUpgradeService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PlanBusinessGroupSyncPlugin
implements IEventServicePlugin {
    public Object handleEvent(KDBizEvent evt) {
        String mpdmBusinessGroupEntity = "mpdm_demandgroup";
        String bdBusinessGroupEntity = "bd_operatorgroup";
        String MPDM_UPGRADSYNCONF = "mpdm_upgradsynconf";
        String SYNC_NUMBER = "PlanOperatorGroupSync";
        if (evt instanceof EntityEvent) {
            EntityEvent entityEvent = (EntityEvent)evt;
            String entityNumber = entityEvent.getEntityNumber();
            if (!bdBusinessGroupEntity.equals(entityNumber)) {
                return evt.getEventId();
            }
            String operation = entityEvent.getOperation();
            List bussinessKeys = entityEvent.getBusinesskeys();
            if (bussinessKeys.isEmpty() || !QueryServiceHelper.exists((String)MPDM_UPGRADSYNCONF, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)SYNC_NUMBER).and("enable", "=", (Object)"1")})) {
                return evt.getEventId();
            }
            HashSet<Long> ids = new HashSet<Long>(bussinessKeys.size());
            for (String bussinessKey : bussinessKeys) {
                ids.add(Long.parseLong(bussinessKey));
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            qFilter.and("operatorgrouptype", "=", (Object)"JHZ");
            String selectHead = "number,name,status,enable,creator,modifier,createtime,modifytime,createorg,org,ctrlstrategy,operatorgrouptype,description";
            String selectFields = String.format("id,%s,entryentity.id,entryentity.operator", "number,name,status,enable,creator,modifier,createtime,modifytime,createorg,org,ctrlstrategy,operatorgrouptype,description");
            String selectBdFields = String.format("%s,entryentity.invalid", selectFields);
            String selectMpdmFields = String.format("%s,srcopgroupid,entryentity.businessarea,entryentity.dpt,entryentity.position", selectFields);
            switch (operation) {
                case "enable": 
                case "disable": 
                case "save": {
                    DynamicObject[] bdOpGroups;
                    HashSet<Long> orgIDList = new HashSet<Long>(4);
                    HashSet<Long> origIds = new HashSet<Long>(16);
                    HashMap<Long, DynamicObject> bdId2OpGroup = new HashMap<Long, DynamicObject>(16);
                    for (DynamicObject dynamicObject : bdOpGroups = BusinessDataServiceHelper.load((String)bdBusinessGroupEntity, (String)selectBdFields, (QFilter[])new QFilter[]{qFilter})) {
                        origIds.add(dynamicObject.getLong("id"));
                        bdId2OpGroup.put(dynamicObject.getLong("id"), dynamicObject);
                        orgIDList.add(dynamicObject.getLong("createorg.id"));
                        ids.remove(dynamicObject.getLong("id"));
                    }
                    if (!origIds.isEmpty()) {
                        OperationResult saveResult;
                        DynamicObject mpdmOpGroup;
                        DynamicObject[] mpdmOpGroups;
                        HashMap<DynamicObject, DynamicObject> updateOpGroups = new HashMap<DynamicObject, DynamicObject>(16);
                        QFilter srcFilter = new QFilter("srcopgroupid", "in", origIds);
                        for (DynamicObject mpdmOpGroup2 : mpdmOpGroups = BusinessDataServiceHelper.load((String)mpdmBusinessGroupEntity, (String)selectMpdmFields, (QFilter[])new QFilter[]{srcFilter})) {
                            Long srcopgroupid = mpdmOpGroup2.getLong("srcopgroupid");
                            DynamicObject bdOpGroup = (DynamicObject)bdId2OpGroup.remove(srcopgroupid);
                            if (bdOpGroup == null) continue;
                            updateOpGroups.put(bdOpGroup, mpdmOpGroup2);
                        }
                        String[] stringArray = "number,name,status,enable,creator,modifier,createtime,modifytime,createorg,org,ctrlstrategy,operatorgrouptype,description".split(",");
                        int size = bdId2OpGroup.size();
                        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(size);
                        if (size > 0) {
                            long[] mpdmOpIds = ORM.create().genLongIds(mpdmBusinessGroupEntity, size);
                            int k = 0;
                            for (DynamicObject bdOpGroup : bdId2OpGroup.values()) {
                                mpdmOpGroup = BusinessDataServiceHelper.newDynamicObject((String)mpdmBusinessGroupEntity);
                                this.updateOpGroup(stringArray, bdOpGroup, mpdmOpGroup);
                                mpdmOpGroup.set("srcopgroupid", (Object)bdOpGroup.getLong("id"));
                                mpdmOpGroup.set("id", (Object)mpdmOpIds[k++]);
                                saveDatas.add(mpdmOpGroup);
                            }
                        }
                        ArrayList<DynamicObject> updateDatas = new ArrayList<DynamicObject>(size);
                        for (Map.Entry entry : updateOpGroups.entrySet()) {
                            DynamicObject bdOpGroup;
                            bdOpGroup = (DynamicObject)entry.getKey();
                            mpdmOpGroup = (DynamicObject)entry.getValue();
                            this.updateOpGroup(stringArray, bdOpGroup, mpdmOpGroup);
                            updateDatas.add(mpdmOpGroup);
                        }
                        if (!saveDatas.isEmpty() && !(saveResult = OperationServiceHelper.executeOperate((String)"save", (String)mpdmBusinessGroupEntity, (DynamicObject[])saveDatas.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
                            SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
                        }
                        if (!updateDatas.isEmpty()) {
                            SaveServiceHelper.save((DynamicObject[])updateDatas.toArray(new DynamicObject[0]));
                        }
                        if (!orgIDList.isEmpty()) {
                            PlanBusinessGroupUpgradeService.clearCache(mpdmBusinessGroupEntity, new ArrayList<Long>(orgIDList));
                        }
                    }
                    this.deletePlanOperatorBySrcId(ids, mpdmBusinessGroupEntity);
                    break;
                }
                case "delete": {
                    this.deletePlanOperatorBySrcId(ids, mpdmBusinessGroupEntity);
                    break;
                }
            }
        }
        return evt.getEventId();
    }

    private void deletePlanOperatorBySrcId(Set<Long> ids, String mpdmBusinessGroupEntity) {
        ArrayList<Object> pks = new ArrayList<Object>(ids.size());
        QFilter srcFilter = new QFilter("srcopgroupid", "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)mpdmBusinessGroupEntity, (String)"id", (QFilter[])new QFilter[]{srcFilter}, null);){
            for (Row row : dataSet) {
                pks.add(row.get("id"));
            }
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        HashSet<Long> refIds = new HashSet<Long>(8);
        MainEntityType mpdmEntityType = MetadataServiceHelper.getDataEntityType((String)mpdmBusinessGroupEntity);
        Map checkResult = checker.checkRef((BasedataEntityType)mpdmEntityType, pks.toArray());
        if (!checkResult.isEmpty()) {
            for (Object refId : checkResult.keySet()) {
                refIds.add(Long.parseLong(refId.toString()));
            }
        }
        if (!refIds.isEmpty()) {
            DynamicObject[] mpdmDatas;
            for (DynamicObject mpdmData : mpdmDatas = BusinessDataServiceHelper.load((Object[])refIds.toArray(), (DynamicObjectType)mpdmEntityType)) {
                mpdmData.set("enable", (Object)"0");
            }
            SaveServiceHelper.update((DynamicObject[])mpdmDatas);
        }
        srcFilter.and("id", "not in", refIds);
        DeleteServiceHelper.delete((String)mpdmBusinessGroupEntity, (QFilter[])new QFilter[]{srcFilter});
    }

    private void updateOpGroup(String[] pros, DynamicObject bdOpGroup, DynamicObject mpdmOpGroup) {
        for (String pro : pros) {
            pro = pro.trim();
            mpdmOpGroup.set(pro, bdOpGroup.get(pro));
        }
        DynamicObjectCollection bdEntrys = bdOpGroup.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection mpdmEntrys = mpdmOpGroup.getDynamicObjectCollection("entryentity");
        mpdmEntrys.clear();
        for (DynamicObject bdEntry : bdEntrys) {
            DynamicObjectCollection userCol;
            DynamicObject operator = bdEntry.getDynamicObject("operator");
            boolean invalid = bdEntry.getBoolean("invalid");
            if (invalid) continue;
            DynamicObject mpdmEntry = mpdmEntrys.addNew();
            mpdmEntry.set("operator", (Object)operator);
            mpdmEntry.set("businessarea", (Object)"MRP");
            if (operator == null || null == (userCol = (operator = BusinessDataServiceHelper.loadSingle((Object)operator.getPkValue(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)operator.getDataEntityType().getName()))).getDynamicObjectCollection("entryentity")) || userCol.size() == 0) continue;
            DynamicObject cuser = (DynamicObject)userCol.get(0);
            ILocaleString position = cuser.getLocaleString("position");
            DynamicObject dpt = cuser.get("dpt") != null ? cuser.getDynamicObject("dpt") : null;
            mpdmEntry.set("dpt", (Object)dpt);
            mpdmEntry.set("position", (Object)position);
        }
    }
}

