/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.materialplan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.BizLog;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;

public class PlanBusinessGroupUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"PlanBusinessGroupUpgradeService-execute", this::executePlanBusinessGroupUggrade);
        return new UpgradeResult();
    }

    public void executePlanBusinessGroupUggrade() {
        String mpdmBusinessGroupEntity = "mpdm_demandgroup";
        String bdBusinessGroupEntity = "bd_operatorgroup";
        String MPDM_UPGRADSYNCONF = "mpdm_upgradsynconf";
        String SYNC_NUMBER = "PlanOperatorGroupSync";
        HashSet<Long> mpdmBusIds = new HashSet<Long>(16);
        HashSet<Long> orgIDList = new HashSet<Long>(4);
        QFilter qFilterSrc = new QFilter("srcopgroupid", "=", (Object)0L);
        qFilterSrc.or("srcopgroupid", "is null", (Object)0L);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)mpdmBusinessGroupEntity, (String)"id,createorg", (QFilter[])new QFilter[]{qFilterSrc}, null);){
            for (Row row : dataSet) {
                mpdmBusIds.add(row.getLong("id"));
                orgIDList.add(row.getLong("createorg"));
            }
        }
        String isEnable = QueryServiceHelper.exists((String)mpdmBusinessGroupEntity, (QFilter[])new QFilter[0]) ? "1" : "0";
        QFilter qFilter = new QFilter("number", "=", (Object)SYNC_NUMBER);
        DynamicObject syncConfig = BusinessDataServiceHelper.loadSingle((String)MPDM_UPGRADSYNCONF, (String)"id, enable", (QFilter[])new QFilter[]{qFilter});
        if (syncConfig != null) {
            syncConfig.set("enable", (Object)isEnable);
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)syncConfig.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{syncConfig}, (OperateOption)OperateOption.create());
            if (!saveResult.isSuccess()) {
                SaveServiceHelper.update((DynamicObject)syncConfig);
            }
        }
        if (!mpdmBusIds.isEmpty()) {
            DynamicObject[] mpdmBusDatas = BusinessDataServiceHelper.load((Object[])mpdmBusIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)mpdmBusinessGroupEntity));
            MainEntityType bdEntityType = MetadataServiceHelper.getDataEntityType((String)bdBusinessGroupEntity);
            ArrayList<String> pros = new ArrayList<String>(16);
            pros.add("number");
            pros.add("name");
            pros.add("status");
            pros.add("creator");
            pros.add("modifier");
            pros.add("enable");
            pros.add("createtime");
            pros.add("modifytime");
            pros.add("createorg");
            pros.add("org");
            pros.add("ctrlstrategy");
            pros.add("operatorgrouptype");
            pros.add("description");
            ArrayList<DynamicObject> bdSaves = new ArrayList<DynamicObject>(mpdmBusDatas.length);
            long[] ids = ORM.create().genLongIds(bdBusinessGroupEntity, mpdmBusDatas.length);
            for (int i = 0; i < mpdmBusDatas.length; ++i) {
                DynamicObject mpdmBus = mpdmBusDatas[i];
                DynamicObject bdBus = BusinessDataServiceHelper.newDynamicObject((String)bdBusinessGroupEntity);
                for (String pro : pros) {
                    if (bdEntityType.getProperty(pro) == null) continue;
                    bdBus.set(pro, mpdmBus.get(pro));
                }
                bdBus.set("id", (Object)ids[i]);
                mpdmBus.set("srcopgroupid", (Object)ids[i]);
                DynamicObjectCollection bdEntrys = bdBus.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection mpdmEntrys = mpdmBus.getDynamicObjectCollection("entryentity");
                for (DynamicObject mpdmEntry : mpdmEntrys) {
                    DynamicObject bdEntry = bdEntrys.addNew();
                    DynamicObject operator = mpdmEntry.getDynamicObject("operator");
                    bdEntry.set("operator", (Object)operator);
                    if (operator != null) {
                        bdEntry.set("operatorname", operator.get("name"));
                        bdEntry.set("operatornumber", operator.get("number"));
                    }
                    bdEntry.set("opergrpnumber", bdBus.get("number"));
                    bdEntry.set("opergrpname", bdBus.get("name"));
                    bdEntry.set("opergrptype", bdBus.get("operatorgrouptype"));
                }
                bdSaves.add(bdBus);
            }
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)bdBusinessGroupEntity, (DynamicObject[])bdSaves.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!saveResult.isSuccess()) {
                SaveServiceHelper.save((DynamicObject[])bdSaves.toArray(new DynamicObject[0]));
            }
            SaveServiceHelper.update((DynamicObject[])mpdmBusDatas);
            if (!orgIDList.isEmpty()) {
                PlanBusinessGroupUpgradeService.clearCache(bdBusinessGroupEntity, new ArrayList<Long>(orgIDList));
            }
        }
    }

    public static void clearCache(String entity, List<Long> orgIDList) {
        try {
            BaseDataService baseDataService = new BaseDataService();
            for (Long useorgId : orgIDList) {
                baseDataService.clearBaseDataFilterCache(entity, useorgId);
            }
            BaseDataServiceHelper.refreshBaseDataUseRange((String)entity, orgIDList);
        }
        catch (Exception e) {
            BizLog.log((String)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }
}

