/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.person;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.mpdm.mservice.api.person.IFilterPersonService;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FilterPersonServiceImpl
implements IFilterPersonService {
    private static final String alogKey = FilterPersonServiceImpl.class.getName();

    public DataSet getPersonData(Object planid, Object areaid, Object instructid, Object classid, Date date) {
        Object[] resourcePlanid = this.getResourcePlanid(planid);
        List<QFilter> filters = this.getFilters(resourcePlanid, areaid, instructid, date);
        DataSet personDataSet = this.getPersonDataSet(filters);
        Set ids = this.getpersonid(personDataSet.copy());
        DataSet classDataSet = this.getPerFilter(classid, ids);
        DataSet result = personDataSet.leftJoin(classDataSet).on("userid", "personid").select(new String[]{"id", "classid", "userid", "worknumid", "number", "name", "dept", "professiona", "worktype", "dispatcharea"}).finish();
        return result.groupBy(result.getRowMeta().getFieldNames()).finish();
    }

    private Set getpersonid(DataSet copy) {
        try (AlgoContext context = Algo.newContext();){
            HashSet<Object> ids = new HashSet<Object>(16);
            for (Row row : copy) {
                ids.add(row.get("userid"));
            }
            HashSet<Object> hashSet = ids;
            return hashSet;
        }
    }

    private DataSet getPerFilter(Object classid, Set ids) {
        String fields = "id as classid,entryentity.manuperson.id as personid";
        QFilter filter = null;
        filter = classid != null ? new QFilter("id", "=", classid) : new QFilter("entryentity.manuperson", "in", (Object)ids.toArray());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(alogKey + "_getPerFilter"), (String)"mpdm_classgroup", (String)fields, (QFilter[])new QFilter[]{filter}, null);
        return dataSet;
    }

    private DataSet getPersonDataSet(List<QFilter> filters) {
        HashSet<Long> ids = new HashSet<Long>(16);
        String fields = "id,user.id as userid,user.user as worknumid,user.number as number,user.name as name,user.dept as dept,user.professiona as professiona,worktype,dispatcharea";
        QFilter temp = new QFilter("usertype", "=", (Object)"mpdm_manuperson");
        filters.add(temp);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(alogKey + "_getPersonId1"), (String)"pmtm_personplan", (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null);
        filters.remove(temp);
        filters.add(new QFilter("usertype", "=", (Object)"mpdm_classgroup"));
        fields = "id,user,worktype,dispatcharea";
        DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)(alogKey + "_getPersonId2"), (String)"pmtm_personplan", (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null);
        for (Row obj : dataSet1.copy()) {
            long user = obj.getLong("user");
            if (user <= 0L) continue;
            ids.add(user);
        }
        fields = "id as classid,entryentity.manuperson.id as userid1,entryentity.manuperson.user as worknumid1,entryentity.manuperson.number as number1,entryentity.manuperson.name as name1,entryentity.manuperson.dept as dept1,entryentity.manuperson.professiona as professiona1";
        temp = new QFilter("id", "in", (Object)ids.toArray());
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)(alogKey + "_getPersonId3"), (String)"mpdm_classgroup", (String)fields, (QFilter[])new QFilter[]{temp}, null);
        dataSet1 = dataSet1.leftJoin(dataSet2).on("id", "classid").select(new String[]{"id", "userid1", "worknumid1", "number1", "name1", "dept1", "professiona1", "worktype", "dispatcharea"}).finish();
        dataSet = dataSet.union(dataSet1);
        return dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
    }

    private List<QFilter> getFilters(Object[] resourcePlanid, Object areaid, Object instructid, Date date) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("resourceplan", "in", (Object)resourcePlanid));
        if (areaid != null) {
            filters.add(new QFilter("dispatcharea", "=", areaid));
        }
        if (instructid != null) {
            filters.add(new QFilter("workgroup.industry", "=", instructid));
        }
        if (date != null) {
            QFilter f = new QFilter("starttime", "<=", (Object)date);
            filters.add(f.and("endtime", ">=", (Object)date));
        }
        return filters;
    }

    private Object[] getResourcePlanid(Object planid) {
        QFilter filter = new QFilter("overdevice", ">", (Object)0L);
        if (planid != null) {
            filter = new QFilter("overdevice", "=", planid);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id", (QFilter[])new QFilter[]{filter});
        Object[] ids = new Object[query.size()];
        int i = 0;
        for (DynamicObject dyobj : query) {
            long id = dyobj.getLong("id");
            ids[i++] = String.valueOf(id);
        }
        return ids;
    }
}

