/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class MpdmLangeuageUpgradeService
implements IUpgradeService {
    private static final String ALGO_KEY = MpdmLangeuageUpgradeService.class.getName();
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"scm");
    private static final int BATCH_NUM = 1000;
    private static final int DEFAULT_BATCHSIZE = 5000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            MpdmLangeuageUpgradeService.updatemergedimension();
            result.setSuccess(true);
            result.setLog("LangeuageUpgradeService upgrade success");
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
            result.setLog("LangeuageUpgradeService upgrade failed");
        }
        return result;
    }

    public static void updatemergedimension() {
        String queryDropLog = "SELECT FENTRYID, FGROUPMERGEATTR FROM T_MPDM_MERGEDIMENENTRY";
        DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)queryDropLog);
        String[] pkids = DB.genStringIds((String)"T_MPDM_MERGEDIMENENTRY_L", (int)dropLogDataSet.copy().count("FENTRYID", false));
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(1000);
        int i = 0;
        for (Row row : dropLogDataSet) {
            Long mappingEntryId = row.getLong("FENTRYID");
            String groupmergeattr = row.getString("FGROUPMERGEATTR");
            Object[] param = new Object[]{pkids[i], mappingEntryId, "zh_CN", groupmergeattr};
            updateParamList.add(param);
            ++i;
        }
        String insertSQL = "INSERT INTO T_MPDM_MERGEDIMENENTRY_L(FPKID, FENTRYID, FLOCALEID, FGROUPMERGEATTR) VALUES (?,?,?,?)";
        if (updateParamList.size() != 0) {
            MpdmLangeuageUpgradeService.batchSave(DB_ROUTE, insertSQL, updateParamList);
        }
    }

    public static void batchSave(DBRoute dbRoute, String sql, List<Object[]> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = totalCount / 5000;
            times = totalCount % 5000 != 0 ? times + 1 : times;
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                DB.executeBatch((DBRoute)dbRoute, (String)sql, values.subList(startIndex, endIndex));
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)sql, values);
        }
    }
}

