/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class MpdmTransactUpgradeService
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(MpdmTransactUpgradeService.class);
    public static final String INSERT_SQL = "insert into t_mpdm_trabomtypes (FPkId,FId,FBaseDataId)values(?,?,?)";
    private Set<Long> ids = new HashSet<Long>(1024);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DataSet oldTransDs;
        List<Object[]> params;
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        if (this.transTypesIsEmpty(scmRoute) && !(params = this.buildInsertParams(oldTransDs = this.getOldTransType(scmRoute))).isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)INSERT_SQL, params);
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private List<Object[]> buildInsertParams(DataSet oldTransDs) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Row row : oldTransDs) {
            Long fpkid = this.getPkId();
            Long fid = row.getLong("fid");
            Long fbasedataid = row.getLong("fbomtype");
            params.add(new Object[]{fpkid, fid, fbasedataid});
        }
        return params;
    }

    private Long getPkId() {
        if (this.ids.isEmpty()) {
            long[] idArr;
            for (long id : idArr = DB.genLongIds((String)"t_mpdm_trabomtypes", (int)1000)) {
                this.ids.add(id);
            }
        }
        Iterator<Long> iterator = this.ids.iterator();
        Long id = iterator.next();
        iterator.remove();
        return id;
    }

    private DataSet getOldTransType(DBRoute scmRoute) {
        String sql = "select fbomtype,fid from t_mpdm_traproduct where fbomtype != 0 and fbomtype is not null";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }

    private boolean transTypesIsEmpty(DBRoute scmRoute) {
        String sql = "select FPkid from t_mpdm_trabomtypes";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        boolean isUpdate = tableSet.isEmpty();
        tableSet.close();
        return isUpdate;
    }
}

