/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.upgrade;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;

public class MpdmTransactoutUpdateBOMConfigService
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(MpdmTransactoutUpdateBOMConfigService.class);
    public static final String updateSql = "update t_mpdm_transactout set fbomexpandconfig = ? where fid = ? ";
    public static final String INSERTHead_SQL = "insert into t_mpdm_bomexpandconfig (fid,fnumber,fenable,fstatus,fcreatorid,fcreatetime,fverconfig,freplacenorule)values(?,?,?,?,?,?,?,?)";
    public static final String INSERTHeadL_SQL = "insert into t_mpdm_bomexpandconfig_l (FPkId,FId,flocaleid,fname)values(?,?,?,?)";
    public static final String INSERTEntry_SQL = "insert into t_mpdm_bomexpconfigentry (fid,fentryid,fpurpose,fbomtype,fpriority)values(?,?,?,?,?)";
    private Set<Long> headids = new HashSet<Long>(1024);
    private Set<String> headlids = new HashSet<String>(1024);
    private Set<Long> entryids = new HashSet<Long>(1024);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        DataSet oldTransDs = this.getTransData(scmRoute);
        if (!oldTransDs.isEmpty()) {
            DataSet bomExpandDs = this.getBomExpandData(scmRoute);
            HashMap<Long, Set> bomtypeSetMap = new HashMap<Long, Set>(16);
            for (Row row : bomExpandDs) {
                Long pkValue = row.getLong("fid");
                Long fbomtype = row.getLong("fbomtype");
                HashSet<Object> bomtypeSet = (HashSet<Object>)bomtypeSetMap.get(pkValue);
                if (bomtypeSet == null) {
                    bomtypeSet = new HashSet<Object>();
                }
                bomtypeSet.add(fbomtype);
                bomtypeSetMap.put(pkValue, bomtypeSet);
            }
            HashMap<Object, HashSet<Long>> tranbomtypeSetMap = new HashMap<Object, HashSet<Long>>(16);
            HashSet<Long> bomTypeSet = new HashSet<Long>();
            HashMap<Object, String> tranNumberMap = new HashMap<Object, String>(16);
            for (Row row : oldTransDs) {
                bomTypeSet.add(row.getLong("fbasedataid"));
                Long pkValue = row.getLong("fid");
                tranNumberMap.put(pkValue, row.getString("fnumber"));
                HashSet<Long> bomtypeSet = (HashSet<Long>)tranbomtypeSetMap.get(pkValue);
                if (bomtypeSet == null) {
                    bomtypeSet = new HashSet<Long>();
                }
                bomtypeSet.add(row.getLong("fbasedataid"));
                tranbomtypeSetMap.put(pkValue, bomtypeSet);
            }
            if (bomTypeSet.isEmpty()) {
                result.setSuccess(true);
                result.setLog("no data need update.");
                return result;
            }
            HashMap<Long, String> bomtypepurpose = new HashMap<Long, String>(16);
            DataSet bOMTypeDs = this.getBOMTypeData(scmRoute);
            for (Row row : bOMTypeDs) {
                bomtypepurpose.put(row.getLong("fid"), row.getString("fpurpose"));
            }
            ArrayList<Object[]> updateparams = new ArrayList<Object[]>(16);
            ArrayList<Object[]> insertHeadparams = new ArrayList<Object[]>(16);
            ArrayList<Object[]> insertHeadLparams = new ArrayList<Object[]>(16);
            ArrayList<Object[]> insertEntryparams = new ArrayList<Object[]>(16);
            for (Map.Entry m : tranbomtypeSetMap.entrySet()) {
                Set transbomTypeIDSet = (Set)m.getValue();
                Long transid = (Long)m.getKey();
                boolean intlabel = false;
                for (Map.Entry mbomtype : bomtypeSetMap.entrySet()) {
                    Set bomtypeSet = (Set)mbomtype.getValue();
                    if (transbomTypeIDSet.size() != bomtypeSet.size() || !bomtypeSet.containsAll(transbomTypeIDSet)) continue;
                    updateparams.add(new Object[]{mbomtype.getKey(), m.getKey()});
                    intlabel = true;
                    break;
                }
                if (intlabel) continue;
                Date now = TimeServiceHelper.now();
                SimpleDateFormat s = new SimpleDateFormat("HHmmss");
                String numberNew = StringUtils.substring((String)((String)tranNumberMap.get(transid)), (int)0, (int)22) + s.format(now);
                Long headid = this.getHeadPkId();
                insertHeadparams.add(new Object[]{headid, numberNew, "1", "C", 1, now, "A", "B"});
                String headlidCN = this.getHeadLPkId();
                insertHeadLparams.add(new Object[]{headlidCN, headid, "zh_CN", numberNew});
                String headlidTW = this.getHeadLPkId();
                insertHeadLparams.add(new Object[]{headlidTW, headid, "zh_TW", numberNew});
                int i = 1;
                for (Long transbomTypeID : transbomTypeIDSet) {
                    Long entryid = this.getEntryPkId();
                    insertEntryparams.add(new Object[]{headid, entryid, bomtypepurpose.get(transbomTypeID), transbomTypeID, i++});
                }
                updateparams.add(new Object[]{headid, m.getKey()});
                bomtypeSetMap.put(headid, transbomTypeIDSet);
            }
            if (!updateparams.isEmpty()) {
                DB.executeBatch((DBRoute)scmRoute, (String)updateSql, updateparams);
            }
            if (!insertHeadparams.isEmpty()) {
                DB.executeBatch((DBRoute)scmRoute, (String)INSERTHead_SQL, insertHeadparams);
            }
            if (!insertHeadLparams.isEmpty()) {
                DB.executeBatch((DBRoute)scmRoute, (String)INSERTHeadL_SQL, insertHeadLparams);
            }
            if (!insertEntryparams.isEmpty()) {
                DB.executeBatch((DBRoute)scmRoute, (String)INSERTEntry_SQL, insertEntryparams);
            }
        } else {
            oldTransDs.close();
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private Long getHeadPkId() {
        if (this.headids.isEmpty()) {
            long[] idArr;
            for (long id : idArr = DB.genLongIds((String)"t_mpdm_bomexpandconfig", (int)1000)) {
                this.headids.add(id);
            }
        }
        Iterator<Long> iterator = this.headids.iterator();
        Long id = iterator.next();
        iterator.remove();
        return id;
    }

    private String getHeadLPkId() {
        if (this.headlids.isEmpty()) {
            String[] idArr;
            for (String id : idArr = DB.genStringIds((String)"t_mpdm_bomexpandconfig_l", (int)1000)) {
                this.headlids.add(id);
            }
        }
        Iterator<String> iterator = this.headlids.iterator();
        String id = iterator.next();
        iterator.remove();
        return id;
    }

    private Long getEntryPkId() {
        if (this.entryids.isEmpty()) {
            long[] idArr;
            for (long id : idArr = DB.genLongIds((String)"t_mpdm_bomexpconfigentry", (int)1000)) {
                this.entryids.add(id);
            }
        }
        Iterator<Long> iterator = this.entryids.iterator();
        Long id = iterator.next();
        iterator.remove();
        return id;
    }

    private DataSet getBOMTypeData(DBRoute scmRoute) {
        String sql = "select fid,fpurpose from  t_mpdm_bomtype";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }

    private DataSet getBomExpandData(DBRoute scmRoute) {
        String sql = "select head.fid,fbomtype,fentryid from t_mpdm_bomexpconfigentry entry inner join t_mpdm_bomexpandconfig head on head.fid=entry.fid where head.fstatus='C' and head.fenable='1'";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }

    private DataSet getTransData(DBRoute scmRoute) {
        String sql = "select fnumber,fbomexpandconfig,entry.fid,fbasedataid from  t_mpdm_transoutbomtypes entry inner join t_mpdm_transactout head on entry.fid=head.fid where head.fbomexpandconfig = 0";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }
}

