/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class MpdmTransactoutUpdateEqModelService
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(MpdmTransactoutUpdateEqModelService.class);
    public static final String INSERTHeadL_SQL = "insert into t_bas_assistantdataentry_l (FPkId,fentryid,flocaleid,fname,ffullname)values(?,?,?,?,?)";
    public static final String INSERTHead_SQL = "INSERT INTO t_bas_assistantdataentry (fentryid,fmasterid,fgroupid,fnumber,fstatus,fseq,fenable,flevel,flongnumber,fisleaf,fparent,fname,ffullname,fcreateorgid,fctrlstrategy) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        DBRoute basedataRoute = new DBRoute("basedata");
        DataSet oldEqmodeDs = this.getEqmodelData(scmRoute);
        if (!oldEqmodeDs.isEmpty()) {
            ArrayList params;
            HashSet<Long> eqmodeIds = new HashSet<Long>();
            HashMap<Long, Object[]> eqmodeHeadparams = new HashMap<Long, Object[]>(16);
            HashMap<Long, Object[]> eqmodeHeadLparams = new HashMap<Long, Object[]>(16);
            Long rootOrgId = 0L;
            for (int i = 10; rootOrgId <= 0L && i < 10; ++i) {
                try {
                    rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                    continue;
                }
                catch (Exception ex) {
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            if (rootOrgId == null || rootOrgId == 0L) {
                rootOrgId = 100000L;
            }
            for (Row row : oldEqmodeDs) {
                Long pkValue = row.getLong("FID");
                String pkid = row.getString("FPKID");
                String number = row.getString("FNUMBER");
                String status = row.getString("FSTATUS");
                String enable = row.getString("FENABLE");
                String name = row.getString("FNAME");
                String lname = row.getString("FNAME");
                eqmodeIds.add(row.getLong("FID"));
                eqmodeHeadparams.put(pkValue, new Object[]{pkValue, pkValue, 2020429999336603648L, number, status, 0, enable, 1, number, "1", 0, name, name, rootOrgId, "6"});
                eqmodeHeadLparams.put(pkValue, new Object[]{pkid, pkValue, "zh_CN", lname, lname});
            }
            Set<Long> entryIds = this.getAssistantdata(basedataRoute);
            for (Long next : eqmodeIds) {
                if (!entryIds.contains(next)) continue;
                eqmodeHeadparams.remove(next);
                eqmodeHeadLparams.remove(next);
            }
            if (eqmodeIds.isEmpty()) {
                result.setSuccess(true);
                result.setLog("no data need update.");
                return result;
            }
            if (!eqmodeHeadparams.isEmpty()) {
                params = new ArrayList(eqmodeHeadparams.values());
                DB.executeBatch((DBRoute)basedataRoute, (String)INSERTHead_SQL, params);
            }
            if (!eqmodeHeadLparams.isEmpty()) {
                params = new ArrayList(eqmodeHeadLparams.values());
                DB.executeBatch((DBRoute)basedataRoute, (String)INSERTHeadL_SQL, params);
            }
        } else {
            oldEqmodeDs.close();
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private Set<Long> getAssistantdata(DBRoute basedataRoute) {
        String sql = "select fentryid from t_bas_assistantdataentry where fgroupid = 2020429999336603648";
        HashSet<Long> entryIds = new HashSet<Long>(16);
        try (DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)basedataRoute, (String)sql);){
            while (tableSet.hasNext()) {
                Row next = tableSet.next();
                entryIds.add(next.getLong("fentryid"));
            }
        }
        return entryIds;
    }

    private DataSet getEqmodelData(DBRoute scmRoute) {
        String sql = "select entry.FID,entry.FENABLE,entry.FMASTERID,entry.FSTATUS,entry.FNUMBER,entry.FNUMBER,entryl.FPKID,entryl.FLOCALEID,entryl.FNAME from t_mpdm_eqmodel entry inner join t_mpdm_eqmodel_l entryl on entry.fid=entryl.fid where entryl.flocaleid ='zh_CN'";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }
}

