/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.upgrade.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CalendarUpdateDataService {
    public static final String updateSql = "update t_mpdm_calendar set fstartdate = ?,fenddate = ? where fid = ? ";
    public static final DBRoute scmRoute = new DBRoute("scm");
    public static final DBRoute sysRoute = new DBRoute("sys");
    private static final Log log = LogFactory.getLog(CalendarUpdateDataService.class);

    public void exec() {
        Set<Long> newCalenderIdSet = this.syncFromPlanCalendar();
        this.updateBeginAndEndDate();
        HashMap<String, Long> cacheHeadMap = new HashMap<String, Long>(16);
        HashMap<String, Long> containEffectMap = new HashMap<String, Long>(16);
        this.initCacheHeadMap(cacheHeadMap, containEffectMap);
        Set<Long> defOrgIdSet = this.createSetDataByCalenderId(newCalenderIdSet, cacheHeadMap, containEffectMap);
        this.createSetDataByOrgId(defOrgIdSet, cacheHeadMap, containEffectMap);
        this.createSetDataByWorkShopId(cacheHeadMap, containEffectMap);
        this.createSetDataByWorkCenterId(cacheHeadMap, containEffectMap);
    }

    public void initCacheHeadMap(Map<String, Long> cacheHeadMap, Map<String, Long> containEffectMap) {
        String sqlHead = "select a.fworkcenterid ,a.fworkshopid ,a.forgid ,a.fobjecttype ,a.fid,b.fiseffectproduct,b.fiseffectplan from t_mpdm_calendarset a left join t_mpdm_calendarsetentry b on a.fid = b.fid ";
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_050"), (DBRoute)scmRoute, (String)sqlHead);){
            for (Row arow : ds) {
                Object fiseffectplan;
                Long fworkcenterid = arow.getLong("fworkcenterid");
                Long fworkshopid = arow.getLong("fworkshopid");
                Long forgid = arow.getLong("forgid");
                Long fid = arow.getLong("fid");
                String fobjecttype = arow.getString("fobjecttype");
                Long bizDataId = "C".equals(fobjecttype) ? fworkcenterid : ("B".equals(fobjecttype) ? fworkshopid : forgid);
                cacheHeadMap.put(fobjecttype + "_" + bizDataId, fid);
                Object fiseffectproduct = arow.get("fiseffectproduct");
                if (fiseffectproduct != null && "1".equals(fiseffectproduct.toString())) {
                    containEffectMap.put(bizDataId + "_A", fid);
                }
                if ((fiseffectplan = arow.get("fiseffectplan")) == null || !"1".equals(fiseffectplan.toString())) continue;
                containEffectMap.put(bizDataId + "_B", fid);
            }
        }
    }

    public void createSetDataByOrgId(Set<Long> defOrgIdSet, Map<String, Long> cacheHeadMap, Map<String, Long> containEffectMap) {
        String source = ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u5c5e\u6027", (String)"CalendarUpdateDataService_3", (String)"bd-mpdm-mservice", (Object[])new Object[0]);
        String ids = this.genIds(defOrgIdSet);
        String sqlHead = "select fcreateorgid,fcalendar,fclasssysteam from t_fmm_defaultorg a where a.fstatus = 'C' and a.fenable = '1' and a.fcalendar > 0 and a.fcreateorgid not in(" + ids + ")  and not exists(select b.fid from t_mpdm_calendarset b inner join t_mpdm_calendarsetentry c on b.fid = c.fid where b.fobjecttype = 'A' and b.forgid = a.fcreateorgid and c.fcalendarid = a.fcalendar ) ";
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_051"), (DBRoute)scmRoute, (String)sqlHead);){
            for (Row arow : ds) {
                Long calendarId = arow.getLong("fcalendar");
                Long createorgId = arow.getLong("fcreateorgid");
                Long classSystemId = arow.getLong("fclasssysteam");
                this.createCalendarSetData(cacheHeadMap, "A", calendarId, createorgId, 0L, 0L, true, false, false, classSystemId, source, containEffectMap);
            }
        }
    }

    public void createSetDataByWorkShopId(Map<String, Long> cacheHeadMap, Map<String, Long> containEffectMap) {
        String source = ResManager.loadKDString((String)"\u8f66\u95f4\u5c5e\u6027", (String)"CalendarUpdateDataService_4", (String)"bd-mpdm-mservice", (Object[])new Object[0]);
        String sqlHead = "select fid,fcreateorgid,fcalendar,fclasssystem from t_mpdm_workshopsetup a where a.fstatus = 'C' and a.fenable = '1' and fcalendar > 0 and not exists(select b.fid from t_mpdm_calendarset b inner join t_mpdm_calendarsetentry c on b.fid = c.fid where b.fobjecttype = 'B' and b.fworkshopid = a.fid and c.fcalendarid = a.fcalendar ) ";
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_052"), (DBRoute)scmRoute, (String)sqlHead);){
            for (Row arow : ds) {
                Long calendarId = arow.getLong("fcalendar");
                Long workShopId = arow.getLong("fid");
                Long createorgId = arow.getLong("fcreateorgid");
                Long classSystemId = arow.getLong("fclasssystem");
                this.createCalendarSetData(cacheHeadMap, "B", calendarId, createorgId, workShopId, 0L, true, false, false, classSystemId, source, containEffectMap);
            }
        }
    }

    public void createSetDataByWorkCenterId(Map<String, Long> cacheHeadMap, Map<String, Long> containEffectMap) {
        String source = ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"CalendarUpdateDataService_5", (String)"bd-mpdm-mservice", (Object[])new Object[0]);
        String sqlHead = "select fid,fcreateorgid,fcalendar,fworkshop from t_mpdm_workcentre a where a.fstatus = 'C' and a.fenable = '1' and fcalendar > 0 and not exists(select b.fid from t_mpdm_calendarset b inner join t_mpdm_calendarsetentry c on b.fid = c.fid where b.fobjecttype = 'C' and b.fworkcenterid = a.fid and c.fcalendarid = a.fcalendar ) ";
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_053"), (DBRoute)scmRoute, (String)sqlHead);){
            for (Row arow : ds) {
                Long calendarId = arow.getLong("fcalendar");
                Long workShopId = arow.getLong("fworkshop");
                Long workCenterId = arow.getLong("fid");
                Long createorgId = arow.getLong("fcreateorgid");
                Long classSystemId = 0L;
                this.createCalendarSetData(cacheHeadMap, "C", calendarId, createorgId, workShopId, workCenterId, true, false, false, classSystemId, source, containEffectMap);
            }
        }
    }

    public String genIds(Set<Long> newCalenderIdSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("0");
        if (newCalenderIdSet != null && !newCalenderIdSet.isEmpty()) {
            for (Long id : newCalenderIdSet) {
                sb.append(",").append(id);
            }
        }
        return sb.toString();
    }

    public Set<Long> syncFromPlanCalendar() {
        HashSet<Long> newIdSet = new HashSet<Long>(16);
        ArrayList<Object[]> paramHeadList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramEntryList = new ArrayList<Object[]>(128);
        ArrayList<Object[]> paramLanList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramUList = new ArrayList<Object[]>(16);
        ArrayList<Long> entryIdList = new ArrayList<Long>(128);
        String sqlHead = "select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fisdefalt,fcreatetime,fmodifytime,fmasterid,fcreateorgid ,forgid ,fctrlstrategy ,fissunrest ,fismonrest ,fistuerest ,fiswedrest,fisthurest,fisfrirest,fissatrest,fishalfsunrest,fishalfmonrest,fishalftuerest,fishalfwedrest,fishalfthurest,fishalffrirest,fishalfsatrest,fexpiringyearfrom,fexpiringmonthfrom,fexpiringyearto,fexpiringmonthto from t_mrp_plancalendar a where  not exists(select b.fid from t_mpdm_calendar b where b.fsrccalendarid  = a.fid)  ";
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_01"), (DBRoute)scmRoute, (String)sqlHead);){
            for (Row arow : ds) {
                String fctrlstrategy;
                Long fplanCalendarId = arow.getLong("fid");
                String newNumber = "PLAN_" + arow.getString("fnumber");
                Long newCalendarId = this.getPkId("t_mpdm_calendar");
                if ("1".equals(arow.getString("fisdefalt")) && "C".equals(arow.getString("fstatus")) && "1".equals(arow.getString("fenable"))) {
                    newIdSet.add(newCalendarId);
                }
                if ((fctrlstrategy = arow.getString("fctrlstrategy")) == null || "".equals(fctrlstrategy)) {
                    fctrlstrategy = "5";
                }
                paramHeadList.add(new Object[]{newCalendarId, newNumber, arow.get("fstatus"), arow.get("fcreatorid"), arow.get("fmodifierid"), arow.get("fenable"), arow.get("fcreatetime"), arow.get("fmodifytime"), newCalendarId, arow.get("fcreateorgid"), arow.get("forgid"), fctrlstrategy, arow.get("fissunrest"), arow.get("fismonrest"), arow.get("fistuerest"), arow.get("fiswedrest"), arow.get("fisthurest"), arow.get("fisfrirest"), arow.get("fissatrest"), arow.get("fishalfsunrest"), arow.get("fishalfmonrest"), arow.get("fishalftuerest"), arow.get("fishalfwedrest"), arow.get("fishalfthurest"), arow.get("fishalffrirest"), arow.get("fishalfsatrest"), arow.get("fexpiringyearfrom"), arow.get("fexpiringmonthfrom"), arow.get("fexpiringyearto"), arow.get("fexpiringmonthto"), fplanCalendarId});
                DataSet entryDs = this.queryEntryData(fplanCalendarId);
                for (Row entryRow : entryDs) {
                    paramEntryList.add(new Object[]{newCalendarId, this.getEntryId(entryIdList, "t_mpdm_calendarentry", 1000), entryRow.get("fseq"), entryRow.get("fworkdate"), entryRow.get("fdatetype")});
                }
                entryDs.close();
                DataSet lanDs = this.queryLanData(fplanCalendarId);
                for (Row lanRow : lanDs) {
                    paramLanList.add(new Object[]{this.getLanTableId("t_mpdm_calendar_l"), newCalendarId, lanRow.get("flocaleid"), lanRow.get("fname")});
                }
                lanDs.close();
                paramUList.add(new Object[]{newCalendarId, arow.get("fcreateorgid")});
            }
        }
        if (!paramUList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildCalendarUInsertSql(), paramUList);
        }
        if (!paramLanList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildCalendarLanInsertSql(), paramLanList);
        }
        if (!paramEntryList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildCalendarEntryInsertSql(), paramEntryList);
        }
        if (!paramHeadList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildCalendarHeadInsertSql(), paramHeadList);
        }
        return newIdSet;
    }

    public Map<String, String> getOrgNumberName(Long bizDateId, String objectType) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        DBRoute execRoute = sysRoute;
        String orgSql = "select fname,fnumber from t_org_org where fid = ?  ";
        if ("B".equals(objectType)) {
            orgSql = "select fname,fnumber from t_mpdm_workshopsetup where fid = ?  ";
            execRoute = scmRoute;
        } else if ("C".equals(objectType)) {
            orgSql = "select a.fnumber,b.fname from t_mpdm_workcentre a left join t_mpdm_workcentre_l b on a.fid = b.fid and b.FLOCALEID = 'zh_CN' where a.fid = ?  ";
            execRoute = scmRoute;
        }
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_07"), (DBRoute)execRoute, (String)orgSql, (Object[])new Object[]{bizDateId});){
            for (Row arow : ds) {
                dataMap.put("number", arow.getString("fnumber"));
                dataMap.put("name", arow.getString("fname"));
            }
        }
        return dataMap;
    }

    public Long getClassSystemId(Long orgId) {
        String orgSql = "select fclasssysteam from t_fmm_defaultorg where fcreateorgid = ? and fclasssysteam > 0 ";
        Long id = 0L;
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_09"), (DBRoute)scmRoute, (String)orgSql, (Object[])new Object[]{orgId});){
            for (Row arow : ds) {
                id = arow.getLong("fclasssysteam");
            }
        }
        return id;
    }

    public int getMaxSeq(Long id) {
        String orgSql = " select fseq from t_mpdm_calendarsetentry where fid = ? order by fseq ";
        int maxSeq = 0;
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_10"), (DBRoute)scmRoute, (String)orgSql, (Object[])new Object[]{id});){
            for (Row arow : ds) {
                maxSeq = arow.getInteger("fseq");
            }
        }
        return maxSeq + 1;
    }

    public Set<Long> createSetDataByCalenderId(Set<Long> newCalenderIdSet, Map<String, Long> cacheHeadMap, Map<String, Long> containEffectMap) {
        String source = ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386", (String)"CalendarUpdateDataService_2", (String)"bd-mpdm-mservice", (Object[])new Object[0]);
        HashSet<Long> defOrgIdSet = new HashSet<Long>(16);
        String sqlHead = "select fid,fcreateorgid,fsrccalendarid from t_mpdm_calendar a where  fstatus  = 'C' and fenable  = '1' and (a.fisdefalt = '1' or a.fid in (" + this.genIds(newCalenderIdSet) + ")) and not exists(select b.fid from t_mpdm_calendarset b inner join t_mpdm_calendarsetentry c on b.fid = c.fid where b.fobjecttype = 'A' and b.forgid = a.fcreateorgid and c.fcalendarid = a.fid ) order by fcreateorgid  ";
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_05"), (DBRoute)scmRoute, (String)sqlHead);){
            for (Row arow : ds) {
                Long calendarId = arow.getLong("fid");
                Long createorgId = arow.getLong("fcreateorgid");
                Long fsrccalendarid = arow.getLong("fsrccalendarid");
                boolean isEffectProduct = fsrccalendarid == null || fsrccalendarid.equals(0L);
                boolean isEffectPlan = fsrccalendarid != null && !fsrccalendarid.equals(0L);
                Long classSystemId = this.getClassSystemId(createorgId);
                if (isEffectProduct) {
                    defOrgIdSet.add(createorgId);
                }
                this.createCalendarSetData(cacheHeadMap, "A", calendarId, createorgId, 0L, 0L, isEffectProduct, isEffectPlan, false, classSystemId, source, containEffectMap);
            }
        }
        return defOrgIdSet;
    }

    public void createCalendarSetData(Map<String, Long> cacheHeadMap, String objecttype, Long calendarId, Long orgId, Long workShopId, Long workCenterId, boolean isEffectProduct, boolean isEffectPlan, boolean isEffectProject, Long classSystemId, String source, Map<String, Long> containEffectMap) {
        Long newSetId;
        Long bizDataId = "C".equals(objecttype) ? workCenterId : ("B".equals(objecttype) ? workShopId : orgId);
        ArrayList<Object[]> paramHeadList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramEntryList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramLanList = new ArrayList<Object[]>(16);
        ArrayList<Long> entryIdList = new ArrayList<Long>(128);
        int orgSeq = 0;
        Long currentUserId = 1L;
        Date currentDate = new Date();
        if (isEffectProduct && containEffectMap.containsKey(bizDataId + "_A")) {
            isEffectProduct = false;
        }
        if (isEffectPlan && containEffectMap.containsKey(bizDataId + "_B")) {
            isEffectPlan = false;
        }
        if ((newSetId = cacheHeadMap.get(objecttype + "_" + bizDataId)) == null || newSetId.equals(0L)) {
            newSetId = this.getPkId("t_mpdm_calendarset");
            Map<String, String> orgMap = this.getOrgNumberName(bizDataId, objecttype);
            String newNumber = objecttype + "_" + orgMap.get("number");
            String newName = objecttype + "_" + orgMap.get("name");
            paramHeadList.add(new Object[]{newSetId, newNumber, newName, currentUserId, currentUserId, currentDate, currentDate, newSetId, objecttype, orgId, workShopId, workCenterId});
            paramLanList.add(new Object[]{this.getLanTableId("t_mpdm_calendarset_l"), newSetId, "zh_CN", newName, String.format(ResManager.loadKDString((String)"\u7531%1$s\u521d\u59cb\u5316\u751f\u6210", (String)"CalendarUpdateDataService_1", (String)"bd-mpdm-mservice", (Object[])new Object[0]), source)});
            cacheHeadMap.put(objecttype + "_" + bizDataId, newSetId);
            orgSeq = 1;
        } else {
            orgSeq = this.getMaxSeq(newSetId);
        }
        paramEntryList.add(new Object[]{newSetId, this.getEntryId(entryIdList, "t_mpdm_calendarsetentry", 10), orgSeq, calendarId, isEffectProduct, isEffectPlan, isEffectProject, classSystemId});
        if (!paramLanList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildSetLanInsertSql(), paramLanList);
        }
        if (!paramEntryList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildSetEntryInsertSql(), paramEntryList);
        }
        if (!paramHeadList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildSetHeadInsertSql(), paramHeadList);
        }
        if (isEffectProduct) {
            containEffectMap.put(bizDataId + "_A", newSetId);
        }
        if (isEffectPlan) {
            containEffectMap.put(bizDataId + "_B", newSetId);
        }
    }

    public Long getEntryId(List<Long> entryIdList, String table, int batchSize) {
        if (entryIdList.isEmpty()) {
            long[] entryIds;
            for (long id : entryIds = DB.genLongIds((String)table, (int)batchSize)) {
                entryIdList.add(id);
            }
        }
        Long id = entryIdList.get(0);
        entryIdList.remove(0);
        return id;
    }

    public DataSet queryEntryData(Long id) {
        String sqlEntry = "select fid,fentryid,fseq,fworkdate,fdatetype from t_mrp_plancalendarentry where fid = ? order by fseq  ";
        return DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_03"), (DBRoute)scmRoute, (String)sqlEntry, (Object[])new Object[]{id});
    }

    public DataSet queryLanData(Long id) {
        String sqlEntry = "select fpkid,fid,flocaleid ,fname from t_mrp_plancalendar_l where fid = ? ";
        return DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_04"), (DBRoute)scmRoute, (String)sqlEntry, (Object[])new Object[]{id});
    }

    public String buildCalendarHeadInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_mpdm_calendar(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fcreateorgid ,forgid ,fctrlstrategy ,fissunrest ,fismonrest ,fistuerest ,fiswedrest,fisthurest,fisfrirest,fissatrest,fishalfsunrest,fishalfmonrest,fishalftuerest,fishalfwedrest,fishalfthurest,fishalffrirest,fishalfsatrest,fexpiringyearfrom,fexpiringmonthfrom,fexpiringyearto,fexpiringmonthto,fisdefalt,fisindividuation,fisrsyncplancalendar,fsrccalendarid)");
        sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','0','0',?)");
        return sql.toString();
    }

    public String buildCalendarEntryInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_mpdm_calendarentry(fid,fentryid,fseq,fworkdate,fdatetype)");
        sql.append(" values(?,?,?,?,?)");
        return sql.toString();
    }

    public String buildCalendarLanInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_mpdm_calendar_l(fpkid,fid,flocaleid,fname)");
        sql.append(" values(?,?,?,?)");
        return sql.toString();
    }

    public String buildCalendarUInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_mpdm_calendar_u(FDataID,FUseOrgID)");
        sql.append(" values(?,?)");
        return sql.toString();
    }

    private Long getPkId(String tableName) {
        return DB.genLongId((String)tableName);
    }

    private String getLanTableId(String tableName) {
        return DB.genStringId((String)tableName);
    }

    public String buildSetHeadInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_mpdm_calendarset(fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fobjecttype,forgid,fworkshopid,fworkcenterid)");
        sql.append(" values(?,?,?,'A',?,?,'1',?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public String buildSetEntryInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_mpdm_calendarsetentry(fid,fentryid,fseq,fcalendarid,fiseffectproduct,fiseffectplan,fiseffectproject,fclasssystemid)");
        sql.append(" values(?,?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public String buildSetLanInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_mpdm_calendarset_l(fpkid,fid,flocaleid,fname,fremark)");
        sql.append(" values(?,?,?,?,?)");
        return sql.toString();
    }

    public void updateBeginAndEndDate() {
        String sql = "select fid,fexpiringyearfrom ,fexpiringmonthfrom ,fexpiringyearto ,fexpiringmonthto from t_mpdm_calendar  ";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(64);
        try (DataSet ds = DB.queryDataSet((String)(CalendarUpdateDataService.class.getName() + "_02"), (DBRoute)scmRoute, (String)sql);){
            for (Row arow : ds) {
                Long id = arow.getLong("fid");
                String fexpiringyearfrom = arow.getString("fexpiringyearfrom");
                String fexpiringmonthfrom = arow.getString("fexpiringmonthfrom");
                String fexpiringyearto = arow.getString("fexpiringyearto");
                String fexpiringmonthto = arow.getString("fexpiringmonthto");
                if (StringUtils.isEmpty((String)fexpiringyearfrom) || StringUtils.isEmpty((String)fexpiringmonthfrom) || StringUtils.isEmpty((String)fexpiringyearto) || StringUtils.isEmpty((String)fexpiringmonthto)) continue;
                Date startDate = this.getMinMaxDate(this.getFirstDayOfMonth(Integer.parseInt(fexpiringyearfrom), Integer.parseInt(fexpiringmonthfrom)), true);
                Date endDate = this.getMinMaxDate(this.getLastDayOfMonth(Integer.parseInt(fexpiringyearto), Integer.parseInt(fexpiringmonthto)), false);
                paramList.add(new Object[]{startDate, endDate, id});
            }
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)updateSql, paramList);
        }
    }

    public Date getMinMaxDate(Date date, boolean isMin) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateFormat.format(date) + (isMin ? " 00:00:00" : " 23:59:59"));
        }
        catch (ParseException parseException) {
            return date;
        }
    }

    public Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }
}

