/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.workcard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.workcardinfo.MroCardGeneratePhotoUtils;
import kd.bd.mpdm.mservice.api.workcard.IWorkCardDataService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class WorkCardDataServiceImpl
implements IWorkCardDataService {
    private static final String strsql = "id,number,name,cardname,cardnum,cardversion,maintrade,majorflag,largemajordesc,largemajordesc_tag,mulmajordesc,group,traderelation.fbasedataid,relentryentity1.doctype,relentryentity1.docnum,relentryentity1.docversion,relentryentity1.docsecltion,relentryentity1.docpart,relentryentity1.docparagraph,relentryentity1.docpagenum,relentryentity1.docattachment,relentryentity1.docremark";
    private static final String strsql2 = "id,number,name,cardname,cardnum,cardversion,maintrade,majorflag,largemajordesc,largemajordesc_tag,mulmajordesc,group,relentryentity1.doctype,relentryentity1.docnum,relentryentity1.docversion,relentryentity1.docsecltion,relentryentity1.docpart,relentryentity1.docparagraph,relentryentity1.docpagenum,relentryentity1.docattachment,relentryentity1.docremark";
    private static final String cardmatcommandsql = "id,workcard,workcard.number,materialmodelone,version,needmaterial,cabinconfig,entryentity.entrytype,entryentity.entrymaterial,entryentity.entrymftmaterial,entryentity.entryqty,entryentity.enrtyunit,entryentity.baseqty,entryentity.entrybaseunit,entryentity.isrequireqtyset,entryentity.paramremark,entryentity.entryprofessiona,entryentity.docattachment,entryentity.isentryqtylimit,entryentity.entrylimittop,entryentity.entrylimitlow,entryentity.cabinconfigsen,entryentity.issuemode,entryentity.entryresptype,entryentity.entryownertype,entryentity.validdate,entryentity.invaliddate";
    private static final String cardtooldemandsql = "id,workcard,workcard.number,entryentity.entrymaterial,entryentity.entrybaseunit,entryentity.entrybaseqty,entryentity.enrtyunit,entryentity.entryqty,entryentity.toolsubgroup,entryentity.entryownertype,entryentity.entryowner,entryentity.entrymandatory,entryentity.supplyorg,entryentity.warehouse,entryentity.location,entryentity.entryhistoryusetime,entryentity.entryremark";
    private static final String cardimpexperiencesql = "id,cardnum,cardnum.number,entryentity.l1mpd,entryentity.lvtwo,entryentity.enginemodel,entryentity.enginemodel.modeltrd,entryentity.describe";
    private static final String MPDM_MROCARDROUTE = "mpdm_mrocardroute";
    private static final String MPDM_CARDMATCOMMAND = "mpdm_cardmatcommand";
    private static final String MPDM_CARDTOOLDEMAN = "mpdm_cardtooldemand";
    private static final String MPDM_CARDIMPEXPERIE = "mpdm_cardimpexperience";
    private static final Log logger = LogFactory.getLog(WorkCardDataServiceImpl.class);

    public Map<String, Map<String, List<Map<String, Object>>>> getWorkCardDataNew(Set<Long> cardId, Long modelone, Long modeltwo, String manuFacturer, Long orgid, Long cabinconfigId) {
        HashMap<String, Map<String, List<Map<String, Object>>>> resultMap = new HashMap<String, Map<String, List<Map<String, Object>>>>(16);
        logger.info("\u5165\u53c2cardId" + cardId.toString() + "modelone:" + modelone + ",modeltwo:" + modeltwo + ",manuFacturer:" + manuFacturer);
        logger.info("\u5165\u53c2orgid:" + orgid + ",cabinconfigId:" + cabinconfigId);
        QFilter qf2 = new QFilter("id", "in", cardId);
        qf2.and(new QFilter("enable", "=", (Object)"1"));
        qf2.and(new QFilter("status", "=", (Object)"C"));
        logger.info("WorkCardDataServiceImpl---qf2:" + qf2.toString());
        Map<String, List<Map<String, Object>>> cardData = this.getWorkCardinfo(qf2, MPDM_MROCARDROUTE, strsql);
        logger.info("WorkCardDataServiceImpl---cardData:" + cardData.toString());
        for (Map.Entry<String, List<Map<String, Object>>> entry : cardData.entrySet()) {
            HashMap<String, List<Map<String, Object>>> hashMap = new HashMap<String, List<Map<String, Object>>>(16);
            hashMap.put("mrocardroute", entry.getValue());
            resultMap.put(entry.getKey(), hashMap);
        }
        Map<String, List<Map<String, Object>>> commandData = this.getMatcommand(cardId, orgid, modelone, cabinconfigId, MPDM_CARDMATCOMMAND, cardmatcommandsql);
        logger.info("WorkCardDataServiceImpl---commandData:" + commandData.toString());
        for (Map.Entry<String, List<Map<String, Object>>> entry : commandData.entrySet()) {
            String string = entry.getKey();
            String[] split = string.split("@@");
            if (!resultMap.containsKey(split[0])) continue;
            Map map = (Map)resultMap.get(split[0]);
            map.put("cardmatcommand", entry.getValue());
        }
        Map<String, List<Map<String, Object>>> map = this.getToolData(cardId, orgid, MPDM_CARDTOOLDEMAN, cardtooldemandsql);
        logger.info("WorkCardDataServiceImpl---toolData:" + map.toString());
        for (Map.Entry<String, List<Map<String, Object>>> entry : map.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("@@");
            if (!resultMap.containsKey(split[0])) continue;
            Map map2 = (Map)resultMap.get(split[0]);
            map2.put("cardtooldemand", entry.getValue());
        }
        Map<String, List<Map<String, Object>>> map3 = this.getImpexperieData(cardId, orgid, modelone, modeltwo, manuFacturer, MPDM_CARDIMPEXPERIE, cardimpexperiencesql);
        logger.info("WorkCardDataServiceImpl---impexperieData:" + map3.toString());
        for (Map.Entry<String, List<Map<String, Object>>> cdata : map3.entrySet()) {
            String key = cdata.getKey();
            String[] split = key.split("@@");
            if (!resultMap.containsKey(split[0])) continue;
            Map map4 = (Map)resultMap.get(split[0]);
            map4.put("cardimpexperience", cdata.getValue());
        }
        logger.info("WorkCardDataServiceImpl---resultMap:" + ((Object)resultMap).toString());
        return resultMap;
    }

    private Map<String, List<Map<String, Object>>> getMatcommand(Set<Long> cardId, Long orgid, Long modelone, Long cabinconfigId, String entityNum, String sql) {
        QFilter cardmatcommandqf = new QFilter("workcard", "in", cardId);
        cardmatcommandqf.and(BaseDataServiceHelper.getBaseDataFilter((String)MPDM_CARDMATCOMMAND, (Long)orgid));
        cardmatcommandqf.and("materialmodelone", "=", (Object)modelone);
        cardmatcommandqf.and("isnewversion", "=", (Object)"1");
        cardmatcommandqf.and("cabinconfig", "=", (Object)cabinconfigId);
        cardmatcommandqf.and(new QFilter("enable", "=", (Object)"1"));
        cardmatcommandqf.and(new QFilter("status", "=", (Object)"C"));
        logger.info("WorkCardDataServiceImpl---batch--cardmatcommandqf:" + cardmatcommandqf.toString());
        HashMap<String, List<Map<String, Object>>> resMap = new HashMap<String, List<Map<String, Object>>>();
        HashMap<String, String> unionMap = new HashMap<String, String>();
        String[] split = sql.split(",");
        boolean flag = true;
        StringBuilder errorStr = new StringBuilder();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"servicequerymatcommand", (String)entityNum, (String)sql, (QFilter[])new QFilter[]{cardmatcommandqf}, (String)"");){
            while (dataSet.hasNext()) {
                ArrayList<HashMap<String, Object>> matList;
                Row row = dataSet.next();
                String id = row.getString("id");
                String workcard = row.getString("workcard");
                String modelmpdone = row.getString("materialmodelone");
                String workcardnumber = row.getString("workcard.number");
                String cabinconfig = row.getString("cabinconfig");
                String unionKey = workcard + "@@" + modelmpdone + "@@" + cabinconfig;
                if (unionMap.containsKey(unionKey)) {
                    String unionid = (String)unionMap.get(unionKey);
                    if (!unionid.equals(id)) {
                        flag = false;
                        errorStr.append(String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s,\u578b\u53f7%2$s\u7684\u7269\u6599\u9700\u6c42\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"WorkCardDataServiceImpl_2", (String)"bd-mpdm-mservice", (Object[])new Object[0]), workcardnumber, modelmpdone));
                    }
                } else {
                    unionMap.put(unionKey, id);
                }
                HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
                if (flag) {
                    for (String str : split) {
                        tempMap.put(str, row.get(str));
                    }
                    if (resMap.containsKey(unionKey)) {
                        List tempList = (List)resMap.get(unionKey);
                        tempList.add(tempMap);
                        resMap.put(unionKey, tempList);
                        continue;
                    }
                    matList = new ArrayList(10);
                    matList.add(tempMap);
                    resMap.put(unionKey, matList);
                    continue;
                }
                matList = new ArrayList<HashMap<String, Object>>(10);
                tempMap.put("errorinfo", errorStr.toString());
                matList.add(tempMap);
                resMap.put(unionKey, matList);
                flag = true;
                errorStr = new StringBuilder();
            }
        }
        return resMap;
    }

    private Map<String, List<Map<String, Object>>> getImpexperieData(Set<Long> cardId, Long orgid, Long modelone, Long modeltwo, String manuFacturer, String entityNum, String sql) {
        QFilter impexperieqf = new QFilter("cardnum", "in", cardId);
        impexperieqf.and(new QFilter("enable", "=", (Object)"1"));
        impexperieqf.and(new QFilter("status", "=", (Object)"C"));
        impexperieqf.and(new QFilter("entryentity.enginemodel.modeltrd", "=", (Object)manuFacturer));
        impexperieqf.and(BaseDataServiceHelper.getBaseDataFilter((String)MPDM_CARDIMPEXPERIE, (Long)orgid));
        QFilter impexperieqf2 = new QFilter("entryentity.l1mpd", "=", (Object)modelone).or(new QFilter("entryentity.l1mpd", "=", (Object)0L));
        QFilter impexperieqf3 = new QFilter("entryentity.lvtwo", "=", (Object)modeltwo).or(new QFilter("entryentity.lvtwo", "=", (Object)0L));
        impexperieqf.and(impexperieqf2);
        impexperieqf.and(impexperieqf3);
        logger.info("WorkCardDataServiceImpl---batch--impexperieqf:" + impexperieqf.toString());
        HashMap<String, List<Map<String, Object>>> resMap = new HashMap<String, List<Map<String, Object>>>(16);
        HashMap<String, String> unionMap = new HashMap<String, String>(16);
        String[] split = sql.split(",");
        StringBuilder errorStr = new StringBuilder();
        boolean flag = true;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"servicequeryimpexperie", (String)entityNum, (String)sql, (QFilter[])new QFilter[]{impexperieqf}, (String)"");){
            while (dataSet.hasNext()) {
                ArrayList<HashMap<String, Object>> matList;
                Row row = dataSet.next();
                String id = row.getString("id");
                String workcard = row.getString("cardnum");
                String modelonestr = row.getString("entryentity.l1mpd");
                String modeltwostr = row.getString("entryentity.lvtwo");
                String modeltrd = row.getString("entryentity.enginemodel.modeltrd");
                String unionKey = workcard + "@@" + modelonestr + "@@" + modeltwostr + "@@" + modeltrd;
                if (unionMap.containsKey(unionKey)) {
                    String unionid = (String)unionMap.get(unionKey);
                    if (!unionid.equals(id)) {
                        String[] workcardnumber = row.getString("cardnum.number");
                        flag = false;
                        errorStr.append(String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s,\u7684\u5b9e\u65bd\u7ecf\u9a8c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"WorkCardDataServiceImpl_1", (String)"bd-mpdm-mservice", (Object[])new Object[0]), new Object[]{workcardnumber}));
                    }
                } else {
                    unionMap.put(unionKey, id);
                }
                HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
                if (flag) {
                    for (String str : split) {
                        tempMap.put(str, row.get(str));
                    }
                    if (resMap.containsKey(unionKey)) {
                        List tempList = (List)resMap.get(unionKey);
                        tempList.add(tempMap);
                        resMap.put(unionKey, tempList);
                        continue;
                    }
                    matList = new ArrayList(10);
                    matList.add(tempMap);
                    resMap.put(unionKey, matList);
                    continue;
                }
                matList = new ArrayList<HashMap<String, Object>>(10);
                tempMap.put("errorinfo", errorStr.toString());
                matList.add(tempMap);
                resMap.put(unionKey, matList);
                flag = true;
                errorStr = new StringBuilder();
            }
        }
        return resMap;
    }

    private Map<String, List<Map<String, Object>>> getToolData(Set<Long> cardId, Long orgid, String entityNum, String sql) {
        QFilter tooldemanqf = new QFilter("workcard", "in", cardId);
        tooldemanqf.and(BaseDataServiceHelper.getBaseDataFilter((String)MPDM_CARDTOOLDEMAN, (Long)orgid));
        tooldemanqf.and(new QFilter("enable", "=", (Object)"1"));
        tooldemanqf.and(new QFilter("status", "=", (Object)"C"));
        logger.info("WorkCardDataServiceImpl---batch--tooldemanqf:" + tooldemanqf.toString());
        HashMap<String, List<Map<String, Object>>> resMap = new HashMap<String, List<Map<String, Object>>>(16);
        HashMap<String, String> unionMap = new HashMap<String, String>(16);
        String[] split = sql.split(",");
        boolean flag = true;
        StringBuilder errorStr = new StringBuilder();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"servicequerytool", (String)entityNum, (String)sql, (QFilter[])new QFilter[]{tooldemanqf}, (String)"");){
            while (dataSet.hasNext()) {
                ArrayList<HashMap<String, Object>> matList;
                Row row = dataSet.next();
                String id = row.getString("id");
                String workcard = row.getString("workcard");
                if (unionMap.containsKey(workcard)) {
                    String unionid = (String)unionMap.get(workcard);
                    if (!unionid.equals(id)) {
                        flag = false;
                        errorStr.append(String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s,\u7684\u5de5\u5177\u9700\u6c42\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"WorkCardDataServiceImpl_0", (String)"bd-mpdm-mservice", (Object[])new Object[0]), row.getString("workcard.number")));
                    }
                } else {
                    unionMap.put(workcard, id);
                }
                HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
                if (flag) {
                    for (String str : split) {
                        tempMap.put(str, row.get(str));
                    }
                    if (resMap.containsKey(workcard)) {
                        List tempList = (List)resMap.get(workcard);
                        tempList.add(tempMap);
                        resMap.put(workcard, tempList);
                        continue;
                    }
                    matList = new ArrayList(10);
                    matList.add(tempMap);
                    resMap.put(workcard, matList);
                    continue;
                }
                matList = new ArrayList<HashMap<String, Object>>(10);
                tempMap.put("errorinfo", errorStr.toString());
                matList.add(tempMap);
                resMap.put(workcard, matList);
                flag = true;
                errorStr = new StringBuilder();
            }
        }
        return resMap;
    }

    private Map<String, List<Map<String, Object>>> getWorkCardinfo(QFilter qf2, String entityNum, String sql) {
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>(16);
        String[] split = sql.split(",");
        DataSet dSet = QueryServiceHelper.queryDataSet((String)"servicequerycard", (String)entityNum, (String)sql, (QFilter[])new QFilter[]{qf2}, (String)"");
        DataSet dataSet = dSet.groupBy(strsql2.split(",")).groupConcat("traderelation.fbasedataid", "traderelation.fbasedataid", ",").finish();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String id = row.getString("id");
            HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
            for (String str : split) {
                if ("largemajordesc".equals(str)) {
                    tempMap.put(str, row.get("largemajordesc_tag"));
                    continue;
                }
                tempMap.put(str, row.get(str));
            }
            if (resultMap.containsKey(id)) {
                List tempList = (List)resultMap.get(id);
                tempList.add(tempMap);
                resultMap.put(id, tempList);
                continue;
            }
            ArrayList<HashMap<String, Object>> matList = new ArrayList<HashMap<String, Object>>(10);
            matList.add(tempMap);
            resultMap.put(id, matList);
        }
        dSet.close();
        dataSet.close();
        return resultMap;
    }

    public Map<String, Map<String, List<Map<String, Object>>>> getWorkCardDataNew(Set<Long> cardId, Long modelone, Long modeltwo, String manuFacturer, Long orgid) {
        Map<String, Map<String, List<Map<String, Object>>>> workCardData = this.getWorkCardDataNew(cardId, modelone, modeltwo, manuFacturer, orgid, 0L);
        return workCardData;
    }

    public Map<String, Map<String, List<Map<String, Object>>>> getWorkCardData(Set<Long> cardId, String modelone, String modeltwo, String manuFacturer, Long orgid, Long cabinconfigId) {
        Map<String, Map<String, List<Map<String, Object>>>> workCardData = this.getWorkCardDataNew(cardId, 0L, 0L, manuFacturer, orgid, 0L);
        return workCardData;
    }

    public Map<String, Map<String, List<Map<String, Object>>>> getWorkCardData(Set<Long> cardId, String modelone, String modeltwo, String manuFacturer, Long orgid) {
        Map<String, Map<String, List<Map<String, Object>>>> workCardData = this.getWorkCardDataNew(cardId, 0L, 0L, manuFacturer, orgid, 0L);
        return workCardData;
    }

    public Map<String, Map<String, List<Map<String, Object>>>> getBatchWorkCardData(List<Map<String, Object>> paramList, Long orgid) {
        HashMap<String, Map<String, List<Map<String, Object>>>> resultMap = new HashMap<String, Map<String, List<Map<String, Object>>>>(16);
        HashSet<Long> cardId = new HashSet<Long>(16);
        for (Map<String, Object> single : paramList) {
            Set mrocardroute = (Set)single.get("cardId");
            cardId.addAll(mrocardroute);
        }
        QFilter qf2 = new QFilter("id", "in", cardId);
        qf2.and(new QFilter("enable", "=", (Object)"1"));
        qf2.and(new QFilter("status", "=", (Object)"C"));
        logger.info("WorkCardDataServiceImpl---batch--qf2:" + qf2.toString());
        Map<String, List<Map<String, Object>>> cardData = this.getWorkCardinfo(qf2, MPDM_MROCARDROUTE, strsql);
        logger.info("WorkCardDataServiceImpl---batch--cardData:" + cardData.toString());
        for (Map.Entry<String, List<Map<String, Object>>> entry : cardData.entrySet()) {
            HashMap<String, List<Map<String, Object>>> subcard = new HashMap<String, List<Map<String, Object>>>(16);
            subcard.put("mrocardroute", entry.getValue());
            resultMap.put(entry.getKey(), subcard);
        }
        for (Map map : paramList) {
            Map.Entry<String, List<Map<String, Object>>> cdata22;
            Set mrocardroute = (Set)map.get("cardId");
            Long modelone = (Long)map.get("modelone");
            Long modeltwo = (Long)map.get("modeltwo");
            String manuFacturer = (String)map.get("manuFacturer");
            Long cabinconfigId = (Long)map.get("cabinconfigId");
            logger.info("batch--\u5165\u53c2cardId" + mrocardroute.toString() + "modelone:" + modelone + ",modeltwo:" + modeltwo + ",manuFacturer:" + manuFacturer);
            logger.info("batch--\u5165\u53c2orgid:" + orgid + ",cabinconfigId:" + cabinconfigId);
            Map<String, List<Map<String, Object>>> commandData = this.getMatcommand(mrocardroute, orgid, modelone, cabinconfigId, MPDM_CARDMATCOMMAND, cardmatcommandsql);
            logger.info("WorkCardDataServiceImpl---batch--commandData:" + commandData.toString());
            for (Map.Entry<String, List<Map<String, Object>>> cdata22 : commandData.entrySet()) {
                String key = cdata22.getKey();
                String[] split = key.split("@@");
                if (!resultMap.containsKey(split[0])) continue;
                Map map2 = (Map)resultMap.get(split[0]);
                map2.put("cardmatcommand", cdata22.getValue());
            }
            Map<String, List<Map<String, Object>>> toolData = this.getToolData(mrocardroute, orgid, MPDM_CARDTOOLDEMAN, cardtooldemandsql);
            logger.info("WorkCardDataServiceImpl---batch--toolData:" + toolData.toString());
            cdata22 = toolData.entrySet().iterator();
            while (cdata22.hasNext()) {
                Map.Entry cdata3 = (Map.Entry)cdata22.next();
                String key = (String)cdata3.getKey();
                String[] split = key.split("@@");
                if (!resultMap.containsKey(split[0])) continue;
                Map map3 = (Map)resultMap.get(split[0]);
                map3.put("cardtooldemand", cdata3.getValue());
            }
            Map<String, List<Map<String, Object>>> impexperieData = this.getImpexperieData(cardId, orgid, modelone, modeltwo, manuFacturer, MPDM_CARDIMPEXPERIE, cardimpexperiencesql);
            logger.info("WorkCardDataServiceImpl---batch--impexperieData:" + impexperieData.toString());
            for (Map.Entry<String, List<Map<String, Object>>> cdata4 : impexperieData.entrySet()) {
                String key = cdata4.getKey();
                String[] split = key.split("@@");
                if (!resultMap.containsKey(split[0])) continue;
                Map map4 = (Map)resultMap.get(split[0]);
                map4.put("cardimpexperience", cdata4.getValue());
            }
            logger.info("WorkCardDataServiceImpl---resultMap:" + ((Object)resultMap).toString());
        }
        return resultMap;
    }

    public void generatePhoto(Set<Long> cardidSet) {
        logger.info("WorkCardDataServiceImpl---generatePhoto:" + cardidSet.toString());
        if (!cardidSet.isEmpty()) {
            QFilter qf = new QFilter("id", "in", cardidSet);
            Map cardMap = BusinessDataServiceHelper.loadFromCache((String)MPDM_MROCARDROUTE, (QFilter[])new QFilter[]{qf});
            logger.info("WorkCardDataServiceImpl---generatePhoto---data:" + cardMap.toString());
            for (Map.Entry mmap : cardMap.entrySet()) {
                DynamicObject card = (DynamicObject)mmap.getValue();
                MroCardGeneratePhotoUtils.generateHistory((DynamicObject)card);
            }
        }
    }
}

