/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.mservice.workcenter.service;

import java.util.ArrayList;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;

public class SyncWorkCenterResDataService {
    private static final Log logger = LogFactory.getLog(SyncWorkCenterResDataService.class);
    private static String regx = "^[0-9]*$";

    public static UpgradeResult handleHistoryData() {
        UpgradeResult result = new UpgradeResult();
        logger.info("\u5f00\u59cb\u5904\u7406\u5de5\u4f5c\u4e2d\u5fc3\u8d44\u6e90\u5386\u53f2\u6570\u636e...");
        long startTime = System.currentTimeMillis();
        String querySql = "select fentryid as entryid, fresourcenumber as resourcenumber from t_mpdm_workcentreentryb where fresourcenumber is not null";
        DataSet dataSet = DB.queryDataSet((String)"kd.bd.mpdm.mservice.workcenter.service.SyncWorkCenterResDataService", (DBRoute)DBRoute.of((String)"scm"), (String)querySql);
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(128);
        if (dataSet != null && dataSet.hasNext()) {
            while (dataSet.hasNext()) {
                Row rowData = dataSet.next();
                long entryid = rowData.getLong("entryid");
                String resourcenumber = rowData.getString("resourcenumber");
                if (!StringUtils.isNotBlank((CharSequence)resourcenumber) || !Pattern.matches(regx, resourcenumber)) continue;
                long resource = Long.parseLong(resourcenumber);
                updateList.add(new Object[]{resource, entryid});
            }
        }
        logger.info("\u6570\u636e\u91cf\uff1a" + updateList.size());
        if (!updateList.isEmpty()) {
            String updateSql = "update t_mpdm_workcentreentryb set fresource = ? where fentryid = ? and (fresource = 0 or fresource is null)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, updateList);
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff1b");
        result.setLog("succuss");
        result.setSuccess(true);
        return result;
    }
}

