/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.bomtemplet;

import java.util.ArrayList;
import kd.bd.mpdm.business.helper.MaterialHelper;
import kd.bd.mpdm.common.bomcache.BomUtils;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BOMSaveValidator
extends AbstractValidator {
    public static final DBRoute scmDBRoute = new DBRoute("scm");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("save".equalsIgnoreCase(operate) || "submit".equalsIgnoreCase(operate) || "audit".equalsIgnoreCase(operate)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            boolean isUseBomCtrlStrategyCache = false;
            boolean isUseBomOrgFilterCache = false;
            try {
                for (ExtendedDataEntity obj : objs) {
                    QFilter qFilter;
                    DynamicObject createOrg;
                    String ctrlStrategy;
                    IDataEntityType mainEntityType;
                    DynamicObject bom = obj.getDataEntity();
                    if (bom == null || (mainEntityType = bom.getDataEntityType()) == null) continue;
                    String entityKey = mainEntityType.getName();
                    qFilterList.clear();
                    Long id = (Long)bom.getPkValue();
                    if (!"0".equalsIgnoreCase(id.toString())) {
                        QFilter qFilter2 = new QFilter("id", "!=", (Object)id);
                        qFilterList.add(qFilter2);
                    }
                    if (StringUtils.isBlank((CharSequence)(ctrlStrategy = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)bom, (String)"ctrlstrategy")))) {
                        ctrlStrategy = BomUtils.getBomCtrlStrategyCache((String)entityKey);
                        isUseBomCtrlStrategyCache = true;
                        bom.set("ctrlstrategy", (Object)ctrlStrategy);
                    }
                    if ((createOrg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"createorg")) == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u3002", (String)"BOMSaveValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                        continue;
                    }
                    QFilter qFilter3 = BomUtils.getBomOrgFilterCache((DynamicObject)createOrg, (String)entityKey, (String)ctrlStrategy);
                    isUseBomOrgFilterCache = true;
                    if (qFilter3 != null) {
                        qFilterList.add(qFilter3);
                    }
                    qFilter3 = new QFilter("createorg", "=", (Object)createOrg.getLong("id"));
                    String fieldName = "material";
                    DynamicObject material = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"material");
                    if (bom.getDataEntityType().getProperties().containsKey((Object)"materialid")) {
                        material = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"materialid");
                        fieldName = "materialid";
                    }
                    if (material == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u3002", (String)"BOMSaveValidator_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                        continue;
                    }
                    String entityName = material.getDynamicObjectType().getName();
                    if ("bd_materialmftinfo".equals(entityName)) {
                        DynamicObject matObj = material.getDynamicObject("masterid");
                        qFilter = new QFilter("materialid", "=", (Object)matObj.getLong("id"));
                        qFilterList.add(qFilter);
                    } else {
                        Long matId = (Long)material.getPkValue();
                        qFilter = new QFilter(fieldName, "=", (Object)matId);
                        qFilterList.add(qFilter);
                    }
                    DynamicObject type = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"type");
                    if (type == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cBOM\u7c7b\u578b\u201d\u3002", (String)"BOMSaveValidator_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                        continue;
                    }
                    QFilter qFilter4 = new QFilter("type", "=", type.getPkValue());
                    qFilterList.add(qFilter4);
                    String purpose = type.getString("purpose");
                    DynamicObject configuredcode = bom.getDynamicObject("configuredcode");
                    if ("C".equals(purpose) && configuredcode == null) continue;
                    if (configuredcode != null && "C".equals(purpose)) {
                        QFilter qFilter5 = new QFilter("configuredcode", "=", configuredcode.getPkValue());
                        qFilterList.add(qFilter5);
                    }
                    Boolean isEnableMaterVersion = MaterialHelper.isEnableMaterialVersion((DynamicObject)material);
                    Boolean isVersion = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)type, (String)"isversion");
                    DynamicObject version = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"version");
                    if (version == null && (isEnableMaterVersion.booleanValue() || isVersion.booleanValue())) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7248\u672c\u53f7\u201d\u3002", (String)"BOMSaveValidator_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                        continue;
                    }
                    Long versionPK = 0L;
                    if (version != null) {
                        versionPK = Long.parseLong(version.getPkValue().toString());
                    }
                    QFilter qFilter6 = new QFilter("version", "=", (Object)versionPK);
                    qFilterList.add(qFilter6);
                    Boolean isUseAuxpty = MaterialHelper.isUseAuxpty((DynamicObject)material);
                    DynamicObject replace = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"replaceno");
                    Long replacepk = 0L;
                    if (replace != null) {
                        replacepk = Long.parseLong(replace.getPkValue().toString());
                    }
                    QFilter reqFilter = new QFilter("replaceno", "=", (Object)replacepk);
                    qFilterList.add(reqFilter);
                    DynamicObject wbs = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"wbs");
                    Long wbsPk = 0L;
                    if (wbs != null) {
                        wbsPk = Long.parseLong(wbs.getPkValue().toString());
                    }
                    QFilter wbsFilter = new QFilter("wbs", "=", (Object)wbsPk);
                    qFilterList.add(wbsFilter);
                    DynamicObject auxpty = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"auxproperty");
                    if (auxpty != null || !isUseAuxpty.booleanValue()) {
                        Long auxptypk = 0L;
                        if (auxpty != null) {
                            auxptypk = Long.parseLong(auxpty.getPkValue().toString());
                        }
                        QFilter qFilter7 = new QFilter("auxproperty", "=", (Object)auxptypk);
                        qFilterList.add(qFilter7);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entityKey) || qFilterList.isEmpty()) continue;
                    DynamicObjectCollection exists = null;
                    if ("pdm_ecobom".equals(entityKey)) {
                        exists = new DynamicObjectCollection();
                        if (this.isEcoInitVersion(bom)) {
                            exists = QueryServiceHelper.query((String)entityKey, (String)"id,number,createorg.name orgName", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
                        }
                    } else {
                        exists = QueryServiceHelper.query((String)entityKey, (String)"id,number,createorg.name orgName", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
                    }
                    StringBuilder error = new StringBuilder();
                    StringBuilder msg = new StringBuilder();
                    if ("pdm_ecobom".equals(entityKey)) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u4e3a\u521d\u59cb\u7248\u672c\u65f6%s", (String)"BOMSaveValidator_23", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ","));
                    }
                    msg.append(ResManager.loadKDString((String)"\u5728\u4f7f\u7528\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u5b58\u5728\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u3001\u201cBOM\u7c7b\u578b\u201d\u3001\u201c\u7248\u672c\u53f7\u201d\u3001\u201cWBS\u201d\u3001\u201c\u66ff\u4ee3\u53f7\u201d\u3001\u201c\u8f85\u52a9\u5c5e\u6027\u201d", (String)"BOMSaveValidator_17", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    if ("C".equals(purpose)) {
                        msg.append(String.format(ResManager.loadKDString((String)"%1$s\u914d\u7f6e\u53f7%2$s", (String)"BOMSaveValidator_19", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), "\u3001\u201c", "\u201d"));
                    }
                    msg.append(ResManager.loadKDString((String)"\u76f8\u540c\u7684BOM\u6570\u636e\u201c%2$s\u201d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"BOMSaveValidator_18", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    for (DynamicObject o : exists) {
                        if (error.length() > 0) {
                            error.append("\u3001");
                        }
                        error.append(String.format("%1$s(%2$s)", o.getString("number"), o.getString("orgName")));
                    }
                    if (error.length() <= 0) continue;
                    this.addErrorMessage(obj, String.format(msg.toString(), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)createOrg, (String)"name"), error.toString()));
                }
            }
            finally {
                if (isUseBomOrgFilterCache) {
                    BomUtils.removeBomOrgFilterCeche();
                }
                if (isUseBomCtrlStrategyCache) {
                    BomUtils.removeBomCtrlStrategyCeche();
                }
            }
        }
    }

    private boolean isEcoInitVersion(DynamicObject bom) {
        boolean isExists = false;
        String querySql = "select fentryid from t_pdm_bomecopentry where fecobomid  = ? and fentryversioncontrol  = 'D' ";
        try (DataSet ds = DB.queryDataSet((String)(BOMSaveValidator.class.getName() + "_isEcoInitVersion"), (DBRoute)scmDBRoute, (String)querySql, (Object[])new Object[]{bom.getPkValue()});){
            for (Row row : ds) {
                isExists = true;
            }
        }
        return isExists;
    }
}

