/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MergeOrderSrcToTargetConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(MergeOrderSrcToTargetConvertPlugin.class);
    private String[] entryGroupKeyArry = new String[]{"id"};

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("id");
        e.addSrcField("srcentry.mappingid");
        e.addSrcField("srcentry.id");
        e.addSrcField("srcentry.pid");
        e.addSrcField("mergeetentry.mappingmgid");
        e.getQFilters().add(new QFilter("srcentry.producttype", "=", (Object)"C"));
    }

    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        super.beforeBuildGroupMode(e);
        String entryGroupKey = e.getEntryGroupKey();
        this.entryGroupKeyArry = entryGroupKey.split(",");
        for (int i = 0; i < this.entryGroupKeyArry.length; ++i) {
            this.entryGroupKeyArry[i] = "srcentry." + this.entryGroupKeyArry[i];
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] mergeBillDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        Long srcId = 0L;
        DynamicObject targebill = null;
        Map fldProperties = e.getFldProperties();
        DynamicProperty sourceidProperty = (DynamicProperty)fldProperties.get("id");
        for (ExtendedDataEntity mergeBillDataEntity : mergeBillDataEntitys) {
            targebill = mergeBillDataEntity.getDataEntity();
            List srcRows = (List)mergeBillDataEntity.getValue("ConvertSource");
            if (srcRows == null || srcRows.size() <= 0) continue;
            srcId = (Long)sourceidProperty.getValue(srcRows.get(0));
        }
        if (targebill == null) {
            return;
        }
        this.doEntryMerge(e, srcId, targebill, fldProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEntryMerge(AfterConvertEventArgs e, Long srcId, DynamicObject targebill, Map<String, DynamicProperty> fldProperties) {
        Map<String, String> propertiesMapping = this.getPropertiesMapping();
        String selectPro = OrderMergeHelper.getAllEntryFields((String)"pom_ordermerge", (String)"srcentry");
        EntityType srcEntityType = OrderMergeHelper.getEntityType((String)"pom_ordermerge", (String)"srcentry");
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey("mergeetentry");
        DynamicProperty srcentryidProperty = fldProperties.get("srcentry.id");
        ArrayList<ExtendedDataEntity> extendedDataEntities = new ArrayList<ExtendedDataEntity>(10);
        DynamicObjectCollection mergeEntryCol = targebill.getDynamicObjectCollection("mergeetentry");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            DynamicObject targetMergeEntry = extendedDataEntity.getDataEntity();
            Set<Long> srcEntryIds = this.getSrcTags(srcentryidProperty, paramList, extendedDataEntity, targetMergeEntry);
            try (DataSet ds2 = null;){
                QFilter pkFilter = new QFilter("id", "=", (Object)srcId);
                QFilter entryPidFilter = new QFilter("srcentry.pid", "in", srcEntryIds);
                DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pom_ordermerge", (String)selectPro, (QFilter[])new QFilter[]{pkFilter, entryPidFilter}, null);
                ds2 = ds.groupBy(this.entryGroupKeyArry).sum("srcentry.qty").sum("srcentry.auxptyqty").sum("srcentry.baseqty").sum("srcentry.repmaxqty").sum("srcentry.repminqty").sum("srcentry.planqty").sum("srcentry.planbaseqty").sum("srcentry.splitqty").sum("srcentry.splitbaseqty").max("srcentry.baseunit").min("srcentry.planpreparetime").max("srcentry.planendtime").min("srcentry.planbegintime").min("srcentry.lot").min("srcentry.expendbomtime").min("srcentry.warehouse").max("srcentry.closebdt").max("srcentry.location").finish().addField("0", "srcentry.materialspread");
                this.copyNewData(propertiesMapping, srcEntityType, extendedDataEntities, mergeEntryCol, targetMergeEntry, ds2);
            }
            targetMergeEntry.set("mappingmgid", (Object)targetMergeEntry.getPkValue().toString());
        }
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)"update t_pom_mgsrcentry set fipid = ? where fentryid = ?", paramList);
        }
        if (extendedDataEntities.size() > 0) {
            e.getTargetExtDataEntitySet().AddExtendedDataEntities("mergeetentry", extendedDataEntities);
        }
    }

    private void copyNewData(Map<String, String> propertiesMapping, EntityType srcEntityType, List<ExtendedDataEntity> extendedDataEntities, DynamicObjectCollection mergeEntryCol, DynamicObject targetMergeEntry, DataSet ds2) {
        int dataIndex = 0;
        for (Row row : ds2) {
            DynamicObject newEntry = new DynamicObject(targetMergeEntry.getDynamicObjectType());
            for (Map.Entry<String, String> stringStringEntry : propertiesMapping.entrySet()) {
                IDataEntityProperty propertyType = srcEntityType.findProperty(stringStringEntry.getValue().split("\\.")[1]);
                if (propertyType instanceof BasedataProp) {
                    BasedataProp baseEntityId = (BasedataProp)propertyType;
                    DynamicObject dynamicObject = (DynamicObject)baseEntityId.getComplexType().createInstance();
                    dynamicObject.set("id", row.get(stringStringEntry.getValue()));
                    newEntry.set(stringStringEntry.getKey(), (Object)dynamicObject);
                    continue;
                }
                newEntry.set(stringStringEntry.getKey(), row.get(stringStringEntry.getValue()));
            }
            newEntry.set("mappingmgid", targetMergeEntry.getPkValue());
            mergeEntryCol.add((Object)newEntry);
            extendedDataEntities.add(new ExtendedDataEntity(newEntry, dataIndex++, 0));
        }
    }

    private Set<Long> getSrcTags(DynamicProperty srcentryidProperty, List<Object[]> paramList, ExtendedDataEntity extendedDataEntity, DynamicObject targetMergeEntry) {
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        if (srcentryidProperty == null || extendedDataEntity == null || targetMergeEntry == null) {
            return srcEntryIds;
        }
        List srcRows = (List)extendedDataEntity.getValue("ConvertSource");
        for (DynamicObject srcRow : srcRows) {
            Long srcEntryPk = (Long)srcentryidProperty.getValue((Object)srcRow);
            srcEntryIds.add(srcEntryPk);
            Object mergeIpid = targetMergeEntry.get("ipidmerge");
            Object[] param = new Object[]{mergeIpid, srcEntryPk};
            paramList.add(param);
        }
        return srcEntryIds;
    }

    private Map<String, String> getPropertiesMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>(50);
        mapping.put("producttypemerge", "srcentry.producttype");
        mapping.put("productmerge", "srcentry.product");
        mapping.put("workcentermg", "srcentry.workcenter");
        mapping.put("unitmerge", "srcentry.unit");
        mapping.put("qtymerge", "srcentry.qty");
        mapping.put("auxptyunitmerge", "srcentry.auxptyunit");
        mapping.put("auxptyqtymerge", "srcentry.auxptyqty");
        mapping.put("bommerge", "srcentry.bom");
        mapping.put("pcesroutemerge", "srcentry.processroute");
        mapping.put("planpretimemerge", "srcentry.planpreparetime");
        mapping.put("planbgtimemerge", "srcentry.planbegintime");
        mapping.put("planendtimemerge", "srcentry.planendtime");
        mapping.put("inwardeptmerge", "srcentry.inwardept");
        mapping.put("warehousemerge", "srcentry.warehouse");
        mapping.put("locationmg", "srcentry.location");
        mapping.put("proddeptmerge", "srcentry.producedept");
        mapping.put("materialspdmerge", "srcentry.materialspread");
        mapping.put("lotmerge", "srcentry.lot");
        mapping.put("baseunitmerge", "srcentry.baseunit");
        mapping.put("baseqtymerge", "srcentry.baseqty");
        mapping.put("mversionmerge", "srcentry.manuversion");
        mapping.put("expdbomtmerge", "srcentry.expendbomtime");
        mapping.put("planstamerge", "srcentry.planstatus");
        mapping.put("taskstamerge", "srcentry.taskstatus");
        mapping.put("bizstatusmg", "srcentry.bizstatus");
        mapping.put("auxpromerge", "srcentry.auxproperty");
        mapping.put("inhlimitmerge", "srcentry.inhlimit");
        mapping.put("inllimitmerge", "srcentry.inllimit");
        mapping.put("isinspectmerge", "srcentry.isinspect");
        mapping.put("qualityorgmerge", "srcentry.qualityorg");
        mapping.put("isconrptqtymerge", "srcentry.isconrptqty");
        mapping.put("repmaxqtymg", "srcentry.repmaxqty");
        mapping.put("repmaxratemg", "srcentry.repmaxrate");
        mapping.put("repminqtymg", "srcentry.repminqty");
        mapping.put("planqtymg", "srcentry.planqty");
        mapping.put("planbaseqtymg", "srcentry.planbaseqty");
        mapping.put("beginbdtmg", "srcentry.beginbdt");
        mapping.put("closebdtmg", "srcentry.closebdt");
        mapping.put("splitqtymg", "srcentry.splitqty");
        mapping.put("splitbaseqtymg", "srcentry.splitbaseqty");
        mapping.put("configcodemg", "srcentry.configuredcode");
        mapping.put("tracknomg", "srcentry.tracknumber");
        mapping.put("targetproject", "srcentry.bdproject");
        mapping.put("yieldratemg", "srcentry.yieldrate");
        mapping.put("iscontrolqtymg", "srcentry.iscontrolqty");
        mapping.put("planscopemg", "srcentry.planscope");
        mapping.put("supplyrulemg", "srcentry.supplyrule");
        return mapping;
    }
}

