/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.helper.MergeBotpAutoFixLinkHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class MergeOrderStockConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(MergeOrderStockConvertPlugin.class);
    private Map<String, String> customParams = null;

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("billno");
    }

    public void initVariable(InitVariableEventArgs e) {
        this.customParams = e.getConvertArgs().getCustomParams();
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entryDataEntitys;
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        MergeBotpAutoFixLinkHelper fixLinkHelper = new MergeBotpAutoFixLinkHelper("pom_mftstock");
        HashSet<Object> srcStockBillNos = new HashSet<Object>(16);
        BigDecimal qty = BigDecimal.ZERO;
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            for (DynamicObject srcRow : srcRows) {
                srcStockBillNos.add(srcRow.get("billno"));
            }
            DynamicObject targetOrderbill = billDataEntity.getDataEntity();
            if (targetOrderbill.get("billno") == null || StringUtils.isEmpty((CharSequence)targetOrderbill.getString("billno"))) {
                String number = CodeRuleServiceHelper.getNumber((String)"pom_mftstock", (DynamicObject)targetOrderbill, (String)targetOrderbill.getDynamicObject("org").getPkValue().toString());
                if (StringUtils.isEmpty((CharSequence)number)) {
                    number = String.valueOf("MERGE_" + System.currentTimeMillis());
                }
                targetOrderbill.set("billno", (Object)number);
            }
            fixLinkHelper.fixRowLink(targetOrderbill, "stockentry", "pom_mftorder", this.customParams, "treeentryentity");
            qty = targetOrderbill.getBigDecimal("qty");
        }
        Map fldProperties = e.getFldProperties();
        for (ExtendedDataEntity entryDataEntity : entryDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey("stockentry")) {
            DynamicObject targetOrderEntry = entryDataEntity.getDataEntity();
            targetOrderEntry.set("sourcetype", (Object)"B");
            List srcRows = (List)entryDataEntity.getValue("ConvertSource");
            for (DynamicObject srcRow : srcRows) {
                String sourcetype = (String)srcRow.get((IDataEntityProperty)fldProperties.get("sourcetype"));
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)sourcetype)) continue;
                targetOrderEntry.set("sourcetype", (Object)"A");
                break;
            }
            if (srcRows == null || srcRows.size() >= 2 || srcStockBillNos.size() <= 1) continue;
            targetOrderEntry.set("qtynumerator", (Object)targetOrderEntry.getBigDecimal("demandqty"));
            targetOrderEntry.set("qtydenominator", (Object)qty);
        }
    }
}

