/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.mftorder.helper.MergeBotpAutoFixLinkHelper;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import org.jetbrains.annotations.NotNull;

public class MergeOrderToManuftechConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(MergeOrderToManuftechConvertPlugin.class);
    private Map<String, String> customParams = null;

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
    }

    public void initVariable(InitVariableEventArgs e) {
        this.customParams = e.getConvertArgs().getCustomParams();
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        MergeBotpAutoFixLinkHelper fixLinkHelper = new MergeBotpAutoFixLinkHelper("sfc_manftech");
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetObject = billDataEntity.getDataEntity();
            if (targetObject.get("billno") == null || StringUtils.isEmpty((CharSequence)targetObject.getString("billno"))) {
                String number = CodeRuleServiceHelper.getNumber((String)"sfc_manftech", (DynamicObject)targetObject, (String)targetObject.getDynamicObject("org").getPkValue().toString());
                if (StringUtils.isEmpty((CharSequence)number)) {
                    number = String.valueOf("MERGE_" + System.currentTimeMillis());
                }
                targetObject.set("billno", (Object)number);
            }
            logger.info(String.format("\u5de5\u5355\u5408\u5e76\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s", this.customParams));
            fixLinkHelper.fixRowLink(targetObject, "oprentryentity", "pom_mftorder", this.customParams, "treeentryentity");
            DynamicObjectCollection proentrys = targetObject.getDynamicObjectCollection("proentryentity");
            proentrys.clear();
            ConvertOperationResult pushResult = this.getConvertOperationResult();
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_manftech");
            List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            for (DynamicObject targetBillObj : targetBillObjs) {
                DynamicObjectCollection mergeProentrys = targetBillObj.getDynamicObjectCollection("proentryentity");
                CloneUtils cloneUtils = new CloneUtils(true, true);
                for (DynamicObject mergeProentry : mergeProentrys) {
                    DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)mergeProentry);
                    clone.setParent((Object)targetObject);
                    proentrys.add((Object)clone);
                }
            }
        }
    }

    @NotNull
    private ConvertOperationResult getConvertOperationResult() {
        List selectedRows = (List)SerializationUtils.fromJsonString((String)this.customParams.get("selectedRows"), List.class);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setAutoSave(false);
        ConvertOperationResult pushResult = OrderMergeHelper.pushTo(null, (List)selectedRows, (String)"1492815937622008832", (String)"sfc_manftech", (String)"sfc_manftech", (PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            String billMessage = "";
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                billMessage = billReport.getFailMessage();
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5de5\u5e8f\u5e8f\u5217\u5408\u5e76\u5931\u8d25\uff1a%1$s", (String)"MergeOrderToManuftechConvertPlugin_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errMessage + ":" + billMessage));
        }
        return pushResult;
    }
}

