/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.opplugin.botp.OrderToMergeConvertPlugin;
import kd.bd.mpdm.opplugin.ordermerge.validator.MergeOrderCheckHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MergeOrderToOrderConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(MergeOrderToOrderConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("mergeetentry.pid");
        e.addSrcField("mergeetentry.ipidmerge");
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey("treeentryentity");
        Map fldProperties = e.getFldProperties();
        DynamicProperty pidProperty = (DynamicProperty)fldProperties.get("mergeetentry.pid");
        block0: for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String pid;
            List srcRows;
            long pkValue;
            DynamicObject targetOrderEntry = billDataEntity.getDataEntity();
            long l = pkValue = targetOrderEntry.getPkValue() == null ? 0L : Long.parseLong(targetOrderEntry.getPkValue().toString());
            if (0L == pkValue) {
                targetOrderEntry.set("id", (Object)ID.genLongId());
            }
            if ((srcRows = (List)billDataEntity.getValue("ConvertSource")).size() < 1) continue;
            DynamicObject srcEntry = (DynamicObject)srcRows.get(0);
            String string = pid = pidProperty.getValue((Object)srcEntry) == null ? "0" : pidProperty.getValue((Object)srcEntry).toString();
            if (StringUtils.equals((CharSequence)"0", (CharSequence)pid)) continue;
            for (ExtendedDataEntity billDataEntity1 : billDataEntitys) {
                String targetSrcEntryid;
                DynamicObject targetBill = billDataEntity1.getDataEntity();
                String string2 = targetSrcEntryid = targetBill.get("srcorderentryid") == null ? "" : targetBill.get("srcorderentryid").toString();
                if (!StringUtils.equals((CharSequence)pid, (CharSequence)targetSrcEntryid)) continue;
                targetOrderEntry.set("pid", targetBill.getPkValue());
                continue block0;
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        String targetBillId = "";
        String targetBillno = "";
        ExtendedDataEntity[] billEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        boolean isprocedure = false;
        ArrayList<DynamicObject> saveOrders = new ArrayList<DynamicObject>(billEntitys.length);
        for (ExtendedDataEntity billEntity : billEntitys) {
            DynamicObject transaction;
            DynamicObject orderbill = billEntity.getDataEntity();
            logger.info(String.format("\u5de5\u5355\u5408\u5e76\u5355\u751f\u6210\u5ba1\u6838\u751f\u6210\u751f\u4ea7\u5de5\u5355\uff1a%1$s", orderbill.getPkValue()));
            if (orderbill.getPkValue() == null || StringUtils.equals((CharSequence)"0", (CharSequence)orderbill.getPkValue().toString())) {
                long id = ID.genLongId();
                orderbill.set("id", (Object)id);
                targetBillId = String.valueOf(id);
                logger.info(String.format("\u5de5\u5355\u5408\u5e76\u5355\u751f\u6210\u5ba1\u6838\u751f\u6210\u751f\u4ea7\u5de5\u5355\u91cd\u65b0\u8bbe\u7f6eID\uff1a%1$s", id));
            }
            if (orderbill.get("billno") == null || StringUtils.isEmpty((CharSequence)orderbill.getString("billno"))) {
                orderbill.set("billno", (Object)("MERGE_" + ID.genLongId()));
            }
            if ((transaction = orderbill.getDynamicObject("transactiontype")) != null) {
                isprocedure = transaction.get("isprocedure") == null ? false : transaction.getBoolean("isprocedure");
            }
            saveOrders.add(orderbill);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("strictvalidation", String.valueOf(true));
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"pom_mftorder", (DynamicObject[])saveOrders.toArray(new DynamicObject[saveOrders.size()]), (OperateOption)option);
        if (operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            for (Object successPkId : successPkIds) {
                targetBillId = successPkId == null ? "" : successPkId.toString();
                logger.info(String.format("\u5de5\u5355\u5408\u5e76\u5355\u751f\u6210\u5ba1\u6838\u751f\u6210\u751f\u4ea7\u5de5\u5355\u4fdd\u5b58\u540e\u7684ID\uff1a%1$s", targetBillId));
            }
            for (DynamicObject orderbill : saveOrders) {
                if (orderbill.get("billno") == null || StringUtils.isEmpty((CharSequence)orderbill.getString("billno"))) {
                    String number = CodeRuleServiceHelper.getNumber((String)"pom_mftorder", (DynamicObject)orderbill, (String)orderbill.getDynamicObject("org").getPkValue().toString());
                    if (StringUtils.isEmpty((CharSequence)number)) {
                        number = "MERGE_" + System.currentTimeMillis();
                    }
                    orderbill.set("billno", (Object)number);
                }
                targetBillno = orderbill.getString("billno");
            }
        } else {
            String operationResultErrorInfos = OrderMergeHelper.getOperationResultErrorInfos((OperationResult)operationResult);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u751f\u6210\u5408\u5e76\u5de5\u5355\u7684\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"MergeOrderToOrderConvertPlugin_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), operationResultErrorInfos));
        }
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey("treeentryentity");
        Map fldProperties = e.getFldProperties();
        DynamicProperty idProperty = (DynamicProperty)fldProperties.get("id");
        DynamicProperty pidProperty = (DynamicProperty)fldProperties.get("mergeetentry.ipidmerge");
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows;
            DynamicObject targetOrderEntry = billDataEntity.getDataEntity();
            String targetEntryid = targetOrderEntry.getPkValue().toString();
            logger.info(String.format("\u5de5\u5355\u5408\u5e76\u5355\u751f\u6210\u5ba1\u6838\u751f\u6210\u751f\u4ea7\u5de5\u5355\u4fdd\u5b58\u540e\u751f\u4ea7\u5de5\u5355\u5206\u5f55ID\uff1a%1$s", targetEntryid));
            String productType = targetOrderEntry.getString("producttype");
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType) || (srcRows = (List)billDataEntity.getValue("ConvertSource")).size() < 1) continue;
            ArrayList<Object> orderIds = new ArrayList<Object>(10);
            ArrayList<Object> ipidmgIds = new ArrayList<Object>(10);
            for (DynamicObject srcRow : srcRows) {
                ipidmgIds.add(pidProperty.getValue((Object)srcRow));
                orderIds.add(idProperty.getValue((Object)srcRow));
            }
            HashMap<Object, String> idNoMapping = new HashMap<Object, String>(16);
            Map<Long, String> srcOrderIds = this.getSrcOrderIds(orderIds, ipidmgIds, idNoMapping);
            this.genStocks(targetBillId, targetBillno, targetEntryid, srcOrderIds);
        }
    }

    private void genStocks(String targetBillId, String targetBillno, String targetEntryid, Map<Long, String> orderids) {
        if (orderids.size() < 1) {
            return;
        }
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(orderids.size());
        String ruleid = "1488587306741857280";
        DynamicObject[] stocks = OrderMergeHelper.queryStocks(orderids);
        MergeOrderCheckHelper.checkStock(stocks);
        for (DynamicObject stock : stocks) {
            ListSelectedRow selectedRow = new ListSelectedRow(stock.getPkValue());
            DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
            if (stockEntrys == null || stockEntrys.size() < 1) {
                ruleid = "1504506431955534848";
            }
            selectedRows.add(selectedRow);
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setAutoSave(true);
        pushArgs.addCustomParam("srcBillId", targetBillId);
        pushArgs.addCustomParam("srcBillNo", targetBillno);
        pushArgs.addCustomParam("srcBillEntryId", targetEntryid);
        ConvertOperationResult pushResult = OrderMergeHelper.pushTo(null, selectedRows, (String)ruleid, (String)"pom_mftstock", (String)"pom_mftstock", (PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder er = this.dealConvertError(pushResult);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c%1$s", (String)"MergeOrderToOrderConvertPlugin_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), er));
        }
    }

    private StringBuilder dealConvertError(ConvertOperationResult pushResult) {
        StringBuilder er = new StringBuilder(50);
        if (pushResult == null) {
            return er;
        }
        String errMessage = pushResult.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)errMessage) && !StringUtils.equals((CharSequence)"null", (CharSequence)errMessage)) {
            er.append(errMessage).append(':');
        }
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            String billMessage;
            if (billReport.isSuccess() || !StringUtils.isNotEmpty((CharSequence)(billMessage = billReport.getFailMessage())) || StringUtils.equals((CharSequence)"null", (CharSequence)billMessage)) continue;
            er.append(billMessage);
        }
        return er;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> getSrcOrderIds(List<Object> mgorderid, List<Object> idIpid, Map<Object, String> idNoMapping) {
        HashMap<Long, String> orderIds = new HashMap<Long, String>(16);
        if (mgorderid == null || idIpid == null) {
            return orderIds;
        }
        try (DataSet dataSet = null;){
            SqlBuilder sql = new SqlBuilder();
            sql.appendIn("select forderid,forderno,forderentryid from t_pom_mgsrcentry where fid ", mgorderid);
            sql.appendIn("and fipid ", idIpid);
            dataSet = DB.queryDataSet((String)OrderToMergeConvertPlugin.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
            for (Row row : dataSet) {
                orderIds.put(row.getLong("forderentryid"), row.get("forderid").toString());
                idNoMapping.put(row.getString("forderid"), row.getString("forderno"));
            }
        }
        return orderIds;
    }
}

