/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.ICreateStockExpandPlugin;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorder.utils.PlanScopeHelper;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bd.mpdm.opplugin.botp.BotpConvertUtils;
import kd.bd.mpdm.opplugin.botp.MftXStockBotpConvertPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MftStockBotpConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(MftXStockBotpConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        String entityName = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(entityName);
        HashSet<Long> stockIdSet = new HashSet<Long>(16);
        HashSet<Long> bomentryIdSet = new HashSet<Long>(16);
        HashSet<Long> orderEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> materialmftIdSet = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> orgMaterialMap = new HashMap<Long, Set<Long>>(16);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject stockBill = billDataEntity.getDataEntity();
            Long orgId = stockBill.getDynamicObject("org").getLong("id");
            DynamicObjectCollection coll = stockBill.getDynamicObjectCollection("stockentry");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject stockEntry = (DynamicObject)coll.get(i);
                Long stockId = stockEntry.getLong("srcbillid");
                stockIdSet.add(stockId);
                if (!this.isAdd(stockEntry)) continue;
                Long bomentryid = stockEntry.getLong("bomentryid");
                bomentryIdSet.add(bomentryid);
                Long mftId = stockEntry.getDynamicObject("materialid").getLong("id");
                materialmftIdSet.add(mftId);
                Long midId = stockEntry.getDynamicObject("materielmasterid").getLong("id");
                HashSet<Long> materialIdSet = (HashSet<Long>)orgMaterialMap.get(orgId);
                if (materialIdSet == null) {
                    materialIdSet = new HashSet<Long>(16);
                }
                materialIdSet.add(midId);
                orgMaterialMap.put(orgId, materialIdSet);
                Object orderEntry = stockBill.get("orderentryid");
                Long orderEntryId = orderEntry instanceof DynamicObject ? Long.valueOf(stockBill.getDynamicObject("orderentryid").getLong("id")) : (orderEntry instanceof Long ? (Long)stockBill.get("orderentryid") : Long.valueOf(Long.parseLong(stockBill.get("orderentryid").toString())));
                orderEntryIdSet.add(orderEntryId);
            }
        }
        DynamicObject[] stocks = BusinessDataServiceHelper.load((Object[])stockIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Map<Long, DynamicObject> stockMap = this.convertToMap(stocks);
        Map<String, DynamicObject> manftechMap = this.getManftechMap(stocks, entityName);
        Map bomEntryMap = MsBomQueryHelper.getBomEntryFromCache(bomentryIdSet);
        Map materialMftMap = MaterialMftQueryHelper.getDataCacheBySet(materialmftIdSet);
        Map<String, DynamicObject> materialPlanMap = this.getMaterialPlan(orgMaterialMap);
        Map<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>(16);
        if (!orderEntryIdSet.isEmpty()) {
            String orderEntryF7 = "pom_mftstock".equals(entityName) ? "pom_mftorder_f7" : "om_mftorder_f7";
            DynamicObject[] orderEntrys = BusinessDataServiceHelper.load((Object[])orderEntryIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)orderEntryF7));
            orderEntryMap = this.convertToMap(orderEntrys);
        }
        this.dealStock(e, entityName, stockMap, billDataEntitys, manftechMap, bomEntryMap, materialMftMap, materialPlanMap, orderEntryMap);
        this.resetResult(e, entityName, stockMap, billDataEntitys);
    }

    private Map<String, DynamicObject> getMaterialPlan(Map<Long, Set<Long>> orgMaterialMap) {
        HashMap<String, DynamicObject> mpMap = new HashMap<String, DynamicObject>(16);
        if (orgMaterialMap == null || orgMaterialMap.isEmpty()) {
            return mpMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : orgMaterialMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> materialIdset = entrys.getValue();
            Map mp = MaterialPlanQueryHelper.getDataCacheByMaterialSet(materialIdset, (Long)orgId);
            if (mp == null || mp.isEmpty()) continue;
            for (Map.Entry mps : mp.entrySet()) {
                mpMap.put(String.valueOf(orgId) + "_" + String.valueOf(mps.getKey()), (DynamicObject)mps.getValue());
            }
        }
        return mpMap;
    }

    private Map<Long, DynamicObject> convertToMap(DynamicObject[] stocks) {
        HashMap<Long, DynamicObject> stockMap = new HashMap<Long, DynamicObject>(stocks.length);
        for (DynamicObject dy : stocks) {
            stockMap.put(dy.getLong("id"), dy);
        }
        return stockMap;
    }

    public void resetResult(AfterConvertEventArgs e, String entityName, Map<Long, DynamicObject> stockMap, ExtendedDataEntity[] billDataEntitys) {
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject stockBill = billDataEntity.getDataEntity();
            DynamicObjectCollection coll = stockBill.getDynamicObjectCollection("stockentry");
            Long stockId = ((DynamicObject)coll.get(0)).getLong("srcbillid");
            DynamicObject newStockBill = stockMap.get(stockId);
            billDataEntity.setDataEntity(newStockBill);
        }
    }

    public DynamicObject getStockEntry(DynamicObject stock, Long stockEntryId) {
        DynamicObjectCollection coll = stock.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            if (!((Long)entry.getPkValue()).equals(stockEntryId)) continue;
            return entry;
        }
        return null;
    }

    public DynamicObject addStockEntry(DynamicObject stock) {
        DynamicObjectCollection coll = stock.getDynamicObjectCollection("stockentry");
        DynamicObjectType dynamicObjectType = coll.getDynamicObjectType();
        DynamicObject stockEntry = (DynamicObject)dynamicObjectType.createInstance();
        int seq = coll.size() + 1;
        IDataEntityType type = stockEntry.getDataEntityType();
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey((Object[])new DynamicObject[]{stockEntry}, type);
        stockEntry.set("seq", (Object)seq);
        stockEntry.set("sourcetype", (Object)"A");
        coll.add((Object)stockEntry);
        return stockEntry;
    }

    private boolean isAdd(DynamicObject oldStockBillEntry) {
        return "A".equals(oldStockBillEntry.getString("entrychangetype"));
    }

    public void dealStock(AfterConvertEventArgs e, String entityName, Map<Long, DynamicObject> stockMap, ExtendedDataEntity[] billDataEntitys, Map<String, DynamicObject> manftechMap, Map<Long, DynamicObject> bomEntryMap, Map<Object, DynamicObject> materialMftMap, Map<String, DynamicObject> materialPlanMap, Map<Long, DynamicObject> orderEntryMap) {
        Set<String> notUpdateFieldSet = this.getNoUpdateFieldSet(entityName);
        Set<String> updateQtyFieldSet = this.getUpdateQtyFields(entityName);
        ArrayList<DynamicObject> addStockList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> addStockEntryList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> repStockList = new ArrayList<DynamicObject>(16);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject oldStockBill = billDataEntity.getDataEntity();
            DynamicObjectCollection oldStockEntryColl = oldStockBill.getDynamicObjectCollection("stockentry");
            for (int i = 0; i < oldStockEntryColl.size(); ++i) {
                DynamicObject oldStockBillEntry = (DynamicObject)oldStockEntryColl.get(i);
                Long stockId = oldStockBillEntry.getLong("srcbillid");
                Long stockEntryId = oldStockBillEntry.getLong("srcbillentryid");
                DynamicObject newStockBill = stockMap.get(stockId);
                DynamicObject newStockEntry = null;
                boolean isAdd = this.isAdd(oldStockBillEntry);
                if (isAdd) {
                    newStockEntry = this.addStockEntry(newStockBill);
                    if (stockEntryId == null || stockEntryId.equals(0L)) {
                        BotpConvertUtils.addList(addStockEntryList, newStockEntry);
                        BotpConvertUtils.addList(addStockList, newStockBill);
                    } else {
                        newStockEntry.set("id", (Object)stockEntryId);
                        newStockEntry.set("pstockentryid", oldStockBillEntry.get("pstockentryid"));
                    }
                } else {
                    newStockEntry = this.getStockEntry(newStockBill, stockEntryId);
                }
                BotpConvertUtils.convertEntry(oldStockBillEntry, newStockEntry, notUpdateFieldSet, updateQtyFieldSet);
                this.initStockEntry(newStockBill, newStockEntry, isAdd, manftechMap, bomEntryMap, materialMftMap, materialPlanMap, orderEntryMap);
                BotpConvertUtils.addList(repStockList, newStockBill);
            }
        }
        if (!addStockList.isEmpty()) {
            CreateStockByBomUtils.setParentEntryId(addStockList, addStockEntryList);
        }
        if (!repStockList.isEmpty()) {
            CreateStockUtils.setIsStep(repStockList);
            MPDMMftGenStocksUtils.updateRepPid(repStockList);
        }
    }

    public DynamicObject findOrderEntry(DynamicObject newStock, DynamicObject[] orderEntrys) {
        DynamicObject orderEntry = null;
        return orderEntry;
    }

    public Set<String> getNoUpdateFieldSet(String entityName) {
        Set<String> fieldSet = BotpConvertUtils.getConfigNoUpdateFieldSet(entityName);
        new HashSet(16);
        fieldSet.add("id");
        fieldSet.add("srcbillentryid");
        fieldSet.add("srcbillid");
        fieldSet.add("pstockentryid");
        fieldSet.add("seq");
        return fieldSet;
    }

    public Set<String> getUpdateQtyFields(String entityName) {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("qtynumerator");
        fieldSet.add("qtydenominator");
        fieldSet.add("fixscrap");
        fieldSet.add("scraprate");
        fieldSet.add("standqty");
        fieldSet.add("demandqty");
        return fieldSet;
    }

    public void initStockEntry(DynamicObject newStock, DynamicObject stockEntry, boolean isAdd, Map<String, DynamicObject> manftechMap, Map<Long, DynamicObject> bomEntryMap, Map<Object, DynamicObject> materialMftMap, Map<String, DynamicObject> materialPlanMap, Map<Long, DynamicObject> orderEntryMap) {
        if (isAdd) {
            Object bomParent;
            Map expandConfigMap;
            DynamicObject expandConfig;
            DynamicObject orgfield;
            Long bomEntryId = stockEntry.getLong("bomentryid");
            Long materialMftId = stockEntry.getDynamicObject("materialid").getLong("id");
            Long materialMasterId = stockEntry.getDynamicObject("materielmasterid").getLong("id");
            DynamicObject bomEntry = bomEntryMap.get(bomEntryId);
            DynamicObject org = newStock.getDynamicObject("org");
            DynamicObject transactproduct = TransactionTypeQueryHelper.getDataCacheByID((Object)newStock.getDynamicObject("transactiontypeid").getPkValue());
            newStock.set("transactiontypeid", (Object)transactproduct);
            DynamicObject materialmftInfo = materialMftMap.get(materialMftId);
            DynamicObject orgMaterialPlanInfo = materialPlanMap.get(String.valueOf(org.getPkValue()) + "_" + String.valueOf(materialMasterId));
            OrderBaseData baseData = this.createOrderBaseData(materialmftInfo, orgMaterialPlanInfo, bomEntry, newStock);
            stockEntry.set("leadtime", bomEntry.get("entryleadtime"));
            if (stockEntry.get("entryconfiguredcode") == null) {
                stockEntry.set("entryconfiguredcode", bomEntry.get("entryconfiguredcode"));
            }
            DynamicObject orderEntry = orderEntryMap.get(newStock.getDynamicObject("orderentryid").getPkValue());
            Date planbegintime = orderEntry.getDate("planbegintime");
            Date planendtime = orderEntry.getDate("planendtime");
            stockEntry.set("demanddate", CreateStockByBomUtils.getDemandDate((DynamicObject)org, (Date)planbegintime, (DynamicObject)stockEntry, (Date)planendtime));
            boolean isconsiderloss = false;
            String materialsource = "A";
            Object backflushtime = null;
            if (transactproduct != null) {
                isconsiderloss = transactproduct.getBoolean("isconsiderloss");
                materialsource = transactproduct.getString("materialsource");
                backflushtime = transactproduct.get("backflushtime");
            }
            if ("B".equals(materialsource)) {
                CreateStockUtils.setStockEntryByMftInfoExPandWarehouse((DynamicObject)stockEntry, (DynamicObject)materialmftInfo);
            } else {
                CreateStockUtils.setStockEntryByBomInfoExPandWarehouse((DynamicObject)stockEntry, (DynamicObject)bomEntry);
            }
            if (orderEntry.containsProperty("manuversion")) {
                PlanScopeHelper.setStockEntryWarehouseByPlanScopeSer((OrderBaseData)baseData, (DynamicObject)stockEntry, (DynamicObject)orderEntry, (DynamicObject)org, (DynamicObject)materialmftInfo, (DynamicObject)bomEntry);
            }
            if ("B".equals(stockEntry.get("isbackflush"))) {
                stockEntry.set("backflushtime", backflushtime);
            } else {
                stockEntry.set("backflushtime", null);
            }
            stockEntry.set("supplymode", bomEntry.get("entryownertype"));
            stockEntry.set("supplierid", bomEntry.get("entryowner"));
            if ("bos_org".equals(bomEntry.get("entryownertype")) && (orgfield = (DynamicObject)stockEntry.get("supplyorgid")) != null) {
                Long orgfieldId = (Long)orgfield.getPkValue();
                stockEntry.set("supplierid", CreateStockByBomUtils.getSupplyByBaseData((OrderBaseData)baseData, (Long)orgfieldId));
            }
            if ((expandConfig = (DynamicObject)(expandConfigMap = baseData.getExpandConfigMap()).get("ICreateStockExpandPlugin.setStockEntryByChild")) != null && !"".equals(expandConfig.getString("classpath"))) {
                try {
                    Class<?> clazz = Class.forName(expandConfig.getString("classpath"));
                    ICreateStockExpandPlugin newInstance = (ICreateStockExpandPlugin)clazz.newInstance();
                    newInstance.setStockEntryByChild(stockEntry, newStock);
                }
                catch (Exception e) {
                    logger.info("\u7ec4\u4ef6\u6e05\u5355\u627e\u4e0d\u5230\u5b9e\u73b0\u7c7b");
                }
            }
            if (stockEntry.getBoolean("isstockallot")) {
                stockEntry.set("outorgunitid_id", (Object)Long.parseLong(CreateStockByBomUtils.getDymId((DynamicObject)stockEntry, (String)"supplyorgid")));
                stockEntry.set("outwarehouseid_id", (Object)Long.parseLong(CreateStockByBomUtils.getDymId((DynamicObject)stockEntry, (String)"warehouseid")));
                stockEntry.set("outlocation_id", (Object)Long.parseLong(CreateStockByBomUtils.getDymId((DynamicObject)stockEntry, (String)"location")));
            }
            if (stockEntry.getBoolean("isstockallot")) {
                if ("B".equals(materialsource)) {
                    stockEntry.set("supplyorgid", (Object)materialmftInfo.getDynamicObject("supplyorgunitid"));
                    stockEntry.set("warehouseid", materialmftInfo.get("warehouse"));
                    stockEntry.set("location", materialmftInfo.get("location"));
                } else {
                    stockEntry.set("supplyorgid", (Object)bomEntry.getDynamicObject("entrysupplyorg"));
                    stockEntry.set("warehouseid", bomEntry.get("entrywarehouse"));
                    stockEntry.set("location", bomEntry.get("entrylocation"));
                }
            }
            stockEntry.set("isbomextend", (Object)Boolean.TRUE);
            DynamicObject entryunit = MPDMMftGenStocksUtils.getEntryUnit((DynamicObject)bomEntry, (DynamicObject)materialmftInfo);
            stockEntry.set("materialunitid", (Object)entryunit);
            stockEntry.set("materialid", (Object)materialmftInfo);
            stockEntry.set("materielmasterid", (Object)materialmftInfo.getDynamicObject("masterid"));
            stockEntry.set("useratio", (Object)0);
            stockEntry.set("pid", (Object)1L);
            if (!bomEntry.getBoolean("entryisreplace")) {
                stockEntry.set("useratio", (Object)100);
                stockEntry.set("pid", (Object)0L);
            }
            stockEntry.set("standqty", (Object)MPDMMftGenStocksUtils.getStandQty((DynamicObject)bomEntry, (DynamicObject)orderEntry, (DynamicObject)stockEntry));
            String wastagerateformula = "B";
            String orgMasterWast = baseData.getOrgMasterWast(Long.valueOf(org.getLong("id")), materialMasterId);
            if (orgMasterWast != null) {
                wastagerateformula = orgMasterWast;
            } else if (!isconsiderloss) {
                wastagerateformula = "";
            }
            stockEntry.set("wastagerateformula", (Object)wastagerateformula);
            stockEntry.set("demandqty", (Object)MPDMMftGenStocksUtils.getDemandQty((DynamicObject)bomEntry, (boolean)isconsiderloss, (DynamicObject)stockEntry, (String)wastagerateformula));
            stockEntry.set("bomreversion", (Object)bomEntry.getDynamicObject("entryversion"));
            stockEntry.set("childauxpropertyid", bomEntry.get("entryauxproperty"));
            Boolean isquotacontrol = materialmftInfo.get("isquotacontrol") == null ? false : materialmftInfo.getBoolean("isquotacontrol");
            if (isquotacontrol.booleanValue()) {
                stockEntry.set("overissuecontrl", (Object)"B");
                stockEntry.set("issinhighlimit", materialmftInfo.get("issinhighlimit"));
                stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(materialmftInfo.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
                stockEntry.set("issinlowlimit", materialmftInfo.get("issinlowlimit"));
                stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(materialmftInfo.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            } else {
                stockEntry.set("overissuecontrl", (Object)"A");
                stockEntry.set("extraratioqty", stockEntry.get("demandqty"));
                stockEntry.set("lackraitioqty", stockEntry.get("demandqty"));
            }
            stockEntry.set("bomentryid", bomEntry.getPkValue());
            stockEntry.set("oprno", bomEntry.get("entryoperationnumber"));
            stockEntry.set("processseq", bomEntry.get("entryprocessseq"));
            stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty((DynamicObject)stockEntry));
            stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry));
            stockEntry.set("priority", bomEntry.get("reppriority"));
            stockEntry.set("ismainreplace", bomEntry.get("entryisreplaceplanmm"));
            stockEntry.set("replaceplan", bomEntry.get("entryreplaceplan"));
            stockEntry.set("sourcetype", (Object)"A");
            if (this.hasProperties(stockEntry, "isjumplevel")) {
                stockEntry.set("isjumplevel", bomEntry.get("entryisjumplevel"));
                if (stockEntry.getBoolean("isjumplevel")) {
                    stockEntry.set("issuemode", (Object)"C");
                }
            }
            if ((bomParent = bomEntry.getParent()) != null) {
                DynamicObject chilidBom = (DynamicObject)bomParent;
                if (this.hasProperties(stockEntry, "childbomid")) {
                    stockEntry.set("childbomid", (Object)chilidBom);
                }
                if (this.hasProperties(stockEntry, "parentmaterial")) {
                    stockEntry.set("parentmaterial", chilidBom.get("material"));
                }
            }
            if (stockEntry.getBoolean("isstockallot")) {
                MPDMMftGenStocksUtils.setStockEntryWarehouse((DynamicObject)org, (DynamicObject)stockEntry, (DynamicObject)orderEntry, null);
            }
        }
        this.updateMftStockEntry(newStock, stockEntry, manftechMap);
        this.reCalQty(stockEntry);
    }

    private boolean hasProperties(DynamicObject data, String propertiesNumber) {
        return data.getDataEntityType().getProperties().containsKey((Object)propertiesNumber);
    }

    private void reCalQty(DynamicObject stockBillEntry) {
        BigDecimal actissueqty = stockBillEntry.getBigDecimal("actissueqty");
        BigDecimal rejectedqty = stockBillEntry.getBigDecimal("rejectedqty");
        BigDecimal feedingqty = stockBillEntry.getBigDecimal("feedingqty");
        BigDecimal demandqty = stockBillEntry.getBigDecimal("demandqty");
        BigDecimal extraratioqty = stockBillEntry.getBigDecimal("extraratioqty");
        BigDecimal calQty = actissueqty.subtract(rejectedqty).add(feedingqty);
        stockBillEntry.set("unissueqty", (Object)demandqty.subtract(calQty));
        stockBillEntry.set("cansendqty", (Object)(extraratioqty.subtract(calQty).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : extraratioqty.subtract(calQty)));
    }

    private void updateMftStockEntry(DynamicObject stock, DynamicObject stockEntry, Map<String, DynamicObject> manftechMap) {
        DynamicObject load = manftechMap.get(stock.getDynamicObject("orderentryid").getPkValue().toString());
        if (load != null) {
            MPDMMftGenStocksUtils.updateMftStockEntry((DynamicObject)stockEntry, (DynamicObject)load);
        }
    }

    private Map<String, DynamicObject> getManftechMap(DynamicObject[] stocks, String stockName) {
        DynamicObject[] manftechDyms;
        HashMap<String, DynamicObject> manftechMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> orderEntryList = new HashSet<Long>();
        for (int i = 0; i < stocks.length; ++i) {
            DynamicObject stock = stocks[i];
            DynamicObject orderEntry = stock.getDynamicObject("orderentryid");
            if (orderEntry == null) continue;
            orderEntryList.add((Long)orderEntry.getPkValue());
        }
        for (DynamicObject manftechDym : manftechDyms = BusinessDataServiceHelper.load((String)StockChangeUtils.getEntityName((int)1, (int)2, (String)stockName), (String)MPDMMftGenStocksUtils.manftechSelectProperties().toString(), (QFilter[])new QFilter[]{new QFilter("mftentryseq", "in", orderEntryList)})) {
            manftechMap.put(manftechDym.getDynamicObject("mftentryseq").getPkValue().toString(), manftechDym);
        }
        return manftechMap;
    }

    private OrderBaseData createOrderBaseData(DynamicObject materialmftInfo, DynamicObject orgMaterialPlanInfo, DynamicObject bomEntry, DynamicObject stock) {
        OrderBaseData baseData = new OrderBaseData();
        this.setSupplyInfos(baseData, materialmftInfo, orgMaterialPlanInfo, bomEntry, stock);
        Map orgMasterWastMap = baseData.getOrgMasterWastMap();
        Long orgId = stock.getDynamicObject("org").getLong("id");
        HashMap<Long, String> masterWastagerateformulaMap = (HashMap<Long, String>)orgMasterWastMap.get(orgId);
        if (masterWastagerateformulaMap == null) {
            masterWastagerateformulaMap = new HashMap<Long, String>(16);
        }
        if (orgMaterialPlanInfo != null) {
            masterWastagerateformulaMap.put(materialmftInfo.getDynamicObject("masterid").getLong("id"), orgMaterialPlanInfo.getString("wastagerateformula"));
        }
        orgMasterWastMap.put(orgId, masterWastagerateformulaMap);
        baseData.setOrgMasterWastMap(orgMasterWastMap);
        return baseData;
    }

    private void setSupplyInfos(OrderBaseData baseData, DynamicObject materialmftInfo, DynamicObject orgMaterialPlanInfo, DynamicObject bomEntry, DynamicObject stock) {
        HashMap<String, LinkedList> params = new HashMap<String, LinkedList>(16);
        String invinfosrc = "D";
        if (materialmftInfo != null) {
            String string = invinfosrc = materialmftInfo.get("invinfosrc") == null ? "D" : materialmftInfo.getString("invinfosrc");
        }
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)invinfosrc)) {
            DynamicObject orderEntry = stock.getDynamicObject("orderentryid");
            DynamicObject manuVersiontInfo = null;
            if (orderEntry.containsProperty("manuversion")) {
                manuVersiontInfo = orderEntry.getDynamicObject("manuversion");
            }
            DynamicObject org = stock.getDynamicObject("org");
            Object inter_assist_type = null;
            Long entrymaterialId = materialmftInfo == null ? 0L : materialmftInfo.getLong("id");
            long manuVersionId = manuVersiontInfo == null ? 0L : manuVersiontInfo.getLong("id");
            StringBuilder keystr = new StringBuilder(150);
            keystr.append(entrymaterialId).append(org.getPkValue()).append(manuVersionId);
            LinkedList param = params.computeIfAbsent(keystr.toString(), k -> new LinkedList());
            param.add(bomEntry);
            param.add(materialmftInfo);
            param.add(org);
            param.add(inter_assist_type);
            param.add(manuVersiontInfo);
        }
        Map supplyInfos = null;
        if (params.size() > 0) {
            Long startdate = System.currentTimeMillis();
            logger.info("\u5f00\u59cb\u8c03\u7528\u6279\u91cf\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f CreateStockByBomUtils.expandBomStocks PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist");
            supplyInfos = PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist(params);
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u5f00\u59cb\u8c03\u7528\u6279\u91cf\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f CreateStockByBomUtils.expandBomStocks PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist cost:" + (System.currentTimeMillis() - startdate));
            params.clear();
            params = null;
        }
        baseData.setSupplyInfos(supplyInfos);
    }
}

