/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.StockChangeImportUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bd.mpdm.opplugin.botp.BotpConvertUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class MftXStockBotpConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(MftXStockBotpConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        String entityName = StockChangeUtils.getEntityName((int)3, (int)1, (String)targetEntityNumber);
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        DynamicObject[] stockChangeBills = new DynamicObject[billDataEntitys.length];
        int i = 0;
        ORM orm = ORM.create();
        HashSet<Long> bomentryIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetOrderbill = billDataEntity.getDataEntity();
            if (targetOrderbill.get("billno") == null || StringUtils.isEmpty((CharSequence)targetOrderbill.getString("billno"))) {
                String number = CodeRuleServiceHelper.getNumber((String)targetEntityNumber, (DynamicObject)targetOrderbill, (String)targetOrderbill.getDynamicObject("org").getPkValue().toString());
                if (StringUtils.isEmpty((CharSequence)number)) {
                    number = String.valueOf("xmo_" + this.genLongId(orm, targetEntityNumber));
                }
                targetOrderbill.set("billno", (Object)number);
                logger.info("------------MftXStockBotpConvertPlugin.afterConvert,setbillno:" + number);
            }
            stockChangeBills[i] = targetOrderbill;
            DynamicObjectCollection coll = targetOrderbill.getDynamicObjectCollection("stockentry");
            for (int k = 0; k < coll.size(); ++k) {
                DynamicObject stockEntry = (DynamicObject)coll.get(k);
                Long bomentryid = stockEntry.getLong("bomentryid");
                if (bomentryid == null || bomentryid.equals(0L)) continue;
                bomentryIdSet.add(bomentryid);
            }
            ++i;
        }
        Map stockNoDymMap = new HashMap(16);
        if (stockChangeBills != null && stockChangeBills.length > 0) {
            logger.info("------------MftXStockBotpConvertPlugin.afterConvert,load stock DynamicObject:" + entityName + ",stockChangeBills.size:" + stockChangeBills.length);
            stockNoDymMap = StockChangeUtils.getStockNoDymMap((DynamicObject[])stockChangeBills, (String)stockChangeBills[0].getDataEntityType().getName());
        }
        OrderBaseData baseData = new OrderBaseData();
        Set<String> notUpdateFieldSet = this.getNoUpdateFieldSet(entityName);
        Set<String> updateQtyFieldSet = this.getUpdateQtyFields(entityName);
        Map bomEntryMap = MsBomQueryHelper.getBomEntryFromCache(bomentryIdSet);
        for (DynamicObject targetOrderbill : stockChangeBills) {
            DynamicObject stock = null;
            DynamicObjectCollection targetOrderbills = targetOrderbill.getDynamicObjectCollection("stockentry");
            for (DynamicObject targetOrderEntry : targetOrderbills) {
                DynamicObject stockEntry;
                String stockIds = targetOrderEntry.getString("stockid");
                if (stockIds == null || "".equals(stockIds)) continue;
                Long stockentryid = targetOrderEntry.get("stockentryid") == null ? 0L : Long.parseLong(targetOrderEntry.getString("stockentryid"));
                String stockNo = targetOrderEntry.getString("stockno");
                stock = (DynamicObject)stockNoDymMap.get(stockNo);
                if (targetOrderbill.get("orderentryid") == null) {
                    targetOrderbill.set("orderentryid", stock.get("orderentryid"));
                }
                if ((stockEntry = this.getStockEntry(stock, stockentryid)) != null) {
                    targetOrderEntry.set("stockentryseq", stockEntry.get("seq"));
                }
                DynamicObject oldXStockBillEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)targetOrderEntry, (boolean)false, (boolean)true);
                StockChangeImportUtils.changeManuBillAfterSubmit((DynamicObject)targetOrderEntry, (DynamicObject)targetOrderbill, (DynamicObject)stock);
                this.setStockEntryOthers(stock, stockEntry, targetOrderEntry, baseData, bomEntryMap);
                BotpConvertUtils.convertEntry(oldXStockBillEntry, targetOrderEntry, notUpdateFieldSet, updateQtyFieldSet);
                StockChangeImportUtils.autoFillStockChange((DynamicObject)targetOrderEntry, (String)targetOrderEntry.getString("qtytype"), (DynamicObject)stock);
            }
            if (targetOrderbill.get("productmasterid") == null && stock != null) {
                targetOrderbill.set("productmasterid", stock.get("productmasterid"));
            }
            if (targetOrderbill.get("productid") != null || stock == null) continue;
            targetOrderbill.set("productid", stock.get("productid"));
        }
    }

    private Long genLongId(ORM orm, String entityname) {
        return orm.genLongId(entityname);
    }

    private boolean isSameBoolean(boolean b1, boolean b2) {
        return b1 && b2 || !b1 && !b2;
    }

    private void setStockEntryOthers(DynamicObject stock, DynamicObject stockentry, DynamicObject xStockEntry, OrderBaseData baseData, Map<Long, DynamicObject> bomEntryMap) {
        DynamicObject orgfield;
        String supplumode;
        DynamicObject transac;
        if (stockentry != null) {
            xStockEntry.set("issuemode", stockentry.get("issuemode"));
        }
        Long bomEntryId = xStockEntry.getLong("bomentryid");
        DynamicObject bomEntry = bomEntryMap.get(bomEntryId);
        if (xStockEntry.getBoolean("isjumplevel")) {
            xStockEntry.set("issuemode", (Object)"C");
        } else if (stockentry != null && "C".equals(xStockEntry.getString("issuemode")) && !this.isSameBoolean(xStockEntry.getBoolean("isjumplevel"), stockentry.getBoolean("isjumplevel"))) {
            xStockEntry.set("issuemode", (Object)"A");
        }
        xStockEntry.set("productbaseqty", stock.get("baseqty"));
        xStockEntry.set("productbaseunit", stock.get("baseunitid"));
        xStockEntry.set("producttransid", stock.get("transactiontypeid"));
        xStockEntry.set("entryorderentryid", stock.get("orderentryid"));
        xStockEntry.set("entryorderno", stock.get("orderno"));
        xStockEntry.set("prodeptorgid", stock.get("mftdeptorgid"));
        xStockEntry.set("productno", stock.get("productid"));
        DynamicObject product = stock.getDynamicObject("productid");
        DynamicObject material = (DynamicObject)xStockEntry.get("materialid");
        xStockEntry.set("rework", (Object)"false");
        if (material != null && product != null && material.getPkValue().equals(product.getPkValue())) {
            xStockEntry.set("rework", (Object)"true");
        }
        xStockEntry.set("demanddate", stock.getDynamicObject("orderentryid").get("planbegintime"));
        String isbackflush = (String)xStockEntry.get("isbackflush");
        if ("B".equals(isbackflush) && (transac = (DynamicObject)stock.get("transactiontypeid")) != null) {
            xStockEntry.set("backflushtime", transac.get("backflushtime"));
        }
        xStockEntry.set("productconfiguredcode", stock.get("configuredcode"));
        xStockEntry.set("entrytracknumber", stock.get("tracknumber"));
        xStockEntry.set("entrybdproject", stock.get("bdproject"));
        if (stockentry != null) {
            xStockEntry.set("overissuecontrl", stockentry.get("overissuecontrl"));
            xStockEntry.set("issinhighlimit", stockentry.get("issinhighlimit"));
            xStockEntry.set("extraratioqty", stockentry.get("extraratioqty"));
            xStockEntry.set("issinlowlimit", stockentry.get("issinlowlimit"));
            xStockEntry.set("lackraitioqty", stockentry.get("lackraitioqty"));
        } else if (xStockEntry.get("overissuecontrl") == null || "".equals(xStockEntry.get("overissuecontrl").toString())) {
            xStockEntry.set("overissuecontrl", (Object)"A");
        }
        if (xStockEntry.get("supplierid") == null && xStockEntry.get("supplymode") != null && "bos_org".equals(supplumode = (String)xStockEntry.get("supplymode")) && (orgfield = (DynamicObject)xStockEntry.get("supplyorgid")) != null) {
            Long orgfieldId = (Long)orgfield.getPkValue();
            xStockEntry.set("supplierid", CreateStockByBomUtils.getSupplyByBaseData((OrderBaseData)baseData, (Long)orgfieldId));
        }
        if (bomEntry != null && stockentry == null) {
            xStockEntry.set("useratio", (Object)0);
            xStockEntry.set("pid", (Object)1L);
            if (!bomEntry.getBoolean("entryisreplace")) {
                xStockEntry.set("useratio", (Object)100);
                xStockEntry.set("pid", (Object)0L);
            }
        }
    }

    private DynamicObject getStockEntry(DynamicObject stock, Long stockEntryId) {
        if (stock == null) {
            return null;
        }
        DynamicObjectCollection coll = stock.getDynamicObjectCollection("stockentry");
        for (DynamicObject entry : coll) {
            if (!stockEntryId.equals(entry.getLong("id"))) continue;
            return entry;
        }
        return null;
    }

    public Set<String> getNoUpdateFieldSet(String entityName) {
        Set<String> fieldSet = BotpConvertUtils.getConfigNoUpdateFieldSet(entityName);
        fieldSet.add("id");
        fieldSet.add("srcbillentryid");
        fieldSet.add("srcbillid");
        fieldSet.add("pstockentryid");
        fieldSet.add("seq");
        fieldSet.add("pid");
        fieldSet.add("useratio");
        return fieldSet;
    }

    public Set<String> getUpdateQtyFields(String entityName) {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("qtynumerator");
        fieldSet.add("qtydenominator");
        fieldSet.add("fixscrap");
        fieldSet.add("scraprate");
        fieldSet.add("standqty");
        fieldSet.add("demandqty");
        return fieldSet;
    }
}

