/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class OrderRepToInBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] byEntityKey = dataEntitySet.FindByEntityKey("billentry");
        if (byEntityKey == null || byEntityKey.length == 0) {
            return;
        }
        HashSet<Long> manuEntryIdSet = new HashSet<Long>(byEntityKey.length);
        for (ExtendedDataEntity entity : byEntityKey) {
            DynamicObject billentry = entity.getDataEntity();
            DynamicObject material = billentry.getDynamicObject("material");
            if (material == null) continue;
            DynamicObject dynamicObject = material.getDynamicObject("masterid");
            if (dynamicObject != null) {
                OrmLocaleValue name = (OrmLocaleValue)dynamicObject.get("name");
                billentry.set("materialname", (Object)name.getLocaleValue());
                if (dynamicObject.getDynamicObject("auxptyunit") != null) {
                    billentry.set("unit2nd", (Object)dynamicObject.getDynamicObject("auxptyunit"));
                }
            }
            billentry.set("unit", (Object)material.getDynamicObject("inventoryunit"));
            DynamicObject unit = billentry.getDynamicObject("unit");
            Object baseunit = billentry.getDynamicObject("baseunit");
            DynamicObject unit2nd = billentry.getDynamicObject("unit2nd");
            BigDecimal baseqty = billentry.getBigDecimal("baseqty");
            if (baseunit == null) {
                baseunit = dynamicObject.getDynamicObject("baseunit");
                billentry.set("baseunit", baseunit);
            }
            Long manuentryid = billentry.getLong("manuentryid");
            manuEntryIdSet.add(manuentryid);
            billentry.set("qty", (Object)this.getQtyByUnit(dynamicObject, (DynamicObject)baseunit, unit, baseqty));
            billentry.set("baseqty", (Object)this.processPrecision(baseqty, (DynamicObject)baseunit));
            billentry.set("qtyunit2nd", (Object)this.getQtyByUnit(dynamicObject, (DynamicObject)baseunit, unit2nd, baseqty));
        }
        if (manuEntryIdSet.size() > 0) {
            DynamicObject[] load;
            HashMap<Long, DynamicObject> bomMap = new HashMap<Long, DynamicObject>();
            QFilter qf = new QFilter("treeentryentity.id", "in", manuEntryIdSet);
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)"id,treeentryentity.id,treeentryentity.bomid", (QFilter[])qf.toArray())) {
                DynamicObjectCollection treeentry = dynamicObject.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject dentry : treeentry) {
                    DynamicObject bomid;
                    Long entryid = dentry.getLong("id");
                    if (!manuEntryIdSet.contains(entryid) || (bomid = dentry.getDynamicObject("bomid")) == null) continue;
                    bomMap.put(entryid, bomid.getDynamicObject("version"));
                }
            }
            for (DynamicObject dynamicObject : byEntityKey) {
                DynamicObject masterId;
                DynamicObject billentry = dynamicObject.getDataEntity();
                DynamicObject material = billentry.getDynamicObject("material");
                if (material == null || !(masterId = material.getDynamicObject("masterid")).getBoolean("isenablematerialversion")) continue;
                Long manuentryid = billentry.getLong("manuentryid");
                billentry.set("mversion", bomMap.get(manuentryid));
            }
        }
    }

    private BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null || baseunit == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterid.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()));
        if (muConv == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal numerator = muConv.getBigDecimal("numerator");
        BigDecimal denominator = muConv.getBigDecimal("denominator");
        int precision = unit.getInt("precision");
        return baseqty.multiply(numerator).divide(denominator, precision, this.getRoundType(unit));
    }

    private BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = 4;
        if (unit != null) {
            precision = unit.getInt("precision");
        }
        return qty.setScale(precision, this.getRoundType(unit));
    }

    private int getRoundType(DynamicObject unit) {
        String precisionAccount = "1";
        if (unit != null) {
            precisionAccount = unit.getString("precisionaccount");
        }
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }
}

